{----------------------------------------------------------------------------}
{                                                                            }
{     HEAD.EXE  --  Copyright (c) 1988 by Marcos R. Della                    }
{                                                                            }
{     The following code has been donated to the public domain for anyone    }
{     out there to use.  All I request is that if you make changes, you      }
{     rename the program so that if it is distributed, it is not confused    }
{     with this version of the program.                                      }
{                                                                            }
{     Any changes or modifications to be incorporated into the program       }
{     should be sent to the above person to be installed in the distribution }
{     copy of the program.                                                   }
{                                                                            }
{     Version 01.00.00 - 01MAR88     Written specifically for the DMG BBS    }
{                                                                            }
{----------------------------------------------------------------------------}
{                                                                            }
{     head [-][ht][num] [path]filename                                       }
{                                                                            }
{     h - Count from the head of the file (num) lines                        }
{     t - Count from the tail of the file (num) lines                        }
{     - - negate the above.                                                  }
{                                                                            }
{     Ex.                                                                    }
{          head h8 filename    - Displays the first 8 lines of the file      }
{          head t6 filename    - Displays the last 8 lines of the file       }
{          head -t6 filename   - Displays all but the last 6 lines           }
{          head -h7 filename   - Displays all but the first 7 lines          }
{                                                                            }
{     Note:  At the moment, the program will not act correctly if there are  }
{            more than 255 characters per line.  Future versions of this     }
{            program will include the fix for this problem.                  }
{                                                                            }
{            This program will also take its input directly from the input   }
{            buffer so you can use something along the lines of:             }
{                                                                            }
{                   garbage | head -h4 > welcome1.txt                        }
{                                                                            }
{            This will take the output of "garbage" and knock off the first  }
{            4 lines of text and put the rest into the file "welcome1.txt"   }
{                                                                            }
{----------------------------------------------------------------------------}

TYPE  holdptr = ^holding;
      holding = RECORD
                   ptr      : holdptr;
                   lne      : STRING[255];
                   count    : INTEGER;
                END;
      line    = STRING[80];
      filen   = RECORD
                   path     : line;
                   filename : line
                END;

VAR   head     : holdptr;
      ptr      : holdptr;
      ptr1     : holdptr;
      lines    : INTEGER;
      fname    : filen;
      filename : line;
      tstf     : TEXT;
      len      : INTEGER;
      top      : BOOLEAN;
      negate   : BOOLEAN;
      done     : BOOLEAN;
      keybd    : BOOLEAN;
      count    : INTEGER;
      hcount   : INTEGER;
      i        : INTEGER;
      temp     : line;

{----------------------------------------------------------------------------}

PROCEDURE error_sys(num : INTEGER);
BEGIN
   WRITE('Error - ');
   CASE num OF
      1 : WRITELN('Invalid parameter');
      2 : WRITELN('Invalid filename');
      3 : WRITELN('Invalid path specification');
      4 : WRITELN('No file specified');
      5 : WRITELN('File does not exist');
      6 : WRITELN('Not enough memory')
   END;
   HALT(1)
END;

{----------------------------------------------------------------------------}

FUNCTION check_filename(fname : line) : BOOLEAN;
VAR   len  : BYTE ABSOLUTE fname;
      dots : INTEGER;
      dotp : INTEGER;
      i    : INTEGER;

BEGIN
   check_filename := TRUE;
   dots := 0;
   IF len > 0 THEN
      FOR i := 1 TO len DO BEGIN
         IF fname[i] = '.' THEN
            dots := dots + 1;
         IF NOT (fname[i] IN ['.','-','_','0'..'9','A'..'Z']) THEN
            check_filename := FALSE
      END;
   IF dots > 1 THEN
      check_filename := FALSE;
   dotp := POS('.', fname);
   IF (dotp > 9) OR (dotp = 1) OR ((dotp = 0) AND (len > 8)) OR
      ((dotp > 0) AND (len > dotp + 3)) OR (fname = '') THEN
      check_filename := FALSE
END;
{----------------------------------------------------------------------------}

PROCEDURE store_name(tmp : line);
VAR   len : BYTE;
BEGIN
   tmp := tmp + '..';
   len := LENGTH(tmp);
   WHILE len > 0 DO BEGIN
      tmp[len] := UPCASE(tmp[len]);
      len := len - 1
   END;
   fname.path := '';
   fname.filename := '';

   WHILE POS('\',tmp) > 0 DO BEGIN
      fname.path := fname.path + COPY(tmp,1,POS('\',tmp));
      DELETE(tmp,1,POS('\',tmp))
   END;
   IF (fname.path[LENGTH(fname.path)] = '\') AND (LENGTH(fname.path) > 1) THEN
      DELETE(fname.path,LENGTH(fname.path),1);
   fname.filename := COPY(tmp,1,POS('..',tmp) - 1);

   IF POS(':',fname.filename) > 0 THEN
      BEGIN
         fname.path := COPY(fname.filename,1,POS(':',fname.filename))
                     + fname.path;
         DELETE(fname.filename,1,POS(':',fname.filename))
      END;

   IF (fname.path[2] = ':') AND (LENGTH(fname.path) = 2)  THEN
      GETDIR(ORD(UPCASE(fname.path[1])) - 64,fname.path);
   IF fname.path = '' THEN
      GETDIR(0,fname.path)
END;

{----------------------------------------------------------------------------}

PROCEDURE get_params(temp : line);
VAR   code : INTEGER;
      i    : INTEGER;
BEGIN
   IF POS('t',temp) > 0 THEN
      top := FALSE;
   IF (POS('h',temp) > 0) AND NOT top THEN
      error_sys(1);
   IF temp[1] = '-' THEN
      IF POS('-',temp) > 1 THEN
         error_sys(1)
      ELSE
         negate := TRUE;
   i := 1;
   WHILE i <= LENGTH(temp) DO BEGIN
      IF temp[i] IN ['0'..'9'] THEN
         BEGIN
            DELETE(temp,1,i - 1);
            i := LENGTH(temp);
            VAL(temp,len,code);
            IF code <> 0 THEN
               error_sys(1)
         END;
      i := i + 1
   END
END;

{----------------------------------------------------------------------------}

FUNCTION eofcheck : BOOLEAN;
BEGIN
   IF keybd THEN
      eofcheck := EOF(input)
   ELSE
      eofcheck := EOF(tstf)
END;

{----------------------------------------------------------------------------}

BEGIN
   IF ParamCount = 0 THEN
      BEGIN
         WRITELN('Usage:  head [-][ht][num] [path]filename');
         HALT(2)
      END;
   len := 10;
   top := TRUE;
   negate := FALSE;
   filename := '';
   temp := ParamStr(1);
   keybd := FALSE;
   IF ParamCount = 1 THEN
      BEGIN
         keybd := TRUE;
         IF (temp[1] = '-') AND (temp[2] IN [' ','h','t']) THEN
            get_params(temp)
         ELSE
            IF (temp[1] IN ['h','t']) AND (temp[2] IN [' ','0'..'9'])
               AND (LENGTH(temp) < 5) THEN
               get_params(temp)
            ELSE
               BEGIN
                  filename := temp;
                  keybd := FALSE
               END
      END
   ELSE
      BEGIN
         filename := ParamStr(2);
         get_params(temp)
      END;

   IF NOT keybd THEN
      BEGIN
         store_name(filename);
         IF NOT check_filename(fname.filename) THEN
            error_sys(2);

         {$I-} CHDIR(fname.path); {$I+}
         IF IOresult <> 0 THEN
            error_sys(3);

         ASSIGN(tstf,fname.filename);
         {$I-} RESET(tstf); {$I+}
         IF IOresult <> 0 THEN
            error_sys(5)
      END;
   IF keybd THEN
      RESET(input);

   IF (len * 270 > memavail) THEN
      error_sys(6);

   done := FALSE;
   NEW(head);
   ptr := head;
   count := 0;
   hcount := 0;
   WHILE NOT eofcheck AND NOT done DO BEGIN
      count := count + 1;
      IF keybd THEN
         READLN(input,ptr^.lne)
      ELSE
         READLN(tstf,ptr^.lne);
      ptr^.count := count;
      IF top AND NOT negate THEN
         IF (count <= len) THEN
            IF count = len THEN
               WRITE(ptr^.lne)
            ELSE
               WRITELN(ptr^.lne)
         ELSE
            done := TRUE;
      IF top AND negate AND (count > len) THEN
        IF eofcheck THEN
            WRITE(ptr^.lne)
         ELSE
            WRITELN(ptr^.lne);

      IF NOT top THEN
         IF hcount < len THEN
            BEGIN
               hcount := hcount + 1;
               NEW(ptr^.ptr);
               ptr := ptr^.ptr;
            END
         ELSE
            BEGIN
               ptr^.ptr := head;
               ptr := head;
               IF negate THEN
                  IF eofcheck THEN
                     WRITE(head^.lne)
                  ELSE
                     WRITELN(head^.lne);
               ptr1 := head;
               head := head^.ptr
            END
   END;
   IF NOT top AND NOT negate THEN
      WHILE hcount > 0 DO BEGIN
         IF hcount > 1 THEN
            WRITELN(head^.lne)
         ELSE
            WRITE(head^.lne);
         ptr := head^.ptr;
         DISPOSE(head);
         head := ptr;
         hcount := hcount - 1
      END;
   IF NOT keybd THEN
      CLOSE(tstf)
END.
