/*Substitutions and fills in file, cppskel.dat

  Area Fills
  @ZZ0    Form the dialog in constructor
  @ZZ1    Defined Control Names in Object Def.
  @ZZ2    Data struct def and TListBoxRec def
  @ZZ3    Variable names in 'read'
  @ZZ4    Variable names in 'write'
  @ZZ5    Ancestor constructor call
  @ZZ6    Uses_ stuff
  @ZZ7    include of tcolortx.h, tinplong.h
  @ZZ8    Links
  @ZZ9    #include <tv.h> or <tvision\tv.h>
  @ZZ10   Splits .h file from .cpp file

  Substitutions
  @XX1    Dialog's Symbol   (as  TMyDialog)
  @XX2    Dialog's ancestor (usually TDialog)
  @XX3    Dialog's registration TStreamRec (as RMyDialog)
  @XX4    Filename (upper case)
  @XX5    Filename (lower case)
*/

#define Uses_TStringCollection

#if defined (TV2)
#   include <tvision\tv.h>
#elif defined (TV1)
#   include <tv.h>
#else
#   error TV1 or TV2 must be defined
#endif

#include <stdlib.h>
#include <dos.h>
#include <dir.h>
#include <fcntl.h>
#include <string.h>
#include <iostream.h>
#include <fstream.h>
#include <stdio.h>
#include "readscpt.h"

ofstream outf;
ifstream data;
#define BIG 300
char s[BIG], upperName[MAXFILE], lowerName[MAXFILE];
Boolean needcontrol1 = False;

char* quoted(const char* s)
//if the first char of s is '@', assumes a variable wanted and strips the '@'
//else returns a double quoted string or 0 for empty string
{
 static char q[300];
 if (s[0] == '@')
   {strcpy(q, &s[1]);
    return q;
   }
 strcpy(q, "\"");   //the first quote in place
 if (*s == '\0' || !s) return "0";
 strcat(q, s);
 short l = strlen(q);
 q[l] = '\"';
 q[l+1] = '\0';
 return q;
}

void aField(ViewObj *P, char* fieldtype)
{
 outf << "  " << fieldtype << " " << P->FieldName << ";   //" << P->Obj <<endl;
}
void aVar(ViewObj *P)
{
 if (strcmp(P->VarName, "control") != 0)
   outf << "    " << P->Obj << " *" << P->VarName << ";\n";
}

//the following extend the ViewObj struct's to also write the code
struct DialogWriteObj : DialogObj {
     virtual void writeCode();
     };

struct ButtonWriteObj : ButtonObj {
     virtual void writeCode();
     virtual void writeVars() {aVar(this);};
     };

struct InputLongWriteObj : InputLongObj {
     virtual void writeCode();
     virtual void writeFields() {aField(this, "long");} ;
     virtual void writeVars() {aVar(this);};
     };
struct LabelWriteObj : LabelObj {
     virtual void writeCode();
     };
struct HistoryWriteObj : HistoryObj {
     virtual void writeCode();
     };
struct InputLineWriteObj : InputLineObj {
     virtual void writeCode();
     virtual void writeFields();
     virtual void writeVars() {aVar(this);};
     };
struct ClusterWriteObj : ClusterObj {
     virtual void writeCode();
     virtual void writeFields() {aField(this, "ushort");} ;
     virtual void writeVars() {aVar(this);};
     };
struct MultiCheckBoxWriteObj : MultiCheckBoxObj {
     virtual void writeCode();
     virtual void writeFields() {aField(this, "ulong");} ;
     virtual void writeVars() {aVar(this);};
     };
struct ListBoxWriteObj : ListBoxObj {
     virtual void writeCode();
     virtual void writeFields() {aField(this, "TListBoxRec");} ;
     virtual void writeVars() {aVar(this);};
     };
struct ScrollBarWriteObj : ScrollBarObj {
     virtual void writeCode();
     virtual void writeVars();
     };
struct MemoWriteObj : MemoObj {
     virtual void writeCode();
     virtual void writeFields();
     virtual void writeVars() {aVar(this);};
     };
struct StaticTextWriteObj : StaticTextObj {
     virtual void writeCode();
     virtual void writeVars() {aVar(this);};
     };
struct ColoredTextWriteObj : ColoredTextObj {
     virtual void writeCode();
     virtual void writeVars() {aVar(this);};
     };
struct ComboWriteObj : ComboObj {
     virtual void writeCode();
     virtual void writeFields();
     virtual void writeVars();
     };
struct PictureValidatorWriteObj : PictureValidatorObj{
     virtual void writeCode(const char* ptrName);
     };

struct RangeValidatorWriteObj : RangeValidatorObj {
     virtual void writeCode(const char* ptrName);
     };

struct FilterValidatorWriteObj : FilterValidatorObj  {
     void writeCharSet();
     virtual void writeCode(const char* ptrName);
     };

struct StringLookupValidatorWriteObj : StringLookupValidatorObj {
     virtual void writeCode(const char* ptrName);
     };
struct UserValidatorWriteObj : UserValidatorObj {
     virtual void writeCode(const char* ptrName);
     };


//now that we know the final extensions of ViewObj, we can write the
//getKind function
ViewObj *getKind(recType Kind)
{ ViewObj *P;
  switch (Kind) {
      case Dlg : P = new DialogWriteObj(); break;
      case Button : P = new ButtonWriteObj(); break;
      case InputL : P = new InputLineWriteObj(); break;
      case Labl : P = new LabelWriteObj();  break;
      case Histry : P = new HistoryWriteObj(); break;
      case ILong : P = new InputLongWriteObj(); break;
      case CheckB: P = new ClusterWriteObj(); break;
      case RadioB: P = new ClusterWriteObj(); break;
      case MultiCB: P = new MultiCheckBoxWriteObj(); break;
      case ListB: P = new ListBoxWriteObj(); break;
      case ScrollB :  P = new ScrollBarWriteObj(); break;
      case Memo: P = new MemoWriteObj(); break;
      case SText: P = new StaticTextWriteObj(); break;
      case CText : P = new ColoredTextWriteObj(); break;
      case ComboB : P = new ComboWriteObj(); break;
      default : P = 0; break;
      }
return P;
}

ValidatorObj *getValKind(valType Kind)
{ ValidatorObj *P;
  switch (Kind)  {
    case Picture: P = new PictureValidatorWriteObj(); break;
    case Range:   P = new RangeValidatorWriteObj();   break;
    case Filter:  P = new FilterValidatorWriteObj();  break;
    case StringLookup: P = new StringLookupValidatorWriteObj(); break;
    case User: P = new UserValidatorWriteObj(); break;
    default : P = 0; break;
    }
  return P;
}

char * getWinFlagWords(ushort w, char *s)
//given the set bits return names in 'or' form
{
 static char *flagArray[4] =  {
      "wfMove", "wfGrow", "wfClose", "wfZoom"};
 s[0] = '\0';
 for (int i = 0; i <= 3; i++) {
   if ((w & 1) == 1 && flagArray[i][0] != '\0')
     strcat(strcat(s, flagArray[i]), " | ");
   w >>= 1;
   }
 int l = strlen(s);
 if (l > 4)
    s[l-3] = '\0';   //remove last " | "
 return s;
}

char * getEventWords(ushort w, char *s)
//given the set bits return names in 'or' form
{
 static char *flagArray[16] =  {
        "evMouseDown", "evMouseUp", "evMouseMove", "evMouseAuto",
        "evKeyDown", "0x20", "0x40", "0x80", "evCommand", "evBroadcast",
        "0x400", "0x800", "0x1000", "0x2000", "0x4000", "0x8000"};
 s[0] = '\0';
 for (int i = 0; i <= 15; i++) {
   if ((w & 1) == 1 && flagArray[i][0] != '\0')
     strcat(strcat(s, flagArray[i]), " | ");
   w >>= 1;
   }
 int l = strlen(s);
 if (l > 4)
    s[l-3] = '\0';   //remove last " | "
 return s;
}

char * getOptionWords(ushort w, char *s)
//given the set bits return names in 'or' form
{
 static char *flagArray[16] =  {
        "ofSelectable", "ofTopSelect", "ofFirstClick", "ofFramed",
        "ofPreProcess", "ofPostProcess", "ofBuffered", "ofTileable",
        "ofCenterX", "ofCenterY", "ofValidate", "0x800", "0x1000",
        "0x2000", "0x4000", "ofShoehorn"};
 s[0] = '\0';
 for (int i = 0; i <= 15; i++) {
   if ((w & 1) == 1 && flagArray[i][0] != '\0')
     strcat(strcat(s, flagArray[i]), " | ");
   w >>= 1;
   }
 int l = strlen(s);
 if (l > 4)
    s[l-3] = '\0';   //remove last " | "
 return s;
}

short bitCount(ushort w) //numbers of set bits in the word
{
 short count = 0;
 for (int i = 0; i <= 15; i++)  {
    if ((w & 1) == 1)
       count++;
    w >>= 1;
    }
return count;
}

void doBitOutput(const char* var, const char* pre, ushort actual,
                       ushort defaul, char* (func)(ushort w, char* s))
//output something like "foo->options |= ofSelectable or ofFramed;"
//and/or "foo-> options &= ofTopSelect;"
//actual is the bits set and defaul are the default settings
//it's known that actual and defaul are not equal on entry
{
 char s[100];
 ushort NOTs, ORs, diff ;
 diff = actual ^ defaul;  //the bits that are different
 if (bitCount(diff) > 5) { //this is too complex--output hex number
   outf << " " << var << pre << " = 0x" << hex << actual << dec <<";\n";
   return;
   }
 NOTs = diff & defaul;  //the bits not in defaul
 ORs = diff & actual;    //the extra bits in actual
 s[0] = '\0';
 if (NOTs != 0) {
   outf << " " << var <<pre;
   if (bitCount(NOTs) == 1)
     outf << " &= ~" << func(NOTs, s) << ";\n";
   else
     outf << " &= ~(" << func(NOTs, s) << ");\n";
   }
 s[0] = '\0';
 if (ORs != 0)
   outf << " " << var << pre << " |= " << func(ORs, s) << ";\n";
}

void doTRect(ViewObj *P)
{
outf << "(TRect(" << P->X1 << ", " << P->Y1 << ", "
     << P->X2 << ", " << P->Y2 << ")";
}

void insertControl(const char *Name)
{
 outf <<  " insert(" << Name << ");\n\n";
}

void doOpEvent(ViewObj *P)
{if (P->DefEvMsk != P->EvMsk)
   doBitOutput(P->VarName, "->eventMask", P->EvMsk, P->DefEvMsk, getEventWords);

if (P->DefOptns != P->Optns)
   doBitOutput(P->VarName, "->options", P->Optns, P->DefOptns, getOptionWords);

}

void writeHelpCtx(char * VarName, char* H, ushort Ctx)
{
if (*H != '\0') {
  if (strcmp(H, "hcNoContext")) {
    outf << " " << VarName << "->helpCtx = " << H << ";\n";
    }
  }
else if (Ctx != 0) {
    outf << " " << VarName << "->helpCtx = " << Ctx << ";\n";
    }
}

void start(ViewObj *P)
{
  outf << " " << P->VarName << " = new " << P->Obj;
  doTRect(P);
}

void finish(ViewObj *P)
{
 writeHelpCtx(P->VarName, P->HelpCtxSym, P->HCtx);
 doOpEvent(P);
 insertControl(P->VarName);
}

void flagsOut(ushort flags)
{
 if (flags == 0) outf << "bfNormal";
 else {
    short plus = 0;
    if ((flags & 1) != 0) {
        plus = 1; outf << "bfDefault"; }
    if ((flags & 2) != 0) {
        if (plus) outf << "|";
        plus = 1;
        outf << "bfLeftJust";}
    if ((flags & 4) != 0) {
        if (plus) outf << "|";
        plus = 1;
        outf << "bfBroadcast"; }
    if ((flags & 8) != 0)  {
        if (plus) outf << "|";
        outf << "bfGrabFocus"; }
    }
}

void ButtonWriteObj::writeCode()
{
 start(this);
 outf << ", " << quoted(ButtonText) << ", ";
 if (*CommandName != '\0')
    outf << CommandName;
 else outf << CommandValue;
 outf << ", ";
 flagsOut(Flags);
 outf << ");\n";
 finish(this);
}

void LabelWriteObj::writeCode()
{
 outf << "   insert(new " << Obj;
 doTRect(this);
 outf << ", " << quoted(LabelText) << ", " << LinkName << "));\n\n";
}

void HistoryWriteObj::writeCode()
{
 outf << "   insert(new " << Obj;
 doTRect(this);
 outf << ", (TInputLine*)" << HistoryLink << ", " << HistoryID << "));\n\n";
}

void InputLongWriteObj::writeCode()
{
  start(this);
  outf << ", " << (LongStrLeng+1) << ", " << LLim << ", " << ULim <<  ", "
       << ILOptions << ", " << quoted(LongLabelText) << ");\n";
  finish(this);
}

void PictureValidatorWriteObj::writeCode(const char* )
{
  char* s;
  if (AutoFill) s = "True"; else s = "False";
  outf << ValPtrName << "(\"" <<  PictureString << "\", " << s << "));\n";
}
void RangeValidatorWriteObj::writeCode(const char* ptrName)
{
  outf << ");\n   {" << ValPtrName << "* tr = new " <<
      ValPtrName << "(" <<  LowLim << ", " << UpLim << ");\n";
  if (Transfer)     //Transfer set for long operation--string op is default
    outf << "    tr->options |= voTransfer;\n";
  outf << "    ((TInputLine*)" << ptrName << ")->setValidator(tr);\n   }\n";
}
void FilterValidatorWriteObj::writeCharSet()
{
  char c = '\0';
  unsigned long L;
  Boolean newLine = True;
  int linePos = 36;
  for (int i = 0; i <=7; i++) {
     L = ActualCharSet[i];
     for (int j = 0; j <=31; j++, c++, L = L >> 1)
       if ((L & 1) == 1) {
         if (newLine) {
           outf << '\"';
           linePos++;
           }
         switch (c) {
           case '\r' : outf << "\\r"; linePos++; break;
           case '\t' : outf << "\\t"; linePos++; break;
           case '\v' : outf << "\\v"; linePos++; break;
           case '\\' : outf << "\\\\"; linePos++; break;
           case '\'' : outf << "\\\'"; linePos++; break;
           case '\"' : outf << "\\\""; linePos++; break;
           case '\x0a' : outf << "\\x0a"; linePos += 3; break;
           default : outf << c; break;
           }
         if (++linePos == 75) {
           outf << "\"\n              ";
           linePos = 15;
           newLine = True;
           }
         else newLine = False;
         }
    }
  if (!newLine) outf << '\"';
}
void FilterValidatorWriteObj::writeCode(const char* )
{
  char s[257];
  outf << ValPtrName << "(";
  if (CharSet[0] == '@')
    outf << CharSet+1;  // a variable
  else writeCharSet();
  outf << "));\n";
}
void StringLookupValidatorWriteObj::writeCode(const char* )
{
  outf << ValPtrName << "(";
  if (stricmp(List, "Nil")) outf <<  List; else outf << "0";
  outf <<  "));\n";
}

void UserValidatorWriteObj::writeCode(const char* )
{
  outf << ValPtrName << ConstructorParams << ");\n";
}

void InputLineWriteObj::writeCode()
{
  start(this);
  outf << ", " << (StringLeng+1);    //Note: add 1
  if (!val)
    outf  << ");\n";
  else if (ValKind != Range) {
    outf << ",\n              new ";
    val->writeCode(VarName);
    }
  else val->writeCode(VarName);   //range validator
  finish(this);
}

void InputLineWriteObj::writeFields()
{
  if (ValKind == Range && ((RangeValidatorObj*)val)->Transfer )   
     outf << "  long " << FieldName << ";      //" << Obj << endl;
  else outf << "  char " << FieldName << "[" << (StringLeng+1)  //Note: add 1 !
       << "];   //" << Obj << endl;
}

void doAtText(char *s)  // an '@' reference string
{
 while (*s) {
   char c = *s++;
   switch (c) {
     case 0x3 :
     case '@': break;
     case '\\' :
       if (*s == 'n') s++;
       else outf << c;
       break;
     default : outf << c;
     }
  }
}

void doText(char *s)
{    //split up a long string into several lines. String cannot exceed 254
 if (!*s) {
   outf << 0;
   return;
   }
 if (strlen(s) > 254) s[254] = '\0';   //truncate if too big
 outf << '\"';
 short count = 47;
 while (*s)  {
    if (s[0] == '\\' && s[1] == 'n' && s[2]) {
       outf << s[0] << s[1] << "\"\n     \"";
       count = 5;
       s++;    //extra increment to pass 'n'
       }
    else {
       outf << *s;
       count++;
       }
    s++;
    if (count > 75 && *s) {
       outf << "\"\n     \"";
       count = 5;
       }
    }
 outf << '\"';
}

void StaticTextWriteObj::writeCode()
{
  start(this);
  outf << ", ";
  if(Text[0] == '@' || Text[0] == 3 && Text[1] == '@')
    doAtText(Text);
  else
    doText(Text);
  outf << ");\n";
  finish(this);
}

void ColoredTextWriteObj::writeCode()
{
  start(this);
  outf << ", ";
  if(Text[0] == '@' || Text[0] == 3 && Text[1] == '@')
    doAtText(Text);
  else
    doText(Text);
  outf << ", 0x" << hex << Attrib << dec << ");\n";
  finish(this);
}

void ScrollBarWriteObj::writeCode()
{
  start(this);
  outf << ");\n";
  finish(this);
}

void ScrollBarWriteObj::writeVars()
{
 if (strcmp(VarName, "control1") != 0) //control1 is used by TMemo
   aVar(this);
 else needcontrol1 = True;
}

void ListBoxWriteObj::writeCode()
{
  start(this);
  outf << ", " << Columns << ", ";
  if (*ScrollBar != '\0')
    outf << "(TScrollBar*)" << ScrollBar << ");\n";
  else outf << "0);\n";
  finish(this);
}

void MemoWriteObj::writeCode()
{
  start(this);
  outf << ", " ;
  if (*HScroll != '\0')
    outf << "(TScrollBar*)" << HScroll << ", ";
  else outf << "0, ";
  if (*VScroll != '\0')
    outf << "(TScrollBar*)" << VScroll << ", 0, ";
  else outf << "0, 0, ";
  outf << BufSize << ");\n";
  finish(this);
}
void MemoWriteObj::writeFields()
{
  outf << "  ushort " << FieldName << ";   //" << Obj << " text length\n";
  outf << "  char " << TextFieldName << "[" << BufSize << "];   //"
       << Obj << " text\n";
}

void ClusterWriteObj::writeCode()
{
  start(this);
  for (int i=0; i < Items; i++)
    outf << ",\n  new TSItem(\"" << (char *)LabelColl->at(i) << "\"";
  outf << ", 0";
  for (i = 0; i <= Items; i++)
    outf << ")";
  outf << ";\n";
  if (Mask != -1)  {         
     char s[34];
     ltoa(~Mask, s, 16);
     outf << "  ((TCluster*)" << VarName << ")->setButtonState(0x" << s
          << ", False);\n";
     }
  finish(this);
}

char *MCBFlagString(ushort f, char* s)
{
  char s1[34];
  switch (f) {
    case 0x101 : strcpy(s, "cfOneBit"); break;
    case 0x203 : strcpy(s, "cfTwoBits"); break;
    case 0x40f : strcpy(s, "cfFourBits"); break;
    case 0x8ff : strcpy(s, "cfEightBits"); break;
    default : strcpy(s, "0x");
              strcat(s, itoa(f, s1, 16));
              break;
    }
  return s;
}

void MultiCheckBoxWriteObj::writeCode()    
{
  char s[34];
  start(this);
  for (int i=0; i < Items; i++)
    outf << ",\n  new TSItem(\"" << (char *)LabelColl->at(i) << "\"";
  outf << ", 0";
  for (i = 0; i < Items; i++)
    outf << ")";
  outf << ", " << SelRange << ", " << MCBFlagString(MCBFlags, s) << ", "
       << quoted(States) << ");\n";
  if (Mask != -1)  {
     ltoa(~Mask, s, 16);
     outf << "  ((TCluster*)" << VarName << ")->setButtonState(0x" << s
          << ", False);\n";
     }
  finish(this);
}

void comboFlags(ushort flags)    //used by TCombo
{
 if (flags == 0) outf << "0";
 else {
    outf << "\n      ";
    short plus = 0;
    if ((flags & 1) != 0) {
        plus = 1; outf << "cbxOnlyList"; }
    if ((flags & 2) != 0) {
        if (plus) outf << " | ";
        plus = 1;
        outf << "cbxDisposesList";}
    if ((flags & 4) != 0) {
        if (plus) outf << " | ";
        outf << "cbxNoTransfer"; }
    }
}

void ComboWriteObj::writeCode()
#define cbxNoTransfer 4
{ outf << "  ";
  start(this);
  outf << ", (TInputLine*)" << ComboLink << ", ";
  comboFlags( cbxFlags );
  if (ComboItems > 0 && (cbxFlags & cbxNoTransfer)) {
    outf << ",";
    for (short i=0; i < ComboItems; i++)
      outf << "\n      new TSItem(\"" << (char *)ComboColl->at(i) << "\",";
    outf << " 0";
    for (i = 0; i < ComboItems; i++)
      outf << ")";
    }
  outf << ");\n";

  if (Character[0] != '\0' && Character[0] != 25)
     outf << "   ((TCombo*)" << VarName << ")->activateChar('"
             << Character[0] << "');\n";
  outf << "  ";
  finish(this);
}

void ComboWriteObj::writeFields()
{
  if (!(cbxFlags & cbxNoTransfer))
    outf << "  TStringCollection* " << FieldName << ";   //" << Obj << endl;
}

void ComboWriteObj::writeVars()
{
 if (strcmp(VarName, "control1") != 0) //control1 is default var name
   aVar(this);
 else needcontrol1 = True;
}

void DoControls(void *p, void*)
{ViewObj *P = (ViewObj*)p;
 P->writeCode();
}

void DialogWriteObj::writeCode()
{
  outf << " TView *control";
  if (needcontrol1) outf << ", *control1;\n";
  else outf << ";\n";

  if (DefEvMsk != EvMsk)
     doBitOutput("", "eventMask", EvMsk, DefEvMsk, getEventWords);

  if (DefOptns != Optns)
     doBitOutput("", "options", Optns, DefOptns, getOptionWords);

  if (WinFlags != 5)    //5 is the default
     doBitOutput("", "flags", WinFlags, 5, getWinFlagWords);
  if (tvVersion >=200) {
    if (Palette == 0)    //2 is the default
      outf << " palette = dpBlueDialog;\n";
    else if (Palette == 1)
      outf << " palette = dpCyanDialog;\n";
    }
  if (*HelpCtxSym != '\0') {
     if (strcmp(HelpCtxSym, "hcNoContext")) {
       outf << " " << "helpCtx = " << HelpCtxSym << ";\n";
       }
     }
  else if (HCtx != 0) {
       outf << " " << "helpCtx = " << HCtx << ";\n";
       }
  outf << endl;

  ScriptColl->forEach(DoControls, 0);
}

char* SkelDatName(char *exe, char* rtn)
//find where to locate cppskel.dat.  Use drive, directory of this exe file
{
 char drive[MAXDRIVE];
 char dir[MAXDIR];
 char name[MAXFILE];
 char ext[MAXEXT];
 fnsplit(exe, drive, dir, name, ext);
 fnmerge(rtn, drive, dir, "CPPSKEL", ".DAT");
 return rtn;
}

void subst(char *p) //make a substitution for @XXn
{
char tail[BIG];
short n = *(p+3) - '0';    //get the @XX #
*p = '\0';                 //terminate s at the '@'
strcpy(tail, p+4);         //keep the rest of the line
switch (n) {
  case 1 :                //this would be @XX1
       strcat(s, Dialog->Obj);
       strncat(s, tail, BIG-strlen(s));
       break;
  case 2 :
       strcat(s, "TDialog");
       strncat(s, tail, BIG-strlen(s));
       break;
  case 3 :
       strcat(s, "R");            //subst 'R' for 'T'
       strcat(s, Dialog->Obj+1);  //less the 'T'
       strncat(s, tail, BIG-strlen(s));
       break;
  case 4 :
       strcat(s, upperName);
       strncat(s, tail, BIG-strlen(s));
       break;
  case 5 :
       strcat(s, lowerName);
       strncat(s, tail, BIG-strlen(s));
       break;
  }
}

void doWriteItems(void *p, void* first)
{
 ViewObj *P = (ViewObj*)p;
 if (*P->VarName != '\0' && strcmp(P->VarName, "control") != 0
                 && strcmp(P->VarName, "control1") != 0) {
    if (*(int*)first)  {
       outf << " os";
       *(int*)first = False;
       }
    outf << " << " << P->VarName;
    }
}

void doTheWriteItems()
{//code to Write pointers in 'Write'
 int first = True;
 ScriptColl->forEach(doWriteItems, &first);
 if (!first) outf << ";\n";  //if !first, there is at least one item
}

void doReadItems(void *p, void* first)
{
 ViewObj *P = (ViewObj*)p;
 if (*P->VarName != '\0' && strcmp(P->VarName, "control") != 0
                 && strcmp(P->VarName, "control1") != 0) {
    if (*(int*)first)  {
       outf << " is";
       *(int*)first = False;
       }
    outf << " >> " << P->VarName;
    }
}

void doTheReadItems()
{//code to read pointers in 'read'
 int first = True;
 ScriptColl->forEach(doReadItems, &first);
 if (!first) outf << ";\n";  //if !first, there is at least one item
}

void doFields(void *p, void* first)
{     // fieldnames for the data transfer struct
 ViewObj *P = (ViewObj*)p;
 if (*(int*)first && *P->FieldName != '\0') {
    outf << "struct " << Dialog->FieldName << "  {\n";
    *(int*)first = False;
    }
 P->writeFields();
}

void doTheDataStruct()
{//code to build the data transfer struct
 if (Dialog->FieldName[0])  {  //no fieldname, no datarecord
   if (tvVersion < 200 && present[ListB])//if we have listbox, define TListBoxRec
      outf <<
        "#if !defined(__TListBoxRec)\n"
        "#define __TListBoxRec\n"
        "struct TListBoxRec\n"
        "{\n"
        "    TCollection* items;\n"
        "    short selection;\n"
        "};\n"
        "#endif\n\n";

   int first = True;
   ScriptColl->forEach(doFields, &first);
   if (!first) outf << "  };\n\n";  //if !first, there is at least one field
   }
}

void doVars(void *p, void*)
{ViewObj *P = (ViewObj*)p;
 P->writeVars();
}

void doTheVars()
 //define variables whose names are not "control"
{
 ScriptColl->forEach(doVars, 0);
 outf << endl;
}

void ancestorConstructor()
{
 outf << "       TDialog";
 doTRect(Dialog);
 outf << ", " << quoted(((DialogWriteObj*)(Dialog))->Title) << "),\n";
}

void doUsesStuff()
{
 static char* usesVal[] = {"TPXPictureValidator", "TRangeValidator",
    "TFilterValidator", "TStringLookupValidator"};
 static char* uses[] = {"TDialog", "TButton", "TStaticText", "TColoredText",
    "TInputLine", "TLabel", "THistory", "TInputLong", "TCheckBoxes",
    "TRadioButtons", "TMultiCheckBoxes", "TListBox", "TMemo", "TScrollBar",
    "TCombo"};

 short ts = 0;
 for (recType i = Button; i <= ComboB; ((int)i)++)
    if (present[i]) {
       outf << "#define Uses_" << uses[i] << endl;
       ts |= (i == CheckB || i == RadioB || i == MultiCB || i == ComboB);
       if (i == ComboB) {
         outf << "#define Uses_TStringCollection\n";
         if (!present[ListB])
           outf << "#define Uses_TListBox\n";
         }
       }
 for (valType j = Picture; j <= StringLookup; ((int)j)++)
    if (valPresent[j])
       outf << "#define Uses_" << usesVal[j] << endl;
 if (ts)
    outf << "#define Uses_TSItem\n";
}

void doLinks(void *p, void*)
{char *P = (char*)p;
 outf << "__link(R" << (char*)((P)+1) << ")\n";  //subst 'R' for 'T'
}

void doIncludes()
{
  if (present[CText])
    outf << "#include \"tcolortx.h\"\n";
  if (present[ILong])
    outf << "#include \"tinplong.h\"\n";
  if (present[ComboB])
    outf << "#include \"tcombo.h\"\n";
}

void doIncludeTV()
{
  if (tvVersion >= 200)
    outf << "#include <tvision\\tv.h>\n";
  else
    outf << "#include <tv.h>\n";
}

void changeToCPP(const char *s)
{
 outf.close();   //the .h file
 outf.open(s, ios::out);
 if (!outf.good()) {
   cout << "Can't open "  << s << endl;
   exit(1);
   }
}

//-------------------------------------------------------------------
// The following exit procedure is required in order to view error
// messages before Turbo Vision wipes out the screen
//-------------------------------------------------------------------
int exit_flag = 1;

void exitfunc(void)
{
  if( exit_flag )
  {
     cout << "\nStrike Enter key to continue" << endl;
     char c;
     cin.get(c);
  }
}

#pragma exit exitfunc  100

int main(int argc, char** argv)
// argv[1] is script file
// argv[2] is .src name
// argv[3] is error filename

{
 int split;
 if (argc < 3) {
   cout << "Usage:  cppsrc2 <script filename> <source filename> [error filename]";
   exit(1);
   }
 if (argc >= 4) {
   freopen(argv[3], "w", stdout);
   exit_flag = 0;   // won't need hold up on exit
   }

 checkMemory();

 data.open(SkelDatName(argv[0], s), ios::in);
 if (!data.good()) {
   cout << "Can't open cppskel.dat" << endl;
   exit(1);
   }

 readScriptFile(argv[1]);  //argv(1) is temporary script file

   {
    char drive[MAXDRIVE], dir[MAXDIR], ext[MAXEXT];
    fnsplit(argv[2], drive, dir, upperName, ext); //find .H filename
    split = stricmp(ext, ".$TM") != 0;
    if (split)
       fnmerge(s, drive, dir, upperName, ".H");
    else strcpy(s, argv[2]);   //won't split the output if ext is .$TM
    outf.open(s, ios::out);
    if (!outf.good()) {
      cout << "Can't open " << s << endl;
      exit(1);
      }
   }

 strupr(upperName);            //for use later
 strcpy(lowerName, upperName);
 strlwr(lowerName);

 while (!data.eof()) {
    data.getline(s, BIG);
    if (strcmp(s, "@ZZ0") == 0) Dialog->writeCode();
    else if (strcmp(s, "@ZZ1") == 0) doTheVars();
    else if (strcmp(s, "@ZZ2") == 0) doTheDataStruct();
    else if (strcmp(s, "@ZZ3") == 0) doTheReadItems();
    else if (strcmp(s, "@ZZ4") == 0) doTheWriteItems();
    else if (strcmp(s, "@ZZ5") == 0) ancestorConstructor();
    else if (strcmp(s, "@ZZ6") == 0) doUsesStuff();
    else if (strcmp(s, "@ZZ7") == 0) doIncludes();
    else if (strcmp(s, "@ZZ8") == 0) classCollection->forEach(doLinks, 0);
    else if (strcmp(s, "@ZZ9") == 0) doIncludeTV();
    else if (strcmp(s, "@ZZ10") == 0)
      {if (split)
         changeToCPP(argv[2]);  //switch from .h to .cpp file
       else outf << "//-------------- Cut Here ------------\n";
      }
    else  {
       char *p = strstr(s, "@XX");
       while (p) {
         subst(p);
         p = strstr(s, "@XX");
         }
       outf << s << endl;
       }
    }

 outf.close();
 data.close();
 cout << "completed" << endl;
 return 0;
}
