{ *******************************************************************
  *			    This file is part of the WMFH package				*
  ******************************************************************* }


{$R+}
{$S+}

PROGRAM  WMFHdemo ;

USES Crt, Dos, KB_Unit, MS_Unit, WND_Unit, MN_Unit, FS_Unit, HLP_Unit ;                                                    

CONST
		Deep_Green_color	=  3 ;
		Brown_color			=  6 ;
		Orange_color		=  5 ;
		Light_Red_color		=  1 ;

TYPE
		Palette_registers = PACKED ARRAY [0..16] OF Byte ;

VAR

		regs :                  Registers ;

		old_palette :           Palette_registers ;
		new_palette :           Palette_registers ;

		{ user input }

		key:        Word ;
		action:     Word ;


		{ menus }

		file_menu,
		help_menu:    Integer ;

		menu_bar:	  Integer ;	            

		file_name:	  String ;
		current_mask: String ;



{ ************************************************************************
  *                                                                      *
  *			   			Check for special key						     *
  *                                                                      *
  ************************************************************************ }

FUNCTION  special_key : Boolean ;
BEGIN
		special_key := (Hi(key) = 0)  OR  (Lo(Key) < Ord(' ')) ;
END ;


{ ************************************************************************
  *                                                                      *
  *               		Build command bar menus                          *
  *                                                                      *
  ************************************************************************ }

PROCEDURE  build_menus ;
BEGIN
		file_menu := MN_new_menu  ('',
								   WND_Single_frame,
								   WND_Transparent_shadow,
								   24,
								   LightGray,
								   Black,       
								   Red,
								   DarkGray,
								   Deep_Green_color,
								   White,
								   Light_Red_color ) ;

		MN_menu_line (file_menu,KB_AltM,0,'Set file \emask ', 'Alt-M') ;
		MN_menu_line (file_menu,KB_AltS,0,'\eSelect a file ', 'Alt-S') ;

		help_menu := MN_new_menu ( '', 
								   WND_Single_frame,
								   WND_Transparent_shadow,
								   24,
								   LightGray,
								   Black,      
								   Red,
								   Orange_color,
								   Deep_Green_color,
								   White,
								   Light_Red_color ) ;

		MN_menu_line (help_menu,1 ,0, 'Help on \eDemo program', '') ;
		MN_menu_line (help_menu,2 ,0, 'Help on \eHelp', '') ;

		menu_bar :=  MN_new_menu_bar ( LightGray, Black,
									   Red,
									   Deep_Green_color,
									   White,
									   Light_Red_color) ;

		MN_menu_bar_entry (menu_bar, '\eFile selection', file_menu,
						   Menu_entry) ;
		MN_menu_bar_entry (menu_bar, '\eHelp',help_menu,
						   Menu_entry) ;
		MN_menu_bar_entry (menu_bar, 'E\exit', KB_AltX, Command_entry) ;

END ;



{ ************************************************************************
  *                                                                      *
  *                       Display a message                              *
  *                                                                      *
  ************************************************************************ }

PROCEDURE  display_message (title, message: String) ;
VAR
		n, msg_save:	 Integer ;
		no_save:	     Integer ;
		y:            	 Integer ; 
		ws:           	 String ;  
BEGIN
		WND_Save_Cursor (False) ;

		ws := message ;
		WHILE (Length(ws)>0) AND (ws[Length(ws)] = ' ')  DO
			Dec(ws[0]) ;

		n := (Length(ws) + Length(ws) MOD 2) DIV 2 ;
		msg_save := 1 ;

		y := 8 ;
		WND_Open_Window (y, 40-n-4, y+4, 40+n+4,
						 LightGray, Deep_Green_color,
						 WND_solid_shadow, WND_no_frame,
						 '',
						 msg_save) ;
		no_save := 0 ;
		WND_Open_Window (y, 40-n-3, y+4, 40+n+3,
						 LightGray, Deep_Green_color,
						 WND_no_shadow, WND_double_frame,
						 title,
						 no_save) ;
		gotoXY (40-n+1, y+2) ;
		TextColor(White) ;
		write (ws) ;

		REPEAT  UNTIL  KeyPressed  OR  MS_LeftPressed  OR  MS_RightPressed ;

		IF  KeyPressed  THEN
			key := KB_read ;
		IF  MS_LeftPressed  THEN
		  REPEAT UNTIL NOT  MS_LeftDown ;
		IF  MS_RightPressed THEN
		  REPEAT UNTIL NOT  MS_RightDown ;

		WND_Close_window (msg_save) ;
		WND_Restore_Cursor ;
END ;


{ ************************************************************************
  *                                                                      *
  *                       Enter a file mask                              *
  *                                                                      *
  ************************************************************************ }

PROCEDURE  get_file_mask ;

	FUNCTION rtrim (s:  String):   String ;
	VAR
		ws:  String ;
	BEGIN
		ws := s ;
		WHILE (Length (ws) > 0) AND (ws [Length (ws) ] = ' ')  DO
		  Dec (ws [0]) ;
		rtrim := ws ;
	END ;

VAR
		n, msg_save:	 Integer ;
		wnd_save:	     Integer ;
		no_save:	     Integer ;
		y:            	 Integer ; 
		status:			 Word ;
		mouse:			 Integer ;
BEGIN
		WND_Save_Cursor (False) ;
		n := 15;
		msg_save := 1 ;

		y := 8 ;
		WND_Open_Window (y, 40-n-4, y+4, 40+n+4,
						 Orange_color, Deep_Green_color,
						 WND_transparent_shadow, WND_no_frame,
						 '',
						 msg_save) ;
		no_save := 0 ;
		WND_Open_Window (y, 40-n-3, y+4, 40+n+3,
						 Orange_color, Deep_Green_color,
						 WND_no_shadow, WND_single_frame,
						 'Enter the file mask',
						 no_save) ;

		wnd_save := 1 ;
		WND_open_window (y+2, 50-n-1,
						 y+2, 50-n+12+1,
						 LightGray, Black,
						 WND_no_shadow, WND_no_frame,
						 '', wnd_save) ;
	
		mouse := 1 ;
		current_mask := rtrim ( WND_input ( y+2, 50-n,
											'*.*' ,
											' ',
											'',
											12,
											0,
											True,
											status,
											mouse
				  		  	  )   	      ) ;

		WND_Close_window (msg_save) ;
		WND_Restore_Cursor ;

END ;


{ ************************************************************************
  *                                                                      *
  *						Select a file name							     *
  *                                                                      *
  ************************************************************************ }

PROCEDURE  select_file ;
BEGIN
		file_name := '' ;
		FS_open ('.', current_mask, '', 'Select a file', 'n', file_name) ;
		IF  file_name <> ''  THEN
		  display_message ('File Selection', 'You selected: '+ file_name) 
		ELSE
		  display_message ('File Selection', 'You did not select a file') ;
END ;


{ ************************************************************************
  *                                                                      *
  *						Interpret key pressed						     *
  *                                                                      *
  ************************************************************************ }

PROCEDURE  interpret_key  ;

BEGIN

		CASE  key  OF
		
		KB_AltM:			get_file_mask ;  

		KB_AltS:			select_file ;

		KB_AltX:				;

		ELSE                                      
		  IF  key = 1  THEN
				HLP_display_area (1, 'Help on Demo') ;
		  IF  key = 2  THEN
				HLP_display_area (2, 'Help on Help') ;

		END ;

END ;



{ ************************************************************************
  *                                                                      *
  *							Initialize units						     *
  *                                                                      *
  ************************************************************************ }

PROCEDURE  initialize_units ;
CONST
	help_palette: HLP_palette =	
				  (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15) ;
BEGIN

	{ Help unit }

	HLP_window_BG	:= LightGray ;
	HLP_window_FG	:= Black ;

	HLP_text_BG 	:= Black ;
	HLP_text_FG 	:= Green ;

	HLP_reference_FG :=	LightGray ;
	HLP_reference_BG := HLP_text_BG ;

	HLP_popup_reference_FG := LightGreen ;
	HLP_popup_reference_BG := HLP_text_BG ;

	HLP_highlighted_reference_FG :=	White ;
	HLP_highlighted_reference_BG := Brown_color ;

 	HLP_popup_FG	:= Red ;
	HLP_popup_BG	:= LightGray ;

	HLP_popup_text_BG := LightGray ;
	HLP_popup_text_FG := Black ;

	HLP_popup_title_line_FG := Red ;
	HLP_popup_title_line_BG := LightGray ;

	HLP_text_scroll_bar_BG			:=	Brown_color;
	HLP_text_scroll_bar_button_BG	:=	Deep_Green_color ;
	HLP_text_scroll_bar_button_FG	:=	Green ;

	HLP_window_BG 	   := LightGray ;
	HLP_button_BG	   := Deep_Green_color ;	
	HLP_button_FG 	   := LightGray ;
	HLP_button_high_FG := Orange_color ;

	HLP_title_line_FG  := Red ;
	HLP_title_line_BG  := HLP_window_BG	;

	HLP_first_line	   := 3 ;	
	HLP_last_line	   := 25 ;	
	HLP_first_column   := 1 ;	
	HLP_last_column	   := 80 ;	


	IF  HLP_init ('demohelp.hlp', help_palette) = 0  THEN
	;
 
	{ File Selection unit }

	FS_file_list_BG       := Black ;
	FS_file_list_FG       := Green ;
	FS_sel_file_BG		  := Brown ;
	FS_sel_file_FG		  := White ;
	FS_button_BG          := Deep_Green_color ;
	FS_button_special_BG  := Red ;
	FS_button_FG          := LightGray ;
	FS_button_high_FG     := Orange_color ;
	FS_button_special_FG  := Brown_color ;
	FS_text_FG            := Black ;
	FS_text_BG            := LightGray ;
	FS_first_line 		  := 3 ;

	{ Windows unit }

	WND_Transparent_shadow_palette_number :=  DarkGray ;

END ;


{ ************************************************************************
  *                                                                      *
  *				  		Change the palette							     *
  *                                                                      *
  ************************************************************************ }

PROCEDURE  change_palette ;
VAR
		i: Integer ;
BEGIN
		regs.ax := 3 ;          { select 80 by 25  16-color alphanumeric }
		Intr ($10, regs) ;

		regs.ax := $1009 ;      { read all palette registers (VGA only)  }
		regs.es := Seg(old_palette) ;
		regs.dx := Ofs(old_palette) ;
		Intr ($10, regs) ;

		new_palette := old_palette ;

		new_palette [Deep_Green_color]  := 16 ;
		new_palette [Brown_color]	    := 20 ;
		new_palette [Orange_color]	    := 46 ;
		new_palette [Light_Red_color]	:= 44 ;

		regs.ax := $1002 ;      
		regs.es := Seg(new_palette) ;
		regs.dx := Ofs(new_palette) ;
		Intr ($10, regs) ;           { set all palette registers }

		regs.bl := 0 ;
		regs.ax := $1003 ;
		Intr ($10,regs) ;            {disable blinking}
END ;


{ ************************************************************************
  *                                                                      *
  *						Restore palette								     *
  *                                                                      *
  ************************************************************************ }

PROCEDURE  restore_palette ;
BEGIN
		 regs.ax := 3 ;              { select 80 by 25  16-color alphanumeric }
		 Intr ($10, regs) ;
		 regs.ax := $1002 ;          { set all palette registers }
		 regs.es := Seg(old_palette) ;
		 regs.dx := Ofs(old_palette) ;
		 Intr ($10, regs) ;
END ;

{ ************************************************************************
  *                                                                      *
  *							Fill the screen							     *
  *                                                                      *
  ************************************************************************ }

PROCEDURE  fill_screen ;
VAR
		i, n:	Integer;
CONST
		pattern:	String = 'demo program ';
BEGIN
		MS_hide ;
		n := 1 ;
		i := 320 ;
		WHILE  i <= 3998  DO
		  BEGIN
		    Mem[$B800:i]   := Ord(pattern [n]) ;
		    Mem[$B800:i+1] := $67 ;
			Inc(n) ;
			IF  n > Length(pattern)  THEN
				n := 1 ;
			Inc (i,2) ;
		  END ;
		MS_show ;
END ;

{ **************************************************************************
  * ********************************************************************** *
  * *                                                                    * *
  * *                     T H E    P R O G R A M			             * *
  * *                                                                    * *
  * ********************************************************************** *
  ************************************************************************** }

BEGIN

		current_mask := '*.*' ;

		change_palette ;		
		initialize_units ;
		fill_screen ;
		build_menus ;
		MN_show_menu_bar (menu_bar, 1, 1, 80) ;
		display_message	('',' A simple demo program for the WMFH package');
		WND_Save_Cursor (False) ;

		{ the main loop }

		REPEAT

		  key := 0 ;
		  action := 0 ;

		  MS_Show ;

		  REPEAT
		  UNTIL  KeyPressed  OR  MS_LeftPressed  OR  MS_RightPressed ; 

		  IF  KeyPressed  THEN
			key := KB_read ;

		  action := MN_check_menu_bar (menu_bar, key) ;

		  IF  action <> 0  THEN
		  	key := action ;

		  IF  special_key  THEN
			  interpret_key ;

		UNTIL  special_key  AND  (key = KB_AltX)  ;

		restore_palette ;
		WND_Save_Cursor (True) ;

END.


