(*Simple ugraf example program*)
(*Shows basic mouse functions*)

program ex03;

uses ugraf;

(*Let's define a mouse pointer*)
(*Don't forget that a "neutral" AND is $ffffffff, cause we can go up to 32bits*)
const cmouse_and : tmouse_ptr=
((0,0,0,0,0,0,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff),
(0,0,0,0,0,0,0,0,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff),
($ffffffff,0,0,0,0,0,0,0,0,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff),
($ffffffff,0,0,0,0,0,0,0,0,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff),
($ffffffff,$ffffffff,0,0,0,0,0,0,0,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff),
($ffffffff,$ffffffff,$ffffffff,0,0,0,0,0,0,0,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff),
($ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,0,0,0,0,0,0,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff),
($ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,0,0,0,0,$ffffffff,$ffffffff,$ffffffff,
$ffffffff),
($ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,0,0,0,0,$ffffffff,$ffffffff,
$ffffffff),
($ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,0,0,0,$ffffffff,
$ffffffff,$ffffffff),
($ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,0,5,$ffffffff,
$ffffffff,$ffffffff),
($ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,
$ffffffff,$ffffffff,$ffffffff,$ffffffff),
($ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,
$ffffffff,$ffffffff,$ffffffff,$ffffffff),
($ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,
$ffffffff,$ffffffff,$ffffffff,$ffffffff),
($ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,
$ffffffff,$ffffffff,$ffffffff,$ffffffff),
($ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,$ffffffff,
$ffffffff,$ffffffff,$ffffffff,$ffffffff));

cmouse_or : tmouse_ptr =
((15,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,15,4,15,4,14,0,5,0,0,0,0,0,0,0,0),
(0,0,12,4,12,4,5,7,5,0,0,0,0,0,0,0),
(0,0,14,12,4,14,5,7,5,0,0,0,0,0,0,0),
(0,0,0,14,14,5,7,15,5,0,0,0,0,0,0,0),
(0,0,0,0,5,7,15,7,7,5,0,0,0,0,0,0),
(0,0,0,0,0,5,5,5,15,7,5,0,0,0,0,0),
(0,0,0,0,0,0,0,0,5,15,7,5,0,0,0,0),
(0,0,0,0,0,0,0,0,0,5,15,7,5,0,0,0),
(0,0,0,0,0,0,0,0,0,0,5,15,5,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,5,5,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0));

const resolution_x  : word = 320;
      resolution_y  : word = 200;
      bits_per_pixel = 8;

var oldspx, oldspy, olddouble : integer;
    oldbutton : byte;

function IntEnStr(i: integer): STRING;
(*Converts an integer to a string*)
var
   s: string[21];
begin
     Str(i, s);
     IntEnStr := s;
end;

begin
     if find_best_mode(resolution_x, resolution_y, bits_per_pixel)=-1
        then begin
             done_graf;
             writeln('Can''t find a mode !!!');
             halt(250);
        end;


     if not init_mode then begin
        done_graf;
        writeln('Impossible to switch to mode : ', mode);
        halt(2);
     end;

     (*Draw some stuff*)
     line(screen, 0, 0, getmaxx-1, getmaxy-1, $8a0f);
     ellipse(screen, getmaxx div 2, getmaxy div 2, getmaxy div 5, getmaxy div 5, $8a0e);
     fillarea(screen, (getmaxx div 2)+5, (getmaxy div 2)+1, $8a0d);

     init_mouse(cmouse_and, cmouse_or);

     read_key;

     (*Now, you can just go on the middle of the screen*)
     define_zone(getmaxx div 3, getmaxy div 3, getmaxx - ( getmaxx div 3 ), getmaxy - ( getmaxy div 3 ) );
     read_key;

     (*Let's define a turbo mouse*)
     get_speed(oldspx, oldspy, olddouble);
     define_speed(2, 2);
     define_double_speed_limit(1);
     read_key;
     (*Switch back*)
     define_speed(oldspx, oldspy);
     define_double_speed_limit(olddouble);

     hide_mouse;
     printat(screen, 0, 100, 'Hit mouse buttons', $8a0f, 0);
     show_mouse;
     oldbutton:=255;
     while not keypressed do begin
           if oldbutton<>mouse_button
              then begin
                   hide_mouse;
                   printat(screen, 0, 0, intenstr(mouse_button), $8a0f, 0);
                   show_mouse;
                   oldbutton:=mouse_button;
              end;
     end;
     read_key;

     (*End*)
     done_mouse;
     done_graf;
end.