(*****************************************************************************

  Program: Text editor demonstration.

    This program is only intended as a demonstration program for the TextEdit
    text editor unit.

  Features:
    Ties together all the features of the TextEdit editor with other units.
    Establishes a nice consistent interface for the user.
    Keystroke for exiting - ^KQ.
    Keystroke for saving - ^JS, [f2].
    Keystroke for saving and exiting - ^KD.
    Keystroke for changing environmental values - ^KA.
    Command menu activated by [f10] or pointer button 2.
    Allows use of the pointer for text minupulation.

  Limitations:
    In the Integrated development unit, this program will only run with the
      Squash flag set and Check unset.
    This program runs better with more memory available to it.

  Copyright 1994, All rights reserved.
    P. Renaud.

  Compiler:
    Turbo Pascal versions 5.0 to 6.0

  System:
    MS-DOS, MDOS

*****************************************************************************)

Program TextDemo( Input, Output, InFile );

  {$DEFINE Point}   { Determines if the pointer is to be used. }
  {$DEFINE Squash}  { Compresses the memory necessary to run the program. }

  Uses
   { Standard units. }
    CRT, DOS,
   { These other units are used for the user interface. }
    Over, Core, Menu, Pick, Editor, Windows, Indicators,
   { These units are necessary for the command extensions. }
    TextLine, KeyBoard,
   { The main demonstration units. }
    TextEdit, TextLink,
   { This unit is an extension to this file. }
    TDemo2,
   {$IFDEF Point}
    Pointer, WindExtra,
   {$ENDIF}
    TextCorrect,
    TextExtras;

   {$IFDEF Squash}
    { These units are overlaid to create more room. }
    {$O Core} {$O Menu} {$O String_Utilities}
    {$O Pick} {$O Editor} {$O Windows}
    {$O TDemo2} {$O Indicators} {$O BTree}
   {$ENDIF}

    {$O TextEdit}
    {$O TextExtras}
    {$O TextCorrect}

  Var
   { Signals if the window opened properly. }
    Window_Okay: Boolean;
   { Hold the old link routines. }
    Old_Control_J_Link,
    Old_Control_K_Link: Procedure( Var All: All_Type; Character: Char; Var Start, Finish: Point_Type; Var Done: Boolean );
   { Hold the old function key link procedures. }
    Old_Function_Key: Procedure( Var Command: Byte; Var Character: Char );

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Write wait new.
    This procedure opens the window for the status
    display.

*************************************************)

  Procedure Write_Wait_New; Far;
    Begin
      Window_Okay := Open_Window( Frame_6, Window_Pop, 1, 1, 35, 6, Yellow_Character + Green_Background );
      If Window_Okay
        then
          Label_Window( Green_Character + White_Background, 'Please wait while processing' );
       Message_Normal := Cyan_Character + Green_BackGround;
       Message_HighLight := White_Character + Green_BackGround;
    End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Write complete new.
    This procedure closes the window for the
    status display.

*************************************************)

  Procedure Write_Complete_New; Far;
    Begin
      If Window_Okay
        then
          Close_Window( Window_Pop );
      Message_Normal := Save_Message_Normal;
      Message_HighLight := Save_Message_HighLight;
    End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Display status new.

*************************************************)

  Procedure New_Display_Status( Amount: Byte ); Far;
    Var
      Old_Attribute: Byte;
    Begin
      Old_Attribute := TextAttr;
      Display_Status_Default( Amount );
      TextAttr := Red_Character + Blue_BackGround;
      Side_Bar_Graph( 1, 3, 33, Amount );
      TextAttr := Old_Attribute;
    End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: New heap error.
    This function makes the allocation procedures
    return nul when there isn't enough memory to
    allocate the pointer variable.

*************************************************)

  Function New_Heap_Error( Size: Word ): Integer; Far;
    Begin
      New_Heap_Error := 1;
    End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Get confirmation of change new.
    This procedure is called to allow the
    confirmation of changing the indicated word
    in the text.

*************************************************)

  Function Get_Confirmation_Of_Change_New: Char; Far;
    Var
      Okay: Boolean;
    Begin
      Okay := Open_Window( Frame_1, Window_Pop, 1, 1, 40, 4, Green_Character + Black_BackGround );
      If Okay
        then
          Label_Window( White_Character + Green_BackGround, ' Item found ' );
      Get_Confirmation_Of_Change_New := Get_Confirmation_Of_Change_Default;
      If Okay
        then
          Close_Window( Window_Pop );
    End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: New control key link.
    This procedure links in before the old link
    so that the new ^K commands can be processed.

*************************************************)

  Procedure New_Control_K_Link( Var All: All_Type; Character: Char; Var Start, Finish: Point_Type; Var Done: Boolean ); Far;
    Begin
      Case Character of
        'Q': Done := True;
        'D': Begin
               Done := True;
               Exit_Character := 'S';
             End;
        else
          Old_Control_K_Link( All, Character, Start, Finish, Done );
      End; { Case }
    End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: New control J link.
    This procedure links in before the old link
    so that the new ^J commands can be processed.

*************************************************)

  Procedure New_Control_J_Link( Var All: All_Type; Character: Char; Var Start, Finish: Point_Type; Var Done: Boolean ); Far;
    Begin
      Case Character of
        'A': Alter_Global_Variables;
        'S': Begin
               Done := True;
               Exit_Character := 'C';
             End;
        else
          Old_Control_J_Link( All, Character, Start, Finish, Done );
      End; { Case }
    End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: New function key
    This procedure links into the system so that
    the new function key commands can be
    implemented.

*************************************************)

  Procedure New_Function_Key( Var Command: Byte; Var Character: Char ); Far;
    Begin
      Case Command of
        Press_Shift_F1: Function_Key_Help( Pred( Right_Of_Window^ - Left_Of_Window^ ) );
        Press_F2: Begin { Save }
                    Command := Press_Control_J;
                    Character := 'S';
                  End;
        Press_Shift_F2: Begin { Save and exit }
                          Command := Press_Control_K;
                          Character := 'D';
                        End;
        Press_F3: Command := Press_Control_L; { Repeat search }
        Press_Shift_F3: Command := Press_Search; { Search }
        Press_Control_F3: Command := Press_Replace; { Search & replace }
        Press_F4: Begin { Print text }
                    Command := Press_Control_J;
                    Character := 'P';
                  End;
        Press_Shift_F4: Command := Press_Print_Block; { Print block }
        Press_F5: Begin { Reform paragraph }
                    Command := Press_Control_J;
                    Character := 'O';
                  End;
        Press_Shift_F5: Begin { Reform block }
                          Command := Press_Control_J;
                          Character := 'K';
                        End;
        Press_Control_F5: Begin { Reform text }
                            Command := Press_Control_J;
                            Character := 'Q';
                          End;
        Press_F6: Command := Press_Center_Text; { Center text }
        Press_Shift_F6: Command := Press_Left_Margin; { Set left margin }
        Press_Control_F6: Command := Press_Right_Margin; { Set right margin }
        Press_F7: Command := Press_Mark_Block_Top; { Set block start }
        Press_Shift_F7: Command := Press_Move_Block_Top; { Goto block start }
        Press_F8: Command := Press_Mark_Block_End; { Set block finish }
        Press_Shift_F8: Command := Press_Move_Block_End; { Goto block finish }
        Press_F9: Begin { Show location }
                    Command := Press_Control_J;
                    Character := ' ';
                  End;
        Press_Shift_F9: Begin { Goto line }
                          Command := Press_Control_J;
                          Character := 'N';
                        End;
        Press_F10,
        Press_Shift_F10,
        Press_Alternate_F,
        Press_Alternate_E,
        Press_Alternate_S,
        Press_Alternate_P,
        Press_Alternate_O,
        Press_Alternate_H,
        Press_Control_F10: Display_Bar_Menu( Command, Character );
        Press_Alternate_X: Command := Press_Escape;
        else Old_Function_Key( Command, Character );
      End; { Case }
    End;

{----------------------------------------------------------------------------}

(*************************************************

  Main section.
    This section indulgences all the variable
    procedures to the new routines and
    calls the main system.

*************************************************)

  Begin
    HeapError := @New_Heap_Error;
    Old_Control_K_Link := Control_K_Link;
    Control_K_Link := New_Control_K_Link;
    Old_Control_J_Link := Control_J_Link;
    Control_J_Link := New_Control_J_Link;
    Old_Function_Key := Function_Key;
    Function_Key := New_Function_Key;
    Write_Wait := Write_Wait_New;
    Write_Complete := Write_Complete_New;
    TextLink.Display_Status := New_Display_Status;
    Get_Confirmation_Of_Change := Get_Confirmation_Of_Change_New;
   {$IFDEF Point}
    Button2_Up := Press_F10;
    Extra_Interface := Add_Interface;
   {$ENDIF}
    Main_System;
  End.

