{$B-} { Compiler Directive: Complete Boolean equation evaluation: Off }
{$F+} { Compiler Directive: Generate far procedure calls: On } { DO NOT CHANGE! }
{$O+} { Compiler Directive: Generate overlay code: On }

(*****************************************************************************

  Multiple
    version 2.3

    This unit is an alternative window management unit.  It allows the use of
    several overlapping windows simultaneously.

    Purpose:
      This unit is designed to allow the creation of several virtual windows
      in memory.  The windows are then mapped onto the screen in an over-
      lapping fashion.

    How it works:
      If the window is invisible, all writes to that window will only be
      stored in memory.  If the window is visible, all writes will be stored
      in memory and put on uncovered portions of the screen.  The screen is
      automatically updated for all procedures and functions.  If the screen
      window is smaller then the virtual window, the remainder of the window
      may be viewed with the Move_View functions or the browse procedure.

    Features:
      Each window may receive output from it's own file, or they can all be
      accessed by the default file.

    Limitations:
      The maximum amount of windows that the unit will allow at one time is
        determined by maxwindows which can not exceed 128.

    Versions
      2.0 - Increased the window area and reorganized the routines for better
            and faster service.
      2.1 - Includes the delay routine to slow down the window animation.
      2.2 - Included the new Sink and Float routines.
      2.3 - Expanded the codes for window types.

    Copyright 1989, All rights reserved.
      Paul R. Renaud

    Compilers:
      Turbo Pascal versions 4.0 to 6.0

    Systems:
      MS-DOS, MDOS

    WARNING!   This unit is not compatible with the Windows unit.

*****************************************************************************)

Unit Multiple;

  Interface

    Uses
      DOS,
      CRT,
      Core,
      KeyBoard;

(***********************************************************

  Visibility values.
    These are the values used to set the window visible or
    invisible.

***********************************************************)

    Const
      Visible   = 1;
      Invisible = 0;

(***********************************************************

  Maximum windows.
    This constant reflects the maximum amount of windows
    that the code will allow.  This value can range from
    one to 128, because only the first seven bits will be
    used.

***********************************************************)

      Max_Windows = 40; { Must be less than 128 }

(***********************************************************

  Attributes.
    All the possible attribute combinations can be put
    together with the following codes in an additive
    formation.
      For example...
        Red_Character + Black_Background
        Light_Blue_Character + Yellow_Background + Flashing
        Reverse_Video_Character + Flashing

***********************************************************)

      Black_Background   = 0;
      Blue_Background    = 16;
      Green_Background   = 32;
      Cyan_Background    = 48;
      Red_Background     = 64;
      Magenta_Background = 80;
      Yellow_Background  = 96;
      White_Background   = 112;

      Black_Character         = 0;
      Blue_Character          = 1;
      Green_Character         = 2;
      Cyan_Character          = 3;
      Red_Character           = 4;
      Magenta_Character       = 5;
      Brown_Character         = 6;
      Light_Gray_Character    = 7;
      Dark_Gray_Character     = 8;
      Light_Blue_Character    = 9;
      Light_Green_Character   = 10;
      Light_Cyan_Character    = 11;
      Light_Red_Character     = 12;
      Light_Magenta_Character = 13;
      Yellow_Character        = 14;
      White_Character         = 15;

      Flashing = 128;

      No_Character                = 0;
      Dim_Underlined_Character    = 1;
      Dim_Character               = 2;
      Bright_Underlined_Character = 9;
      Bright_Character            = 10;
      Reverse_Video_Character     = 112;

(***********************************************************

  Frame styles.
    These are the standard frame styles used in creating a
    window.

***********************************************************)

      No_Frame = Core.No_Frame;
      Frame_1  = Core.Frame_1;
      Frame_2  = Core.Frame_2;
      Frame_3  = Core.Frame_3;
      Frame_4  = Core.Frame_4;
      Frame_5  = Core.Frame_5;
      Frame_6  = Core.Frame_6;
      Frame_7  = Core.Frame_7;
      Frame_8  = Core.Frame_8;
      Frame_9  = Core.Frame_9;
      Frame_10  = Core.Frame_10;
      Frame_11  = Core.Frame_11;
      Frame_12  = Core.Frame_12;
      Frame_13  = Core.Frame_13;
      Frame_14  = Core.Frame_14;
      Frame_15  = Core.Frame_15;
      Frame_16  = Core.Frame_16;
      Frame_17  = Core.Frame_17;
      Frame_18  = Core.Frame_18;
      Frame_19  = Core.Frame_19;
      Frame_20  = Core.Frame_20;
      Frame_21  = Core.Frame_21;
      Frame_22  = Core.Frame_22;
      Frame_23  = Core.Frame_23;
      Frame_24  = Core.Frame_24;


(***********************************************************

  Methods of opening and closing the windows.
    These are the possible ways of opening and closing the
    window on the screen.  Underlapping windows may not be
    completely visible for the animation.

***********************************************************)

      Window_Up = 1;
      Window_Pop = 2;
      Window_Left = 3;
      Window_Down = 4;
      Window_Right = 5;
      Window_Explode = 6;
      Window_Up_Left = 7;
      Window_Up_Right = 8;
      Window_Vertical = 9;
      Window_Down_Left = 10;
      Window_Down_Right = 11;
      Window_Horizontal = 12;
      Window_Vertical_Up = 13;
      Window_Vertical_Down = 14;
      Window_Horizontal_Left = 15;
      Window_Horizontal_Right = 16;

(***********************************************************

  Delay amount.
    Amount of delay used for window animation sequences.

***********************************************************)

      Delay_Amount: Byte = 0;

(***********************************************************

  Function: Create a new virtual Window on the screen.

    This function creates a virtual window on the screen at
    the given location.  The function returns a value
    corresponding to the first available window location.
    The higher this value is, the higher screen priority it
    will have. A window with a high value will not be
    covered by a window with a lower value.  New windows are
    automatically assigned the default output file so that
    programs will automatically write to the top-most
    window.
    Row_Size gives the height of the actual window to be
     allocated.
    Column_Size gives the width of the actual window to be
     allocated.
    View determines If the window is visible or invisible.
    Frame indicates which frame the window will have around
     it.
    Attribute determines the color of the window's text and
     background.
    Method determines the animation sequence used create
     window.

***********************************************************)

  Function Create_Window( Frame, Method, Left, Top, Right, Bottom, Attribute, Row_Size, Column_Size, View: Byte ): Byte;

(***********************************************************

  Procedure: Destroy a window on the screen.

    This procedure deletes the given window from the system.
    Then it automatically assigns the default file to that
    of the topmost window.  Any other file assigned to this
    window should also be reassigned.

***********************************************************)

  Procedure Destroy_Window( Var Which_Window: Byte; Method: Byte );

(***********************************************************

  Procedure: Browse through a virtual window.

    This procedure allows a complete examination of the
    contents of a virtual window.  It supports all the
    standard screen moving function keys.  The procedure
    will automatically make the window visible if it is
    invisible but all higher priority windows will still
    cover the specified windows so they should be moved
    before use.  This procedure will exit when enter or
    escape is pressed.

***********************************************************)

  Procedure Browse( Which_Window: Byte );

(***********************************************************

  Function: Float the window.

    This function allows the specified window to gain the
    topmost status on the window stack.  This function is
    recommended before browsing through a window.  The
    function returns true if the window can be floated,
    false if not.  The floated window is automatically made
    the active window.
   WARNING! The function assigns a new number for the
    window.

***********************************************************)

    Function Float( Var the_Window: Byte ): Boolean;

(***********************************************************

  Function: Sink the window.

    This function allows the specified window to be moved to
    the lowest available platform.  This function helps also
    squeeze the window stack.  Function returns true If the
    window can be sunk, false If not.
   WARNING!  The function assigns a new number for the
    window.

***********************************************************)

    Function Sink( Var the_Window: Byte ): Boolean;

(***********************************************************

  Procedure: Switch active window to new value.

    This function will simply reassign the default output
    file to the new window value.  It is easy to duplicate
    with the Assign_File_To_Window procedure, but this
    method is much faster.  New_Window holds the window to
    be assigned to the default output file.

***********************************************************)

    Procedure Switch_Active_Window( New_Window: Byte );

(***********************************************************

  Procedure: Assign file to write to the specified Window.

    This procedure ties a file to the specified window.  It
    will work only as long as the window exists regardless
    of the window's visibility. If the window is destroyed,
    the file should be reassigned.
    The_file is the file to be assigned to the window.
    The_Window is the window which will be assigned to the
     file.

***********************************************************)

    Procedure Assign_File_To_Window( Var The_File: Text; The_Window: Byte );

(***********************************************************

  These procedures duplicate the ones in the CRT screen
    management unit but will work with the currently active
    virtual window.  The cursor position procedures work
    with the virtual screen's cursor, not the screen cursor.

***********************************************************)

    Procedure ClrEOL( The_Window: Byte );
    Procedure ClrScr( The_Window: Byte );
    Procedure GotoXY( The_Window, Column, Row: Byte );
    Function  WhereY( The_Window: Byte ): Byte;
    Function  WhereX( The_Window: Byte ): Byte;
    Procedure Change_Window_Attribute( The_Window, Column, Row, Length, Attribute: Byte );

(***********************************************************

  These procedures scroll the virtual window.
    These extensions allow the window screen to be scrolled
    in the specified directions: Up, Down, Left and Right.

***********************************************************)

    Procedure Scroll_Window_Up( The_Window: Byte );
    Procedure Scroll_Window_Down( The_Window: Byte );
    Procedure Scroll_Window_Right( The_Window: Byte );
    Procedure Scroll_Window_Left( The_Window: Byte );

(***********************************************************

  Procedure: Reposition the virtual window.

    This procedure allows for the movement and resizing of
    the specified virtual window.  The new window location
    is defined by the current window coordinates.
    The Move, Reduce & Expand functions are recommended
     because of speed in processing.

***********************************************************)

    Procedure Reposition_Window( The_Window, Left, Top, Right, Bottom: Byte );

(***********************************************************

  Functions: Move the current window.

    These functions allow for the movement of the specified
    virtual window.  The new window location is shifted from
    the current window coordinates.

***********************************************************)

    Function Move_Window_Up( The_Window: Byte ): Boolean;
    Function Move_Window_Down( The_Window: Byte ): Boolean;
    Function Move_Window_Left( The_Window: Byte ): Boolean;
    Function Move_Window_Right( The_Window: Byte ): Boolean;

(***********************************************************

  Functions: Expand the current window.

    These functions allows for the expandion of the
    specified virtual window.  The new window size is
    expanded from the current window coordinates.

***********************************************************)

    Function Expand_Window_Up( The_Window: Byte ): Boolean;
    Function Expand_Window_Down( The_Window: Byte ): Boolean;
    Function Expand_Window_Left( The_Window: Byte ): Boolean;
    Function Expand_Window_Right( The_Window: Byte ): Boolean;

(***********************************************************

  Functions: Reduce the current window.

    These functions allow for the reduction of the specified
    virtual window.  The new window size is reduced from the
    current window coordinates.

***********************************************************)

    Function Reduce_Window_Up( The_Window: Byte ): Boolean;
    Function Reduce_Window_Down( The_Window: Byte ): Boolean;
    Function Reduce_Window_Left( The_Window: Byte ): Boolean;
    Function Reduce_Window_Right( The_Window: Byte ): Boolean;

(***********************************************************

  Procedure: Change the virtual window's visibility.

    This procedure changes the visibility of the given
    window, making it either visible or invisible.

***********************************************************)

    Procedure Change_Window_Visibility( The_Window, View: Byte );

(***********************************************************

  Functions: Move the view in a virtual window.

    These procedures allow for moving the view in a virtual
    window which happens to be larger than the corresponding
    area on the screen.

***********************************************************)

    Function Move_View_Left( The_Window: Byte ): Boolean;
    Function Move_View_Right( The_Window: Byte ): Boolean;
    Function Move_View_Up( The_Window: Byte ): Boolean;
    Function Move_View_Down( The_Window: Byte ): Boolean;

(***********************************************************

  Procedure: Change the attribute in a virtual window.

    This procedure changes the attribute in the virtual
    window.

***********************************************************)

    Procedure Put_TextAttr( The_Window, New_Attribute: Byte );

(***********************************************************

  Procedure: Get the attribute for a virtual window.

    This procedure returns the current attribute of the
    given virtual window.

***********************************************************)

    Procedure Get_TextAttr( The_Window: Byte; Var Old_Attribute: Byte );

{----------------------------------------------------------------------------}

  Implementation

    Const
      No_Window = $FF;    { Value used to signify that no such window exists. }
      Max_Rows = 51;      { Maximum amount of rows allowed on the screen. }
      Max_Columns = 133;  { Maximum amount of columns allowed on the screen. }

    Type
      Extra_Record = Record { This is used for assigning files to windows. }
                       Current_Window: Byte;
                       Unused: array[ 1 .. 15 ] of Byte;
                     End;
      Window_Pointer_Type = ^Window_Type; { Used to hold information on the virtual windows. }
      Window_Type = Record
                      The_View,
                      Where_Top,
                      Where_Left,
                      Frame_Type,
                      Screen_Top,
                      Where_Right,
                      Screen_Left,
                      Screen_Right,
                      Where_Bottom,
                      Screen_Bottom: Byte;
                      The_Frame: Frame_Type;
                      Storage: Storage_Record;
                    End;
      Expand_Data_Type = Record { Used for window animation. }
                           Frame: Frame_Type;
                           Top,
                           Left,
                           Right,
                           Bottom,
                           Attribute,
                           Current_Top,
                           Current_Left,
                           Current_Right,
                           Current_Bottom: Byte;
                           Expand_Up,
                           Expand_Down,
                           Expand_Left,
                           Expand_Right: Boolean;
                           Window: Byte;
                         End;
      { Type used to hold the actual window data. }
      Window_Array_Type = packed array[ 0 .. Max_Windows ] of Window_Pointer_Type;
      { Array to hold information on the individual areas of the screen. }
      Screen_Check_Type = packed array[ 0 .. Max_Rows, 0 .. Max_Columns ] of Byte;
      Area_Type = packed array[ 0 .. Max_Columns ] of Cell_Type;
      Data_Area_Type = packed array[ 0 .. Max_Rows ] of Area_Type;
      { Holds the information for managing the windows. }
      Window_Work_Type = Record
                           Data: Data_Area_Type;
                           Screen_Check: Screen_Check_Type;
                           Windows: Window_Array_Type;
                           Default_Window: Byte;
                           Blank_Line: Area_Type;
                         End;

    Var
      Old_Exit_Pointer: Pointer;  { Points to the old exit procedure. }
      Data: ^Window_Work_Type;     { Points to the window management data. }

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Emergency exit.
    This procedure is designed to go into the
    exit procedure list to close the standard out-
    put so that data written to it won't be lost.

*************************************************)

    Procedure Emergency_Exit;
      Begin
        ExitProc := Old_Exit_Pointer;
       {$IFNDEF OS2}
        Assign( Output, '' );
        Rewrite( Output );
       {$ENDIF}
      End;

{////////////////////////////////////////////////////////////////////////////}

 {$I Multipl2.Pas}

{////////////////////////////////////////////////////////////////////////////}

(*************************************************

  Procedure: Reposition.
    This is the internal procedure that handles
    taking care of the window when it is resized
    or moved.

*************************************************)

    Procedure Reposition( The_Window, Left, Top, Right, Bottom: Byte );
      Var
        Old_Top,
        Old_Left,
        Old_Right,
        Old_Bottom: Byte;
      Begin
        With Data^.Windows[ The_Window ]^ do
          Begin
            Old_Top := Screen_Top;
            Old_Left := Screen_Left;
            Old_Right := Screen_Right;
            Old_Bottom := Screen_Bottom;
            If ( Frame_Type <> No_Frame )
              then
                Begin
                  Dec( Old_Top );
                  Dec( Old_Left );
                  Inc( Old_Right );
                  Inc( Old_Bottom );
                End;
            Screen_Right := Right;
            Screen_Top := Top;
            Screen_Left := Left;
            Screen_Bottom := Bottom;
            If ( Storage.Column_Length < Where_Right )
              then
                Begin
                  Where_Right := Storage.Column_Length;
                  Screen_Right := Pred( Where_Right + Screen_Left );
                End;
            If ( Storage.Row_Length < Where_Bottom )
              then
                Begin
                  Where_Bottom := Storage.Row_Length;
                  Screen_Bottom := Pred( Where_Bottom + Screen_Top );
                End;
            If ( Screen_Right > Old_Right )
              then
                Old_Right := Screen_Right;
            If ( Screen_Left < Old_Left )
              then
                Old_Left := Screen_Left;
            If ( Screen_Top < Old_Top )
              then
                Old_Top := Screen_Top;
            If ( Screen_Bottom > Old_Bottom )
              then
                Old_Bottom := Screen_Bottom;
          End;
        Update_All_Virtual_Windows( Old_Left, Old_Top, Old_Right, Old_Bottom );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Change window attribute.
    As previously defined.

*************************************************)

    Procedure Change_Window_Attribute( The_Window, Column, Row, Length, Attribute: Byte );
      Begin
        If not Check_Range( The_Window )
          then
            Begin
              Get_The_Mode;
              Change_Storage_Attribute( Data^.Windows[ The_Window ]^.Storage, Row, Column, Length, Attribute );
              Update_Virtual_Window( The_Window );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Create window.
    As previously defined.

*************************************************)

    Function Create_Window( Frame, Method, Left, Top, Right, Bottom, Attribute, Row_Size, Column_Size, View: Byte ): Byte;
      Var
        Counter,
        Locator: Byte;
        Okay: Boolean;
      Begin
        Create_Window := No_Window;
        Get_The_Mode;
        If ( Left < Right ) and ( Top < Bottom ) and ( Right <= Screen_Column_Limit ) and ( Bottom <= Screen_Row_Limit )
          then
            Begin
              Locator := No_Window;
              If ( Frame = No_Frame )
                then
                  Method := Window_Pop;
              For Counter := 0 to Max_Windows do
                If ( Data^.Windows[ Counter ] = Nil )
                  then
                    Locator := Counter;
              If ( Locator <> No_Window )
                then
                  Begin
                    If ( Row_Size = 0 )
                      then
                        Row_Size := Succ( Bottom - Top );
                    If ( Column_Size = 0 )
                      then
                        Column_Size := Succ( Right - Left );
                    New( Data^.Windows[ Locator ] );
                    If ( Data^.Windows[ Locator ] <> Nil )
                      then
                        With Data^.Windows[ Locator ]^ do
                          Begin
                            The_View := View;
                            Frame_Type := Frame;
                            Set_Window_Frame( The_Frame, Attribute, Frame );
                            Screen_Right := Right;
                            Screen_Top := Top;
                            Screen_Bottom := Bottom;
                            Screen_Left := Left;
                            Storage.Row_Length := Row_Size;
                            Storage.Column_Length := Column_Size;
                            Storage.Cursor_Column := 1;
                            Storage.Cursor_Row := 1;
                            Storage.Attribute := Attribute;
                            Where_Left := 1;
                            Where_Top := 1;
                            Where_Right := Succ( Screen_Right - Screen_Left );
                            Where_Bottom := Succ( Screen_Bottom - Screen_Top );
                            If ( Storage.Column_Length < Where_Right )
                              then
                                Begin
                                  Where_Right := Storage.Column_Length;
                                  Screen_Right := Pred( Where_Right + Screen_Left );
                                End;
                            If ( Storage.Row_Length < Where_Bottom )
                              then
                                Begin
                                  Where_Bottom := Storage.Row_Length;
                                  Screen_Bottom := Pred( Where_Bottom + Screen_Top );
                                End;
                            Storage.Amount := ( ( Storage.Row_Length * Storage.Column_Length ) * 2 );
                            Okay := Allocate_Storage( Storage );
                            If ( View = Visible )
                              then
                                Update_Screen_Check( Locator, Screen_Left, Screen_Top, Screen_Right, Screen_Bottom, Frame );
                          End;
                    If Okay
                      then
                        Begin
                          Clear_Storage( Data^.Windows[ Locator ]^.Storage );
                          If ( Method = Window_Pop )
                            then
                              Update_Virtual_Window( Locator )
                            else
                              If ( View = Visible )
                                then
                                  Frame_Animation( Locator, Method );
                         {$IFNDEF OS2}
                          Extra_Record( TextRec( Output ).UserData ).Current_Window := Locator;
                         {$ENDIF}
                          Data^.Default_Window := Locator;
                          Create_Window := Locator;
                        End;
                  End;
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Move view left.
    As previously defined.

*************************************************)

    Function Move_View_Left( The_Window: Byte ): Boolean;
      Begin
        If not Check_Range( The_Window )
          then
            With Data^.Windows[ The_Window ]^ do
              If ( Where_Left > 1 )
                then
                  Begin
                    Get_The_Mode;
                    Dec( Where_Left );
                    Dec( Where_Right );
                    Update_Virtual_Window( The_Window );
                    Move_View_Left := True;
                  End
                else
                  Move_View_Left := False;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Move view right.
    As previously defined.

*************************************************)

    Function Move_View_Right( The_Window: Byte ): Boolean;
      Begin
        If not Check_Range( The_Window )
          then
            With Data^.Windows[ The_Window ]^ do
              If ( Where_Right < Storage.Column_Length )
                then
                  Begin
                    Get_The_Mode;
                    Inc( Where_Left );
                    Inc( Where_Right );
                    Update_Virtual_Window( The_Window );
                    Move_View_Right := True;
                  End
                else
                  Move_View_Right := False;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Move view up.
    As previously defined.

*************************************************)

    Function Move_View_Up( The_Window: Byte ): Boolean;
      Begin
        If not Check_Range( The_Window )
          then
            With Data^.Windows[ The_Window ]^ do
              If ( Where_Top > 1 )
                then
                  Begin
                    Get_The_Mode;
                    Dec( Where_Top );
                    Dec( Where_Bottom );
                    Update_Virtual_Window( The_Window );
                    Move_View_Up := True;
                  End
                else
                  Move_View_Up := False;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Move view down.
    As previously defined.

*************************************************)

    Function Move_View_Down( The_Window: Byte ): Boolean;
      Begin
        If not Check_Range( The_Window )
          then
            With Data^.Windows[ The_Window ]^ do
              If ( Where_Bottom < Storage.Row_Length )
                then
                  Begin
                    Get_The_Mode;
                    Inc( Where_Top );
                    Inc( Where_Bottom );
                    Update_Virtual_Window( The_Window );
                    Move_View_Down := True;
                  End
                else
                  Move_View_Down := False;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Move view home.
    This function moves the view to the home
    position.

*************************************************)

    Function Move_View_Home( The_Window: Byte ): Boolean;
      Begin
        If not Check_Range( The_Window )
          then
            With Data^.Windows[ The_Window ]^ do
              Begin
                Get_The_Mode;
                While ( Where_Left > 1 ) do
                  Begin
                    Dec( Where_Left );
                    Dec( Where_Right );
                  End;
                Update_Virtual_Window( The_Window );
                Move_View_Home := True;
              End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Move view end.
    This function moves the view to the end
    position.

*************************************************)

    Function Move_View_End( The_Window: Byte ): Boolean;
      Begin
        If not Check_Range( The_Window )
          then
            With Data^.Windows[ The_Window ]^ do
              Begin
                Get_The_Mode;
                While ( Where_Right < Storage.Column_Length ) do
                  Begin
                    Inc( Where_Left );
                    Inc( Where_Right );
                  End;
                Update_Virtual_Window( The_Window );
                Move_View_End := True;
              End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Move view page up.
    This function moves the view one page up.

*************************************************)

    Function Move_View_PageUp( The_Window, Amount: Byte ): Boolean;
      Var
        Count: Byte;
      Begin
        If not Check_Range( The_Window )
          then
            With Data^.Windows[ The_Window ]^ do
              Begin
                Get_The_Mode;
                For Count := 1 to Amount do
                  If ( Where_Top > 1 )
                    then
                      Begin
                        Dec( Where_Top );
                        Dec( Where_Bottom );
                      End;
                Update_Virtual_Window( The_Window );
                Move_View_PageUp := True;
              End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Move view page down.
    This function moves the view one page down.

*************************************************)

    Function Move_View_PageDown( The_Window, Amount: Byte ): Boolean;
      Var
        Count: Byte;
      Begin
        If not Check_Range( The_Window )
          then
            With Data^.Windows[ The_Window ]^ do
              Begin
                Get_The_Mode;
                For Count := 1 to Amount do
                  If ( Where_Bottom < Storage.Row_Length )
                    then
                      Begin
                        Inc( Where_Top );
                        Inc( Where_Bottom );
                      End;
                Update_Virtual_Window( The_Window );
                Move_View_PageDown := True;
              End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Reposition window.
    As previously defined.

*************************************************)

    Procedure Reposition_Window( The_Window, Left, Top, Right, Bottom: Byte );
      Begin
        If not Check_Range( The_Window )
          then
            Begin
              Get_The_Mode;
              Reposition( The_Window, Left, Top, Right, Bottom );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Change window visibility.
    As previously defined.

*************************************************)

    Procedure Change_Window_Visibility( The_Window, View: Byte );
      Begin
        If not Check_Range( The_Window )
          then
            With Data^.Windows[ The_Window ]^ do
              Begin
                Get_The_Mode;
                The_View := View;
                If ( Frame_Type = No_Frame )
                  then
                    Update_All_Virtual_Windows( Screen_Left, Screen_Top, Screen_Right, Screen_Bottom )
                  else
                    Update_All_Virtual_Windows( Pred( Screen_Left ), Pred( Screen_Top ),
                                                Succ( Screen_Right ), Succ( Screen_Bottom ) );
              End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Close change window visibility.
    This procedure changes the window's visibility
    for closing.

*************************************************)

    Procedure Close_Change_Window_Visibility( The_Window, View, Method: Byte );
      Begin
        If not Check_Range( The_Window )
          then
            With Data^.Windows[ The_Window ]^ do
              Begin
                Get_The_Mode;
                The_View := View;
                If ( Frame_Type = No_Frame )
                  then
                    Close_No_Frame( Screen_Left, Screen_Top, Screen_Right, Screen_Bottom )
                  else
                    Close_Frame( The_Frame, Pred( Screen_Left ), Pred( Screen_Top ), Succ( Screen_Right ),
                                 Succ( Screen_Bottom ), Method, The_Window );
              End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: GotoXY.
    As previously defined.

*************************************************)

    Procedure GotoXY( The_Window, Column, Row: Byte );
      Begin
        If not Check_Range( The_Window )
          then
            With Data^.Windows[ The_Window ]^ do
              If ( Column <= Storage.Column_Length ) or ( Column >= 1 ) or
                 ( Row <= Storage.Row_Length ) or ( Row >= 1 )
                then
                  Begin
                     Storage.Cursor_Column := Column;
                     Storage.Cursor_Row := Row;
                  End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: ClrScr.
    As previously defined.

*************************************************)

    Procedure ClrScr( The_Window: Byte );
      Begin
        If not Check_Range( The_Window )
          then
            With Data^.Windows[ The_Window ]^ do
              Begin
                Get_The_Mode;
                Clear_Storage( Storage );
                Storage.Cursor_Column := 1;
                Storage.Cursor_Row := 1;
                Update_Virtual_Window( The_Window );
              End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: ClrEOL.
    As previously defined.

*************************************************)

    Procedure ClrEOL( The_Window: Byte );
      Var
        Column: Byte;
      Begin
        If not Check_Range( The_Window )
          then
            Begin
              Get_The_Mode;
              With Data^.Windows[ The_Window ]^ do
                For Column := Storage.Cursor_Column to Storage.Column_Length do
                  Put_To_Storage( Storage, Storage.Cursor_Row, Column, ' ', Storage.Attribute );
              Update_Virtual_Window( The_Window );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: WhereX.
    As previously defined.

*************************************************)

    Function WhereX( The_Window: Byte ): Byte;
      Begin
        If Check_Range( The_Window )
          then
            WhereX := 0
          else
            WhereX :=  Data^.Windows[ The_Window ]^.Storage.Cursor_Column;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: WhereY.
    As previously defined.

*************************************************)

    Function WhereY( The_Window: Byte ): Byte;
      Begin
        If Check_Range( The_Window )
          then
            WhereY := 0
          else
            WhereY :=  Data^.Windows[ The_Window ]^.Storage.Cursor_Row;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Scroll window up.
    As previously defined.

*************************************************)

    Procedure Scroll_Window_Up( The_Window: Byte );
      Begin
        If not Check_Range( The_Window )
          then
            Begin
              Get_The_Mode;
              Scroll_Storage_Up( Data^.Windows[ The_Window ]^.Storage );
              Update_Virtual_Window( The_Window );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Scroll window down.
    As previously defined.

*************************************************)

    Procedure Scroll_Window_Down( The_Window: Byte );
      Begin
        If not Check_Range( The_Window )
          then
            Begin
              Get_The_Mode;
              Scroll_Storage_Down( Data^.Windows[ The_Window ]^.Storage );
              Update_Virtual_Window( The_Window );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Scroll window left.
    As previously defined.

*************************************************)

    Procedure Scroll_Window_Left( The_Window: Byte );
      Begin
        If not Check_Range( The_Window )
          then
            Begin
              Get_The_Mode;
              Scroll_Storage_Left( Data^.Windows[ The_Window ]^.Storage );
              Update_Virtual_Window( The_Window );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Scroll window right.
    As previously defined.

*************************************************)

    Procedure Scroll_Window_Right( The_Window: Byte );
      Begin
        If not Check_Range( The_Window )
          then
            Begin
              Get_The_Mode;
              Scroll_Storage_Right( Data^.Windows[ The_Window ]^.Storage );
              Update_Virtual_Window( The_Window );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get text attribute.
    As previously defined.

*************************************************)

    Procedure Get_TextAttr( The_Window: Byte; Var Old_Attribute: Byte );
      Begin
        If not Check_Range( The_Window )
          then
            Old_Attribute := Data^.Windows[ The_Window ]^.Storage.Attribute;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Put text attribute.
    As previously defined.

*************************************************)

    Procedure Put_TextAttr( The_Window, New_Attribute: Byte );
      Begin
        If not Check_Range( The_Window )
          then
            Data^.Windows[ The_Window ]^.Storage.Attribute := New_Attribute;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Assign file to window.
    As previously defined.

*************************************************)

    Procedure Assign_File_To_Window( Var The_File: Text; The_Window: Byte );
      Begin
       {$IFNDEF OS2}
        With TextRec( The_File ) do
          Begin
            Mode := FmClosed;
            BufSize := SizeOf( Buffer );
            BufPtr := @Buffer;
            OpenFunc := @Window_Open;
            Name[ 0 ] := #0;
            Extra_Record( UserData ).Current_Window := The_Window;
          End;
       {$ENDIF}
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Switch active window.
    As previously defined.

*************************************************)

    Procedure Switch_Active_Window( New_Window: Byte );
      Begin
        If not Check_Range( New_Window )
          then
            Begin
             {$IFNDEF OS2}
              Extra_Record( TextRec( Output ).UserData ).Current_Window := New_Window;
             {$ENDIF}
              Data^.Default_Window := New_Window;
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Destroy window.
    As previously defined.

*************************************************)

    Procedure Destroy_Window( Var Which_Window: Byte; Method: Byte );
      Var
        Counter: Byte;
      Begin
        If not Check_Range( Which_Window )
          then
            Begin
              Close_Change_Window_Visibility( Which_Window, Invisible, Method );
              With Data^ do
                Begin
                  Deallocate_Storage( Windows[ Which_Window ]^.Storage );
                  Dispose( Windows[ Which_Window ] );
                  Windows[ Which_Window ] := Nil;
                End;
              For Counter := 0 to Max_Windows do
                If ( Data^.Windows[ Counter ] <> Nil )
                  then
                    Begin
                     {$IFNDEF OS2}
                      Extra_Record( TextRec( Output ).UserData ).Current_Window := Counter;
                     {$ENDIF}
                      Data^.Default_Window := Counter;
                    End;
              Which_Window := 0;
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Move window up.
    As previously defined.

*************************************************)

    Function Move_Window_Up( The_Window: Byte ): Boolean;
      Begin
        If Check_Range( The_Window )
          then
            Move_Window_Up := False
          else
            Begin
              Get_The_Mode;
              Move_Window_Up := Move_Up( The_Window );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Move window down.
    As previously defined.

*************************************************)

    Function Move_Window_Down( The_Window: Byte ): Boolean;
      Begin
        If Check_Range( The_Window )
          then
            Move_Window_Down := False
          else
            Begin
              Get_The_Mode;
              Move_Window_Down := Move_Down( The_Window );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Move window left.
    As previously defined.

*************************************************)

    Function Move_Window_Left( The_Window: Byte ): Boolean;
      Begin
        If Check_Range( The_Window )
          then
            Move_Window_Left := False
          else
            Begin
              Get_The_Mode;
              Move_Window_Left := Move_Left( The_Window );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Move window right.
    As previously defined.

*************************************************)

    Function Move_Window_Right( The_Window: Byte ): Boolean;
      Begin
        If Check_Range( The_Window )
          then
            Move_Window_Right := False
          else
            Begin
              Get_The_Mode;
              Move_Window_Right := Move_Right( The_Window );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Expand window up.
    As previously defined.

*************************************************)

    Function Expand_Window_Up( The_Window: Byte ): Boolean;
      Begin
        If Check_Range( The_Window )
          then
            Expand_Window_Up := False
          else
            Begin
              Get_The_Mode;
              Expand_Window_Up := Expand_Up( The_Window );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Expand window down.
    As previously defined.

*************************************************)

    Function Expand_Window_Down( The_Window: Byte ): Boolean;
      Begin
        If Check_Range( The_Window )
          then
            Expand_Window_Down := False
          else
            Begin
              Get_The_Mode;
              Expand_Window_Down := Expand_Down( The_Window );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Expand window left.
    As previously defined.

*************************************************)

    Function Expand_Window_Left( The_Window: Byte ): Boolean;
      Begin
        If Check_Range( The_Window )
          then
            Expand_Window_Left := False
          else
            Begin
              Get_The_Mode;
              Expand_Window_Left := Expand_Left( The_Window );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Expand window right.
    As previously defined.

*************************************************)

    Function Expand_Window_Right( The_Window: Byte ): Boolean;
      Begin
        If Check_Range( The_Window )
          then
            Expand_Window_Right := False
          else
            Begin
              Get_The_Mode;
              Expand_Window_Right := Expand_Right( The_Window );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Reduce window up.
    As previously defined.

*************************************************)

    Function Reduce_Window_Up( The_Window: Byte ): Boolean;
      Begin
        If Check_Range( The_Window )
          then
            Reduce_Window_Up := False
          else
            Begin
              Get_The_Mode;
              Reduce_Window_Up := Reduce_Up( The_Window );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Reduce window down.
    As previously defined.

*************************************************)

    Function Reduce_Window_Down( The_Window: Byte ): Boolean;
      Begin
        If Check_Range( The_Window )
          then
            Reduce_Window_Down := False
          else
            Begin
              Get_The_Mode;
              Reduce_Window_Down := Reduce_Down( The_Window );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Reduce window left.
    As previously defined.

*************************************************)

    Function Reduce_Window_Left( The_Window: Byte ): Boolean;
      Begin
        If Check_Range( The_Window )
          then
            Reduce_Window_Left := False
          else
            Begin
              Get_The_Mode;
              Reduce_Window_Left := Reduce_Left( The_Window );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Reduce window right.
    As previously defined.

*************************************************)

    Function Reduce_Window_Right( The_Window: Byte ): Boolean;
      Begin
        If Check_Range( The_Window )
          then
            Reduce_Window_Right := False
          else
            Begin
              Get_The_Mode;
              Reduce_Window_Right := Reduce_Right( The_Window );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Browse.
    As previously defined.

*************************************************)

    Procedure Browse( Which_Window: Byte );
      Var
        Okay,
        Done: Boolean;
        Amount,
        Result: Byte;
        Command: Char;
      Begin
        If not Check_Range( Which_Window )
          then
            Begin
              Get_The_Mode;
              With Data^.Windows[ Which_Window ]^ do
                Begin
                  Amount := ( Screen_Bottom - Screen_Top );
                  If ( The_View = Invisible )
                    then
                      Change_Window_Visibility( Which_Window, Visible );
                  Cursor_Row := ( Screen_Top + Screen_Bottom ) div 2;
                  Cursor_Column_Start := ( Screen_Left + Screen_Right ) div 2;
                  Cursor_Column_Finish := Cursor_Column_Start;
                End;
              Done := False;
              While KeyPressed do
                Command := ReadKey;
              Repeat
                Get_Command( Command, Result );
                Case Result of
                  Pointer_Down,
                  Press_Down_Arrow:
                    Okay := Move_View_Down( Which_Window );
                  Pointer_Up,
                  Press_Up_Arrow:
                    Okay := Move_View_Up( Which_Window );
                  Pointer_Right,
                  Press_Right_Arrow:
                    Okay := Move_View_Right( Which_Window );
                  Pointer_Left,
                  Press_Left_Arrow:
                    Okay := Move_View_Left( Which_Window );
                  Press_Escape:
                    Done := True;
                  Press_Enter:
                    Done := True;
                  Press_Home:
                    Okay := Move_View_Home( Which_Window );
                  Press_End:
                    Okay := Move_View_End( Which_Window );
                  Press_Page_Down:
                    Begin
                      With Data^.Windows[ Which_Window ]^ do
                        Amount := ( Screen_Bottom - Screen_Top );
                      Okay := Move_View_PageDown( Which_Window, Amount );
                    End;
                  Press_Page_Up:
                    Begin
                      With Data^.Windows[ Which_Window ]^ do
                        Amount := ( Screen_Bottom - Screen_Top );
                      Okay := Move_View_PageUp( Which_Window, Amount );
                    End;
                  Press_Control_Left_Arrow:
                    Okay := Move_Left( Which_Window );
                  Press_Control_Right_Arrow:
                    Okay := Move_Right( Which_Window );
                  Press_Control_Page_Up:
                    Okay := Move_Up( Which_Window );
                  Press_Control_Page_Down:
                    Okay := Move_Down( Which_Window );
                  Press_Alternate_F1:
                    Okay := Reduce_Window_Up( Which_Window );
                  Press_Alternate_F2:
                    Okay := Expand_Window_Down( Which_Window );
                  Press_Alternate_F3:
                    Okay := Reduce_Window_Left( Which_Window );
                  Press_Alternate_F4:
                    Okay := Expand_Window_Right( Which_Window );
                End; { Case }
              Until Done;
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Float.
    As previously defined.

*************************************************)

    Function Float( Var The_Window: Byte ): Boolean;
      Var
        Locator,
        Counter: Byte;
      Begin
        Float := False;
        Locator := No_Window;
        Counter := 0;
        Repeat
          Inc( Counter );
          If ( Data^.Windows[ Counter ] = Nil )
            then
              Locator := Counter;
        Until ( Data^.Windows[ Counter ] <> Nil ) or ( Counter = Max_Windows );
        If ( Locator <> No_Window )
          then
            Begin
              With Data^ do
                Begin
                  Windows[ Locator ] := Windows[ The_Window ];
                  Windows[ The_Window ] := Nil;
                End;
              The_Window := Locator;
              Float := True;
              With Data^.Windows[ The_Window ]^ do
                Begin
                  Get_The_Mode;
                  If ( Frame_Type <> No_Frame )
                    then
                      Update_All_Virtual_Windows( Pred( Screen_Left ), Pred( Screen_Top ),
                                                  Succ( Screen_Right ), Succ( Screen_Bottom ) )
                    else
                      Update_All_Virtual_Windows( Screen_Left, Screen_Top, Screen_Right, Screen_Bottom );
                End;
             {$IFNDEF OS2}
              Extra_Record( TextRec( Output ).UserData ).Current_Window := The_Window;
             {$ENDIF}
              Data^.Default_Window := The_Window;
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Sink.
    As previously defined.

*************************************************)

    Function Sink( Var The_Window: Byte ): Boolean;
      Var
        Locator: Byte;
        Counter: ShortInt;
      Begin
        Sink := False;
        Locator := No_Window;
        Counter := Max_Windows;
        Repeat
          If ( Data^.Windows[ Counter ] = Nil )
            then
              Locator := Counter;
          Dec( Counter );
        Until ( ( Counter < 0 ) or ( Locator <> No_Window ) );
        If ( Locator <> No_Window )
          then
            Begin
              With Data^ do
                Begin
                  Windows[ Locator ] := Windows[ The_Window ];
                  Windows[ The_Window ] := Nil;
                End;
              The_Window := Locator;
              Sink := True;
              With Data^.Windows[ The_Window ]^ do
                Begin
                  Get_The_Mode;
                  If ( Frame_Type <> No_Frame )
                    then
                      Update_All_Virtual_Windows( Pred( Screen_Left ), Pred( Screen_Top ),
                                                  Succ( Screen_Right ), Succ( Screen_Bottom ) )
                    else
                      Update_All_Virtual_Windows( Screen_Left, Screen_Top, Screen_Right, Screen_Bottom );
                End;
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Main initialization section.
    Allocate the data structure and initialize it.
    Set the exit procedure.
    Create the default window.

*************************************************)

    Var
      Counter: Byte;
    Begin
      New( Data );
      If ( Data = Nil )
        then
         {$IFDEF Ver40}
          Halt( 203 );
         {$ELSE}
          RunError( 203 );
         {$ENDIF}
      For Counter := 0 to Max_Windows do
        Data^.Windows[ Counter ] := Nil;
      Old_Exit_Pointer := ExitProc;
      ExitProc := @Emergency_Exit;
      Data^.Default_Window := Create_Window( No_Frame, $0, 1, 1, Screen_Column_Limit, Screen_Row_Limit, TextAttr, 0, 0,
                                             Visible );
      Assign_File_To_Window( Output, Data^.Default_Window );
     {$IFNDEF OS2}
      Rewrite( Output );
     {$ENDIF}
    End.


