{$F+} { Compiler Directive: Generate far procedure calls: On } { DO NOT CHANGE! }
{$O+} { Compiler Directive: Generate overlay code: On }

(*****************************************************************************

  Lock
    version 1.01

    This unit holds a simple procedure designed to lock the computer system.

    Purpose:
      To supply a procedure that locks the computer system when the user is
      away.

    How it works:
      It opens a window on the screen and asks for a password.
      After the password is entered, the system waits until the matching
      passwords is reentered.

    Features:
      Simple bouncing cursor animation displayed on the screen to signify
      that the system is locked.

    Limitations:
      Doesn't work as well in graphic mode.

    Versions:
      1.01 - Added support to compile under Speed Pascal/2.

    Copyright 1991, All rights reserved.
      Paul R. Renaud

    Compilers:
      Turbo Pascal versions 5.0 to 6.0
      Speed Pascal/2 version 1.5

    Systems:
      MS-DOS, MDOS, OS/2

*****************************************************************************)

Unit Lock;

  Interface

    Uses
      CRT,
      Core,
      KeyBoard;

    Const
      { These values are defined to make it easy to change the window colors. }
      Black_Background   = 0;
      Blue_Background    = 16;
      Green_Background   = 32;
      Cyan_Background    = 48;
      Red_Background     = 64;
      Magenta_Background = 80;
      Yellow_Background  = 96;
      White_Background   = 112;

      Black_Character         = 0;
      Blue_Character          = 1;
      Green_Character         = 2;
      Cyan_Character          = 3;
      Red_Character           = 4;
      Magenta_Character       = 5;
      Brown_Character         = 6;
      Light_Gray_Character    = 7;
      Dark_Gray_Character     = 8;
      Light_Blue_Character    = 9;
      Light_Green_Character   = 10;
      Light_Cyan_Character    = 11;
      Light_Red_Character     = 12;
      Light_Magenta_Character = 13;
      Yellow_Character        = 14;
      White_Character         = 15;

      Flashing = 128;

      No_Character                = 0;
      Dim_Underlined_Character    = 1;
      Dim_Character               = 2;
      Bright_Underlined_Character = 9;
      Bright_Character            = 10;
      Reverse_Video_Character     = 112;

(***********************************************************

  Open_Attribute
    defines the color the window will be.

***********************************************************)

      Open_Attribute: Byte = ( White_Character + Red_Background );

(***********************************************************

  Enter_Attribute
    defines the color that the password input prompt will
    be.

***********************************************************)

      Enter_Attribute: Byte = ( Red_Character + Black_Background );

(***********************************************************

  Message_Attribute
    defined the color that the message will be.

***********************************************************)

      Message_Attribute: Byte = ( Flashing + Red_Character + White_Background );

(***********************************************************

  Animation_Attribute
    defines the color that the animation prompt will be.

***********************************************************)

      Animation_Attribute: Byte = ( Yellow_Character + Red_Background );

(****************************************************************************

  Procedure: Lock up.

    This procedure simply locks up the computer system by first getting
    a password, then remaining in a lockup loop until a word is entered
    which matches the original password.

****************************************************************************)

    Procedure Lock_Up;

{----------------------------------------------------------------------------}

  Implementation

    Const
      { Definition of the enter keyword event signal. }
      Enter_Key  = Keyboard.Press_Enter;
      { Definition of the escape keyword event signal. }
      Escape_Key = Keyboard.Press_Escape;
      { Delay amount defines the amount of time used in animation. }
      Delay_Amount = 25;

    Type
      { Defines the window on the screen for saving underlying information. }
      Window_Type = Record
                      Old_Top,
                      Old_Left,
                      Old_Right,
                      Old_Bottom,
                      Safety_Top,
                      Safety_Left,
                      Safety_Right,
                      Safety_Bottom,
                      Old_Attribute,
                      New_Attribute,
                      Old_Where_Row,
                      Old_Where_Column: Byte;
                      Storage: Storage_Record;
                    end;
      { Animation type is the procedure that displays the on screen reassuring
        animation. }
      Animation_Type = Procedure;

    Var
      { Used to keep track of the location of the animation cursor. }
      Count,
      { Used to hold the current event signal. }
      Command: Byte;
      { Defines the direction of the animation cursor. }
      Go_Right: Boolean;
      { Holds a copy of the underlying screen information. }
      Current_Window: Window_Type;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Preserve row.
    This procedure saves the current screen row
    in the storage memory location.

*************************************************)

    Procedure Preserve_Row( Row, Left, Right, Top: Byte );
      Var
        Where: Pointer;
      Begin
        Where := Address_Storage( Current_Window.Storage, Succ( Row - Top ), 1 );
       {$IFNDEF OS2}
        Read_Data( Row, Left, Where^, Succ( Right - Left ) );
       {$ELSE}
        Read_Data( Row, Left, Where, Succ( Right - Left ) );
       {$ENDIF}
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Function: Save screen.
    This procedure allocates the space, then saves
    the current screen information of the given
    region in the memory space.  If it fails, it
    returns false.

*************************************************)

    Function Save_Screen( Top, Bottom, Left, Right: Byte ): Boolean;
      Var
        Row: Byte;
        Okay: Boolean;
      Begin
        Okay := Allocate_Storage( Current_Window.Storage );
        If Okay
          then
            For Row := Top to Bottom do
              Preserve_Row( Row, Left, Right, Top );
        Save_Screen := Okay;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Function: Open window.
    This function truncates the size to that of
    the current screen, then saves the region of
    the screen that the new window will go in,
    then creates a new window on the screen.  If
    it fails, it returns false.

*************************************************)

    Function Open_Window( New_Left, New_Top, New_Right, New_Bottom, Attribute: Byte ): Boolean;
      Begin
        Get_The_Mode;
        If ( ( New_Left < 1 ) or ( New_Left > New_Right ) or ( New_Right > Screen_Column_Limit ) )
          then
            Begin
              New_Left := 1;
              New_Right := Screen_Column_Limit;
            End;
        If ( ( New_Top < 1 ) or ( New_Top > New_Bottom ) or ( New_Bottom > screen_Row_Limit ) )
          then
            Begin
              New_Top := 1;
              New_Bottom := Screen_Row_Limit;
            End;
        With Current_Window do
          Begin
            Old_Attribute := TextAttr;
            Old_Where_Column := WhereX;
            Old_Where_Row := WhereY;
            Old_Left := Left_Of_Window^;
            Old_Top := Top_Of_Window^;
            Old_Right := Right_Of_Window^;
            Old_Bottom := Bottom_Of_Window^;
            Safety_Left := New_Left;
            Safety_Right := New_Right;
            Safety_Top := New_Top;
            Safety_Bottom := New_Bottom;
            New_Attribute := Attribute;
            Storage.Column_Length := Succ( New_Right - New_Left );
            Storage.Row_Length := Succ( New_Bottom - New_Top );
            Storage.Amount := ( ( Storage.Column_Length * Storage.Row_Length ) * SizeOf( Cell_Type ) );
            Storage.Location := Nil;
          End;
        Open_Window := Save_Screen( New_Top, New_Bottom, New_Left, New_Right );
        Window( New_Left, New_Top, New_Right, New_Bottom );
        TextAttr := Attribute;
       {$IFDEF OS2}
        TextBackground( TextAttr shr 4 );
       {$ENDIF}
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Restore row.
    This procedure restores the saved screen data
    of the specified row from storage back onto
    the screen.

*************************************************)

    Procedure Restore_Row( Row, Left, Right, Top: Byte );
      Var
        Where: Pointer;
      Begin
        Where := Address_Storage( Current_Window.Storage, Succ( Row - Top ), 1 );
       {$IFNDEF OS2}
        Write_Data( Row, Left, Where^, Succ( Right - Left ) );
       {$ELSE}
        Write_Data( Row, Left, Where, Succ( Right - Left ) );
       {$ENDIF}
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Restore screen.
    This procedure restores the save screen data
    from storage back onto the screen in the given
    region.

*************************************************)

    Procedure Restore_Screen( Left, Top, Right, Bottom: Byte );
      Var
        Row: Byte;
        Count,
        Value: Word;
      Begin
        Value := ( Top + Bottom );
        For Row := Top to Succ( Value Div 2 ) do
          Begin
            Count := ( Value - Row );
            Restore_Row( Row, Left, Right, Top );
            Restore_Row( Count, Left, Right, Top );
          End;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Close window.
    This procedure restores the screen data,
    then deallocates the screen storage space and
    restores the previous screen window in exactly
    the same state as when it was altered.

*************************************************)

    Procedure Close_Window;
      Begin
        Get_The_Mode;
        With Current_Window do
          Begin
            Restore_Screen( Safety_Left, Safety_Top, Safety_Right, Safety_Bottom );
            Deallocate_Storage( Current_Window.Storage );
            Window( Succ( Old_Left ), Succ( Old_Top ), Succ( Old_Right ), Succ( Old_Bottom ) );
            GotoXY( Old_Where_Column, Old_Where_Row );
            TextAttr := Old_Attribute;
           {$IFDEF OS2}
            TextBackground( TextAttr shr 4 );
           {$ENDIF}
          End;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Display.
    This procedure writes the given data on the
    screen, starting in the given location.

*************************************************)

    Procedure Display( Row, Column: Byte; Data: String );
      Begin
        GotoXY( Column, Row );
       {$IFNDEF OS2}
        Write( Screen, Data );
       {$ELSE}
        Write( Data );
       {$ENDIF}
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Internal get string.
    This procedure handles getting the input from
    the screen keyboard.
    While it's waiting for the input, it performs
    the given animation routine.

*************************************************)

    Procedure Internal_Get_String( Row, Column, Size: Byte; Var Field: String; Animation: Animation_Type );
      Var
        Okay,
        Stop: Boolean;
        Replace: String;
        Character: Char;
      Begin
        Field := ' ';
        While ( Length( Field ) < Size ) do
          Field := ( Field + ' ' );
        Replace := Field;
        Display( Row, Column, Field );
        Stop := False;
        Repeat
          Repeat
            Animation;
          Until KeyPressed;
          Get_Command( Character, Command );
          Case Command of
            Press_Lower_Letters,
            Press_Numbers,
            Press_Lower_Letters,
            Press_Capital_Letters,
            Press_Extra_Characters:
              Begin
                Delete( Field, 1, 1 );
                Field := ( Field + Character );
                Display( Row, Column, Field );
              End;
            Press_Delete_Arrow:
              Begin { Clear last character }
                Delete( Field, Length( Field ), 1 );
                Field := ( ' ' + Field );
                Display( Row, Column, Field );
              End;
            Press_Delete: { Clear line }
              Begin
                Field := Replace;
                Display( Row, Column, Field );
              End;
            Press_Enter: { Enter key }
              Stop := True;
            Press_Escape: { Escape key }
              Stop := True;
          End; {Case}
        Until Stop;
        GotoXY( Column, Row );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get string.
    This procedure is an intermediary procedure
    for reading a string from the keyboard.

*************************************************)

    Procedure Get_String( Row, Column: Byte; Var Field: String; Animation: Animation_Type );
      Begin
        Internal_Get_String( Row, Column, Length( Field ), Field, Animation );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: No animation.
    This procedure is supplied to the get string
    routine when no animation is desired.

*************************************************)

    Procedure No_Animation;
     {$IFDEF VER60}
      Far;
     {$ENDIF}
      Begin
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Animation;
    This procedure displays an cursor on the
    screen which will only change location each
    time this routine is called.

*************************************************)

    Procedure Animation;
     {$IFDEF VER60}
      Far;
     {$ENDIF}
      Var
        Save_TextAttr: Byte;
      Begin
        Save_TextAttr := TextAttr;
        TextAttr := Animation_Attribute;
       {$IFDEF OS2}
        TextBackground( TextAttr shr 4 );
       {$ENDIF}
        If Go_Right
          then
            Begin
              Inc( Count );
              GotoXY( ( 2 + Count ), 2 );
             {$IFNDEF OS2}
              Write( Screen, '  ' );
             {$ELSE}
              Write( '  ' );
             {$ENDIF}
              Go_Right := ( Count <= 14 );
            End
          else
            Begin
              Dec( Count );
              GotoXY( ( 2 + Count ), 2 );
             {$IFNDEF OS2}
              Write( Screen, '  ' );
             {$ELSE}
              Write( '  ' );
             {$ENDIF}
              Go_Right := ( Count <= 0 );
            End;
        Delay( Delay_Amount );
        TextAttr := Save_TextAttr;
       {$IFDEF OS2}
        TextBackground( TextAttr shr 4 );
       {$ENDIF}
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Lock up.
    As previously defined.

*************************************************)

    Procedure Lock_Up;
      Const
        Width = 34;
        Height = 12;
      Var
        Top,
        Left,
        Right,
        Bottom: Byte;
        PassWord_Try,
        Pass_Word: String;
        Hold_Break: Boolean;
      Begin
        Hold_Break := CheckBreak;
        CheckBreak := False;
        Get_The_Mode;
        Top := Succ( ( Screen_Row_Limit - Height ) Div 2 );
        Bottom := ( Top + Height );
        Left := Succ( ( Screen_Column_Limit - Width ) Div 2 );
        Right := ( Left + Width );
        If Open_Window( Left, Top, Right, Bottom, Open_Attribute )
          then
            Begin
             {$IFNDEF OS2}
              Write( Screen, 'ͻ' );
              Write( Screen, '                                ' );
              Write( Screen, '              ' );
              Write( Screen, '                                 ' );
              Write( Screen, '                                 ' );
              Write( Screen, '                                 ' );
              Write( Screen, '                                 ' );
              Write( Screen, '                                 ' );
              Write( Screen, '                                 ' );
              Write( Screen, 'Ķ' );
              Write( Screen, '                                 ' );
              Write( Screen, 'ͼ' );
             {$ELSE}
              Write( 'ͻ' );
              Write( '                                ' );
              Write( '              ' );
              Write( '                                 ' );
              Write( '                                 ' );
              Write( '                                 ' );
              Write( '                                 ' );
              Write( '                                 ' );
              Write( '                                 ' );
              Write( 'Ķ' );
              Write( '                                 ' );
              Write( 'ͼ' );
             {$ENDIF}
              GotoXY( 3, 5 );
              TextAttr := Open_Attribute;
             {$IFDEF OS2}
              TextBackground( TextAttr shr 4 );
             {$ENDIF}
             {$IFNDEF OS2}
              Write( Screen, 'Please enter security password:' );
             {$ELSE}
              Write( 'Please enter security password:' );
             {$ENDIF}
              Pass_Word := '123456789ABCDEFGHIJKLMNOPQRSTU';
              TextAttr := Enter_Attribute;
             {$IFDEF OS2}
              TextBackground( TextAttr shr 4 );
             {$ENDIF}
              Get_String( 7, 3, Pass_Word, No_Animation );
              If ( Command = Enter_Key )
                then
                  Begin
                    GotoXY( 3, 11 );
                    TextAttr := Message_Attribute;
                   {$IFDEF OS2}
                    TextBackground( TextAttr shr 4 );
                   {$ENDIF}
                   {$IFNDEF OS2}
                    Write( Screen, '          L o c k e d          ' );
                   {$ELSE}
                    Write( '          L o c k e d          ' );
                   {$ENDIF}
                    PassWord_Try := '123456789ABCDEFGHIJKLMNOPQRSTU';
                    Count := 0;
                    Go_Right := True;
                    TextAttr := Enter_Attribute;
                   {$IFDEF OS2}
                    TextBackground( TextAttr shr 4 );
                   {$ENDIF}
                    Repeat
                      Get_String( 7, 3, PassWord_Try, Animation );
                    Until ( PassWord_Try = Pass_Word );
                  End;
              Close_Window;
            End;
        CheckBreak := Hold_Break;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Main initialization section.
    Link the routine up with the core unit.

*************************************************)

    Begin
      Core.Lock_Routine := Lock_Up;
    End.


