{
The Following code is a little cheeze example of getting around the ye ol'
retrace and flicker problem. To do this all writes are made to a vitual
screen and then the whole thing is moved at once. This code has quite a
nice effect even though it almost all in pure pascal.
Enjoy: Swag ready. [g]

- IMPORTANT : Use XX3402 to get the needed PCX files
              ( Last part of the program ).

  1) Cut from line 192 to the end and save as SPACEPCX.XX
  2) Run : XX3402 D SPACEPCX.XX ( It generates SPACEPCX.ZIP )
  3) Run : PKUNZIP SPACEPCX.ZIP ( It generates two PCX files )
  4) Compile and Run this program.
  5) XX3402.EXE is found in the SWAG Directory.
}

{$q-,r-,d-,b-}

PROGRAM SPACE_Sprites;
{ - Slow game-sprites-example, by Bas van Gaalen, Holland, PD
    12/20/94 }
{ - Modified and completely rewritten by Mr. Krinkle : Cameron Clark }
{ - Basicly is the same program from Cameron; I have only add some
    sprites from SPRITELIB to make it more spectacular. Hugo Rozas :
    <hrm@mail.cosapidata.com.pe>
    07/12/97 }
USES crt;
CONST  maxSpr=144;                         {Reduce, if program runs slugish}
       ScrSze=64000;
TYPE a_scrn= ARRAY [1..ScrSze] OF byte;
     sprite= RECORD
             xCOR,  yCOR   : word;
             width, height : byte;
             vVEL,  hVEL   : word;
             it: ARRAY[1..188]  OF byte;   {bitmap}
     END;
VAR sprites : ARRAY[1..MaxSpr] OF sprite;
    point1 : Pointer;
    point2 : ^a_scrn; {Used for screen math}
    i,j,k  : word;
    c      : Char;
    a : byte;
    Pic:Array [0..35999] Of Byte;
    Pcx:File;
    Read_Result:Integer;


{
 This nice load pcx procedure is
 from : Alan Bang Andersen
}
Procedure Load_Pcx(Name:String);
begin
   Asm
     Mov  AL, 0
     Mov  DX, 03C8h
     Out  DX, AL
     Inc  DX
     Mov  CX, 1023
@l1: Out  DX, AL
     Loop @l1
  End;
  Assign(PCX, name);
  Reset(PCX, 1);
  BlockRead(PCX, Pic, SizeOf(Pic), Read_Result);
  Close(PCX);
  Asm
     Cld
     Mov  AX, 0A000h
     Mov  ES, AX
     Lea  BX, Pic
     Add  BX, 128
     Xor  DI, DI
     Xor  DX, DX
     Xor  AX, AX
     Xor  CX, CX
@l2: Mov  AL, [BX]
     Inc  BX
     Cmp  AL, 0C0h
     Ja   @r1
     Stosb
     Inc  DX
     Jmp  @r3
@r1: Sub  AL, 0C0h
     Mov  CL, AL
     Add  DX, AX
     Mov  AL, [BX]
     Inc  BX
 Rep Stosb
@r3: Cmp  DX, 64000
     Jnz  @l2
     Inc  BX
     Mov  DX, 03C8h
     Mov  AL, 00h
     Out  DX, AL
     Inc  DX
     Mov  CX, 255
@r4: Mov  AL, [BX]
     Shr  AL, 2
     Out  DX, AL
     Mov  AL, [BX+1]
     Shr  AL, 2
     Out  DX, AL
     Mov  AL, [BX+2]
     Shr  AL, 2
     Out  DX, AL
     Add  BX, 3
     Loop @r4
  End;
End;

PROCEDURE SpriteData( nSprite : Word );
VAR
 i,d,x,y,Px,Py : Word;
BEGIN
   Px := 1 + ( ( ( nSprite - 1 )  MOD 18 ) * 17);
   Py := 89 + ( ( ( nSprite - 1 )  DIV 18 ) * 11 );
   i := 1;
   FOR x :=1 TO 17 DO
     FOR y := 1 TO 11 DO
       BEGIN
         d := (((Py+y) + (y DIV 18)) * 320 ) + ( Px+x );
         sprites[ nSprite ].it[I] :=  Point2^[ d ];
         Inc( i );
       END;
END;

PROCEDURE setpal(col,r,g,b : byte); assembler; ASM
  mov dx,03c8h; mov al,col; out dx,al; Inc dx; mov al,r
  out dx,al; mov al,g; out dx,al; mov al,b; out dx,al; END;

PROCEDURE putsprite( VAR spriter : sprite );
VAR i,x,y,d : word;
BEGIN {Update coordinates according to H&V velocity and virtual draw}
  WITH Spriter DO BEGIN
   IF  (xCOR + hVEL > 320 - width)  OR (xCOR + hVEL < 1) THEN
       hVEL:=hVEL * -1;
   IF  (yCOR + vVEL > 200 - height) OR (yCOR + vVEL < 1) THEN
       vVEL:=vVEL * -1;
   xCOR:=xCOR + hVEL;  yCOR:=yCOR + vVEL;
   i := 1;
   FOR x :=1 TO 17 DO
     FOR y := 1 TO 11 DO
       BEGIN
         IF ( It[ i ] <> 0 ) THEN BEGIN
            Point2^[( (((yCor+y) + (y DIV 18)) * 320 ) + ( xCor+x ) ) ] := It[ i ];
         END;
         Inc( i );
       END;
  END;
END;

BEGIN {*Skeleton*}
  ASM mov ax,13h; Int 10h; END;
 { load and save background }
  load_pcx( 'SPACESPR.PCX' );
  GetMem(Point1, ScrSze);
  GetMem(point2, ScrSze);
  Move(mem[$a000:0000], Point2^, ScrSze);
  Randomize;  { create random sprite }
  FOR J:=1 TO MaxSpr DO BEGIN
      sprites[j].xCor := random(300)+1;  {Screen Pos}
      sprites[j].yCor := random(170)+1;
      sprites[j].width := 17;  {Fixed Dimensions}
      sprites[j].height := 11;
      REPEAT
      sprites[j].hVEL := 6-random(16)+1;   {horiz. sprite displacement}
      UNTIL sprites[j].hVEL <> 0;
      REPEAT
      sprites[j].vVEL := 6-random(13)+1;   {Vert.  sprite displacement}
      UNTIL sprites[j].vVEL <> 0;
      SpriteData( J );
  END;
  load_pcx( 'SPACEBCK.PCX' );
  Move(mem[$a000:0000], Point1^, ScrSze);
  REPEAT
    Move(Point1^, Point2^, ScrSze);         {copy Background for writing on}
    FOR J :=1 TO MaxSpr DO
      putsprite( sprites[J] );             {virtual write to Point2}
    Move(point2^, mem[$a000:0000], ScrSze); {write Point2}
  UNTIL KeyPressed;                         {NO retrace needed}
  ASM mov ax,03h; Int 10h; END;
  FreeMem(Point1, ScrSze);
  FreeMem(point2, ScrSze);
END.

{
 -----------------  CUT HERE AND SAVE AS SPACEPCX.XX  ----------------------
}

*XX3402-022127-071297--72--85-40507----SPACEPCX.ZIP--1-OF--5
I2g1--E++U+6+3SaVmCY2HezWFo++AEq+++A++++Ip--EoJ0EogiI2BMtLgvY-nZiTObjyPI
n1Z3ZSTGoxAxitlmsA+-xNQ1+U8enYdO4NIEJDRALqPag29-f8tvYvGs0-EEi8UBQ-I-UE80
1FkcQ2-+sA1-oTTpf8uUCt8F226MY+oMAA7UUpTbSRujNrM2dovJCR3TxKjEvilgxzTSbzRt
rlPzwYyPGUdzzarHGPIPfzzlbopHanOd3zvDvIreTzL58rXORHmrLepI8yK8vgzSJzPp3uKx
EgDphJijJQjJWWuDzT69rBXEfgPBpJetJevolqzxL5YBSuiXOlK1Uwr49nynhncyPwJ9dCfl
LnTYxlv2satRTT1rTwtjRtquJmz9vTr8P5zgxkJvTxpnbFcjACLlynwRrexdhCXyc6-DFkdM
xOa+ySwCmDqqcQ6bMmfIQlJ2l-hepz0OKxwnsvwudMtHT9SeunIBFQEFiGbTeXjfjCNBtHcB
vICDiZAPSXBrlwMpHfrEd0N4fVYewvpHT4zg39ReyjYVtxO1SBiCPL3kDfxKpwSpeX6vu7uj
ONhFNxT1JXhCsrMfT5BAFH3I1hRoaVuSTaMxX77hDxzlwqp739slp1TrbZDX5HM8cj-rujFu
WBB3+Ds9ny4CDuZbvqksIqHUCqIAPqZ3QF7jyzYqT6pOtxPj8PpkLpoPVdZWXBVVgpHiO2Qu
BcaCcrPfL8vJUm6eNPReXTU5fUxOPFqNKCDmM5Hxu5U2i36RlSsTA1c6KkBs8813pxLIDRJo
uzNknOERNSGuCf2Sa1-MKkw4wVLjgy2xX7U6M4kFJR3yLEJh2vS1+LE8wS6PyQ0APgih235x
XQ7hdvpzvuJhb-x4fLMf0XDQaLyapvxJInQS23dnuyLe01-Ib7di4cSa5POWBZshjgoztBqP
PqmMCTEUPrtHHRpLnruVsWHhd6Y65MGWUrlUPtuycPPQ2nXG9d9MEU8eOI3h7YupsTec-HDL
qpfyktiUlEyhthjYRbwMXd5YzDOkNF+qiHDIPTaDvkBy5-fQjroYrgLhU1DQTJ3htPobwd0o
HklZsoqKTzWhqbF1POL50GKk4PItSxbSO6C04rCFj0aDovRelkop1KRFsneAvQxSJRBWu0V2
iP1jVSX74qfPWpyeVth2VAfgRPKBRyJFmBNPUvU3nst3tSaJ8qf9pWpPdwCNvjHKuOpPBUya
vefPjCwRhL-Z3-LH0eB-OfyDsj8NahewNLfPxWQqvLVmtnzzOCOd7zKCHJRIY2NTqWB4YH2E
CiUVCxP5kz8oK5ZPDP2F-9DSCf2S1HfFWTKK4Mj+Heq0urFZTfJpCuu41kM7DA4fQtzjm6zR
hC3aCGoQE5ySjy5bHF9MzB6BFkOVGAMrzO-zhyTLvlVnukZ-740FzLdWn9wgiAqwzYatDjQZ
fcXG9dldjtsMHrK95DYBpbYu+9EEKT8j4ltwsC7V2hA9D7DTBr7sSCbCwNkBBFr0fxY6KDui
RZr0RIzlCa-hd9hKErsT+hivugKbUrycLyJLt1Pkyz08KqdDvxyv9t66b3trzzLzDj8jvcbw
yz0Ggqd8PxuuFIzfPTc7jIbjo2ziT8dbThFvOeR45i4H7z0PuGpPxSMd7iCNxMOSP-XtygN6
n6jR5pYlRoMaDUokaVfzs0aXxbnrs2QvAvLbKk9DFqlOrx05RxKjfj2HjhunHjryXpgqThnl
s6yPTjXXpcoTYP2gLyaR+Ai9xeCwBkfEexZudJzHeen8xpJaWyQiJLhTJKhS+zqgvxGPLZLd
jZCdggr87LmxcKPRViQLOcKuezpuhJyiCyIzesL94tSQUxVOkTVBvRIRQes8ibqBehmqSgYd
tNejalBBLtA3s8zLxChmmROVfVLLPotcTw95fvJPQLWUCnhEpKz4fycrAfyUQJ5BOE1qz2YQ
ZDKR4WzOD7FKfc2yyOuSl6L4bIEjah0HTVD4pTnupyBLpU4tLbBW2WzTUsbBQgoo5wOxZOf1
6uS4BZPQ7Xeh9pQ0eR4Tk9nwdj5fParqal3rurgyiukDSFBBpsAneiIOa8dLxxpm-Glam083
0xLd2xrIjZlMePeydmQ86-SnTlpRu3FfXeuG1KOyJm18Ym-tBPw+YXHvpSWuTeI8JQX3hAxS
EaCfPY5v1ETGmrfq5eX5gtM0UtIuw3qBAHKSh-oOt76EOexKlfLrpRiKHJtGBSfeBGMFBmXM
8BXq952isCSe26cjFWucpXCro2EWB+f4pFBpcLmuGfNNsAJpNyDOGVb-VARQ46zKXT+rLCg8
V-SrIsPnyQV4uAnSsz+0OCArx+GxW7xpHTH0yuOPeMeex1yGCs8JIZU8JSiyyZeJ4t7RZ3LX
yIUCtda9hANDA8t-5QdOIKXTuLyUK0M-ScACUp9GOwJUP22vj8zi8MGeCRZoHQq-O+ReAn7E
1MZ-Ckdy4NzrZSTfGSCLzu06-M1x2Z0zF8HKQNeMi8E0cghgfRdcucT-LWlzc19JGg5n7n51
JA-dz+6wH8gTFZd-nIfz1YvwECaUp6NxfO16ww+z+S67IBk2h5oK-BejCNvs2GP1n4c1RIei
u88YEJFe9j6uaumHYfyb0+XkZqND-Obhx2mreB3pcVWjJWb2eKydeKi+2oris-TeQet2cu0x
WdrlMA42Lr4x+d7f2bJEbGXIbBg0JbF+oWupEbGRqD1sXY5DWZgZB7lk-SRTJdijcsVE2JLI
XwCHkR0NwOF41XGjsNQ3J06gA-Acw8ObuyzWjUJKOR0Ce0zDErzO285X3VaQa5-7HJxLZOe5
oaqWMc+pa1Tk2pVfHLUIwvfioDSiAqYa16OPLA-NS1ke0U5Z8mU3u3n3B2u9Ch3dEh4A-Uqt
e9NRIqKQtjYBenpxHxoPZ6XokF1Yub9J-JXJ-Yl3rvoZYpgdX6eA+Tv47PcRDmRdlj40AjU7
mQBxRI3hjuOejZAdBp04f0CcDE3UEDJ1FW5nQvMDB6A6gIqvvsWEA0taIM6l--8MrepCgNBo
ij+NS++H8Sr4H8DnOhApdLp5JF-l1kXY2Xae++15MD606d+oEkV6QlI+1l0h3pW5vYr3lVca
idT02iEF7D43+iWYG8lib2dWdOIkuLNWK9F0FBtlLRLFeacIJq-FmlUDMQUgcXK9JP6AIup4
ok7Uk5T+q-gWfxHi3JARAFmM36mYPKHGMdH2eIsAMlPfPWg9oAFiYh5eDWcBUdXBl-8L66IQ
E3H8iUeQeuBwOet5P1LyF-DZzPOpX347WxqIQM2XOJZMkgwNf49NZ3O0I8SoaLMxjL71xKQ7
OtF+0lUapbTBEV9wOi1U8X8lnU0WoEl3-L2dFYtoCr+LAUrHPuG1g4huGPe41v7+Ft9lnB0Q
81ylPLe9rbkFXPT0E340UtGUdyc1c3uhveDj+LpFFsquLqK5l3zrxl-sIk4ZE9ZuiUgvCaa2
YiLTIhXdnSUSA+3uh7AIs6em8ZZYC8CSjYJdCMXJebu-Mk8KC5v4oFxB208AmwsBL7XoFBlp
2GR7rdbdaEFNmC13xZWRRcegfRH+mV85NhVN2a4Yv1RJbtpykjClsb+ag1Kcp44Bon0inB6H
0-nf0X1MbBFSEs7rHGF85cMRE95ikI0HFa67i1t9f7X-NWNb8g-FEa8SJXjSJKLOoI-5-JuW
IRTsYqDEguLo23BoR5Fev7uOLgCkJPZjERkB3FVWHsX1sBGY-uiY1bHGaR2dgECknOmZbM84
39XdLFMR8um+LIUBV+bP6bFo1nm7c69ict4H9aZE-WPW4TSeG9BJ-bZ+XXF8Nm0DsR7lNx-9
Wj+in6J6x+eUGFFHpjPPeiMpKJkHbZCnBEQbkV-6mWRH1hRwtksEKZWdrGjKCApy6RYDMCyM
LhFC2tUNRvdfjNFZ3ohPAfGkLPejHedhvmar0Lw-1ljQkf5m0jtOowyr6-07RwMp08T5ZIuR
cWscH1Kb+3phalsK51gxl0vhR5hdIikI8F3NekJQM4Qv1XxJnptLorQI4lssUyDOTNVH-yUq
xMEMW2MUkc1A64JS+vsYgvUgb1BEOIx57lKu8mHfRYar8FxEkhZ8RlB6FddqdHNW++6HZF53
75JRvTdIPLpTxR4AIFYMoIrRof7g+Zyx+VO+RECeW0sBNC1W2YLXp0s7DEq16VdM58qdBdR3
B3g8gIJgULZRUlW0HU+8H2fo-UYk27jSJly12R8JNM2OcQi6NkO8tN3XpI0WamtQ91pDyVAE
vu769NZS-rJE4eUGwnyKsN0WExXQmdgTeeGLR5gnjOtag-4-C94CPpBsZTqgPwcp8QI4+spu
Ns17iG+IMOJopcoo8KH--K5O+OH1dWEi4F04j2aU4Yjm3uVC1I9INVTsVCvSGsiR5gF0iB0J
B+b7hdk80+aWG4EZ5EOagWPF7HpeN0aYx-Sv-mEYwyhtxO5OxHtxU+O3fBKMtJJ+G28RkadB
e2QXPWKhBX6EfELL3S26m6R0W27AHd1E1LTFbHLL7MMstHQ9m970Ms+6XoUNYQEHOYMbp8V1
yPkWkh2D9Gp9FEnG0hK1fV77MWD0LK-zVsV3w464R5EDDFlkUc-UEs-qpu6P0gFp20MQn5Lu
VAgCVnQ+mtdkyRlgpU3XoFQZdDixeMUAdI1rs4MYDH7DolRK0qMsL+7h1Anih0lhY19j7c-K
+1aViuCN5w23xRruquf4wEY++htM7XL4OfSCsggwmpoM8dY-0d6K62QtjOEadw09W4HGq3bs
+oKOF3XXrmmJL6l9Kjm2vqH2LO62Kb45U+Gz7BrYjC6Wsf7mz4nGeK2Se3EPYmsZ0qQW2KXY
B3l414+0b42dFxK1sZONM6NS+PP-8ypUNO1Eia7w2CLTRIlpGWoRUSirg9q-O1NiYWr+M7RC
VSMLQaoUm2la2op9EGIXWTJtSO6um-8gMVUjkFJew7Bpn2YJ6ZQvn+yC3mSJt+DBpp+2ru36
OggKHFpkpIjndVr46OALFy3EXHuMvkEs9oNjI-qoOWVEDSJCQ2HGvWGbl1cOPIrs0d4nIeI8
OolK-XmV3D1TYudIF1MU0tAiX+IaFxqN5YW9dM+FO3Cl0wR-dO-YkBFvFTnGOb23ktJHmmOw
7Ue3NB8FfPsAwQVOAYCAcXLyJ3-JFyWuEAT+Cc9oV4kz1B+e2-++AjYMCnq848gnvBlYcC4b
u6mh6Rg6Ji+gTfQdQZJJkNaxOco9-xRfKVu83zCHhMfxUWhCe+K89QKd21sndIDo+PFs+v7W
UhA8J1d0On67GVMhEjNr01z9d0IJp0PAYYe3-X5-S7FfQ2IVvhUEC3X+Cu+KV2mAg7XvmLo-
7F-eehG1crgBZOf+lBYt11c5uFif7Mu2Stk49SWW1g0v2sM84c+Ec0WMdtoqIPIYl9J2VsH0
7z4uADF3kkCrRqk4EV5DFSigt-+aQtyUlWGNAk+ejWNOZC+7Z+ae-9mhNM6n8YduIcgc2zOB
4KGhcEuulw2EslJokUAMR3eafA5ANXJsGxIN+Z0jUizs1eQew1iNzD4r9-fkoMwv0K9MamYa
J+-jNvexPdOmUMUtNpL8kICnOG-1MPgEcMts6I5eFWG2hhyoGh7e6liCopVggXYuk+1CpNWr
m6TU06xcNKl9kRe8u8NRf3SvtB6el+n80NFFAAVznd+xAXxC1qE7u-mx94NCc+G+LGkKbIco
K9+h8Egf5Egx11k3JA6YBqY+R++sWUB91xy6KevajUU1+kS5EAx6CGFWDd0ElLYKjmGh3uOE
d6CSvGaKIb3MFiPWCWo3IUf5VFC2T+vRHKnJ0dvPs2XaH57X+z6o6O1p1VwFGSdpu3ai7qH3
L27XVx4MCNa+O8C6TEzw7FJQkgkQ7oV18UeId86LFs9Dsl3T1HiuVmQxG9MYhA6BM7KWiJoX
3GzTkeAj13mqFM-tARugf-0WEncnUbIUH1-udhUf0a-86qa1Ed1E7D+-eb31w+I8VfaYcXu5
Ray0nO20YqYshkH6ibSkJxCqGQ8fYK4LPAiUxeOWmtCoC+BmaC8-Lxf-1uZ78-OrF1Ac15Ei
***** END OF BLOCK 1 *****



*XX3402-022127-071297--72--85-27524----SPACEPCX.ZIP--2-OF--5
mUsql071RaL8skFMYCJU+E1Uy5MM-iOExLDLJPY3mMEwUdi3D5WPX7+K6xJYida-O+Xab4fg
5WQTkV42fgEcHgB96y4L24LUDuM7KMQIa4pwBoaO7Wnd3duf2iuH5CtVPaX-h-iRJJG-UoIF
UI+16WIbogLdE3MkfF67AmUHM9YRP6Wx195M5U1GiHSeUeqtiXtFRmiHfgnVZSevS5V+MlBX
YnLY7UpKk9LFOGIeh7X7784+CSNqoYq9+jlqXF7rNW+NDo3uy8-c-xkT4pNN688OoJfeXifL
eedQSIzxHEd7qViTk7d+YEAGE9eb+TO7d514CETlvn0xwMDYAPix0HcxndFR2Ab96u3L3CMq
Lzs7+-xkpqIE8hz3kk60hqpWBXgp3Upo6r+gPO5LlsVZWS-Ui5OUzK+x71rYmR7FPKg5DoSj
0OyAF3tJr5JXemKfDohiefIMKTA-ZeBVOEMp+JhU6xECAYkQsBBMAI+adWUwc74Fa+y5U72g
pZFPjUzAcjCn+D+lYsFLFl9TIWur4bliU0T-T07QfK2+XXy2j60YgQU7WE0PoSmITO-PKZBV
hsLR0UDQtcjX5LAM0MS+QdoL0yY8GrNN4PspYbVBQPVUXq81-dJS0I0BDp7z3HuTruZ-Hs-0
v1ahUQ9+0cO8jN+C6OaBic3l8CKC2Js7weXnYGg9J9+Vufd05lvymlJwJu-sRxJLu1X6T732
03c-BQ7a+yK0ltAen6+zLP6oKEKj283aCANkGctZVxGCwpL9qqCGweT8xZxDZ0h-z2Sgc4aF
S2JAKXb36EIlH8CG-Vv7hUVK3g5P+k6tW1iiW-4rPg6CG+OTvpBiX2Hxbe9ub236AGjZXxKL
ZbN9kl+WgL7OhQ5cWeklD6k3nqxnrd1RN-91hNkM2mZ+UUiHwNrFyFU-03n0Za1GlrUAK77i
oP3B0YjUgmfdYXr3OBsscorepW4DFAxgMme0RSXH7ZYlkSrFiHSIz0A9E0OSZT1IQ6NJF3mI
qXx52gPBFngE-A04UXc0Uy01GmfwQ5HGHIJemmInihj5y6R66uVXL3PSU+ytLoE-+itojdDZ
4VJzznMutFqQMY+IetJDgBwLNP7VEOAfQ3BQMjaGXj3iJ-O88Tvvq+5ZT7ry8NvLUB-M7Mmk
uzCMWkJtISzAb0vdEgl3kJJ2DblzRAchlQ4uyVYS-ZUy81qDIPmcVBmEN54+6eM0ni6frDl-
mHiX6qsfDBftH843MQqVvQC3GmfUWVo5QMvVh+LjRe6fT-s-QZxejHSubT1uaMe5JMgCQ3Z7
LPQ0SEk0OAEqeYqtL4UU8MR-DOCyLiQOzLB3CaHtIr-JmQOFvYcub68-gtQJOFJy1zLOvsvi
jfFyOQxZCS29r7GL6y-kp0Qgux3mUYW5Hy5XMawXMQycwyhaXttRDPRrJQzeDFTZj9wcmEJo
w8i8qe+Oi-UcmP4ZAmfIWfidUEGd3RgMrlcRyQOutd3uvnuxTyq+qOzrOLjuar9uDPgBZOCd
2+PxC4U7sfR8egFohaWMZcHLsrT2NA-I9qqRIQxS5UYu0o2WNvwycCToDDz1ZsA5fAXNDKy6
k8zUjuj2S--o1cmdtPpUU0JUtu0bNQWJpMygMD2U5fEyrj1o4Qe-Z+A58QIgn0yQbAy3nCst
7n7YZoIe1P0EkcjmA57llg3RVbDGIo54W0AwY+jNgG5ax1egUNW1QzBu6JhQKlXAnlowcDTj
UtGniFEwWktYPxlZ9vP+bPRD6Nn3fdPy3d+cQPr9-BP7FguRKfSanAojuAJgmGmSL1+Eckx+
nCeSAygLpRvpr-cE0X6BKMtP8M0M+M2lhYAkH84vChlF7SyBF7mo6UvC9Gki1EtZGrdF9mnC
vNzH0rDK6+UuDP65nwKkPgFG7Rxr6h3HOknOX2vMZylI1IuGWeEv6oZf6oZuuP+tMUtbVtMK
6CrUzcmG20C6CfIV0U8ukdU1xjeJU-W-MErwfQS3S00ImwO4nlvS5kYO6+BK6KUS7ib1UmC5
1loqVzGWaHysroX44IcuCFMYqB2hgWqlYB+XYQm+SevVKJQZzWCIJ4PHx+xXIa+CVGkRocSD
u4Jx76B3R7gyeCTpb-a4OKoYGCOrbXlpFT8RNKb01dY3fMkWVSUl6Nbsv+00+m5uW3YygUkl
GshnNU47hk-FIY4GqsCFb5Od0zvEgi+7OUY9a3tmSd7yA5vu8UuTLpkuRDV6hjmQKMMVVzKV
FJECnZuMBrA5x24SjXcuzErJoZqvnIQ53zXYHVPCcbzW1wQDnxo1lTJmxVmz5BN6g6J3N12R
76eXwfDFqM4R-Y-gt33tKpMZd5oTXQspQAYyGJSQiumTovxsPjatNSVxuD1G6EFwoGk+KS+L
b4uUyD1kBtIg2Ouf3OimJHXxObXceWEA594A6vDbZcqsMcYb9h1HJZx1TIpyt+IJz-uDe+2R
7i7A+yzyJMvHmA0xpf4kSW+OkUZ6EvA2zE-wQZWqRyCgDo6jWnIgIK-syg-FADQEnApywRkj
AVlpu1-DmgHG+zOcpR3FRu3Hk6MsD0ftCXy8bdirbaB2a2u5XlVIDQeECOg3kQPDyYXQFOch
OxqNLj9Bw8nJzLAqyNaLnn3vw+Ml4096UfN6BLvQVo1r2jTrC6riHzsqThcWggAKYuW4onHA
h-U-xEH3lozv63SCXt+6+LzTCCnUj3uoVmon+YkD1RKKtUE4tbxcu0rpv7ck-grIs+MayFPB
2EJWQEF5NIQY8Eu7JchnhhHbtrvUznzM-tP1SYutc8LjaF2ktd-VsVfIwG3e-5R7BGx66Ez4
nbaTUnkVZUAJ-sGBYmFLuGqSVF+Gs+Gu1GgLQPHKqTHOmrLY5QiZC3x9YyBVdqrS5l1D6krg
EIi9xWXY3f9oUNAimfyPoDOl0zgJvMjtSA06TETbnO7VGdmGIuUDA4EXQBbuHPLkdG8DYxMO
QxxUu84n+YMoWsoiMmoDZVOc-cd3OgzMqViKAoykDFgw38m2i0RcSK-ykGmWmb+64eO34z0+
iMAaRywEmRupKkbPET+cCGI+1L6hHe9SpgEBP2tnMg4+wUSXT-Ym2BvBNKtySlva+NK5+Uh2
1rd-XZUPukRsNdxrA0ut61wVG8o77fC1I4gQUXDsRcF+OqCxuuPhLPM+a97QHtqo7tWthTaH
3fYm-b2UrTJDOhQ5i4MLDKu-ICs3toa6NuRs9kXOkQ5Q8SUgDIkA5r4+4kmzWKn3dTkAH4WJ
vB2Q4C+qm47dfEYz4RtWqljsWO4MGy-cSqPpLfBjzwY1ta04urDbbVrN3EWrAw85SATNRG4D
OzjKG-yh7nTcr1hUeRM3GIeCTousta1jCHZKtxGGEQBGYEGNkPuWrfHQxzFS2IzGSruI4uq6
1p-H9WciKBNxVdSMb5Kn1i8NHj8ZqjKSiflyMQyJzCAvOCaQz9wS3L2kzWDzBs+Tjjz8zZCs
kRWjv4jkzxnvVyFzd1aCZndyz9WwClvlPQEzry2JTTTRRz6CrqvTjhpFz-xxtdFuLeZT8jKm
Iezm9jKuIjyVI9FM8++lAJVVTOVSqnrpSbzuhrDHjpjObXqzzRHFbSRSq5ZV7PXmIb1xZSXa
gSXqetqvjytwQjmNnpxvthvfixLDZ5dQeSp8FIAlFtJOIScJdJOJycpGjpD+HAEOU65zmMEm
p7FGCtK0LbqZZgNiy1LYzz04lltvP5du4fPhrfpvOKbduB4X9vroof3Xlq1muuyzbaLNVEgL
MCMbbrk0UvxtPTaPptzztbR5jwZSyCsQC0ipymaoSyEbbIRzijjlbyqPTaldtxHnoTMLbUZK
ydqLZrMTSvuzyg9QwNLZppsyyhhXjzmDpNRC5LzZkiijRWM9zNwKZVsh5Nr0szK5LbbacRJx
tRwwLzvh9trgNST0ebTnBxvRrovSCzJXxNB50cwwyh0XXnhHqmSr-nw7CcwworyoDzTsrD9o
wmzgT42ZKbbtaJRSvPzuuvbXfnYzXfl5bjblMzqTPdxv73dyhDz0sogfIoRTrjvGgS1MOiTs
Ps8TD9HvNkwhHnqogfDwuXDZpyP8qTDCxFLbYqCSyjzg1k9ujOzrvxzzHp-9+kEI++6+0+0e
csQXONF52EUs++1HOE++1++++3BEEIB3Ip-G9Z-1K7lxHL+XltJa4e4BI4kskZoccD0X0c82
E01MUbe25lM41+H2QTX+Us9P+32Y+Oca52AR7lEung45CSlV1XvgMEsyn42DQz-V1rDkMExn
qAse+Dlfxbz9IfTyP5ZYGTOClyDN0LgovDqyZkKEP9KYqKqGeAmefAnrZyyxTDYGzNzzovSS
JzXrufSaujjsyLzyxurpPrp9zKLWkqydzuxzHyMzsuwhTumoRFhz97z6bNwfmw2hT9-qfBtJ
VJ7piH-JVSJeeT-Def-IoGWULh9JmZ9V5xbovenxYTed8VGLesJWZNTZMe48LplyXFSfZO94
UmLoh6kO8lLIDZ7FA4I5xzYlFSq7ybRpc-MbOZ44pGdA7NSfyxLZN7XGGe1VkwSeU0s9KeKR
R57tNLxZCMaGJimqw62OXrEkJcvp2BqC3QeXxnX+EkBfeB17mYGh96slFZ4fJ0OLGGKfpud7
8KZJL0uAsmODZGu2HvQ6QTB1tSgRDRGXjG0Qcl0eM2yDQ5T5TwluT7iXOUKsZkgHJJVNX+-y
+NpeBtR8JeeJN0ebrIm8RmCAmoP9WlyM-aZdY7M45uiyXYQpUxuB-nJXOfzzW1TaHkmy55WZ
c7NoeQ1-UPFKaNkf40o9FWW1RaBdJh0Z7HPvsAhhDZMxrEw-k1+SzbMwz+W1sruzxoWlTjv2
QaHskgfmof7SKGugZ-MDMa6iJpMemsOQM5VddQ+4GwgfVEyyrC+LGjR0c9snX6ZxCWDq22XX
GSxbwvhDk3rm3p7lPKKth5WcYe3oRcrRcLW6oNNLfY3aJVMzJAZIyjkdmtyc23VW9A2ltJV5
u1IZK46gsByvdsN5cy32KPNX5mZwK-CtwmyIL87FKZcwJa3m0Po0VgdGa1lKWogZ2a1lNtQT
z-kmjlSSOFZm34WAtN7jhYvNZeZcXAm-EM8njGUsIQDFmQtc443Ypv3bHOIGlQzy4PBlAJlO
8E0UtJ7-blJ8Ue2d9cA5VNJkOT3IVQLPQMj3iAKWOL2PXsvJ3DBcHkho+Zk8UuGQXAta50YG
B63AbyrdM1cuJADPzaUM4aXC4xcV+9jh1rw9fP66qewI6KgZO7DZkcqnkV84fdGKK3m4MWZ-
EchcgknsWeULPt7V3RBqIRciGhhe-SmxeMfcdrWc-hBRHUg-3x-48GSPmiOpawT3WJ6Xrs07
eH8QvUsCp9r-m+sjBEdHxiXSs9TEVchI8QKEA6cIEKI-mB6G3FUZ-l02U55Tk3XJJ2P2v0hO
9oAQc7XEf5WUhY6zqUZrVmABI5jxZ5Mo-dx1YR7NvOHu+3LjUN8vOChj5OVkWl6KPRbDOat5
wXHQyeo0fE12GeIs+pojJOvdkd6iL8jcdFbkFKanS6yHjIXuFrVXyGhTK0um+HVIV+ctITpc
Gkzw22WAVbgrnbcUcdg3bpBNvKNlARLSXPCxsGXQ1LRwDMWqycSlPCeSzOnqhiuNtpDM77JG
pX4ia6+btV8eIy383E+8a2i37RUO-nxJ8EBEn8yJ8bZmbxGiZ1EYKbCSTQoPQFBR8S4Bscbe
HThuOs1N5yvi1RM7KgvF+1GTpGYbFv1L-rjV9XH-E4xByvo16z40opAhvNv6T2EZsdNGfbJc
GdM9r2eCMW3Ihwm2+CGI54VV+-Y8V0XX0F0KiT-+JHHAMDJOF3lKx1BPwys8Ku0VrezQJ3Cc
HI3b2BcBkGM2V43KA4a2xc06P6LxOSxErK2Pyr6P4qri108JQohLFqsdNlp6wQMNmw1WeZOZ
G345U9sJk+fv7KEaG-3-UeC+NsgD1Ige8pIBZ2e9Lx2KRY+O45PQIkSKhhDNlef+5Y9akvl+
jhf6dYBvOhpGzQbKj73xgN2hXPFxM2qqya00SrKYnuuuA1McVWnRJrQ+y06b+GqiLafc7Gb+
***** END OF BLOCK 2 *****



*XX3402-022127-071297--72--85-21319----SPACEPCX.ZIP--3-OF--5
Hi9yqmm3a-oVNgmn4z5FIgXm5SdVi0-q9aibQxZACm2ktmNiHi-Bh1DNLBfCtimocxAqH3LI
zz6PxikBywhjFDqlmdK+kuWIcuyI8oJb962X7TVEuUA3KXN+msxa4iY-DGXQ8HmMOFzC8LOL
muFp8YqHris6c-lJkCmoOSbtB8Bn+2s1ojBrvDBrPDCCzQlrM-hHEixFmKI3wb6Jo9c+4yPg
OeF8fVO+8wr8wh9DX7dzC8gzB0fx0+B5u0mBDeYewhZ4HBK74xCoEHKMHOIRX0thyQvMTjcJ
qvlWDzAJy6YWrJRRYB6locrmYQc-Ijk+M2V0IQCH7MKPLVAoXazwyegSkDbHRUG0KSYg6AbZ
ENxMWjDkt56n8EMxwnZ+YorDqVwwyorvsdjqAxwQopr6ZJ8t6pBEiNj8bOe5QBR-HbUPVKen
pKspez1XJqVb0txzxOBrFNuX10KDjpaAXRYY8cHZb8U5g1n9AYWNNbgOT9sliTWqbfxhDzKq
TTZholtc85cKx9iI+xJzInupSe12Ws3mcmZeRJcoL3Jld2e3HvzisIw-HZdbEAegna+6fG1E
KN+jnGaObT11+H0tTBM-CSDK27wQKoRTyPPxtPThy4oUa7TKjk5QGtc0fEKskZe-UCZxY3YL
Zk+r5eswzF+woII1hk2YOoM4foAAkd2RG8zZQ4Ev5M8K-itAphJtmDoAvexwSq6zsxoQKlic
vsCUppM8oAQkYxSeGqh9IAnvpBq3ZKiZkWRsjDwJXzR9VPSZjllUaMqBrWAvbQz+KmrH0mq5
RWOTXakwbUpy4T-bjFnOLzBinU+CduNIL63P+rxPnqU8uUCmMaaZK0fw+legZDGLbqjSbs4S
prBqdnBi7aoFRWUm9B2oDquQKEH0ZcQndijQ-N5t1zRVDPCDruWvL5yLWYhMYmoJZr3hRxhl
WLTkfD+9JM7r-eqn30v5npbUEfmmNAEb2VdW-eIlFX6BzZcQL7wF0+hWHPICqA69fGRTSXBd
wIrvz2qPPpf7dxzwa1tCBcSZ0tRARxIGL1OMG3KcE24qqdpq0qemUVLpIUaiqV9ULs5Au8ST
OrDz5TMQCIMfu8GqgEs4z+S2CtQSmyqskQ3HHJ4vo7EWbfnEyXtpWx2l8MSfQ0iJHs3BRn5i
BR+pAU0ppxc0HYFCL3gd2RnxZJ7syKZcvfs9qtDIuOGMDlVaz6PqoJa6KNfXvqHyzCV0GphO
FaUMqR9CbZngFr2lS6+vSRRlsFX1Ub7-JPdOmfVC5afm1dNm613R2g8I26UaV-THwqA1KLHl
KHG13gn9Yf3nO4yTnG2ZMl3t65p+QhD8RVb6i5j4S6NfbvSNk4depnb2-G-SVOT+1Vkrivzr
yhspObkB1x3+WMLbYcMj+chn2ADsQoJTfnEyTn6qRw1wh-+0Zz4LM-lTS5eUYdbnZcEHjtVQ
79pac60H1V+FvjDrAgY6R5KjjZv8oSWuJzLfJogKUIyt-DrpOpSVUXEwRA-yfJUscjRLVjS5
EV59cU9w3WnnWi+LX+oKH-BHlvF9tvCFZQLAXUnQ4Q8R2PWX0oybmgtbcNEh7qwPiAZX4wG2
i1c69qUL1cfQtjCwkvNNhULITreJvVHwZRTpbvty3G6An99tmfs4s-+CWAMd+rI+z7Vl7NVs
3ccOmjgX-JyxgUEdsS6-Q2gJWUxyeBWzB8290Pgaw8Q2LVDuI80DqyF6vOHXEWocCkjc6i8U
GKWUsFcQK99ALMEbU4aKfG4wGENmGc1QUJCMmXh0zflql6plGWw-I-Dx69Z9lEeaLy2a63NJ
LX-B8vVPS+yWjJy-m+0DY-xXQyBVX2kYm9+PAU7GUAwHYO2PweY3d9VRXZQv-xVkCyDa050S
Pk3uq0MP7hr0-HMGyD1xj4YDXIcuG5gn3R-pGJy3Srv+6h+jsHOc-u3bq+1G+WzZ+sdwOMbH
gEW50zM76QrGbJbV+KaRtZl8tzai1KXDm6sXYGKKPR7kpWM4DgapHctmvZ82L9c7E+ST30jI
lqm3hYbHGXZ8JeNi1eeEigN0n+pyT6s8TAd+IMa-pY7ZVQFScKsi32D2uxuamsIMPt34xCP3
0fFfpU1Zl1A+kCcQj4ocCGqUatbUa3PNK6sAqHCwtqd+SVdT7yMqW2mtcSuqu-MaIocv2qd+
-5oTAG7AYdMeypK2PcfJTI-my3Hx5aMwhObcD-64zKj68OvE2f4GNcCdGaNnV6QqVBe-2IrB
7E9g0G57NNCzdMKi91r0xC5+w7m903sIEO9ddRcjZ1I4qpkN09AVAwtNXtEKxTAN3nYcznDw
ZWIWgTF2zEMXNHGXWz4wEL+2Ry8cD1xz0IAaFZfirTuOCDwz84d8IrxPzcOXjFC3KSOQ8+GM
n7A1z1pICkV8vFqfz3XZXzZgRySl4imCUjQEtRgRT8teLfgqJfKqJyCCkKD3FO4H5gTLHxFU
KrcsYhuDH+zPUrRl5l5XM69rBRsBsyh2-MUOPkwyNPrKtjqqff5jMzKFmeJ1ZQvxGUpwomYY
B-yeD0HJRCgDrZ5x9NwxXm9oIBBby7UL6gKEx9OzpTzYmkytJz2nX6+-TeqqnYSESDbt+3jj
e-u4o-VX38d4vQNNjRKdSnKjrabJPtnJ4e2O6SPCELfjeJr2wmPGeh3OOu-JMurJM0h6pBtc
xkZY-FrdrS4lmebQgFfeLE1szjbs-qMC5tmDzuuu1U+EyhrS+Mtp0ztujJq5rqvJUFx4pVnu
yWAJPeDXDJ+MErRPXLOXpQLU2yt3vCu2qzwCT+TP2EN-Jm24Co-wBirMW3oVCUQ223XQrFuw
TFaKWt+w7WFOE+2dfCl0reZvRGSzY9J6-+0W1GFuc6JUU2OIzM9Hw-fCUhW4M4xL0x-uw6J0
j5Nv943ELo0034LHCTmB-GX03CuCRmt-lHOVB7Y1xXs+ok9NxYXLAG-6p+87eD5f6s29il9L
5oBK0-c6-QV0EuOiY0Zg+0sEWK-hxEIkTkmEh02LI-ZepT0ks4ugSUoBu9EVaEOMMw-kecvM
q6+MGhAgasMlZ4VshDAqs2EYfZNjS7dGpCkq6IKuvXLeBMHTShTTVum3KsNwikrhpIK8iW73
RSopRUrVEd0NA4sBlc+GswMkBflqOvKlqaendQ+5ncyrlm1FHLKujHAIuBG3NUOusQvdxWA3
gBdR9ukrgM-cVbKjqkNMq-w2OGRPnrUqqK9Abq8pBEMUKb1bdP4eqHwz172E8+IEsw5KePc3
9Us7lMJ4V44sgrr9juTea9BpfxqI+JPfHGnVavVmw4PPUw1LuXxbUxJbB3V3+uevMnLSaUt6
kR2EbkqxqgXl+u+AFu0UDlqAhqudKu+mMR2XDgl8Wl5VoDuhkJpJVr9G52dray1DOXQ-t7jp
F-S1SIrRlK0Oif1yoRQrSe6M4HrMGa3Btsm41Rpg6B1B0q9zHVPPLZgDp8Zt1+uSDkPFyDVo
utvmpfdSHINdEr+OelpwwfQ1YCDPxNfLLTAyJBzEWhiS1pJT+VvOOHGxJMnLO8tunMOK02Oe
ztsuzffblzo5efY4ugQxsYaxqObPyCYourUX5UcQKKhyc9ul4PR2HpJ8Np8Fsf-QvHQdc2oA
0l3hNiGSkwRcx9NdSjPpHQxAonc7Fq--jItv-c4Aryu+MUGFN8iz1otyIngM1CmfA8WTMq-8
Ub7McnQdkUG+ZsnQmz8lOTRUzg9Npvxk3fRvG7YGug7I+MsqUSU+3U1J-YFwHBfWwTieoIOw
negzglrcqqeqEJsMuFFwDekLBLQa79uGOnGpsGkjU63-3cpB8CnakJZArNBLRCczx6eKJlue
7eXRp+qMw1dciPOeuvOifu9IfACeuoMHZ4uGoaq-2dA9AqHS11A62oekO-jnbt6REpgq4mTN
r6KdYNhYNli85DfCf4beEhDkMghIrD6-mR7hOo82YJeuesIgrFMUkWpBzINlO9EuLKUKOU-d
VaIr4YcnnDeaD+Jh1qJYv4IveF1vb7-7Pd2jQACQwmQHQbzfE6OyyOmasPBOrgA+b-ghEUGp
ojEQRCZU-bY0RsgDavJrJOoVkY6sbxZGs8EQBKfz-iSCsmBiU5p3W-frdqkbZNMRTEF+kSlg
LUHJGIo3X-DpnDPVgtjTtqE1UO0WcTswrE1-B2lLUXR+E2km+Bk49+PUwRDBlX4s1PPu+ma9
s69NONOFkXCcG200zI7YLdk7G4Pv4H27IjSdtcfBExBODRLuje3kmoV-+g03BcErMMGU7SFx
Vr1+QzBas1vJA6PLMthqvTS61tWxQ5gCfNiuQNOJrtEv-pbPoilRNONO14jGB3NgenD74Q1G
xf56P8hCMsGka2toEMGiHW-EFVBIPlbOBibJhXhSIpnfJaQBKhwnHPr4uZeb7HtroyioqP1t
Sx3ZV64-P4fqB5FE-Z43AniDt7SnBBIx+xY4MCVR-VDWdc+MEIn4+F0s-9XnlaXoWAE3j4Oe
SPetab+GevcdhHfV3S2pl4oMqGJWfTNekvFhBZOVisWSm511oDXrJ+Y0QEEDA-yuKOBIERaI
oO1NY75X86PsDUIyX7h4-a+1PuFAGt-Nk7p-qpY14DLa8juwpZdb-arhYE92R1U2J86Vk2d9
+ueU-a1dVU1vrwAb2YUb0W3f6ktC8jtkQd4PnIkAZ3Go8E87JaC-IF30vD4V2E0oeRqwyVFR
Sy8EB2UeGBwNPKW9feUMVBcIYBo-8dV-ewO5uekVoeQPK5qWNI9EUTioWiZ5QLq+GQglIXR-
Bs7cjoRuKH5-g8-CdY4iR-7ljNWg6BNh26EiKerFOZ+tpfkEr7aSaGgp6lvkCNfRtK0fKC+7
m9dl96++t6Ztw+Qs6c+-bHgrnlmA0FXStm-UPoMqjCsdqRv8M4m+RViXffIWTd+F1LX3LfQl
DMg9d1uQtOW4XxfX498PwNJisRgQ9Qwcvz2N2urm4Cw1dF2kUuP+8+yEuNG5hY0a44VSOmHK
EeuTWAoZ9+JvDYgoOizBk9Ut8r0YbmdCP6FuXgwQ9TDs2oVi-ZYk1tFQIZ+iRGyVqHro00lA
gw5yHM3rKVfRpqjjDkCDRuFrBqgTbhZNuTqLGaDzVfs4Rb5G24XugWFwgoK9-F8NkWFywi3g
m7in+jhx3zre99OWIyCn3BDcd4ScIto0lDS6+NGyYze59k5wexZ6BqQ3xjSM4qE6ScbQixkF
zZH-TcXf-9Zrl2i09TaMsV+q6-5XgpbdwqR0y-XhLNp4ZnTM7IeNp8RogA7tZu40UTUNeBgK
DRVgpuYv9hFyWHam4a9Kpcvb7Pfcvo5KoXTCq9bXgd-9TqOunVfYgx9pFrk7Ykq+bVR+YEGt
ZeURnYhohBxHQJxiqcrvzdnqbrwDNUI4Nxfge5oMLzbeyocEn23EyRejIJKWV5ZtcXtFNin1
yAdLDX1OoLkmbDCjh40Ap-0giAG4zx5Io4weTochsxJDn+Kvn3rrBDv6NkzIdhsM8yXmntIi
MouJ1pEJpr9pIDJxS0ZyzoXprL1-lFJNac5tz7pWe-EFhVBJhT-nVAsHrMFLblSamgRGj6j+
ElT9QDz+3C4g920NHJGsiP2SeZKgKyf5OiaqKY75KdIPxIMNWOC5dcGFYRdHrT5v-mWBevk4
ak50rzWwI2G2bNjCXiV3loKJUK92zRkvU9DeJBoechMA5tgUDQhHxBUztQQ-MlO+3ShrEXd+
zVO8FmEAhnVHc2qcBZ-PFp6bP2Y1G0tRKncp5sr+0lcbtb8YYDAMSgARDp7RkC1jX9oRzp+-
n5o+0h6JI0UUxAAE7W6n9jMH3-FEdAufvarGBdGYYEKL60wEN5Q-VeQzq+uq-yH6ZVwUb1FF
DQ8ik3W-j8TJHYVIMAxJCBk7VQt6EFB0OvISPc1yyPG4nXcoykX5eWTLrZFpcOp-nQo+y5Mb
gz6VoBUByvgvzZVtfZFue1-NcJ8p+ehOaGW2yJJZn78fi0a0y0xrEdF9OyF6CBWVNS+a-JUI
mas3QCIqaGFaKi0UalQ2xqM6vU5-+m1c1wDuoBzeFKe9mOkef0hav4v3H+ZHkVDoiYspax7p
***** END OF BLOCK 3 *****



*XX3402-022127-071297--72--85-50541----SPACEPCX.ZIP--4-OF--5
H04YvKq7D90+PbqdyDodK6h+Ic+TV7GwgPdE0sJbO-es+Nd0WdEvTp4FMRIEK3cJ3078OwLO
1LOh0Y8Fak529RX2zc2HP88s4HVrU0nsNwpGFA2zXToTi4+rnY7gFnVdtSMaefyxikqcVV8H
wm5dX6sV7RDLkP+5BjO4Cj+bZ0hI63UHwb0RGm0k27uoNaH0t1Mvq2Zl77Yt+VOaCWESLPcX
Oxsuzi052AznCegSO4w7gmpRbeXmf38aM+9DccVj2HeV58fmj5uYBhP-qTKBSS2iQ0N94IfA
QpgDKn0I-lLTU-EXqCknm9Q3H1FMW5+ODjJKd27z0DRg429AUDCkXYeRVH2M0vpIfm4h2ii5
Uek22PDj1zTWwhsEQh9kkbIDLZEPm9PKUzIKI4q5mfplJUM5k37+Iu-WkxFmwJg4OgFcL0l1
CQE3OXy0XKVeVVjCq+g1o2va3dbdQWgJDLBT3JZrgWBhuZcNhA+5mCW7wYyBfYLYHzhGEinr
AvDJVH-iO2f6gVJlNBmEchUavAF0gkV83mn2MhQFZOKajJEjZ8TbL6U9o7vJAQ0qb0vyAWVm
ioFer15765ostYKsPZUlaT3ZOc-r-Tlr6-uMMhpXW2OxynY3U6gz8iIelBO3z866Bxi1tA0D
Dd+m0e+WQmFa762O7gGaJc-QJQhA8dmFqtHFfE1eVAElUmVoVb6HmjNjVbZrYYvY96VaDn0H
0GG2nDUE5am6j+SH-E2ekqohakh6eO4yhGSLD8IFTSOb32odEmn-zDpeaM1gWolLOT58t9dc
MGRnf50x1zjtG04lT+qc5gibAOfQknZInIEbubMGHQmzG8pppUuZ8OyyUCTz4jBkpyyTa+iG
n1ofx2-4iM6A85iDcAIqTe5Yz+EGEPZRzJE-gdrcO+k2uQPORg7pvIEZz1Khpee7egTdPoe5
925xypA8KFRF-gT1z2PmSpmaEMLCUdNFjUfY7vtlG1s51f94elCevN+q8O6VJ86AK1dI3EJh
-tKYBc8Ohs4lSYWo-z7+6J7yQ6f1+s+tN2PfkHB8g0a7PUHs4qBWghNWy8x3T4-OTDXNHe8J
wBFO+fB7fHJMCE6auxU02ECR0bAdgR2H-Efa91m3xRi1tOD0-+-uJXwqI2wVic-k2kcOeU+c
sSpWU-xBqYiH+rZh+zsEw+aUT66tRg3hS2wsH1CiZ+XvZogFwJZfuHFlO2EeUNIdRqC7J8Q3
fLrXn2jYU2I1OnnUhCMte1UEYDKBM5ARXcQzR-qNjcsvd83mIuOKCiFo14F8Maw4ADYxJ5hy
1wsCollGs3K8-XGGGFpLeJtPrK6Zl7NohrI6pJ0YVUXw1P-jkuTDt+ieTb+5Ikhsv8pjP+Pf
Ss6AeWjJY3ZVHxR0EGqBhFsEwm1gk1f1nA+AA3wHF9ZlvXY7Pu9KTAyG68ar-ZXxsTe4rZm5
UFjHZXho4S+oC1uR3FxKOrN11m36EKzcPiuuawASb8FtFLBW6RYUbt9s5gCRUjSgWdm23d7G
YOFLB2VLwOSvA0GIvq2+8uVcG66PNrqVFDz44NU97J+O-ddSF1+goOOLRWxL1t4q-Rm-PJcH
xuvrH0MPR826tyJOMaoeZVfHNQglH2otx43onuaCWGua1WIDowz5-1mO3HEp-nXedBm3xEIL
yIvQsYIhN6LMOPVQG4DdhdFLr6TjjJx2+0ZGDFysCYA5iDfc4sWRlPXfgq-s4fBvBxnMzKNi
LlPfmpAJ43hA6IdEnxosKlBwZLQU2zKMvXQKYr02L24OJgObJvJSLTTv+TPf+dG0+RlS66zA
18u1piJkWdCTn0d5E6rq+HMZV1V1DaXTB7lGcCU0FHWyDj2HTDKNrnjxVeYubeiSmJm7HUJy
K2a2LO+4A2SRb9QqJu92-IE5nOiaICLouKAOEbp0hEFxDmFCMrc0XWGMQAL90jECHoc+1EUV
3KSAXeNTvMyYXl4ph-zXskxjTsDibAuhkA5Qw-l0JR687xNOaDRy+h9dEStWuwC3b77+AqmP
yCVGeR7v1ECAHbKUNjVAi181VwL9+Hwg8LVRf+iwOMn6J6pkV+Vxsn9adm45Xtirjgu2DI3A
+CBCyT4EtgabdgI5hOwjWsElDmUq1jwsM+iniUhxUZ962hsOwOoFLi1Ev4I2JyjmiVQFDIKr
toFCwjoHnawxkPsJpAE-DkvJu-PnXUut+aAKWtDYyci1lnKnHBb-FBo6MBGkVD7r+ZxeIY8Q
XVgtRJmkpYLAcmtSmE7Dba5TbAvK2JUJ7-fjcwT+GRtID3-4r+zdv-VCk+nF-x78iC38jhi0
t2xVKPIfXiG6WK-M9E7ifeKUs9amsi9KkYM2TmqLcA9qOKVMjG53e4QeIKyWi3zhCRWQxU+X
8hXRfoR0ZcVC99Dv5LRXTE5YCWH6ak1uI6ELG28AYvW1d-cBhUUalucAETLvK7T5VKaAmPv-
VP0ZgpnV6mM7UazrwLCgX2e2ZvaUfNEMrNGq3gNekL8ZtZc9UUW4qW87gEEme2Vh8yeBuIsr
Ji23fXPUH2yYih-c4rFcGnS+2668o-ukeusKEIdoUYu0cUHS0YD2tSIuHf1VkVhQ7iC77uWA
dXrFa9qXaRaUVpUg-y-JI0sm9U62NR3V2CntrzJvlwlcqYQit7GQGUabIX4bMfsNHirohbNh
NZbMipixK9-AbGKsFCpin102rWRGRJX2z3VMXnPL3wUmNk5wrJUUCFoL8c2OULV-VZlV6EhH
WjQMTwFLiM8jWm7KHN6N+9loLkpZTHB22RtjgPkNw9Q6dfddi2n-Ndcj6CDXHpvv2qE5c8jS
X7IcAiMGqpwOMqGBiYad7hov-ZQTvAAOrdzX4hQ3JqnfB7WWUxGQ-jNl7UevCIW3oNnfL4MF
mLJVsw8u3dOGii0Xaw10nVJw5S2kB0yaRJ9aHz66VJ0iDe9xLVCSMbw6FEqBaKV0Jky-8jV6
USLdDiHk68uRlhEJHc9zqgR7C3aSsOUQ8hWEo4smhs1gAaPVIKasAdGPJBZPtp6vj0GpEmCp
LwpEg52q-sbVVWhZ95IO9c6jM0SkWdY9D1bz6BakX2YdoVUZkIgM2dlXUGbdAwEVO-77WapF
EXCQZ3CJniDRTDeMwv4r1OgHyHqfMDIWChJUb-AHnt3OZaAbgrUZayFu9wi36kuJMGa9JPdU
84LpRTCGlvZ38H8vYgjDICMV2CEjDL2eSi4aITT2OZqkEYaj-tcJM0IadWYa-YV0O8K4UZay
3wiVlMZNZIFVcoCN0nIG3PcvJSAVgollf6zstM-IXhVWpwENfnh7YRGHaN8Tl7zDodgHQn1Q
CJOC8FmMJT5g6n8ZoBG6FEuSH0t48+XL+sCDjogIw0RffXszhCXEzJW1Mjrdm0cLZ6RQkUfU
gEi-RCJlxflbZNqQmwIRV5aTBYmD3RCwAQIRMpNNoYzTA80WCtZ1SY292vFcW9RJyTycEVa5
G0xA9mbQjKFpgI95Aehk1G2BmPbY2jfaz6XrkSlUR0wy9lqNGowyESvShBuf6tamIXX3v2ey
fucSTf0Zg3cvBFzUcLmQoAhpsBwSGg3bwEsGIy-A6OqP50UcTkzScGJKm89hqIE8gPYktAiZ
+3NFdVGNWmyT2xICR1R2fYDEbU2J4JgBzQt2qWeBRvQ-JXKkYithVEWskUNMDKEdSXJQ1mx3
qV3N3II0Ol6L0DIEOveVe-cKVp8t1FFqUrs-enLYGJQ8zE+i+DHq1+qKgLemYfaBLB9WitOG
gg6YBVsQp3nTZC6PEza2xyFv+Uqif2ll5QQsvFig1WYAp6-HmwSIfjYCh+fmQL-373LLScrB
vaOXduKWsddWhKftlMreFh4rs-d9gS+T046xFnv5gsedrU8SSo4zQYqwsKiJDUvH4wwNWvWI
b+8+8tPo5NrAuuHX7uKWd+NiMkCvXuVkbnuX8ILa2gUbhgpuBPD3quiFapDVN9K+jRsexcI9
JRbh7FCgkIu+P9S-FELj1RpV3yZULJkxvW6qT6b7sJDqu-gefWjNJGkvEP4mKGY41aBOJZml
6-d2gPjS7OdXIkZB9QMPzALskhyxID8HlNJU+Qtps0Pny541fZGemPmJHpNFXP4KxPyIEaKi
SyPyR4OJ1o0+8KW+k9lLkqmdSL-7a3O+INZY+80C9HXDt914Jex51YRehRg6d2bEu8u4f9dl
rNIPJg2R3W4zlO3P+8-ZNmXg4ndZISbfayiCwP7Er708YKRCGG1D8FbgEbOEh6sZf0Ffysss
qrAC4xTvbABv2Byx43RTfYDtVDQRQrW48pDo6QUwBa3VACj+Q5QrtWtbXGM9B8MbhfbOXG5R
XCsEitQVeosUxQ1-1J3DKJykwvCmaEHQTMYNyc9v-EtD-C2BSWY4MLxjl6VlZF5XoNvDhGlX
bsXYx8nlPBOCNpCKmDH+oogAXHz534GNh9JnENt8rfn3hDZ11VBILI4KYzNURaAeoUiCUvTb
oajeGbPy9NnYv+Z4DFnjh+n8QZv02QgHLNuyHogl++mB5RzXnU93plKf89fwl3lWDRgHhAvJ
f6fJf+S+EYfT-MJIk7ay0gvumoKQcef9JIYD8OhPjQDNXECecleueQrJ2TOBsEfKe7+W3FZA
6b6CWAMuXcWCnpLjt4aZF829nJSI23Wn22gFZSCbXRXsYUJHgEKPeNeNoS0s3H2OZToNDcvp
bfZUDEW9VgZwAhD-059AhcZ0Gkk1xapuFd3Wrw7MWATW8PdQs7dVQ37Mmp2O9F9VK-yMXv-q
orHqesgqwe8t3YSHbclmt6hTrgRt2tc-A1CgUO5jQ2r8PrH+7hOJ3lNSi58HhVZqpfadpayd
urpn9iA3aDkr2NRv4vJrg4TNhP0xWxZlOmM307r7L+cJn2Dcx3Ft5mestWEQt-IVw8tu6FqI
4qRR0ngj7yd8-cBZfVkPSri0O5vJug6Y67Wv2RlIjNp-vmPHbCZFQcR4jLXpdM786OtimFYS
veLqvWCCUjRQepf4SVjMJIyJeAs1lHo5CLBQ9BDayRcegp2hUHJOceMZpg4xX0Di-KVASI1b
RloLQILg8xXD+Pfbv8ANpsusPP1jCZoc7NnLsTaI+rJxNvEpE8ETf1DinO58+BDZtqEJ941G
wk35vs2Fw0GkSMtD9XAFZepWNMqMXF23yfE+S2ls8LqmUPJTtg4AHYrKnPKCebI2t7O5aR7X
VkKo0XWgVRoi9bACpFjDjN10nrBjs5VB7FHx6Iw8Qg+znJUSH3-CHjToRdWXDe19UjKj9EWw
S1KXLoex729aKfuNXFMS+sS6D0IN2MPYpi2yWjgM2rT9JWzcKRlUWP+OeT-EBR+dMYsvqWyv
L2nLCYXTuK9b55a3E+fuMai0tS6+X6t6YP9q5M009bno0m4m3ycRSw5ip-SEgZKhl6Oxki+8
4jUMRKfCR3YyxtBsvj1uXVvhvKljQJANR9S7IS5emrzqQbatjDmaPDTlb7vA611hDfG-+Ltj
-XnMXBKzfVeond5JlMrBkiO49VsfhpQB-8AC2WQF7QPDKZoHcS22dr4kvhrN2cm0Ogx34+LW
1jO+z4ywc05pSW4Zfvnk-XRPnq99XKCvw49-6mrvIV4BKsELfahg2UyS-pKggLqgLWlbmWya
LblH1evVy3sCGsO7FPtQYWBWt-8PcrCNYzC2FTsKC3L9qcIv-ybW6fiBORlCp0QL4+7PU3be
VaE1izBdwn2TC0yy4pz3FQPtCrev4UhcQNUloHXmgIUIUWLLzSqhtzh5YXuWbS-2NQcj9Pvs
r04zi29Q4ClLm-3JuuuWAhmXl23O+wXnmKle2zV0jD2dNm6l3H46hfdMa8ol-FHNRqh53yQ4
2Wm-BXQ71cGZ2as2mAxRSSu3tp69hbdV6cTGO1I8sVCLNRu9YHU-q27ofX4kgXu4xbZfyQIr
3P7e+yr6oIhAwI+9nSycKCKP3ulPp6o6ls6YJ24+aOT8dmceJzoixp8lLet9a-XO-nfIfoPY
J3KlIo-bdykfhZusAVM+lOsEF-kkfdOV3kS6TZy5oe3OV0sD6U1+wVp7oV4f1-0cwuTmHKOW
***** END OF BLOCK 4 *****



*XX3402-022127-071297--72--85-35906----SPACEPCX.ZIP--5-OF--5
ZApm0VeijhPawCqpyXj8SIxFmPrlF353zmjyvWeg+8b5cQI9B-xr3HTFTlIb0TonohkkDfyd
t0D7Q8n-HAWr+C3+GVQt7Uhj3j7Ml4aUWMxPL9E1af8e4U4U5cyMYAWLt+Ya2lkwZpr6zIOB
yH1l4A69Sd+wdMUR9500cOHM8IHvxcZA-6eE0x2GW8Vu0v+Bm2c0E8aLmlYg9LI02GWsGveB
v+WfE3PNLPS98IKp4I1SgBG9KXKEok2Ht-imXgzv0mlJWvni9KLKQHq7QZ+bqhcltuZXAS2d
EjlW1kwvt1AsmSTdL3cUdRfmXaQDeMYUIUJAE+zivNiNDrgdJS-HnAcqRWvYE3sLeEw-POl4
EXqmjCIEOmHCG1Rehqfc+VrVMRTdqcmR7KcypeVy9E2ysALOi4q+ttnYKL0UBvGNzWSGaoDj
FqNN2JeAk5glQ-vryk3RHUlwXGbVig5ww7fgfQvt+BQCSpmkF663lCvZpAj9aT7PFu7QqbeC
-wpOZMTGQKsGIHMSccFR09i40K2LzIvEjwI7OQhmGJdsLLxjq-jiyNkpcBuYmyqwK2hC79-h
yvMfTg82on05o8n2c+K5fa-oW2RHExU040uUGivISNAqTJDsbhcZLZDptghLxuz0Q7EFZewN
H5WPS4hue+LNlf+Zo4G9bpm9U0E25Km-lqclGB2aLs26Yftnt-pq41I4MyGl-mvdPc92OOBZ
kPcfCJAwMyvPMh5YWylQbXKplO-NB4WF7HYfU-jfK8lYCM0lNn3yNes7Ve+Rqq4dlbPQM-4U
B0LjHRXtlQmrLnlYybwv6TRaYA1RVehaAqtaEwQXYcENoCtWSRqCi0uSYOY3SV+r5ez+3LY6
0HE3PbWv-zcag+sxdlQXQAM5gMoD+gc+IRiM0wgg+bl932IBq5KPW7xqOxCt1n6FDgka9M+K
-62TLGGot7OhGB+ldV7gNM3Ttx14YeVqP+G5WHkEDb+AenKStWTDQD0jsILAwNq7gKtV8LPS
neIYkHPJj+B1MGD6r3ITUoMqBJ-kQh2Dh4GPtE9d7yTC6CNlBtv+823JUH5BAQ3bzYNrr7M7
XPnuZvuRCN67r8WRn0QmMYJmP4N-HhRUKs98vqWiFU+tUzJirA7ZUWG3quSMMphFt3zI0Eo4
L4osw8T4nlOLBPGcTF+Nup9ItLksbdsfGaMiLI09eIhRG2GgCKY+--NNFwJuIohS-fz6V+11
1YDzbyjdBYbhODBQAlfS3H9EDqxsAsJx3lYsulz9qeAawGceD3cy2TL10m15-iMFHQchMpSW
qaxcbnuVILc5JUrf0ciDrdjplFmTfdTkijxPUEaMBhrTkK5rh4mASFyd6PyvItOwMYpDSJmN
wl45+43JcRcxBQM0SMlEhFRkBl87DXSSvBpswdrb2LS5RTAkbDSjGhEa1+2qkw29nIJpLzgr
ZSkxJPKQUeMLdN5E+pa4GuaFnVBvDV+-d55L78lsGoPhQH3IwAMygVq4MxwfY5axDW0MA2SB
Cno6JLw5M3l5D5PPlyuQ3qmOH0ZjAq+-qaHXJD4Ey5pW98kVP9vaDXIm33a+59WGWQARAUA3
zM6SwXCpQOaNcsY6E3KJ+bUwEMZfE3qKrGRR3eg7XDb3LO4pkkortVvusm2XxfsiKs57zMLK
4EGyF6IM0UekzE+eDeyid9VJ+s87oI2AU3WA9pG-0vlLglT8pEmA0xF9vmtKVlswuU9BVaHM
6AR46qXd+-OW+xykWLnENZYm17-hGe79jWaEeSmL+ewOS8LxWid939IJRZj05y-1YXV2d6Qw
HFVJHtRfJP1NexNoqKCkTqTMht+iA-V7FgHaViFVXM1HRuuf8zNnPs+X2y35HSA+FcqNP2-2
pt0RKYQBczGFfMCRALuHMOyDKEtFvzScErJzs-TUPDU1wbW6Z+VN6W77UYa4ZiDJVgUlWHCS
-1BsoNPUBENS6YxkqdK2IRhMYX2PrFzKDASWLxfP4EdKs825Rvv9w5sLWk1h5FWwVXhx8BcM
ArqC4JVZrrX0xI4D4VC4klgAhrUCFbigh1n7MqIUX3hyX6eN4jb34YBfwZqmArUd-lfVkCpk
Rlj110a9-VHE1d68vh5F6jTv72ZV-yaa2yEeJo7yIEpuEleR286tlsNSzVn14CjX4Rba457m
+YDqWyUaSVIATT+iExtRZvnlwLexlXKthnsMfhQNdSf7bC2y+urJlRdhFK7R316WVmFct0-P
zU0-vgBMSW+6o6dhn9Bq1IR71q6VlW7s5rb67L0j-AnqGE5c4kzeVlEk2bVnVZlD+bAWdgRn
UQSx49Y7YSBam8ut21bhavbqDBsRSph1LvU3xIuyOH7iSmTe1rQdXr5d1d0uf+PEQrwEKUBA
fbVmkqEU9ho3Zfn+3tud4QWWfa9r36l0PVnHAfo91T2sJVB5AIs47R2YllRIIhxUB-KAFUOX
YQ56rzOdyevrfWAPIPDrK+HdmwNcASiQ4RJPp-lluGvYw96GviwUKrrErk3HMpI9WcBDcMJg
T8PAn-IvdKzcVw068T9oxPnEwiXdXKTeqW-27H3wE-kCpJ0CDNmntDaM7F2KcjmFIo7mh8kS
mJYYVbbfMSprL5m8-IFvx5G1OK-Ab-3Pd9VnKTB+IBefaHp1NWSqDbTwme3swJHb+XPR2FUm
ffqM2n3w4rMDzVCU+pn8Tluky2n6sTSH5wEax5rnzVDp8lIySO9ycAGayKP5w7yMZsOkb4Ql
rFFtbJ8Aprn57WY4+NW7Ki-L80owIaxWuMBhWXtBUCDTIFBXPwz+ZwUrzC2qr1weyLdKZnaf
9cCzsXMWzQxwur6UDdOI6Pq7o0nYEj33szEJljmauUdCj3otIdYfesbJ8oU0TjDZwch5Mjd0
gLhrp5VaT9xUCaDI-l1HC+nDvGJY3tL0ZM8g2FZENce773rbX0S9V2RuMJ++DMPO+pARogMZ
iiSfB+07e-a09K2NgE8MHiwvy1ZI9uXJ4ozsepu+hzvmbmo9S92R+sr5eeEfprGZR-Bx5QT7
yd6Pzd1Uwjh7QAlU6-hnX8Y5X8f9PiE+dcBCLOYeLv59h4CUU6AA7dLPbRIce99bP09IQN3G
5Oz6u9y4pTBw2U0zyVo-aUXUwZxKLoAJkOBA8gDJC1sLa+QaxcdVoRX6beW2lOBOJFApsNR1
YVMD3D5+VUskqI589AxtJ2B--9LSk-xdd6IBSjnKPDbaFbsd9zMtLOP5db8N67B1lUcnx57U
2Qh57YgCFc0dwLWFOn45Gn3nz+5FCjsWtv8nygefWRSwpl8jjf9OUShKvvE3grObXhbmtgjw
ubgi1e3syb2yNrz+1Kfg-ylfyQKC+3leBrgo1ysW7d57izka2tUvlsLlqlgwlFy8mWW6yY+A
j0eiJDSL8ojuqUezq3evgZ-TA1i+JUvN+Ctuna6W4PzJKzuaH56nNGpdGriIpXVZRedKCuiR
JlDskNLPMeyiuYuvoxMRZ61KGyKLjjrWscgwoHIrHICT4IoJk-xOM2u3ikT65QUSLcnp6il+
p-PQl7FAqm5HUbs+BUJalUGL4MMIJ5uBz38pgfkcWtdIX-WCi8FmuoVILwyZX1XmgSqOQWXZ
6wsSv+kZc3HWh--UxYevwydrLyqoLk3SrejM-hSRJrI5ppSFC9aEmXm5BS3n225Ybg9t5W-D
Tk-jUwgsH08UWib2AkEsB+KCAJO8U0bEgXkbft2XaNX6hBc-0hVjNt+orf7WyWLnVsv7fKj9
l8b2Pm8qsWEIqJ18VSiGH0LnmnIWmjJPL1ksLuNBF-+-1xBUsKuqzkVsRRfphZaHpBjTPKiQ
vs7XI2+k3N6QquMyskSXiI2RMHgWl35IkzDM9xTD8FvfHRGc-OXFW6QCcDA1TVghjy8NLmSi
4Rj6lpjBSJWFb6K+XNKH3GRtQ0EWBtNjEO5RlW3wk+cJ3-eJ1hZu7JFzV+hgMziJJzy6gQsr
gFsLAlIOAoJr1v+OOsY0zzw-XFDOD7xUBZso6uQpaxxfYCLG-nk1xE2mHXAQwyCVeC+tlBn5
ZHATK+77D+gTzBe8nWf1begR2LxQJzx38LOjl-7eCW6Mr2hlloRLHEc6cuswTQgjEy5LezBv
2PJYGocmdQKD7r7ct8SWj211+jTCQC3zq-5KyD1LW7bmsCZjJLSBX5MwF8jss5DpSmOvSiz5
FiontBb14WQuHWRFCqy+WDOXqC9kqvWuwKNEZmoykz3d1k2LWLazQlvyTbUtuE4tEfJ2BonE
2y3fbm9SSlvejryVzC0GTgINoGtCRm7MIHCjrPqskr5jMiL-tMrsnt2rXoq3Hg9UwRL1nHH1
tkVAMuWpibbVex-0-bRUe6LYTjwn03wRFxjfOtuVldlSm1kDDYCLLLtnFBToyaZAvxbCuDF9
FqWBAKTdrz3rRg2uwhuzmTq9JcNrzm-reOD5JB1bhn0HeCyL3mypWiEvY0zQawqsOBvPaF3c
TgjzP3W0JiHz-X01vFniPwjz8zBXz8UTzzX5IjflUAI-zrq-bw2LLrkV7JkyzD11LQLzxyPD
ZTc9dTufIjxBePzVKycbGjojTWgBN-bibTeBIZwcxLTTLzz74xzvbrzyjPxzOmDuWsq15vlq
wdSjrTufuzRzSDqbTnpsz8D-VrynywizrTrJXpzznRyxzfiTT3yxcZF5eEqZ-fBVTe1ILmbp
pofxRuLyVp7zfy+uejh8TOXUAb6AhOvIOoc-fXSISij00ry9wPzwkVzzwFxzvrjT+qvTzzvr
rrfffFzws+QzzC2DTzGX5k5ZbznY7p2IrPvxTwgr6nQ7UE089kE9+w3+g-+2EP+kg-+20o2k
2+E1kQ10E-+A-+A9+kg1kI+E5+F-g-+Q5+E9-y5-zE25sI3krxTBhrXzkXpsz5vTozRaUvYg
Wk3SVr8xwzKpKWTlwmvlAtpjodbj-z9nw5UtbscYsaYg07MoIoKiCKo3uqEte4fIpvTqxiXe
yRtY-sjuJc5qJPGL4BE2h-SvtzNsVNC0QyhwxgvLSDVyi1gjg+62I+XBoXD45gs0EV3Z6GjD
L0F0dZ8Fie5B0yg4u8NCEBkHxKAKd0KW6WlYJ8bsdf3iguv55gWDc6m+HCm4q+Cn7ksz73mo
gzhbAcLywKrPTU3EGk203++I++6+0+-LdcQXd-2ujsYR++12BU++1++++++++++++0++++++
++++Ip--EoJ0EogiI2BMI2g-+VE+3++0++U+eeC56qaIFl26C+++oqY+++k++++++++++++U
++++glo++3BEEIB3Ip-G9Z-1K3-9-EM++++++U+0+5E+++1ZJE++++++
***** END OF BLOCK 5 *****

