{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Streams/Encrypt2.pas             [x] Protected mode

  This program demonstrates the encryption filter.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFKERNEL, EFSTREAM, EFFILTER;


const EncryptionBuffer = 4096;

      Scrambler = 'This is a scrambling code that encrypts the'+
                  'keyword to make this program the only program'+
                  'that can decrypt the files. This is a second' +
                  'keyword.';

var Source : pStream; Target : pEncryptFilter;
    ScrambledKey : string;

{ ParamStr(1) must contain the input file, ParamStr(2) the output
  file and ParamStr(3) your keyword string. }

begin

     if ParamStr(1) = ''
        then begin
             WriteLn ('Syntax: ENCRYPT <file1> <file2> <keyword>');
             WriteLn ('  Encrypts or decrypts <file1> with <keyword> and writes the');
             WriteLn ('  result in <file2>.');
             Halt;
             end;

     { Initialize source stream }
     Source := New ( pIFile,
                     Initialize (ParamStr(1), EncryptionBuffer) );

     { Initialize target stream as a filtered stream based on the
       encryption filter with a file stream as secondary stream. }
     Target := New ( pEncryptFilter,
                     Initialize (ParamStr(3), New ( pOFile,
                                { Keyword }   { Base stream (will be intercepted) }
                     Initialize (ParamStr(2), EncryptionBuffer))  )  );
                                { Filename }  { Buffer size }


     { Encrypt the keyword to make the encryption specific
       for this program. No other program can then access your
       coded files, even if they use EFLIB. }
     ScrambledKey := Target^.Scramble (ParamStr(3), Scrambler);
     WriteLn ('Scrambling keyword:');
     WriteLn ('  You specified ', ParamStr(3), ' but EFLIB uses ', ScrambledKey, '.');
     Target^.SetKey ( ScrambledKey ); { Change to scrambled keyword }

     { Demonstrate seeking inside an filtered, encrypted stream. }
     Target^.Seek(Target^.Size div 2); Target^.Seek(0);

     { Transfer all data from source to the target (the target is
       the secondary stream inside the encryption filter. }
     WriteLn ('Encrypting your file:');
     Source^.CopyOut (Target, Source^.Size);
     WriteLn ('  ', Source^.LastTransfer, ' bytes written.');

     Source^.Free; Target^.Free;
end.