{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Transfer.pas            [x] Protected mode

  Demonstration of how elements can be transferred between arbitrary
  ADTs. The polymorphic interface makes this *very* easy.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFDEF, EFKERNEL, EFARRAY, EFLIST, EFSTREAM, EFFILE;


var A : tArray; B : tList;
    F : tTemporaryFile; SomeData : string; Index : word;

begin
     A.Initialize (9, SizeOf(String));
     B.Initialize (SizeOf(String));

     { Create two duplicate data types }
     SomeData := '1'; A.Store (SomeData); B.Store (SomeData);
     SomeData := '2'; A.Store (SomeData); B.Store (SomeData);
     SomeData := '3'; A.Store (SomeData); B.Store (SomeData);

     { Export elements from B into A, hence giving the array
       twice as many elements. Then, do same thing but in
       another way - giving the array 3+3+3=9 elements. }
     B.CopyOut (@A);
     A.CopyIn (@B);

     WriteLn ('A = imported elements:');
     for Index := 1 to A.Elements do
         Write ('[', Index:1, ']: ', String(A.Get(Index)^.Data(0)^):1, '':2);

     WriteLn; WriteLn ('Temporary file:');

     { Put the ADT in a temporary file }
     with F do begin
          Initialize ( 1024 );
          Put ( @A );

            { Demonstration of stream loading (using the Get method
              in any tStream). }
            Reset;
            with pArray(Get)^ do begin
                 WriteLn ('':2, 'Loaded ', NameOfType, ' from stream.');
                 WriteLn ('':2, Elements, ' transferred into ADT.');
                 Free;
            end;

          Intercept;
     end;

     WriteLn ('B = the original elements:');
     for Index := 1 to B.Elements do
         Write ('[', Index:1, ']: ', String(B.Get(Index)^.Data(0)^):1, '':2);
     WriteLn;

     B.Intercept;
     A.Intercept;
end.