/* TCHK 2.1 - Howard Kapustein's Turbo C library        6-6-89      */
/* Copyright (C) 1988,1989 Howard Kapustein.  All rights reserved.  */

/* timehk.c  -  Howard Kapustein's time routines */

#ifndef TIMEHK_HEADER
#define TIMEHK_HEADER   1

#include <howard.h>

/* function prototypes */
int pause(int wait);         /* pause like delay or till keypress, returns scan code */
char *timetostr(struct time *tsource, boolean seconds, boolean hundreds, boolean ampm);  /* convert time to string */
struct time *strtotime(char *source);       /* convert a string to time */
boolean time_convert(void *source, void *dest, int stype, int dtype);
long dostimetolong(struct time *t);         /* convert a DOS time to 1/100 seconds */
struct time longtodostime(long t);          /* convert a 1/100 seconds time to DOS time */

#define MAXLONGTIME     8640000l            /* 24 * 60 * 60 * 100 => # of 1/100 secs per day */
#define isPM(hr)        ((hr>=12)?TRUE:FALSE)
#define tohour(hr)      ((hr>12)?hr-12:(hr==0?12:hr))
#define to24hour(hr)    ((hr==0)?24:hr) /* 0-23 = 24-hour clock */

#endif              /* TIMEHK_HEADER */
