
   NNAAMMEE
      chmod - change the permissions mode of a file

   SSYYNNOOPPSSIISS
      cchhmmoodd [ --RRffhh ] _m_o_d_e _f_i_l_e_n_a_m_e ...

   DDEESSCCRRIIPPTTIIOONN
      Change the attributes (mode) of a file or files.

      The mode of each named file is changed according to _m_o_d_e, which may
      be absolute or symbolic, as follows.

      Absolute Modes
         An absolute _m_o_d_e is an octal number constructed by ORing the
         following values together:

            400   Read by owner.
            200   Write by owner.
            100   Execute (search in directory) by owner.
            040   Read by group.
            020   Write by group.
            010   Execute (search) by group.
            004   Read by others.
            002   Write by others.
            001   Execute (search) by others.
            4000  Set user ID on execution.
            2000  Set group ID on execution (this bit is ignored if the
                  file is a directory; it may be set or cleared only
                  using symbolic mode).
            1000  Sticky bit, (see chmod(2) for more information).

         These values are supported only for Unix compatibility, under
         MS-DOS and OS/2 only the Write attribute is examined and is used
         to set the Read-Only atrribute.

         Symbolic Modes
            A symbolic _m_o_d_e has the form:

            [ _w_h_o ] _o_p _p_e_r_m_i_s_s_i_o_n [ _o_p _p_e_r_m_i_s_s_i_o_n ] ...

            _w_h_o is a combination of:

               u  User's permissions.
               g  Group permissions.
               o  Others.
               a  All, or ugo.

            If _w_h_o is omitted, the default is aa.

            _o_p is one of:

               +  To add the _p_e_r_m_i_s_s_i_o_n.
               -  To remove the _p_e_r_m_i_s_s_i_o_n.
               =  To assign the permission explicitly (all other bits for
                  that category, owner, group, or others, will be reset).

         _p_e_r_m_i_s_s_i_o_n is any combination of:

            r  Read.
            w  Write.
            x  Execute.
            X  Give execute permission if the file is a directory or if
               there is execute permission for one of the other user
               classes.
            s  Set owner or group ID. This is only useful with u or g.
               Also, the set group ID bit of a directory may only be
               modified with '+' or '-'.
            t  Set the sticky bit to save program text between processes.
            A  Set the MS-DOS and OS/2 Archive attribute.
            H  Set the MS-DOS and OS/2 Hidden attribute.
            S  Set the MS-DOS and OS/2 System attribute.

         The letters u, g, or o indicate that _p_e_r_m_i_s_s_i_o_n is to be taken
         from the current mode for the user-class.

         Omitting _p_e_r_m_i_s_s_i_o_n is only useful with '=', to take away all
         permissions.

         Multiple symbolic modes, separated by commas, may be given.
         Operations are performed in the order specified.

      Again, symbolic values are supported only for Unix compatibility.
      For MS-DOS and OS/2 the only applicable symbolic values are w, A, H
      and S.

   OOPPTTIIOONNSS
      --RR Recursively descend through directory arguments, setting the
         mode for each file as described above.

      --ff Force.  cchhmmoodd will not complain if it fails to change the mode
         of a file.

      --hh Display a short help message.

   CCooppyyrriigghhtt  ((cc))  11999922    FFrraannkk  EE..  WWhhaalleeyy    AAllll  rriigghhttss  rreesseerrvveedd
