;----------------------------------------------------------
;
;   Sample TSR to demonstrate application specific task
;   context save and restore routines.
;
;   This TSR must be installed after MultiDos Plus is
;   executed and before any other application task is
;   started.  Use the following MultiDos Plus commands
;   to install this program:
;
;      LC
;      ND
;      XQ
;      APPLCTX
;
;
;   One of the context choices is to save/restore the 10
;   interrupt vectors used by Microsoft C's floating point
;   emulator.  If a task was written in Microsoft C and
;   uses floating point, use the following sequence to
;   load and execute the program.
;
;     RM xxx
;     MISCFLAG 2                 indicates must save context
;     other pre-load commands
;     YOURPROG                   load your application program
;
;   The MISCFLAG 2 command informs the context routines
;   contained in this (APPLCTX) module that the interrupt
;   vectors used by the Microsoft 8087 emulator are to be
;   saved and restored for the task.  Please note that this
;   is only required if more than one task uses a floating
;   point emulator.  Only tasks which use the floating point
;   emulator need to use the MISCFLAG 2 command.
;
;
;----------------------------------------------------------
;
;   Copyright (c) 1990
;           by
;     Nanosoft Inc.
;   13 Westfield Road
;   Natick, MA  01760
;
;-----------------------------------------------------------
.MODEL	LARGE
.286
;
	NAME	APPLCTX

MISCFLG		EQU	200	;misc. flag word
TCBTSKNM	EQU	220	;task number


;------------------------------------------------------
;
;  start of the code segment
;
;------------------------------------------------------

_TEXT	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:_TEXT

	assume	ds:NOTHING,ES:NOTHING,SS:NOTHING
;
	db	'Copyright (c) 1990 Nanosoft Inc.'

MAXTASKS	EQU	12	; ALLOW ONLY FOR MULTIDOS PLUS DEFAULT

SVDATA87	DB	128 * MAXTASKS DUP(0)

SVINTMS		DB	64 * MAXTASKS DUP(0)

;-----------------------------------------------------
;
;  CONTEXT SAVE ENTRY POINT
;    ENTRY:
;	BX = OFFSET OF TCB
;	ES = SEGMENT OF TCB
;    EXIT:
;	ALL REGISTERS MUST BE PRESERVED
;
;-----------------------------------------------------

CTXSAVE	PROC	FAR
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	SI
	PUSH	DS
	PUSH	ES
;
	TEST	WORD PTR ES:[BX+MISCFLG],100H	; SAVE 8087?
	JZ	CTXSN100
;
; SAVE 8087 CONTEXT FOR THIS TASK
;
	MOV	SI,ES:[BX+TCBTSKNM]	;GET TASK NUMBER
	SHL	SI,7			; * 128
	ADD	SI,OFFSET SVDATA87	; ADD IN BASE OF CONTEXT SAVE TABLE
	FNSAVE	CS:[SI]
	FWAIT
;
CTXSN100:
	TEST	WORD PTR ES:[BX+MISCFLG],200H	;SAVE EMULATOR INT?
	JZ	CTXSN200
;
; SAVE INT 34 - 3D INTERRUPT VECTORS FOR MICROSOFT FP EMULATOR
;
	PUSH	ES
	MOV	DI,ES:[BX+TCBTSKNM]	;GET TASK NUMBER
	SHL	DI,6			; * 64
	ADD	DI,OFFSET SVINTMS	; ADD IN BASE OF CONTEXT SAVE TABLE
	PUSH	CS
	POP	ES			; DESTINATION IN CODE SEGMENT
	MOV	AX,0			; SOURCE IN SEGMENT 0
	MOV	DS,AX
	MOV	SI,34H*4		;
	CLD
	MOV	CX,20			; COPY 20 WORDS (10 VECTORS)
	REP	MOVSW
	POP	ES
;
CTXSN200:
;
CTXSNO:
	POP	ES
	POP	DS
	POP	SI
	POP	DI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET
;
CTXSAVE	ENDP

;----------------------------------------------------------
;  Restore context routine
;----------------------------------------------------------

CTXRSTR	PROC	FAR
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	SI
	PUSH	DS
	PUSH	ES

;
	TEST	WORD PTR ES:[BX+MISCFLG],100H	; SAVE 8087?
	JZ	CTXRN100
;
; SAVE 8087 CONTEXT FOR THIS TASK
;
	MOV	SI,ES:[BX+TCBTSKNM]	;GET TASK NUMBER
	SHL	SI,7			; * 128
	ADD	SI,OFFSET SVDATA87	; ADD IN BASE OF CONTEXT SAVE TABLE
	FRSTOR	CS:[SI]
	FWAIT
;
CTXRN100:
	TEST	WORD PTR ES:[BX+MISCFLG],200H	;RESTORE EMULATOR INT?
	JZ	CTXRN200
;
; RESTORE INT 34 - 3D INTERRUPT VECTORS FOR MICROSOFT FP EMULATOR
;
	PUSH	ES
	MOV	SI,ES:[BX+TCBTSKNM]	;GET TASK NUMBER
	SHL	SI,6			; * 64
	ADD	SI,OFFSET SVINTMS	; ADD IN BASE OF CONTEXT SAVE TABLE
	PUSH	CS
	POP	DS			; DESTINATION IN CODE SEGMENT
	MOV	AX,0			; SOURCE IN SEGMENT 0
	MOV	ES,AX
	MOV	DI,34H*4		;
	CLD
	MOV	CX,20			; COPY 20 WORDS (10 VECTORS)
	REP	MOVSW
	POP	ES
;
CTXRN200:
;
CTXRNO:
	POP	ES
	POP	DS
	POP	SI
	POP	DI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET
CTXRSTR	ENDP

lastlbl	dw	0

;---------------------------------------------------------
;
;   INITIALIZATION CODE TO INSTALL THIS PROGRAM AS A TSR
;
;---------------------------------------------------------
savds	dw	0
saves	dw	0
;
	PUBLIC	TSRINIT
TSRINIT	PROC	FAR
	MOV	CS:SAVDS,DS
	MOV	CS:SAVES,ES

	MOV	AX,1E08H	;FUNCTION AND SUBFUNCTION CODES
	PUSH	CS
	POP	DX
	MOV	BX,OFFSET CTXSAVE	;OFFSET OF CONTEXT SAVE ROUTINE
	MOV	CX,OFFSET CTXRSTR	;OFFSET OF CONTEXT RESTORE ROUTINE
	INT	15H			;CALL MULTIDOS PLUS API
;
; COMPUTE THE END OF WHAT WE WANT TO STAY RESIDENT AND DO A DOS TSR
;
	MOV	AX,offset lastlbl
	SAR	AX,1
	SAR	AX,1
	SAR	AX,1
	SAR	AX,1
	MOV	DX,AX
	MOV	AX,seg lastlbl
	ADD	DX,AX
	MOV	AX,cs:savds	;get psp
	SUB	DX,AX
	INC	DX
	MOV	AX,3100H	;EXIT AND STAY RESIDENT
	INT	21H
;
TSRINIT	ENDP

;--------------------------------------------------------

_TEXT	ENDS

_stack	segment	stack
	db	500 dup(0)
_stack	ends

	END	TSRINIT

