/* Definitions for OMF record types */
#define THEADR	0x80  
#define LHEADR	0x82
#define COMENT  0x88
#define C_XLATE 0x00
#define C_MEMODEL 0x9D
#define C_DOSSEG 0x9E
#define C_DEFLIB 0x9f
#define C_COMENTA0 0xa0
#define CA0_IMPDEF 0x01
#define CA0_EXPDEF 0x02
#define CA0_INCDEF 0x03
#define CA0_PML	0x04
#define CA0_LNKDIR 0x05
#define CA0_BIGENDIAN 0x06
#define CA0_PRECOMP 0x07
#define C_OMFDEBUG 0xA1
#define C_LINKPASS 0xa2
#define C_LIBMOD 0xa3
#define C_EXESTR 0xa4
#define C_INCERR 0xa6
#define C_NOPAD 0xa7
#define C_WKEXT 0xa8
#define C_LZEXT 0xa9
#define C_COMMENT 0xda
#define C_COMPILER 0xdb
#define C_DATE 0xdc
#define C_TIME 0xdd
#define C_USER 0xdf
#define C_MAINTIME 0xe8
#define C_DEPENDTIME 0xe9
#define MODEND 0x8a
#define EXTDEF 0x8C
#define PUBDEF 0x90
#define LINNUM 0x94
#define LNAMES 0x96
#define SEGDEF 0x98
#define GRPDEF 0x9a
#define FIXUPP 0x9c
#define LEDATA 0xa0
#define LIDATA 0xa2
#define COMDEF 0xb0
#define BAKPAT 0xb2
#define LEXTDEF 0xb4
#define LPUBDEF 0xb6
#define LCOMDEF 0xb8
#define CEXTDEF 0xbc
#define COMDAT 0xc2
#define LINSYM 0xc4
#define ALIAS 0xc6
#define NBKPAT 0xc8
#define LLNAMES 0xca
#define VERNUM 0xcc
#define VENDEXT 0xce

/* OMF psuedo-record types used in libraries */
#define LIBHEAD 0xf0
#define LIBEND 0xf1
#define LIBEXT 0xf2
#define LIB_CASE_SENSITIVE 0x01

/* Values returned by the record load function */
#define MODERR -1	/* Error this record */
#define MODQUIT -2	/* Never encountered */
#define MODIGNORE -3	/* Record was ignored */

/* Flags for the execution list */
#define TE_REPORT 1	/* Report what record was encountered */
#define TE_IGNORE 2	/* Ignore the record */
#define TE_ERROR  4	/* Generate an error for the record */
#define TE_HAS32 8	/* Record may be 32 bit */

/* OMF record handling functions will have this format */
typedef void (*EXECFUNC)(BOOL use32, BYTE *bufpos, uint size, char *modname, uint pass);

/* Descriptor for an OMF record type */
typedef struct _typexec_ {
	ushort  select;	/* OMF record ID */
	ushort  flags;	/* FLAGS, as above */
	EXECFUNC	run;	/* Routine to run to parse the record */
} TYPEXEC;

#include "module.p"