;
; LSD os library for use with C compilers
;
; Copyright(c) 1996 LADsoft
;
; David Lindauer, gclind01@starbase.spd.louisville.edu
;
	.386
	MODEL USE32 SMALL

include	lib.asi

   	PUBLIC	_OSDosOpenFile,_OSDosCreatFile,_OSDosCloseFile
	PUBLIC	_OSDosReadFile,_OSDosWriteFile,_OSDosPositionFile

_TEXT	SEGMENT	
;
;* int OSDosOpenFile(char *filename, unsigned mode);
;
_OSDosOpenFile	PROC	
	ARG	FILENAME : DWORD, MODE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[FILENAME]
	mov	dl,[BYTE PTR MODE]
	OS	FI_OPEN
	pop	ebx
	jc	short zeroreturn
	LEAVE
	RET
zeroreturn:
	xor	eax,eax
	LEAVE
	ret
_OSDosOpenFile	ENDP	
;
;* int OSDosCreatFile(char *filename);
;
_OSDosCreatFile	PROC	
	ARG	FILENAME : DWORD, MODE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[FILENAME]
	sub	ecx,ecx
	OS	FI_CREAT
	pop	ebx
	jc	zeroreturn
	LEAVE
	RET
_OSDosCreatFile	ENDP	
;
;* int OSDosCloseFile(int handle);
;
_OSDosCloseFile	PROC	
	ARG	HANDLE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[HANDLE]
	OS	FI_CLOSE
	pop	ebx
	jnc	zeroreturn
	LEAVE
	ret
_OSDosCloseFile	ENDP	
;
;* int OSDosReadFile(int handle, unsigned char *buffer, int size, int *sizeret);
;
_OSDosReadFile	PROC	
	ARG	HANDLE : DWORD, BUFFER : DWORD, BUFSIZE : DWORD, SIZERET : DWORD
	ENTER 0,0
	push	ebx
	mov	ebx,[HANDLE]
	mov	ecx,[BUFSIZE]
	mov	edx,[BUFFER]
	OS	FI_READ
	mov	ebx,[SIZERET]
	mov	[ebx],ecx
	pop	ebx
	jc	zeroreturn
	LEAVE
	ret
_OSDosReadFile	ENDP	
;
;* int OSDosWriteFile(int handle, unsigned char *buffer, int size, int *sizeret);
;
_OSDosWriteFile	PROC	
	ARG	HANDLE : DWORD, BUFFER : DWORD, BUFSIZE : DWORD, SIZERET : DWORD
	ENTER 0,0
	push	ebx
	mov	ebx,[HANDLE]
	mov	ecx,[BUFSIZE]
	mov	edx,[BUFFER]
	OS	FI_WRITE
	mov	ebx,[SIZERET]
	mov	[ebx],ecx
	pop	ebx
	jc	zeroreturn
	LEAVE
	ret
_OSDosWriteFile	ENDP	
;
;* int OSDosPositionFile(int handle, int position);
;
_OSDosPositionFile	PROC	
	ARG	HANDLE : DWORD, POSITION : DWORD
	ENTER	0,0
	push	ebx
	mov	edx,[POSITION]
	mov	ebx,[HANDLE]
	OS	FI_POSITION
	pop	ebx
	XOR	EAX,EAX
	LEAVE
	ret
_OSDosPositionFile	ENDP	
_TEXT	ENDS	
END