;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, gclind01@starbase.spd.louisville.edu
;
;message.asm
;
; Function: message passing
;   Handles allocating the global message page table page
;   Handles allocating/deallocating a named message page
;   Handles keeping message pages sorted by name
;   Handles moving messages into a message queu
;   Handles retrieving messages from a message que
;   Does NOT error check to see if message queues exceed 4MB, severe consequences
;     if you pass the limit!!!!  For that matter, the code assumes you don't
;     go beyond 4MB - 4KB
	
	;MASM MODE
	.386p
include  segs.asi 
include  message.asi 
include  page.asi 
include  pageall.asi 
include  errors.asi 
include  page.ase 
include  pageall.ase 
include  sys.mac 
include  boot.ase 
include  remaps.ase 
include  dispatch.ase 

	PUBLIC Init_Global_Message_Page, MessageHandler
seg386data	SEGMENT	
messageques dd	0
seg386data	ENDS	

seg386	SEGMENT	
;
; Allocate the global messag page table
;
Init_Global_Message_Page	PROC	
	ALLOCEXT
	call	PageAlloc	; Allocate a page
				; Assume succeed, if not we have no memory!
	push	eax
	or	eax,PG_WRITEABLE; Make it writeable
	mov	ebx,eax		; Getting set to initialize system page table
	mov	edi,CR3		; System page dir
	ZA	edi		;
	mov	eax,MSGPAGE	; Message block of 4MB
	call	PageTableEnterAddress	; Mapped it
				; This will stay mapped for life of OS
	pop	edi
	ZA	edi
	push	edi
	call	PageTableDisable; No entries in it yet
	pop	edi
	sub	eax,eax
	call	PageTableEnterAddress	;Point first page of message area at
					; page table for message area
	ret
Init_Global_Message_Page	ENDP	
;
; Compare two names
;
cmpname	PROC	
	push	esi		; Compare one name
	push	edi		;
	push	ecx		;
	mov	ecx,MSGNAMELEN	;
	mov	esi,ebx		; Get source
	repe	cmpsb		;
	pop	ecx		;
	pop	edi		;
	pop	esi		;
	ret
cmpname	ENDP	
;
; Find a message queue by doing a binary search
;
FindMessageQueue	PROC	
	mov	esi,MSGBASE+MSGQUESIZE; Start with first queue
	ZA	esi
	mov	edx,esi
	mov	ecx,[messageques]; Get total number of queues
	or	ecx,ecx		; See if any
	jz	short noqueues	; Quit if none
	shl	ecx,MSGQUESHIFT; Point above last queue
	add	edx,ecx		;
findlp:
	mov	eax,edx		; See if difference is one queue or less
	sub	eax,esi		;
	cmp	eax,MSGQUESIZE	;
	jbe	short lastqueue	; Quit if so
	sub	ebx,ebx
	bt	eax,MSGQUESHIFT
	jnc	short iseven
	mov	ebx,MSGQUESIZE
iseven:
	add	ebx,edx		; Else average the two
	add	ebx,esi
	stc			; Because always at top of 32 Bit memory
	rcr	ebx,1
	call	cmpname
	jz	short found	; Quit if found
	jc	short loadbottom; If less load bottom
	mov	edx,ebx		; Else load top
	jmp	findlp
loadbottom:
	mov	esi,ebx		; Load bottom
	jmp	findlp
found:
	mov	esi,ebx		; Found: ESI = midpoint
found2:
	clc
	ret
lastqueue:
	jc	short loaded	; Quit if diff less than one queue
	mov	ebx,esi		; Else compare pointer item to input
	call	cmpname		;
	je	short found2	; Quit if match
	jnc	short loaded	; If greater use bottom
	mov	esi,edx		; Load bottom
loaded:
noqueues:
	stc
	ret
FindMessageQueue	ENDP	
;
; Format a queue name appropriately
;
GetName	PROC	
	push	edi
	mov	ecx,MSGNAMELEN	; Get len
copylp:
	cmp	BYTE PTR fs:[esi],0; See if hit end
	jz	short blankit	; Go add blanks if so
	mov	al,fs:[esi]
	mov	[edi],al
	inc	esi
	inc	edi
	dec	ecx		; Dec count
	jecxz	gotname		; Quit if full name copied
	jmp	copylp		; Loop
blankit:
	mov	al,' '		; Blank out end of name
	rep	stosb		;
gotname:
	pop	edi
	ret			;
GetName	ENDP	
;
; Add a new message queue
;
theNAME	EQU	EBP-MSGNAMELEN
AddMessageQueue	PROC	
	ENTER	MSGNAMELEN,0	; Save space for name
	lea	edi,[theNAME]	; Get pointer to name
	call	GetName		; Load the name
	call	FindMessageQueue; Find the queue
	jnc	short duplicate	; Quit if is duplicate name
	ALLOCEXT		; Else allocate a page for the queue
	call	PageAlloc	;
	jc	short nomem	; Err if no memory
	push	esi		; save message queue ptr
	push	eax		; save alloced memory

	add	esi,[zero]
	and	esi,PG_MEMSIZE-1; Convert queue pointer to table entry ptr
	shr	esi,MSGQUESHIFT-2;
	mov	ebx,esi
	add	esi,MSGBASE	;
	ZA	esi
	push	esi		; Save page table ptr
	shr	ebx,2		; Get index to this item
	dec	ebx		;
	mov	ecx,[messageques];
	sub	ecx,ebx		; EBX = ECX = items to move up
	jecxz	nomove
	mov	ebx,ecx		;
	shl	ebx,2		;
	add	esi,ebx		; Point at end of table to move
	mov	edi,esi		;
	sub	esi,4		;
	std			;
	rep	movsd		; Do a move
	cld			;
	mov	eax,CR3		; Reset the TLB
	mov	cr3,eax		;
nomove:
	pop	edi		; Restore page table ptr
	pop	ebx		; Restore alloced memory
	or	ebx,PG_WRITEABLE; Make it writeable but system
	sub	eax,eax		; First entry
	call	PageTableEnterAddress
	pop	edi		; Restore corresponding queue address
	inc	[messageques]	; Increment number of queues
	lea	esi,[theName]	;
	mov	ecx,MSGNAMELEN/4;
	push	edi		;
	rep	movsd		;
	pop	edi		;
	sub	eax,eax
	lea	eax,[eax + MESSAGETABLE.DATA] ; Get init que insert & delete ptrs
	mov	DWORD PTR [edi + MESSAGETABLE.CQIN],eax;
	mov	DWORD PTR [edi + MESSAGETABLE.CQOUT],eax;
	clc
	leave
	ret
duplicate:
	mov	al,ERR_DUPLICATEMESSAGEQUE
	stc
	leave
	ret
nomem:
	mov	al,ERR_NOMEM
	stc
	leave
	ret
AddMessageQueue	ENDP	
;
; Delete a message queue
;
DeleteMessageQueue	PROC	
	ENTER	MSGNAMELEN,0	; Copy name to stack
	lea	edi,[theNAME]	;
	call	GetName		;
	call	FindMessageQueue; See if exists
	jc	short badqueue	; Error if not existant
	add	esi,[zero]
	and	esi,PG_MEMSIZE-1; Else convert to page table index
	shr	esi,MSGQUESHIFT-2;
	mov	ebx,esi		;
	add	esi,MSGBASE	;
	ZA	esi
	mov	eax,[esi]	; Get item to release
	call	PageDealloc	; Release it
	shr	ebx,2		; Index to item released
	dec	ebx		;
	mov	ecx,[messageques]; Get queue count
	dec	[messageques]	; Decrement queue count
	sub	ecx,ebx		; Number of items
	jecxz	nomovedown	; Quit if no move
	mov	edi,esi		; Else move down
	add	esi,4		;
	rep	movsd
	mov	eax,CR3		; Reset the TLB
	mov	cr3,eax		;
nomovedown:
	clc
	leave
	ret
badqueue:
	mov	al,ERR_NOMESSAGEQUEUE
	stc
	leave
	ret
DeleteMessageQueue	ENDP	
;
; Get the length of the next data in the message queue
GetMessageLen	PROC	
	ENTER	MSGNAMELEN,0	; Space for name
	push	edi		; Save possible data pointer
	lea	edi,[theNAME]	;
	call	GetName		;
	call	FindMessageQueue; See if exists
	pop	edi
	jc	short badqueue	; Get out if no such queue
	mov	eax,[esi + MESSAGETABLE.CQIN]	; Get len
	sub	eax,[esi + MESSAGETABLE.CQOUT]	;
	jz	short gmn_nomessage
	push	esi
	mov	edx,esi
	add	edx,MSGQUESIZE
	mov	eax,[esi + MESSAGETABLE.CQOUT]
	add	esi,eax
	sub	eax,eax
	call	getbyte
	mov	cl,al
	call	getbyte
	mov	ah,al
	mov	al,cl
	pop	esi
gmn_nomessage:
	clc 
	LEAVE
	ret
GetMessageLen	ENDP	
;
; Get amount of space left in message queue
;
GetMessageLeft	PROC	
	ENTER	MSGNAMELEN,0	; Space for name
	push	edi		; Save possible data pointer & len
	push	ecx		;
	lea	edi,[theNAME]	;
	call	GetName		;
	call	FindMessageQueue; See if exists
	pop	ecx
	pop	edi
	jc	short badqueue	; Get out if no such queue
	mov	eax,[esi + MESSAGETABLE.CQIN]	; Get len
	sub	eax,[esi + MESSAGETABLE.CQOUT]	;
	bt	eax,31		; If negative, IN wrapped around but OUT didnt
	jnc	short gmf_nobias; No bias if positive
	add	eax,MSGDATASIZE	; Else apply que len
gmf_nobias:
	mov	ebx,eax
	mov	eax,MSGDATASIZE
	sub	eax,ebx
	clc 
	LEAVE
	ret
GetMessageLeft	ENDP	
;
; Empty the message queue
;
EmptyQue	PROC	
	ENTER	MSGNAMELEN,0
	lea	edi,[theNAME]	;
	call	GetName		;
	call	FindMessageQueue; See if exists
	jc	badqueue
	sub	eax,eax
	lea	eax,[eax + MESSAGETABLE.DATA] ; Get init que insert & delete ptrs
	mov	DWORD PTR [edi + MESSAGETABLE.CQIN],eax;
	mov	DWORD PTR [edi + MESSAGETABLE.CQOUT],eax;
	LEAVE
	clc
	ret
EmptyQue	ENDP	
;
; Put a byte in message queue, with wrap around
;
putbyte	PROC	
	stosb			; Store the byte & update ptr
	cmp	esi,edx		; See if hit end
	jc	short pb_nowrap	;
	mov	esi,edx		; Yes, wrap back to start
	sub	esi,MSGQUESIZE	;
	lea	esi,[esi + MESSAGETABLE.DATA];
pb_nowrap:
	ret
putbyte	ENDP	
;
; Put a message in message queue
;
SendMessage	PROC	
	call	GetMessageLeft		; See if enough space
	jc	short nosend		; Error, get out
	sub	eax,2			; Two bytes for message size
	jc	short noroom		;
	sub	eax,ecx			; Plus ECX bytes for message
	jc	short noroom		;
	mov	edx,esi			; Set up end of queue
	add	edx,MSGQUESIZE		;
	push	esi
	mov	eax,[esi + MESSAGETABLE.CQIN]; Get start of input queue
	add	esi,eax			;
	xchg	esi,edi			; FS:ESI = data EDI = message queue
	mov	al,cl			; Put CL
	call	putbyte			;
	mov	al,ch			; Put CH (for total length)
	call	putbyte			;
sm_loop:
	mov	al,fs:[esi]             ; Get a byte
	call	putbyte			; Puyt it to queue
	inc	esi
	loop	sm_loop			; Loop till done
	pop	esi
	sub	edi,esi
	mov	[esi + MESSAGETABLE.CQIN],edi
	clc
	ret
noroom:
	mov	al,ERR_MSGQUENOROOM	; Error, not enough room in queue
	stc
nosend:
	ret
SendMessage	ENDP	
;
; Get a byte from message queue
;
getbyte	PROC	
	lodsb				; Get byte, update ptr
	cmp	esi,edx			; See if hit end
	jc	short gb_nowrap		; Quit if not
	mov	esi,edx			; Else wrap to start
	sub	esi,MSGQUESIZE		;
	lea	esi,[esi + MESSAGETABLE.DATA];
gb_nowrap:
	ret
getbyte	ENDP	
;
; Get a message from the message queue
;
ReceiveMessage	PROC	
	call	GetMessageLen		; Get len of message
	or	eax,eax			; See if any
	jz	short rm_nomessage	; Quit if not
	mov	ecx,eax			; Len in ecx
	push	eax			; Save len for later
	push	esi			; save pointer to queue
	; EDX was set up by GetMessageLen
	mov	eax,[esi + MESSAGETABLE.CQOUT]; Point at retrieval data
	add	esi,eax			;
	call	getbyte			; Ignore len, we already have it
	call	getbyte			;
rm_loop:
	call	getbyte                 ; Get a data byte
	mov	fs:[edi],al		; Put in user buffer
	inc	edi			;
	loop	rm_loop			; Loop till done
	pop	edi			; Reset retrieval pointer to next data
	sub	esi,edi
	mov	[edi + MESSAGETABLE.CQOUT],esi	;
	pop	eax			; Restore len
rm_nomessage:
	clc
	ret
ReceiveMessage	ENDP	
;
; Main message handler
;
MessageHandler	PROC	
	push	fs		; Save seg regs
	push	ds		;
	push	es		;
	push	esi		; Save other regs
	push	edi		;
	push	ebx		;
	push	ecx		;
	push	edx		;
	push	ds		; FS = user data seg
	pop	fs		;
	push	DS386		; DS = ES = kernel data seg
	pop	ds		;
	push	DS386		;
	pop	es		;
	push	0		; AX = 0 at entry
	call	TableDispatch	; Dispatch function
	dd	6
	dd	AddMessageQueue
	dd	DeleteMessageQueue
	dd	SendMessage
	dd	ReceiveMessage
	dd	GetMessageLen
	dd	GetMessageLeft
	dd	EmptyQue
	pop	edx		; Restore regs
	pop	ecx		;
	pop	ebx		;
	pop	edi		;
	pop	esi		;
	pop	es		; Restore segs
	pop	ds		;
	pop	fs		;
	ret
MessageHandler	ENDP	
seg386	ENDS	
END
