; exelink.asm
; Copyright (c) 1993 Stephen Harris
;
; A TSR program which intercepts all EXEC calls (int21 function 4Bh).
; If the call is to run a program residing in the directory listed in
; 'linknm' then instead of executing that it will open the file and read in
; the name of a program, and execute that instead.
;
; see exelink.doc for details
;
; This is version 2, which releases unused memory (environment block) and
; relocates itself over the PSP to make the resident part as small as
; possible.
;
; Written for the TINY model in Turbo Assembler.  Should work for MASM
; since Borland say that TASM is MASM compatible...
;
; For Turbo Assembler use:
;   tasm exelink
;   tlink /t exelink
; For MASM use:
;   masm exelink;
;   link exelink;
;   exe2bin exelink.exe exelink.com
; NOTE:  The MASM stuff is just a guess - I don't use it!

cseg            segment para    public  'code'
                assume cs:cseg, ds:cseg, es:cseg

                org     100h

START:          jmp     setup

oint21          dd      ?

linknm          db      'C:\LINKS\'
len_link        equ     9

execnm          db      128 dup (0)

handle          dw      0

nint21          proc    far
                pushf
                cmp     ah,4bh
                jne     exit2

exec:           push    ax                      ;       Save everything
                push    bx
                push    cx
                push    es
                push    si
                push    di
                push    bp
                push    dx
                push    ds

                mov     si,dx
                push    cs
                pop     es
                mov     di,offset execnm
                mov     ah,60h
                int     21h

                push    cs
                pop     ds
                mov     si,offset linknm        ; ds:si point to linknm

                push    cs
                pop     es
                mov     di,offset execnm        ;es:di point to execnm

                mov     cx,len_link
                cld
                repe    cmpsb                   ; check if identical

                jne     exit                    ; nope - exit as normal

                ; oh gosh!  the same!  Open the file and find what the link
                ; points to

                mov     dx,offset execnm        ; open it
                mov     ax,3d00h
                int     21h
                jc      exit                    ; if can not open, exit normal
                mov     cs:handle,ax

                mov     bx,ax                   ; get the name from it
                mov     cx,127
                mov     ah,3fh
                int     21h

                mov     ah,3eh                  ; close it
                mov     bx,cs:handle
                int     21h

                mov     di,offset execnm-1      ; turn to ASCIIZ
lp:             inc     di
                mov     al,byte ptr cs:[di]
                cmp     al,32
                jg      lp
                mov     byte ptr cs:[di],0

                pop     ds                      ; throw away old exec name
                pop     dx

                push    cs                      ; set pointers to new name
                pop     ds
                mov     dx,offset execnm
                jmp     exit1b

exit:           pop     ds                      ; restore registers
                pop     dx
exit1b:         pop     bp
                pop     di
                pop     si
                pop     es
                pop     cx
                pop     bx
                pop     ax

exit2:          popf
                jmp     cs:[oint21]

nint21          endp

; there ended the TSR code.  The next stuff is simple initialisation.
; if gets the old int21 vector, throws away the environment, then
; relocates itself down to 60h in the PSP.  Since we don't use FCB's in
; this code, there will never be a need for the DTA - even assuming a TSR
; uses its own DTA!

setup:          xor     ax,ax                   ;       Get old 21h vector
                mov     es,ax
                mov     ax,3521h
                int     21h
                mov     word ptr oint21,bx
                mov     word ptr oint21+2,es

                push    cs
                pop     ds

                mov     es,ds:[2ch]             ;       lose environment
                mov     ah,49h
                int     21h

                cld                             ;       move tsr over PSP
                mov     si,100h
                mov     di,60h
                push    ds
                pop     es
                mov     cx,setup-START
                rep     movsb

                mov     ax,ds                   ;       work out new segment
                sub     ax,0ah                  ;       for relocated code
                mov     ds,ax

                mov     dx,offset nint21        ;       set new int21 address
                mov     ax,2521h
                int     21h

                mov     ah,9                    ;       Sign on message
                mov     dx,offset ident
                push    cs
                pop     ds
                int     21h

; Now we need to go TSR.  Calculate number of paragraphs code needs
IF              (setup-START) mod 16
ROUNDUP         =       1
ELSE
ROUNDUP         =       0
ENDIF

                mov     dx,((setup-START)+60h)/16+ROUNDUP

                mov     ax,3100h                ;       TSR
                int     21h

ident:          db      'Command file linking v2. '
                db      'Copyright (c) 1993 Stephen Harris',13,10
                db      '$'

cseg            ends
                end     START
