 { GENERATE A 3 DIMENSIONAL SURFACE - INPUT TO THE SURFMODL PROGRAM
  Written by Amnon Levav
  Converted to turbo pascal 4.0 on January 16 1987 by Kevin Lowey.  Needed
  to ensure a space between real numbers output with the WRITELN routine
}

program SURF;

var Out : string[12];
    OutFile : text;
    Pi:real;
    NU ,NV:integer;
    StartU,EndU,StartV,EndV:real;

procedure f(u,v:real; var x,y,z:real);
begin
     x:= u;
     y:= cos(v)*(1.3+sin(u));
     z:= sin(v)*(1.3+sin(u));
end;

procedure printGrid;
var iu,iv:integer;U,V,X,Y,Z:real;
begin
     writeln(OutFile,'* Nodal Coordinate lines');
     for iu :=0 to NU -1 do
     begin
          U:=StartU+iu*(EndU-StartU)/(NU-1);
          for iv :=0 to NV -1 do
          begin
               V:=StartV+iv*(EndV-StartV)/(NV-1);
               f(U,V,X,Y,Z);
               writeln(OutFile,X,' ',Y,' ',Z);
          end;
     end;
end;

procedure Connect;
var iu,iv,n1,n2,n3,n4:integer;
begin
     writeln(OutFile,'* Surface Connectivity Data');
     FOR IU := 1 TO NU-1 do begin
        FOR IV := 1 TO NV-1 do begin
           N1 := (IU-1)*NV + IV;
           N2 := (IU-1)*NV + IV + 1;
           N3 := (IU)*NV + IV + 1;
           N4 := (IU)*NV + IV;
           writeln(OutFile, 4,' ', 1,' ', N1,' ', N2,' ', N3,' ', N4);
        end
     end
end;

procedure Initialize;
begin
    Pi := 3.1415926;
    NU := 21; NV:=21;
    StartU := -Pi; EndU := Pi;
    StartV := 0;  EndV := Pi*2;
end;

begin {main}
     Initialize;
     write('output file ? ');
     readln(Out);
     Assign(OutFile,Out);
     rewrite(OutFile);
     writeln(OutFile,'3d parametric function');
     writeln(OutFile,'* version line');
     writeln(OutFile,4);
     writeln(OutFile,'* Control line');
     writeln(OutFile,'* No. Of Materials,No. Of nodes,No. of Surfaces,');
     writeln(OutFile,'* Max Vert Per Surf,No. of sides in the surface to use');
     writeln(OutFile,1,' ',NU*NV,' ',(NU-1)*(NV-1),' ',4,' ',2);
     writeln(OutFile,'* Material Data');
     writeln(OutFile,'2 .7 .5 1 .1');
     PrintGrid;
     Connect;
     close(OutFile);
end.
