; SETDAC.ASM
;
; Version 1.3 - July 25, 1994.  Modified to improve detection of the DAC,
; to make the base I/O port of the DAC a variable, and to display the port
; address to the user.
;
; This program sets up the DAC to take direct writes.  If this program is
; run before another program that writes 8-bit unsigned samples to a DAC
; at the port displayed by Setdac, the program should produce better sound 
; than is available with the PC speaker.
;

	JMP	START

;
; Data.
;
SOUNDHALTED	DB	0
INT15DEFAULT	DD	0
PORTBASE	DW	0		; base I/O port of DAC
NODACMSG	DB	"Tandy DAC not detected.",0Dh,0Ah,"$"
PORTMSG1	DB	"Tandy DAC at port $"
PORTMSG2	DB	"h",0Dh,0Ah,"$"

;
; Replacement Int 15h handler, for BIOS callout.
;
INT15HDLR:
	CMP	AX,91FBh
	JE	>L0
	JMP	DWORD PTR CS:INT15DEFAULT
L0:	MOV	CS:SOUNDHALTED,1
	IRET

;
; Routine to check whether there is BIOS support for Tandy sound functions.  
; Sets carry if no Tandy DAC found; otherwise, carry is cleared and the base
; I/O port of the DAC is returned in AX.  (Modified, 7/13/1994.)
;
CHKDAC:
	PUSH	CX
	PUSH	DX
	;
	; Check for PCMCIA Socket Services.
	;
	MOV	AX,8003h
	XOR	CX,CX
	INT	1Ah
	CMP	CX,5353h
	JE	CHKDAC_NODAC
	;
	; Check for Tandy DAC.
	;
	MOV	AX,8100h
	INT	1Ah
	CMP	AX,8100h
	JE	CHKDAC_NODAC
	;
	; DAC found.  Base port returned in AX.  Verify the presence of a
	; read/write port at (base+2).
	;
	MOV	DX,AX		; DX addresses (base+2)
	INC	DX
	INC	DX
	MOV	CL,40h		; set bit 6 of CL (assume port present)
	CLI			; disable interrupts
	IN	AL,DX		; save value from port in CH
	JMP	$+2
	MOV	CH,AL
	MOV	AL,0FFh		; set all bits of port
	OUT	DX,AL
	JMP	$+2
	MOV	AL,0		; clear all bits
	OUT	DX,AL
	JMP	$+2
	IN	AL,DX		; read back and test
	JMP	$+2
	OR	AL,AL
	LAHF
	AND	CL,AH		; bit 6 of CL still set if successful
	MOV	AL,0FFh		; set all bits
	OUT	DX,AL
	JMP	$+2
	IN	AL,DX		; read back and test
	JMP	$+2
	NOT	AL
	OR	AL,AL
	LAHF
	AND	CL,AH		; bit 6 of CL still set if successful
	MOV	AL,CH		; write back saved value
	OUT	DX,AL
	JMP	$+2
	STI			; enable interrupts
	TEST	CL,40h		; if bit 6 of CL still set, port found
	JZ	CHKDAC_NODAC
	;
	; Read/write port found.  Return port base in AX.
	;
	MOV	AX,DX
	DEC	AX		; decrement twice to get base port back
	DEC	AX
	CLC
	JMP	CHKDAC_END
CHKDAC_NODAC:
	STC
CHKDAC_END:
	POP	DX
	POP	CX
	RET

;
; Routine to display a hex digit.  The digit is in AL.
;
HEXDIGIT:
	PUSH	AX
	PUSH	DX
	CMP	AL,9
	JA	HEXDIGIT_LETTER
	ADD	AL,'0'
	JMP	HEXDIGIT_DISPLAY
HEXDIGIT_LETTER:
	ADD	AL,'A'-10
HEXDIGIT_DISPLAY:
	MOV	DL,AL
	MOV	AH,2
	INT	21h
	POP	DX
	POP	AX
	RET

;
; Routine to display a word in hex.  The word is passed in AX.
;
HEXWORD:
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV	DX,AX
	MOV	BL,12
	MOV	CX,4
HEXWORD_LOOP:
	PUSH	CX
	MOV	AX,DX
	MOV	CL,BL
	SHR	AX,CL
	AND	AL,0Fh
	CALL	HEXDIGIT
	SUB	BL,4
	POP	CX
	LOOP	HEXWORD_LOOP
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET

;
; Main program.
;
START:
	;
	; Check whether the needed sound circuitry is present; display error
	; message and halt if not.
	;
	CALL	CHKDAC
	JNC	DACFOUND
	MOV	DX,OFFSET NODACMSG
	MOV	AH,9
	INT	21h
	JMP	TERMINATE
	;
	; Save the I/O port returned.
	;
DACFOUND:
	MOV	PORTBASE,AX
	;
	; Display the output port (base+1) to the user.
	;
	MOV	DX,OFFSET PORTMSG1
	MOV	AH,9
	INT	21h
	MOV	AX,PORTBASE
	INC	AX
	CALL	HEXWORD
	MOV	DX,OFFSET PORTMSG2
	MOV	AH,9
	INT	21h
	;
	; Use the replacement Int 15h handler now.
	;
	MOV	AX,3515h
	INT	21h
	MOV	WORD PTR INT15DEFAULT,BX
	MOV	WORD PTR INT15DEFAULT+2,ES
	MOV	DX,OFFSET INT15HDLR
	MOV	AX,2515h
	INT	21h
	;
	; Initialize/finalize the sound chip.
	;
	MOV	SOUNDHALTED,0
L0:	MOV	AH,84h
	INT	1Ah
L1:	MOV	AH,81h
	INT	1Ah
	JC	L1
	CMP	SOUNDHALTED,0
	JE	L0
	;
	; Restore Int 15h vector to default.
	;
	PUSH	DS
	MOV	AX,2515h
	MOV	DX,WORD PTR INT15DEFAULT
	MOV	DS,WORD PTR INT15DEFAULT+2
	INT	21h
	POP	DS
	;
	; Set DAC for direct write (byte-by-byte, without DMA).
	;
	MOV	DX,PORTBASE
	CLI
	IN	AL,DX		; set base port (DAC Control Register)
	JMP	$+2
	AND	AL,0E3h
	OR	AL,3
	OUT	DX,AL
	JMP	$+2
	INC	DX		; set volume at (base+2), (base+3)
	INC	DX
	MOV	AL,0
	OUT	DX,AL
	JMP	$+2
	INC	DX
	MOV	AL,0E0h
	OUT	DX,AL
	JMP	$+2
	STI
	;
	; Terminate.
	;
TERMINATE:
	MOV	AX,4C00h
	INT	21h
