	IDEAL
	JUMPS
	SMART
	EMUL
	P386                    ; Use 386 instructions

	MODEL   medium

MAXY    EQU     599
MINCOLOR EQU    3

	EXTRN   _bytesPerLine:word,_bankAdjust:word,_oldBank:word
	EXTRN   _BankFunc:dword

	EXTRN   _logamp:word
	EXTRN   _log_scale:dword,_amp_scale:dword,_log_base:word
	EXTRN   _diff_mode:word
	EXTRN   _Points:word,_BitReversed:word

	PUBLIC  _df,_tf,_repcount

	DATASEG
_df             dw      0
_tf             dw      0
_repcount       dw      1

;
; Now that we have the frequency domain data, we can update the screen
;

	CODESEG

PROC    C DisplayData
	PUBLIC  DisplayData
	ARG     data:word,olddata:word,x:word,y:word
	LOCAL   bri:word,temp:dword,oldval:word,PageNum:word
	USES    si,di

	; Compute pixel position for first point
	mov     ax,[y]
	mul     [_bytesPerLine]
	add     ax,[x]
	adc     dx,0
	push    ax

	mov     ax,[_bankAdjust]
	mul     dx
	mov     [PageNum],ax    ; Store this value for later
	mov     dx,ax
	mov     bx,0            ; Set the bank
	call    [_BankFunc]

	pop     di              ; Hold pixel position in DI

	mov     si,[olddata]    ; SI points to old data array for diff mode
	mov     [oldval],0

	mov     ax,0A000h       ; ES points to display memory
	mov     es,ax

	;  Get pointer to Bit-reversed indexing pointers
	mov     bx,[_BitReversed]
	mov     [bri],bx

	; Perform loop Point/2 times
	mov     cx,[_Points]
	shr     cx,1

next_bin:
	push    cx                      ; Save our loop count
	mov     bx,[bri]                ; Get bit-reversed index value
	mov     bx,[bx]
	add     bx,bx                   ; Double it to deal with integers

	add     bx,[data]
	movsx   eax,[word ptr bx]       ; Get and square real part
	imul    eax,eax
	movsx   edx,[word ptr bx+2]     ; Get and square imag part
	imul    edx,edx

	add     eax,edx                 ; Sum the result

	; Compute the amplitude (linear or logarithmic)

	cmp     [_logamp],0             ; Check if scale is linear
	je      short linear_scale      ;   or logarithmic

	;
	; This code computes the logarithm of the amplitude (in EDX and temp).
	; The result is placed in AX.
	;
log_scale:
        cmp     eax,0
	jne     short amp_ok            ; Watch for 0
	mov     eax,1
amp_ok:
	mov     [dword ptr temp],eax    ; Put amp^2 in a place we can load from
	fld     [dword ptr _log_scale]  ; Load scale factor (float)
	fild    [dword ptr temp]        ; Load amplitude squared (long)
	fyl2x                           ; Compute (log base 2) * y_scale

	fistp   [dword ptr temp]        ; Get result (long)
	fwait
	mov     ax,[word ptr temp]
        sub     ax,[_log_base]          ; Subtract log base value (float)

	jmp     short have_val

	;
	;  This code computes the square root of the amplitude (in temp).
	;  The result is in AX.
	;
linear_scale:
	mov     [temp],eax             ; Put amp^2 in a place we can load from
	fild    [dword ptr temp]       ; Load long amp^2
	fsqrt
	fmul    [dword ptr _amp_scale] ; Scale the resulting value
	fistp   [dword ptr temp]       ; Integer extract
	fwait                          ; Wait for the floating point to finish
	mov     ax,[word ptr temp]     ; Get result in ax

have_val:
	cmp     [_diff_mode],0         ; Normal mode
	je      short dopixel
mode1:
	mov     bx,[si]                 ; Compute amplitude difference
	add     bx,128                  ; Half-palette bias
	sub     bx,ax
	jnc     short non_neg           ; Watch for negative values here
	xor     bx,bx
non_neg:
	mov     dx,[oldval]             ; Save data to olddata array
	mov     [si],dx                 ; (oldval gives a one-pixel shift)
	add     si,2                    ; Step through the array
	mov     [oldval],ax             ; Store current value for the next line
	mov     ax,bx
dopixel:
	cmp     ax,MINCOLOR
	jge     short isok1
	mov     ax,MINCOLOR             ; Get rid of any too-small value
isok1:
	cmp     ax,255                  ; Saturate at 255
	jle     short isok2
	mov     ax,255
isok2:
	mov     cx,[_repcount]          ; Times to repeat this pixel
pix_loop:
	mov     [es:di],al

	sub     di,[_bytesPerLine]
	jnc     short nc2               ; Change bank if necessary

	push    ax
	mov     ax,[_bankAdjust]
	sub     [PageNum],ax
	mov     dx,[PageNum]
	mov     bx,0                    ; Set the bank
	call    [_BankFunc]
	pop     ax
nc2:
	loop    pix_loop

	add     [bri],2                 ; Increment bit-reversed index pointer

	pop     cx                      ; Restore outer loop count
	loop    next_bin                ; Repeat CX times

	mov     [_oldBank],0ffh         ; Invalidate the bank number
	ret

ENDP    DisplayData

PROC    C DrawBar
	PUBLIC  DrawBar
	ARG     x:word,y:word,PageNum:word
	USES    si,di

	; Compute pixel position for first point
	mov     ax,[y]
	mul     [_bytesPerLine]
	add     ax,[x]
	adc     dx,0
	push    ax

	mov     ax,[_bankAdjust]
	mul     dx
	mov     [PageNum],ax    ; Save this value for later
	mov     dx,ax
	mov     bx,0            ; Set the bank
	call    [_BankFunc]

	pop     di              ; Hold pixel position in DI

	mov     si,[_df]        ; Get precomputed value

	mov     ax,[_Points]    ; Calculate the number of pixels
	shr     ax,1
	mul     [_repcount]
	mov     cx,ax
bar_loop:
	add     si,[_df]        ; Step counter up
	cmp     si,[_tf]        ; Check if we reached the target
	jl      short bar_color
	sub     si,[_tf]        ; Reset to count to the next tick
	mov     [byte ptr es:di],1  ; Fill in tick mark color
	jmp     short cont
bar_color:
	mov     [byte ptr es:di],2  ; Fill in bar color
cont:
	sub     di,[_bytesPerLine]
	jnc     short nc4       ; Change bank if necessary

	mov     ax,[_bankAdjust]
	sub     [PageNum],ax
	mov     dx,[PageNum]
	mov     bx,0            ; Set bank number
	call    [_BankFunc]
nc4:
	loop    bar_loop

	; Fill top in with three black pixels to erase tick marks
	mov     cx,3
erase_tick:
	mov     [byte ptr es:di],0      ; Fill in black

	sub     di,[_bytesPerLine]
	jnc     short nc5               ; Change bank if necessary

	mov     ax,[_bankAdjust]
	sub     [PageNum],ax
	mov     dx,[PageNum]
	mov     bx,0                    ; Set the bank number
	call    [_BankFunc]
nc5:
	loop    erase_tick

	mov     [_oldBank],0ffh         ; Invalidate the bank number
	ret

ENDP    DrawBar

	END
