
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1993
//------------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <mem.h>
#define inb inportb
void buildcode ( unsigned short );

//OPCODES FOUND FROM DEBUG:
//E461          IN      AL,61
//24FC          AND     AL,FC
//88C4          MOV     AH,AL
//80CC02        OR      AH,02
//C3            RET
//CB            RETF
//BA6100        MOV     DX,0061
//B502          MOV     CH,02
//B100          MOV     CL,00
//8AC5          MOV     AL,CH
//EE            OUT     DX,AL
//8AC1          MOV     AL,CL
//90            NOP

unsigned char opstart[] = {0xBA,0x61,0x00,0xB5,0x02,0xB1,0x00};
unsigned char ophigh[] = {0x8A,0xC5,0xEE};
unsigned char oplow[] = {0x8A,0xC1,0xEE};
unsigned char opend[] = {0xCB};

typedef (*fun) ( void );
fun playfuncs[256];

unsigned short ra;
unsigned short rb;
unsigned long la;
unsigned short bps;
FILE *fp;
unsigned char *data;
//------------------------------------------------------------------------------
void main ( int argc, char *argv[] )
{
    opstart[6]=inb(0x61)&0xFC;
    opstart[4]=opstart[6]|2;
    if(argc==1)
    {
        printf("ss filename [bps]\n");
        exit(1);
    }
    bps=50;
    if(argc>2)
    {
        bps=atoi(argv[2]);
    }
    if((fp=fopen(argv[1],"rb"))==NULL)
    {
        printf("Error opening file [%s]\n",argv[1]);
        exit(1);
    }
    fseek(fp,0,2);
    la=ftell(fp);
    fseek(fp,0,0);
    if(la>65000) la=65000;
    if((data=malloc(la))==NULL)
    {
        printf("Out of memory\n");
        exit(1);
    }
    fread(data,1,la,fp);
    fclose(fp);
    buildcode(bps);
    for(rb=0;rb<la;rb++)
    {
        playfuncs[data[rb]]();
    }
}
//------------------------------------------------------------------------------
void buildcode ( unsigned short n )
{
    unsigned char *p;
    unsigned short value, sum, i;
    unsigned short opstartlen, ophighlen, oplowlen, opendlen;
    unsigned long size;

    opstartlen=sizeof(opstart);
    ophighlen=sizeof(ophigh);
    oplowlen=sizeof(oplow);
    opendlen=sizeof(opendlen);

    size=opstartlen+opendlen;
    if(size>65535)
    {
        printf("Error opcodes too long\n");
        exit(1);
    }
    if(ophighlen>oplowlen) size+=n*ophighlen; else size+=n*oplowlen;

    for(value=0;value<256;value++)
    {
        p=calloc(1,size);
        if(p==NULL)
        {
            printf("Out of memory\n");
            exit(1);
        }
        playfuncs[value]=(fun)p;
        memcpy(p,opstart,opstartlen); p+=opstartlen;
        sum=0;
        for(i=0;i<bps;++i)
        {
            sum+=value;
            if(sum>=256)
            {
                sum-=255;
                memcpy(p,ophigh,ophighlen); p+=ophighlen;
            }
            else
            {
                if(i)
                {
                    memcpy(p,oplow,oplowlen); p+=oplowlen;
                }
            }
        }
        memcpy(p,opend,opendlen);
    }
}
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1993
//------------------------------------------------------------------------------

