;****************************************************************
;*                                                              *
;*      FONT. (C) 1997 RonSoft.                                 *
;*                                                              *
;*      A little utility(joke) that lets You change the         *
;*      appearance of the fonts in a DOS window. You have       *
;*      three options. Turn them upside down,mirror them or     *
;*      both.                                                   *
;*      It changes the font table from ASCII 32-153 to get      *
;*      the swedish stuff included.                             *
;*                                                              *
;*      Usage:                                                  *
;*      Font <a/m/r/u>.                                         *
;*      A=both mirror(M) and upside down(U).                    *
;*      R=reset.                                                *
;*                                                              *
;*      Ronald Nordberg                                         *
;*      Silvervgen 3                                           *
;*      907 50 Ume                                             *
;*      Sweden                                                  *
;*      christine.martinson@swipnet.se                          *
;*      http://home2.swipnet.se/~w-20064                        *
;*                                                              *
;*      THIS IS ALL PUBLIC DOMAIN FREEWARE                      *
;*      LET E'M KNOW IF YOU USE MY CODE                         *
;*                                                              *
;****************************************************************


bel     equ     7
cr      equ     13
lf      equ     10

;ascii 32=SPACE 48=0 65=A 97=a 122=z 132= 134= 142= 143= 148= 153= 

[bits 16]
[org 0x100]

start:
	mov     ax,cs                   ;get code segment
	mov     ds,ax                   ;uset it as data
	mov     [comseg],ds             ;save it

	cmp     byte [080h],1           ;anything on command line ?
	jle     useit                   ;noo, let us know
	mov     al,byte [082h]          ;skip the blank
	and     al,0dfh                 ;force upper case
	jmp     doit                    ;do the stuff
useit:
	mov     dx,usage                ; address of string for output
	mov     ah,9                    ; function 09h - output string
	int     21h                     ; DOS service call
	jmp     quit
doit:
	push    ax                      ;save command line
	mov     ah,0Fh                  ;function 0Fh - get video mode
	int     10h                     ;BIOS video service call
	mov     [vmode],al              ;save original video mode
	
	mov     ah,11h                  ;get font information
	mov     al,30h                  ;subfunction 30h
	mov     bh,06h                  ;ROM 8x16 font table address
	int     10h                     ;call BIOS
	mov     [bytes],cx              ;ret CX=bytes/char
	mov     [rows],dl               ;DL=screen rows
					;ES:BP=seg:off font table
	mov     di,bp                   ;get offset font table
	mov     cx,[bytes]              ;font size
foff:   add     di,32                   ;bytes*32
	loop    foff
	mov     si,myfont               ;dest, our character buffer

	pop     ax                      ;get command line
	cmp     al,'A'
	je      all
	cmp     al,'R'                  ;wanna restore fonts ?
	je      exit                    ;yeahh
	cmp     al,'U'                  ;wanna make it upside down
	je      ud
	cmp     al,'M'                  ;wanna mirror it
	je      mi
	mov     dx,usage                ;wrong command line parameters
	mov     ah,9                    ;let us know, output string
	int     21h                     ;DOS service call
	jmp     quit
all:
	call    updown                  ;updown now in myfont
	mov     ax,cs
	mov     es,ax
	mov     si,temp
	mov     di,myfont
	mov     cx,121
mlop:   push    cx
	call    mirror
	pop     cx
	loop    mlop
	mov     si,temp
	mov     di,myfont
	mov     cx,1936
	repe    movsb
	jmp     program

ud:
	call    updown                  ;make chars upside down
	jmp     program                 ;reprogram BIOS
mi:
	mov     cx,121                  ;mirrror chars
mloop:  push    cx                      ;save counter
	call    mirror                  ;mirror one char
	pop     cx                      ;get counter
	loop    mloop                   ;next char

;*******************************************************************
;*      This reprograms BIOS with our modified chars
;*******************************************************************
program:
	xor     bl,bl                   ;Block Number=0
	mov     bh,[bytes]              ;height of character cell
	mov     cx,121                  ;number of character changed = 121
	mov     dx,32                   ;offset for character "SPACE"
	mov     ax,ds                   ;address of DATA segment
	mov     es,ax                   ;ES points to DATA segment
	mov     ax,1100h                ;Subfunction 11
	mov     bp,myfont               ;ES:BP address of user font table
	int     10h                     ;BIOS video service call
	jmp     quit                    ;don't change mode
exit:
	mov     al,[vmode]              ;AL - original video mode
	xor     ah,ah                   ;function 00h - set video mode
	int     10h                     ;BIOS video service call
quit:
	mov     ax,4C00h                ;Return Code =0
	int     21h                     ;DOS service call

;*********************************************************************
;*      Turn characters upside down
;*********************************************************************
updown:
	mov     cx,121                  ;convert 121 chars
char:   push    cx                      ;save char count
	mov     cx,[bytes]              ;bytes/char
	mov     bx,[bytes]              ;offset destination
        sub     bx,1                    ;adjust dest offset
byt:
	mov     byte dl,[es:di]         ;get orig byte
	mov     byte [ds:si+bx],dl      ;copy char
	sub     bx,1                    ;decrease offset
	inc     di                      ;next source byte
	loop    byt                     ;next character
	add     si,[bytes]              ;next dest char
	pop     cx                      ;restore char count
	loop    char                    ;next char
	ret

;*********************************************************************
;*      Mirror characters
;*********************************************************************
mirror:
	mov     cx,[bytes]              ;bytes to mirror
mirr:   push    cx                      ;save byte count
	mov     dx,0x00ff               ;set all bits in destination
	mov     bx,0                    ;first bit to process
	mov     cx,7                    ;start test bit in source
cflop:  xor     ax,ax                   ;needed ?
	mov     al,byte [es:di]         ;get byte to test
	bt      ax,cx                   ;bit test 
	jc      cnzero                  ;bit was set
	btc     dx,bx                   ;clear bit
	jmp     cclop                   ;next bit
cnzero: bts     dx,bx                   ;set bit
cclop:  inc     bx                      ;next bit to set/clear
	loop    cflop                   ;next bit in byte
	and     dl,01111111B            ;mask out high bit
	mov     byte [ds:si],dl         ;copy byte to destination
	inc     byte si                 ;next row in char
	inc     byte di                 ;next pos in buffer
	pop     cx                      ;restore char counter
	loop    mirr                    ;do next char
	ret

;*************************** DATA stuff *****************************

comseg  dw      0
bytes   dw      0
rows    db      0
vmode   db      0

usage   db      'Font (C) 1997 RonSoft.',cr,lf
	db      'Usage: Font <u/m>',cr,lf
	db      'A = both',cr,lf
	db      'U = upside down',cr,lf
	db      'M = mirror',cr,lf
	db      'R = reset',cr,lf,"$"

myfont          times 1936 db 0                 ;121x16
temp            times 1936 db 0

	END
