;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; DIMWIT - a Windows aware screen blanker
; 
; Copyright (C) 1992-1994 Larry Board.
; 
; This program is free software. Permission is granted to anyone to use,
; modify, or redistribute this software for any purpose, subject to the
; following restrictions:
;
;    1.  This program, including altered versions, may not be sold for
;        profit, except for nominal distribution or copying fees.  All or
;        parts of this software may, however, be included as part of another
;        applications which is sold for profit.
;        
;    2.  The author is not responsible for any consequences of use of
;        this software, even if they arise from flaws in it.
;
;    3.  The origin of this software must not be misrepresented, either
;        by explicit claim or by omission.  Credits must appear in the
;        documentation.
;
;    4.  Altered versions must be plainly marked as such, and must not
;        be misrepresented as being the original software.  Credits must
;        appear in the documentation.
;
; 
; This program is distributed "as is", without warranty of any kind,
; either expressed or implied, including, but not limited to, the
; implied warranties of merchantability and fitness for a particular
; purpose. 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 

CSEG	segment para public 'CODE'
	assume	cs:CSEG,ds:CSEG

;---------------------------------------
DFLTCNT		equ	1092*10		; default 10 min timeout
CR		equ	0dh		; carriage return
SIGLEN		equ	6		; length of signature string
CTRLALT		equ	0ch		; CTRL-ALT shift status
HC		equ	0E0h		; hidden scancode
CRTC_ENABLE	equ	08h		; video enable bit
BIOS_DATA_SEG	equ	40h		; base segment address of rombios data
CRTC_ADDR	equ	63h		; 6845 CRTC base address found here
;---------------------------------------
; flag byte definitions

VIDON		equ	01h		; video display is on
DISABLE		equ	02h		; TSR is disabled
WINACT		equ	04h		; Windows is active
INSTALLED	equ	80h		; TSR is installed

;---------------------------------------
; macro definitions

prnstr	MACRO	strptr			; print a string
	mov	dx,offset strptr	; offset address of message string
	mov	ax,0900h		; DOS function 9
	int	21h
	ENDM

;---------------------------------------
	org	100H
dimwit	proc	far
	push	cs
	pop	ds			; ds = cs
	jmp	start			; jump around resident portion

; keyboard trap routine

key_in	proc	far
	push	ax
	push	bx
	pushf

	cmp	ah,4fh			; keyboard intercept?
	jnz	keyx			; no, exit now
	test	cs:flags,DISABLE	; are we disabled?
	jnz	keyx			; yes, exit now
	cmp	al,HC			; hidden scan code?
	jz	keyx			; yes, exit now
	mov	bx,ax			; else save scancode
	mov	ah,2			; go get shift status
	int	16h
	and	al,CTRLALT		; only look at CRTL & ALT keys
	mov	cs:shftstate,al		; save for later
	jnz	key2			; no unblanking if either is set
	push	bx			; save scancode on stack

	test	cs:flags,VIDON		; is the video on
	jnz	key1			; yes - don't turn it on

	; turn on the video

	or	cs:flags,VIDON		; indicate video is ON
	call	cs:[v_on]		; turn the video on
key1:	mov	ax,cs:maxcnt		; set counter to max
	mov	cs:count,ax
	pop	bx			; restore the scancode

key2:	cmp	bl,cs:hotkey		; is this the hotkey?
	jnz	keyx			; no, continue
	cmp	cs:shftstate,CTRLALT	; are we in the proper shift state?
	jnz	keyx			; no, continue
	mov	cs:count,0		; else blank screen
	and	cs:flags,NOT VIDON	; indicate video is off
	call	cs:[v_off]		; turn the video off

	popf
	clc				; clear carry so key isn't processed
	jmp	short keyxx

keyx:	popf
keyxx:	pop	bx
	pop	ax

	jmp dword ptr cs:kb_int		; continue to interrupt handler
key_in endp

; timer tick trap - 18.2 ticks/sec

ticker	proc	far
	test	cs:flags,DISABLE	; are we disabled?
	jnz	tx			; yes, just exit
	test	cs:flags,VIDON		; is the video off
	jz	tx			; no blanking if so
	cmp	cs:count,0		; is the count 0?
	je	tx			; no blanking if so
	dec	cs:count		; decrement countdown
	jnz	tx			; exit if not time to blank video

	; turn the video off

	pushf
	push	ax
	push	bx
	call	cs:[v_off]		; turn the video off
	and	cs:flags,NOT VIDON	; indicate that video is off
t5:	pop	bx
	pop	ax
	popf

tx:	jmp dword ptr cs:tck_int	; continue to interrupt handler
ticker endp

; video output trap

video	proc	far
	test	cs:flags,DISABLE	; are we disabled?
	jnz	v2			; yes, just exit
	pushf
	push	ax
	push	bx
	cmp	ah,12h			; ignore function 12h since 
	je	v1			; this routine uses it
	test	cs:flags,VIDON		; is the video on	  
	jnz	v0			; yes - skip video turn on
	call	cs:[v_on]		; turn the video on

	; reset counter to max

v0:	mov	ax,cs:maxcnt		; restart countdown
	mov	cs:count,ax
	or	cs:flags,VIDON		; indicate video is ON
v1:	pop	bx
	pop	ax
	popf

v2:	jmp dword ptr cs:vid_int	; continue to real interrupt

video	endp

; INT 2FH trap

int2f	proc	far
	pushf
	cmp	ax,1605h		; Windows init brodcast?
	jne	int2f2			; jump if not
	or	cs:flags,DISABLE	; else disable TSR
	popf
	jmp dword ptr cs:mpx_int	; pass the interrupt on

int2f2:	cmp	ax,1606h		; Windows exit broadcast?
	jne	int2f3			; continue if not
	and	cs:flags,NOT DISABLE	; else re-enable TSR
	popf
	jmp dword ptr cs:mpx_int	; pass the interrupt on

int2f3:	cmp	ah,cs:ProgID		; check requested ID is ours
	je	int2f4			; continue if so
	popf				; else
	jmp dword ptr cs:mpx_int	; pass the interrupt on

int2f4:	popf
	or	al,al			; check function code
	jz	int2f9			; this is an install check
	cmp	al,1
	jz	int2f8			; return user data pointer
	iret

int2f8:	mov	di,offset maxcnt	; ES:DI points to data area
	push	cs
	pop	es
	iret
int2f9:	mov	al,0FFh			; indicate installed
	push	cs
	pop	es			; ES points to signature segment
	mov	di,cs:idstr		; DI points to signature offset
int2fx:	iret

int2f	endp

; enable the screen (EGA/VGA)
ega_on	proc	near
	mov	ax,1200h
	mov	bl,36h
	int	10h
	ret
ega_on	endp

; disable the screen (EGA/VGA)
ega_off	proc	near
	mov	ax,1201h
	mov	bl,36h
	int	10h
	ret
ega_off	endp

; enable the screen (non EGA/VGA)
vid_on	proc	near
	push	dx
	mov	dx,cs:crtc_port		; get port address
	in	al,dx
	or	al,CRTC_ENABLE
	out	dx,al
	pop	dx
	ret
vid_on	endp

; disable the screen (non EGA/VGA)
vid_off	proc	near
	push	dx
	mov	dx,cs:crtc_port		; get port address
	in	al,dx
	and	al,NOT CRTC_ENABLE
	out	dx,al
	pop	dx
	ret
vid_off	endp


; TSR variables

crtc_port	dw	0		; 6845 crtc address
v_on		dw	offset ega_on	; video on function pointer
v_off		dw	offset ega_off	; video off function pointer
tck_int		dd	0		; original timer interrupt
kb_int		dd	0		; original keyboard interrupt
vid_int		dd	0		; original video interrupt
mpx_int		dd	0		; original INT 2FH interrupt
count		dw	0		; current time count 'til blanking
ProgID		db	0		; Multiplex ID
dosid		db	"DIMDOS"	; DOS signature string
winid		db	"DIMWIN"	; Windows signature string
idstr		dw	0		; ID string pointer
shftstate	db	0		; current shift state
flags		dw	VIDON		; general purpose flags
maxcnt		dw	0ffffh		; maximum count 'til blanking
hotkey		db	0		; hotkey for instant blanking
; end of resident portion
;--------------------------------------------------------------

; installation starts here

start:	push	cs			; set DS to code segment
	pop	ds

	mov	cs:idstr,offset dosid

	; test for Windows Enhanced mode

	mov	ax,1600h		; setup interrupt call
	int	2Fh
	or	al,al			; if zero
	jz	start1			; then test for standard Mode
	cmp	al,80h			; if 80h
	jz	start1			; then test for standard Mode
	mov	cs:idstr,offset winid
	jmp	short start2

	; test for Windows Standard mode

start1:	mov	ax,4680h		; setup interrupt call
	int	2fh
	or	ax,ax
	jnz	start2			; not standard mode
	mov	cs:idstr,offset winid

start2:	mov	si,cs:idstr		; offset of ID string
	call	CheckInstall		; check if currently installed
	jnc	start3			; if not, get an unused ID
	or	cs:flags,INSTALLED	; else indicate installed
	jmp	short start4		; and use current ID

	; get next available ID

start3:	call	GetMpxID		; get an unused ID, returned in AH
	jnc	start4			; all ok
	prnstr	ec3			; error - no IDs available
	mov	al,2			; terminate program w/ error 3
	jmp	DimXit			; and exit

start4:	mov	ProgID,ah		; store the ID

	prnstr	signon			; print signon

	; check command line for parameters

	mov	ah,62h		; get PSP segment address in BX
	int	21h
	mov	es,bx
	mov	di,80h		; offset to command tail
	mov	cl,es:[di]	; get command tail length
	cmp	cl,0		; any more characters?
	jz	instal		; no more parameters
	inc	di		; point to 1st char

start5:	inc	cs:argc
	call	SkipWhite	; skip past white space
	cmp	al,CR		; end of command line?
	jz	instal		; yes, start install
	call	CheckHot	; check for hotkey parameter
	jnc	start6		; not defined, check timeout parameter
	mov	al,es:[di]	; update current char
	cmp	al,CR		; end of command line?
	jz	instal		; yes, start install
	call	NextWhite	; position to next whitespace char
	cmp	al,CR		; end of command line?
	jz	instal		; yes, start install
	jmp	short start5	; restart loop

	; check for timeout parameter

start6:	call	CheckTO		; check for timeout parameter
	mov	al,es:[di]	; update current char
	cmp	al,CR		; end of command line?
	jz	instal		; yes, start install
	call	NextWhite
	cmp	al,CR		; end of command line?
	jz	instal		; yes, start install
	jmp	short start5	; restart loop



instal: test	cs:flags,INSTALLED	; is the TSR installed?
	jnz	inst00			; yes, just update parameters
	jmp	inst10			; else go do install

	; updating parameters

inst00:	mov	ah,ProgID		; else get user parameters
	mov	al,1
	int	2fh
	mov	ax,cs:maxcnt		; see if a count was specified
	cmp	ax,0ffffh		; ffffh means no
	jz	inst0			; skip save if not
	mov	es:[di],ax		; else save new value
inst0:	mov	ax,es:[di]		; recall current value for status
	mov	cs:maxcnt,ax
inst1:	add	di,2
	mov	al,cs:hotkey		; see if hotkey was specified
	or	al,al			; zero means no
	jz	inst2			; skip save if not
	mov	es:[di],al		; else save new value
inst2:	mov	al,es:[di]		; recall current value for status
	mov	cs:hotkey,al

	; print out the current status

	prnstr	hkmsg			; print hotkey =
	mov	al,cs:hotkey		; get hotkey value
	call	htoa			; convert to ascii
	mov	bx,0			; init index
	mov	buff[bx],ah		; store hi nibble
	inc	bx
	mov	buff[bx],al		; store low nibble
	inc	bx
	mov	al,'H'			; append 'H'
	mov	buff[bx],al
	inc	bx
	mov	ax,0d0ah		; CR-LF
	mov	buff[bx],ah
	inc	bx
	mov	buff[bx],al
	inc	bx
	mov	al,'$'			; terminate the string
	mov	buff[bx],al
	prnstr	buff			; and print the value
	prnstr	tomsg			; print timeout =
	mov	ax,cs:maxcnt		; get the count in ticks
	mov	cx,0
inst4:	cmp	ax,1092			; convert to minutes
	jc	inst5
	sub	ax,1092
	inc	cx
	jmp	short inst4

inst5:	mov	ax,cx			; move count to ax
	mov	di,offset buff		; point to string storage
	push	cs
	pop	es
	call	itoa			; convert to ascii
	mov	al,'$'			; append to '$' to ascii string
	mov	es:[di],ax
	prnstr	buff			; print the value
	prnstr	tomsg1			; add "Min"

	mov	al,1			; load return status
	jmp	DimXit			; and exit

; install TSR
;
; Using INT 21H FUNCTION 35H (get vector) and FUNCTION 25H (set vector)
; hook the TSR into the keyboard, timer, and video interrupts.
;
; Also hook into INT 2FH (multiplex) to detect the Windows broadcast messages
; and installation status for this TSR

inst10:	cmp	cs:maxcnt,0ffffh	; 0ffffh means no count specified
	jnz	inst11
	mov	cs:maxcnt,DFLTCNT	; using default value
	mov	cs:count,DFLTCNT
inst11:	cmp	cs:hotkey,0		; 0 means no hotkey specified
	jnz	inst12
	mov	cs:hotkey,36h		; using default value

inst12:	mov	ax,3515H		; get current keyboard interrupt
	int	21H
	mov	word ptr kb_int,bx	; save for chain
	mov	word ptr kb_int+2,es
	mov	dx,offset key_in	; hook in TSR keyboard trap
	mov	ax,2515H
	int	21H

	mov	ax,3508H		; get current timer interrupt
	int	21H
	mov	word ptr tck_int,bx	; save for chain
	mov	word ptr tck_int+2,es
	mov	dx,offset ticker	; hook in TSR timer trap
	mov	ax,2508H
	int	21H

	mov	ax,3510H		; get current video interrupt
	int	21H
	mov	word ptr vid_int,bx	; save for chain
	mov	word ptr vid_int+2,es
	mov	dx,offset video 	; hook in TSR video trap
	mov	ax,2510H
	int	21H

	mov	ax,352FH		; get current INT2F interrupt
	int	21H
	mov	word ptr mpx_int,bx	; save for chain
	mov	word ptr mpx_int+2,es
	mov	dx,offset int2f 	; hook in TSR INT2F trap
	mov	ax,252FH
	int	21H

	; test video type
	; EGA/VGA uses bios routines for screen disable.
	; all others require programming the 6845 crt controller.

	mov ax, 1200h			; bios function to turn on screen
	mov bl, 36h
	int 10h
	cmp al, 12h			; 12h indicates function supported
	jz	inst13			; EGA/VGA installed

	; non EGA/VGA system installed

	mov	v_on,offset vid_on	; else install non EGA routine
	mov	v_off,offset vid_off
	mov	ax,BIOS_DATA_SEG	; bios data segment
	mov	es,ax
	mov	bx,CRTC_ADDR		; CRTC controller address location
	mov	ax,es:[bx]		; get address (3B4 or 3D4)
	add	al,4			; want mode control port at 3X8
	mov	cs:crtc_port,ax

	; release the environment block

inst13: push	cs			; get current segment
	pop	es
	mov	es,es:[2ch]		; get environment block segment
	mov	ah,49h			; release environment block
	int	21h

	prnstr	success			; installed message

	; terminate and stay resident

	mov	ax,3100h
	mov	dx,offset start		; # of resident bytes
	mov	cl,4			; convert to # of pages
	shr	dx,cl
	inc	dx
	int	21h
dimwit	endp

; exit with error code
;
; exit code s/b in al
;
; 1 - TSR is already installed, parameters updated
; 2 - No MPX IDs available

DimXit:	mov	ah,4Ch		; terminate program w/ error code
	int	21h


; ---- S U B R O U T I N E S ----

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; CheckInstall - check for installed TSR ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Call with:	DS -> Data segment of TSR signature
;		SI -> Offset of TSR signature
;
; Returns:	Carry set   - Program is installed (AH = ID code)
;		Carry reset - Program is not installed
;
; Notes:	If carry returns reset, the caller should call
;		GetMpxID to obtain an unused multiplex ID.
;
;		The INT2F handler for the TSR being checked should return
;		with AL = FFh and ES:DI pointing to its signature.

CheckInstall	proc	near
		cld			; direction is forward
		mov	ax,0C000h	; start at ID = C0h
		mov	cx,40h		; end at ID = FFh

Check1:		push	ax		; save AX, CX, and SI
		push	cx
		push	si
		xor	di,di		; zero ES and DI
		mov	es,di
		int	2Fh		; MPX interrupt
		cmp	al,0FFh		; installed?
		jne	Check2		; no, try next ID

		mov	cx,SIGLEN	; size of signature
		repe	cmpsb
		jne	Check2		; branch if no compare
		pop	si		; restore stack and exit
		pop	cx
		pop	ax
		stc			; indicate installed
		ret

Check2:		pop	si		; restore stack
		pop	cx
		pop	ax
		inc	ah		; next ID
		loop	Check1		; loop 'til done
		clc			; indicate not installed
		ret

CheckInstall	endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; GetMpxID - get an unused multiplex ID ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Returns:	Carry set   - No multiplex IDs available
;		Carry reset - Multiplex ID in AH

GetMpxID	proc	near
		mov	ax,0C000h	; start at ID = C0h
		mov	cx,40h		; end at ID = FFh

GMID1:		push	ax		; save ID and count
		push	cx
		int	2Fh		; Multiplex interrupt
		or	al,al		; force flag status valid
		jz	GMID2		; found an unused ID
		pop	cx		; restore ID and count
		pop	ax
		inc	ah
		loop	GMID1		; try next ID
		stc			; no IDs available
		ret

; an unused ID was found

GMID2:		pop	cx		; clear stack
		pop	ax
		clc			; indicate success
		ret

GetMpxID	endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; SkipWhite - skip past space characters ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Call with:	 es:di -> string
;
; Returns:	es:di -> non space char
;		al contains char

SkipWhite	proc	near
	mov	al,es:[di]
	cmp	al,' '			; is it a space?
	jne	skipx			; exit if not
	inc	di
	jmp	short SkipWhite		; next character
skipx:	ret
SkipWhite	endp

NextWhite	proc	near
	mov	al,es:[di]		; get next char
	cmp	al,' '			; space:
	je	nextx			; yes, exit
	cmp	al,CR			; end of command line?
	je	nextx			; yes, exit
	inc	di
	jmp	short NextWhite
nextx:	ret
NextWhite	endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; CheckHot - check for hotkey definition ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Call with:	AL =  first char of parameter
;		DI -> first char of parameter
;
; Returns:	Carry set   - this was a hotkey definition
;		Carry reset - this was not a hotkey definition
;
; Notes:	If a valid hotkey was defined, the hotkey code will
;		be stored.

CheckHot	proc	near
		cmp	al,'H'
		jz	Hot0		; this is a hotkey definition
		cmp	al,'h'
		jnz	hotnot		; not a hotkey definition

Hot0:		push	bx		; save used registers
		push	cx
		xor	cx,cx		; initialize char count

Hot1:		inc	di		; point to next
		mov	al,es:[di]	; get char
		cmp	al,CR		; end of parameters?
		jz	hotx		; yes, exit
		cmp	al,' '		; space?
		jz	hotx		; yes, exit
		sub	al,'0'		; check for legal hex values
		jl	hotbad		; less than 0 is not legal
		cmp	al,9
		jle	Hot2		; good hex value
		add	al,'0'		; restore original
		and	al,0dfh		; to uppercase
		cmp	al,'A'
		jl	hotbad		; less than A is illegal
		cmp	al,'F'
		jg	hotbad		; greater than F is illegal
		sub	al,'A'-10	; convert to number

Hot2:		inc	cx		; increment count of good digits
		cmp	cx,1		; 1st digit?
		jnz	Hot3		; no
		mov	bl,al		; save 1st digit in bl
		jmp	short Hot1	; next char

Hot3:		cmp	cx,2		; should be 2nd char
		jnz	hotbad		; error if not
		mov	dx,cx		; save digit count
		mov	cl,4
		shl	bl,cl
		or	bl,al
		mov	cx,dx		; restore digit	count
		jmp	short Hot1	; next char

hotx:		cmp	cx,2		; did we get 2 digits?
		je	hotok		; yes, save and exit
hotbad:		call	badarg
		jmp	short hotx1	; skip hotkey save

hotok:		mov	cs:hotkey,bl	; save the hotkey
hotx1:		pop	cx
		pop	bx
		stc
		ret

hotnot:		clc
		ret
CheckHot	endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; CheckTO - check for timeout parameter ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Call with:	ES:DI -> parameter string
;		AL = 1st char of string
;
; Returns:	nothing

CheckTO	proc	near
	cmp	al,'0'		; check for valid decimal number
	jl	badval
	cmp	al,'9'
	ja	badval
	sub	al,'0'		; convert to number
	mov	bl,al		; save ones place number in bl
	mov	ah,10		; assume this is the tens place
	mul	ah		; al = 10 * al
	mov	bh,al		; save tens place number in bh
	inc	di
	mov	al,es:[di]	; get possible 2nd number
	cmp	al,CR		; is it a CR?
	je	onenum		; yes, only one number specified
	cmp	al,' '		; is it a space?
	je	onenum		; yes, only one number specified
	sub	al,'0'		; check for legal value
	jl	badval		; bad value
	cmp	al,9
	ja	badval		; bad value
	add	al,bh		; add previous tens place value to this value
	inc	di
	mov	bl,es:[di]	; get possible 3rd number
	cmp	bl,CR		; must be either CR
	jz	setit		; ok
	cmp	bl,' '		; or space
	jz	setit		; ok

badval:	call	badarg
	ret

onenum:	mov	al,bl		; get old ones place number
setit:	cmp	al,60		; test for valid timeout
	jg	badval		; value is too large
	mov	bx,182*6	; # of ticks/minute
	mul	bx
	mov	cs:maxcnt,ax	; store count
	ret
CheckTO	endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; htoa - hex to ascii conversion                           ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; This routine converts an 8 bit unsigned integer to a 2 character
; ascii hex value.  The integer is passed in the AL register.
;
; The ascii value is returned in the AX register, AH contains the
; most significant nibble and AL contains the least significant.

htoa	proc	near
	push	bx
	push	cx

	xor	ah,ah			; zero the high byte
	mov	bx,ax			; bx is working register
	mov	cl,4			; shift by 4
	shr	bl,cl			; high nibble in bl
	mov	ah,hexval[bx]		; extract to ah
	mov	bl,al			; now get low nibble
	and	bl,0fh
	mov	al,hexval[bx]		; and extract to al

	pop	cx
	pop	bx
	ret
htoa	endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; itoa - integer to ascii conversion                       ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; This routine converts a 16 bit integer to an ascii string and
; stores the result in a buffer.
; The integer is passed in the AX register.
; The string buffer address is passed in ES:DI
;
; When the routine returns, the buffer will contain the ascii string
; terminated by the '$' character.  ES:DI will be pointing to the
; termination character.  The buffer requires a minimum of 6 bytes,
; 5 for the string and 1 for the terminating character.
;
; This is a recursive routine which divides the integer by 10 using
; successive subtraction of 10 to obtain a quotient and remainder.
; The remainder is saved on the stack and the quotient is used as the
; new integer value for the next call.  Each return pops its remainder
; and stores its value as an ascii character to the buffer.

itoa	proc	near
	mov	cx,0			; initialize loop counter
itoa1:	cmp	ax,10
	jl	itoa2			; this is a valid remainder
	sub	ax,10			; keep subtracting 10
	inc	cx			; cx contains quotent
	jmp	short itoa1

itoa2:	push	ax			; save for return
	cmp	cx,0
	jz	itoa3
	mov	ax,cx			; use quotient for new seed
	call	itoa			; recursive call for next higher digit


itoa3:	pop	ax			; get previously saved remainder
	add	al,'0'			; convert to ascii
	mov	es:[di], al		; and put it in the buffer
	inc	di			; advance buffer pointer
	mov	byte ptr es:[di],'$'	; terminate in case last digit
	ret
	
itoa	endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; badarg - bad argument message print ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
badarg	proc	near
	push	ax
	push	es
	push	di

	prnstr	badmsg			; first part of message
	mov	al,cs:argc		; get arg count
	mov	di,offset buff		; point to string storage
	push	cs
	pop	es
	call	htoa			; convert to ascii
	mov	es:[di],al
	inc	di
	mov	al,'$'			; terminate string
	mov	es:[di],ax
	prnstr	buff			; print the arg value
	prnstr	badmsg1			; print 2nd part of string

	pop	di
	pop	es
	pop	ax
	ret
badarg	endp


signon	db	13,10,"Dimwit 1.3",13,10
	db	"Copyright (C) 1992-1994  Larry Board",13,10,13,10,'$'
hkmsg	db	"Status: Hotkey  = $"
tomsg	db	"        Timeout = $"
tomsg1	db	" Min.",13,10,'$'
success	db	"Dimwit is now installed",13,10,'$'
badmsg	db	"<<<<<< error in argument $ "
badmsg1	db	" >>>>>> skipping ",13,10,'$'
crlfmsg	db	13,10,'$'
ec3	db	"Dimwit: No multiplex ID's available",13,10,'$'
hexval	db	"0123456789ABCDEF"
argc	db	0
buff	db	0

CSEG	ends
	end	dimwit
