/*  Demo.c  -  A demo program using pc curses. The program illustrate
    the use of colours for text output.   */

#include <stdio.h>
#include <signal.h>
#include <time.h>
#include "curses.h"

//
//  The Australian map
//
char    *AusMap[16] =
{   
    "           A           A ",
    "    N.T. AAAAA       AAAA ",
    "     AAAAAAAAAAA  AAAAAAAA ",
    "   AAAAAAAAAAAAAAAAAAAAAAAAA Qld.",
    "AAAAAAAAAAAAAAAAAAAAAAAAAAAAA ",
    "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA ",
    " AAAAAAAAAAAAAAAAAAAAAAAAAAAA ",
    "   AAAAAAAAAAAAAAAAAAAAAAAAA N.S.W.",
    "W.A. AAAAAAAAA      AAAAAA Vic.",
    "       AAA   S.A.     AA",
    "                           A  Tas.",
    ""
};

//
//  Funny messages
//
#define NMESSAGES   6

char    *messages[] =
{   
    "Hello from the Land Down Under",
    "The Land of crocs. and a big Red Rock",
    "Where the sunflower runs along the highways",
    "the dusty red roads lead one to loneliness",
    "Blue sky in the morning and",
    "freezing nights and twinkling stars",
    ""
};

//
//  Main driver
//
main()
{
WINDOW  *win;
int     w, x, y, i, j, c, len;
time_t  t;
char    buffer[80], *message;
int     width, height;
int     save[80];
void    trap();

    initscr();
    signal(SIGINT, trap);
    width  = 48;
    height = 13;                // Create a drawing window
    win = newwin(height, width, (_LINES-height)/2, (_COLS-width)/2);
    if(win == NULL)
    {   endwin();
        return 1;
    }

    while(1)
    {   wattrset(win, F_GRAY | B_BLUE);
        werase(win);

        wattrset(win, F_RED | B_RED);
        box(win, '-', '+');
        wrefresh(win);
                                // Do ramdom output of a character
        wattrset(win, F_GRAY | B_BLUE);
        c = 'a';
        for(i=0; i < 5000; ++i)
        {   x = rand() % (width-2)  + 1;
            y = rand() % (height-2) + 1;
            mvwaddch(win, y, x, c);
            wrefresh(win);
            if(kbhit())
                break;
            if(i == 2000)
            {   c = 'b';
                wattron(win, F_CYAN | B_BROWN);
            }
        }

        SubWinTest(win);
                                // Erase and draw green window
        wattrset(win, B_GREEN | F_BROWN | A_HIGH);
        werase(win);
        wrefresh(win);
                                // Draw RED bounding box
        wattrset(win, F_RED | B_RED);
        box(win, ' ', ' ');
        wrefresh(win);
                                // Display Australia map
        wattrset(win, B_GREEN | F_BROWN | A_HIGH);
        i = 0;
        while(*AusMap[i])
        {   mvwaddstr(win, i+1, 8, AusMap[i]);
            wrefresh(win);
            delay(100);
            ++i;
        }

        wattrset(win, A_BLINK| F_BLUE | B_GRAY);
        mvwaddstr(win, height-2, 12, " PC curses for Ansi-C ");
        wrefresh(win);

                                // Draw running messages
        wattrset(win, F_BROWN | B_GRAY);
        message = messages[0];
        len = strlen(message);
        j = 0;
        i = 2;
        w = width-2;
        while(j < NMESSAGES)
        {   strncpy(buffer, message, w - i);
            buffer[w-i] = 0;
            mvwaddstr(win, height/2, i, buffer);
            if(w - i < len)
            {   memset(buffer, ' ', i);
                strcpy(buffer, message + (w - i));
                buffer[strlen(buffer)]   = ' ';
                buffer[i-2] = '\0';
                mvwaddstr(win, height/2, 2, buffer);
            }                
            wrefresh(win);
            if(kbhit()) 
            {   bioskey(0);
                break;
            }
            mvwaddch(win, height/2, i, ' ');
            i = ++i % w;
            if(i < 2)
            {   message = messages[++j%NMESSAGES];
                memset(buffer, ' ', w-2);
                buffer[w-2] = 0;
                mvwaddstr(win, height/2, 2, buffer);
                i = 2;
            }
            delay(300);
        }

        j = 0;
                                //  Draw running As across in RED
        wattron(win, B_GREEN|F_RED);
        for(i=2; i < width - 4; ++i)
        {   c = wgetatpos(win, 4, i);
            save[j++] = c;
            c = c & 0x7f;
            mvwaddch(win, 4, i, c);
        }
        wrefresh(win);

                                // Put a message up wait for a key
        i = height-2;
        wattrset(win, F_BLUE | B_GRAY);
        mvwaddstr(win, i, 12, " Type a key to continue ");
        wrefresh(win);

        if(WaitForUser() == 0x1b)
            break;

        j = 0;                  // Restore the old line 
        for(i=2; i < width - 4; ++i)
            wputatpos(win, 4, i, save[j++]);
        wrefresh(win);

        BouncingBalls(win);
                                // Put a message up wait for a key
        i = height-2;
        wattrset(win, F_BLUE | B_GRAY);
        mvwaddstr(win, i, 12, " Hit ESC key to exit ...");
        wrefresh(win);
        if(WaitForUser() == 0x1b)
            break;
    }
exit:
    endwin();
    return 0;
}

//
// Test sub windows
//
SubWinTest(WINDOW *win)
{
int     w, h, sw, sh, bx, by;
WINDOW  *swin1, *swin2, *swin3;

    w  = win->_maxx;
    h  = win->_maxy;
    bx = win->_begx;
    by = win->_begy;
    sw = w / 3;
    sh = h / 3;
    if((swin1 = subwin(win, sh, sw, by+3, bx+5)) == NULL)
        return  1;
    if((swin2 = subwin(win, sh, sw, by+4, bx+8)) == NULL)
        return  1;
    if((swin3 = subwin(win, sh, sw, by+5, bx+11)) == NULL)
        return  1;
    wattron(swin1, B_BLUE    | F_RED);
    werase(swin1);
    mvwaddstr(swin1, 0, 3, "Sub-window 1");
    wrefresh(swin1);

    wattron(swin2, B_MAGENTA | F_CYAN);
    werase(swin2);
    mvwaddstr(swin2, 0, 3, "Sub-window 2");
    wrefresh(swin2);

    wattron(swin3, B_GREEN   | F_BROWN);
    werase(swin3);
    mvwaddstr(swin3, 0, 3, "Sub-window 3");
    wrefresh(swin3);

    delwin(swin1);
    delwin(swin2);
    delwin(swin3);
    WaitForUser();
    return  0;
}

//
//  Bouncing balls
//
BouncingBalls(WINDOW *win)
{
int     c1, c2, c3, w, h;
int     x1, y1, xd1, yd1;
int     x2, y2, xd2, yd2;
int     x3, y3, xd3, yd3;

    w    = win->_maxx;
    h    = win->_maxy;
    x1   = 2 + rand() % (w - 4);
    y1   = 2 + rand() % (h - 4);
    x2   = 2 + rand() % (w - 4);
    y2   = 2 + rand() % (h - 4);
    x3   = 2 + rand() % (w - 4);
    y3   = 2 + rand() % (h - 4);
    xd1  = 1; yd1 = 1;
    xd2  = 1; yd2 = 0;
    xd3  = 0; yd3 = 1;
    while(bioskey(1) == 0)
    {   x1 = xd1 > 0 ? ++x1 : --x1;
        if(x1 <= 1 || x1 >= w - 2)
            xd1 = xd1 ? 0 : 1;
        y1 = yd1 > 0 ? ++y1 : --y1;
        if(y1 <= 1 || y1 >= h - 2)
            yd1 = yd1 ? 0 : 1;

        x2 = xd2 > 0 ? ++x2 : --x2;
        if(x2 <= 1 || x2 >= w - 2)
            xd2 = xd2 ? 0 : 1;
        y2 = yd2 > 0 ? ++y2 : --y2;
        if(y2 <= 1 || y2 >= h - 2)
            yd2 = yd2 ? 0 : 1;

        x3 = xd3 > 0 ? ++x3 : --x3;
        if(x3 <= 1 || x3 >= w - 2)
            xd3 = xd3 ? 0 : 1;
        y3 = yd3 > 0 ? ++y3 : --y3;
        if(y3 <= 1 || y3 >= h - 2)
            yd3 = yd3 ? 0 : 1;

        c1 = wgetatpos(win, y1, x1);  
        c2 = wgetatpos(win, y2, x2);
        c3 = wgetatpos(win, y3, x3);

        wattrset(win, B_BLUE  | F_RED);
        mvwaddch(win, y1, x1, 'O');
        wattrset(win,  B_RED   | F_BLUE);
        mvwaddch(win, y2, x2, '*');
        wattrset(win,  B_GRAY  | F_BROWN);
        mvwaddch(win, y3, x3, '@');
        wmove(win, 0, 0);
        wrefresh(win);
        wputatpos(win, y1, x1, c1);
        wputatpos(win, y2, x2, c2);
        wputatpos(win, y3, x3, c3);
        delay(150);
    }
    return 0;
}

//
//  Wait for user
//
WaitForUser()
{
time_t  t;

    t = time((time_t *)0);
    while(1)                         
    {   if(bioskey(1))
        {   if((bioskey(0) & 0x7f) == 0x1b)
                return  0x1b;
            else
                return  0;
        }
        if(time((time_t *)0) - t > 5)
            return  0;
    }
}

//
//  Trap interrupt
//
void trap()
{
    endwin();
    exit(0);
}

//  End of demo.c
