/****************************************************************************/
/* RBBSMNT, a maintenance utility for RBBS-PC                               */
/* NOTICE ͸*/
/*  A limited license is granted to all users of this program to make     */
/*  copies if this program and distribute those copies to other users     */
/*  on the following three conditions:                                    */
/*                                                                        */
/*    1.   This notice is NOT altered, bypassed or removed,               */
/*    2.   The program is not to be distributed to others in modified     */
/*         form. You may make changes for your own non-commercial use     */
/*    3.   No fee is to be charged (or any other consideration received)  */
/*         for copying or distributing these programs without an express  */
/*         written agreement with J. Terpstra, Bamestra RBBS, PO Box 66,  */
/*         Beemster, The Netherlands.                                     */
/*                                                                        */
/*Copyright (C) 1991, 1992 - Jan Terpstra, Bamestra RBBS, The Netherlands.*/
/*;*/
/****************************************************************************/

#include "rbbsmnt.h"                    /* definitions for this program     */
#include "externs.h"                    /* external data references         */

  /**************************************************************************/
  /* main                                                                   */
  /**************************************************************************/

FILE *logfile;
int logging = FALSE;
int _cdecl main(int argc,char *argv[])
{
   int n;
   long t_start;

   printf("\n     "PRGNAME VERSION"of "__DATE__
   " - a maintenance utility for RBBS-PC.\n");
   printf("(C)1991, 1992 by J.R. Terpstra of Bamestra RBBS, The Netherlands \
(2:512/10.0)\n\n");
 
   if (argc < 2)
   {
      printf("Usage: RBBSMNT [options]\n\nOptions are:\n\n");
      printf(
    " -w  workdir   drive\\path to be used as workdir, preferably a VDISK.\n"
      );
      printf(" -l  logfile   the name of the logfile to use.\n");
      printf(" -m  msgfile   the name of the msgfile to process.\n");
      printf(" -km N         maximum age of msgs (n = 1...32767).\n");
      printf(" -mm N         maximum number of msgs that will be left in the\
 msgfile after\n");
      printf("               processing is done (n = 1...999).\n");
      printf
      (" -r            renumber msgs in msgsfile. Requires usrfile too!\n");
      printf(" -pip          Pack In Place, do not use temporary file.\n");
      printf(" -t            Truncate empty records when using -pip.\n");
      printf(" -s            Save old messages to a file XXXX.NNN, where XXX\
X is the name of\n");
      printf("               conference and NNN is the current daynumber.\n"
      );
      printf(" -u usrfile    name of usrfile to process.\n");
      printf(" -ku N         days of inactivity before user is deleted (n = \
1...32767).\n");
      printf
      (" -xu N         user level exempted from cleanup (n = 1...32767).\n")
      ;
      printf
      (" -q            quiet, minimum progress indication. Runs faster.\n");
      printf(" -fix          repair message file's HEADER & NODE records.\n"
      );
      printf("Strike a key when ready . . .");
      getch();
      printf("\rSome Examples:                \n");
      printf("RBBSMNT -w E:\\ -m MESSAGES -r -km 60 -mm 200 -r  -u USERS -ku\
 60 -xu 10\n");
      printf(" Removes killed msgs and all msgs older than 60 days from file\
 MESSAGES.\n");
      printf
      (" If needed, removes additional msgs untill 200 msgs are left.\n");
      printf(" Renumbers msgs in file MESSAGES, update last msg read for all\
 users. Then\n");
      printf(" cleans USERS file from users that have not logged on for 60 d\
ays or more,\n");
      printf(" except users with access level 10 or higher. Uses Drive E:\\ \
as workdir.\n\n");
      printf("RBBSMNT -m IBMPCM.DEF -mm 5000 -q\n");
      printf(
  " Removes killed msgs and as many additional msgs until a maximum of 500\n"
      );
      printf(" msgs is left in the file IBMPCM.DEF. Runs in quiet mode.\n\n"
      );
      printf
      ("RBBSMNT -m TENNISM.DEF -r -u TENNISU.DEF -ku 90 -l RBBSMNT.LOG\n");
      printf(" Renumbers msgs in the file TENNISM.DEF, adjusts the last msg \
read pointers\n");
      printf(" in the file TENNISU.DEF. Deletes users that have not logged o\
n for 90 days.\n");
      printf(" Writes activities and deleted users to RBBSMNT.LOG.\n\n");
      printf("RBBSMNT -m TENNISM.DEF -fix\n");
      printf(" Repair header & node records of messages file TENNISM.DEF.\n"
      );
      exit(0);
   } 

   /*************************************************************************/
   /* process commandline options                                           */
   /*************************************************************************/
 

   for (n = 1; n < argc; n++)
   {
      strupr(argv[n]);

      /**********************************************************************/
      /* msgfile options                                                    */
      /**********************************************************************/
 

      if (!stricmp(argv[n], "-M"))      /* MESSAGES filename                */
      {
         n++;
 
         if (n == argc)
         {
            bad_arg(argv[n-1]);
         } 
         msgfile = argv[n];
         strupr(msgfile);
         continue;
      } 
 
      if (!stricmp(argv[n], "-KM"))     /* max age of messages              */
      {
         n++;
 
         if (n == argc)
         {
            bad_arg(argv[n-1]);
         } 
         max_age = atoi(argv[n]);
         do_clean = TRUE;
         continue;
      } 
 
      if (!stricmp(argv[n], "-MM"))     /* max # of msgs to leave           */
      {
         n++;
 
         if (n == argc)
         {
            bad_arg(argv[n-1]);
         } 
         max_msgs = atoi(argv[n]);
         do_clean = TRUE;
         continue;
      } 
 
      if (!stricmp(argv[n], "-R"))
      {
         do_renum = TRUE;
      } 
 
      if (!stricmp(argv[n], "-S"))
      {
         save_em = TRUE;
      } 
 
      if (!stricmp(argv[n], "-PIP"))
      {
         pip = TRUE;
      } 
 
      if (!stricmp(argv[n], "-T"))
      {
         trunc = TRUE;
      } 
 
      if (!stricmp(argv[n], "-FIX"))
      {
         fixhdr = TRUE;
         quiet = FALSE;
      } 

      /**********************************************************************/
      /* user file options                                                  */
      /**********************************************************************/
 

      if (!stricmp(argv[n], "-U"))      /* USERS file                       */
      {
         n++;
 
         if (n == argc)
         {
            bad_arg(argv[n-1]);
         } 
         usrfile = argv[n];
         strupr(usrfile);
         continue;
      } 
 
      if (!stricmp(argv[n], "-KU"))     /* max age of users                 */
      {
         n++;
 
         if (n == argc)
         {
            bad_arg(argv[n-1]);
         } 
         max_since = atoi(argv[n]);
         do_usr = TRUE;
         continue;
      } 
 
      if (!stricmp(argv[n], "-XU"))     /* exempt users                     */
      {
         n++;
 
         if (n == argc)
         {
            bad_arg(argv[n-1]);
         } 
         exempt = atoi(argv[n]);
         continue;
      } 

      /**********************************************************************/
      /* misc options                                                       */
      /**********************************************************************/
 

      if (!stricmp(argv[n], "-Q"))
      {
         quiet = TRUE;
      } 
 
      if (!stricmp(argv[n], "-L"))      /* log to file?                     */
      {
         n++;
 
         if (n == argc)
         {
            bad_arg(argv[n-1]);
         } 
 
         if ((logfile = fopen(argv[n], "a+")) == NULL)
         {
            printf("\n!Cannot open logfile.\n");
         } 
 
         else
         {
            sprintf(logbuf, "Begin "PRGNAME VERSION);
            writelog(logbuf, 0, 2);     /* log start time                   */
            logging = TRUE;
         } 
         continue;
      } 
 
      if (!stricmp(argv[n], "-W"))      /* workdir                          */
      {
         n++;
 
         if (n == argc)
         {
            bad_arg(argv[n-1]);
         } 
         strcpy(wkf, argv[n]);
 
         if (wkf[strlen(wkf)-1] == '\\')/* zap trailing backslash           */
         {
            wkf[strlen(wkf)-1] = '\0';
         } 
         strupr(wkf);
         use_wrk = TRUE;
         continue;
      } 
   } 
   t_start = time(NULL);

   /*************************************************************************/
   /* allocate room for msg and user list                                   */
   /*************************************************************************/
 

   if (pip)
   {
      use_wrk = FALSE;
   } 
 
   if (fixhdr)
   {
      repair();
   } 
 
   if ((mlist = (MSGINFO_PTR)calloc(1024, sizeof(MSGINFO)+1)) == NULL)
   {
      sprintf(logbuf, "%s messages list.", no_memory);
      writelog(logbuf, 1, 0);
      exit(2);
   } 
 
   if (do_usr || fixhdr)
   {
 
      if ((hlist = (char far *)calloc(32767, sizeof(char))) == NULL || 
      (ulist = (RBBSUSER_PTR)calloc(UBLOCK, sizeof(RBBSUSER)+1)) == NULL)
      {
         sprintf(logbuf, "%s users list.", no_memory);
         writelog(logbuf, 1, 0);
         exit(2);
      } 

      /**********************************************************************/
      /* fill "used records" list                                           */
      /**********************************************************************/

      memset((char *)hlist, 'F', 32767);
      memset((char *)ulist, ' ', UBLOCK *sizeof(RBBSUSER));

      /**********************************************************************/
      /* prepare a block of 256 user records                                */
      /**********************************************************************/
 

      for (n = 0; n < UBLOCK; n++)
      {
         ulist[n].user_level = -32000;
      } 
   } 
   time(&ltime);                        /* get current date/time            */
   today = localtime(&ltime);
   now = (int)(((today->tm_year-80)*365)+to_month[today->tm_mon]+
   today->tm_mday);
 
   if (do_clean || do_renum || fixhdr)
   {
      cleanmsg();
   } 
 
   if (do_usr)
   {
      cleanusr();
   } 
   sprintf(logbuf, PRGNAME VERSION" done in %d sec.", (int)(time(NULL)-
   t_start));
   printf("+ %s", logbuf);
 
   if (logfile)
   {
      writelog(logbuf, 0, 2);
      fclose(logfile);
   } 
   return (0);
} 


  /**************************************************************************/
  /* complain about bad argument for option                                 */
  /**************************************************************************/

void bad_arg(char *a)
{
   printf("Bad argument for switch \"%s\"\n, please perform RTFM\n", a);
   exit(2);
} 


  /**************************************************************************/
  /* write to logfile                                                       */
  /**************************************************************************/

void writelog(char *logmsg,int flag,int l)
{
   char buf[TXTLEN],*ds;
   static char s[] = "!*+: ";

   time(&ltime);                        /* get current date/time            */
   ds = asctime(localtime(&ltime));
 
   if (flag)
   {
      printf("\r%c %s\n", s[l], logmsg);
   } 
   sprintf(buf, "%c %.2s %.3s %.8s RMNT %s\n", s[l], ds+8, ds+4, ds+11, 
   logmsg);
 
   if (logfile)
   {
      fputs(buf, logfile);
   } 
} 


/*--------------------------------------------------------------------------*/

