/*-----------------------------------------------------------------------
| iodisp.c - Display data captured with I/O Monitor                     |
|            (must compile with -Zp to pack structures)                 |
-----------------------------------------------------------------------*/
#include <stdio.h>
#include <bios.h>
#include <dos.h>

#define FALSE 0
#define TRUE 1
#define USER_INT 0x61
#define BUFFER_SIZE 8192
#define INPUT           0
#define OUTPUT          0x10
#define ABYTE           1
#define AWORD           2
#define CONSTANT        8
#define CONTAINS_DATA   0x80

struct buf_record       {
        		unsigned char  io_attrib;
	        	unsigned short int io_port;
		        unsigned short int io_data;
	        	};
char * text_direc[]=      {"Read",
                          "Write"};
char * text_size[]=       {"Byte",
                          "Word"};
main()
{
struct buf_record far * buf_ptr;
unsigned far * vector_ptr;
union REGS inregs, outregs;
unsigned x;
register unsigned char attrib;

        vector_ptr=(unsigned far *) ((USER_INT << 2) + 2);    //cs of user isr  
        if ( *vector_ptr == 0)          //if user int not installed
        {
                printf ("%s", "IOM not installed.");
                exit(1);
        }
             
       	int86 ( USER_INT, &inregs, &outregs );  //do user int
        FP_SEG(buf_ptr)=outregs.x.dx;
        FP_OFF(buf_ptr)=outregs.x.bx;

        for (x=0;x< ( BUFFER_SIZE  / sizeof(struct buf_record)) && \
             ((attrib=buf_ptr->io_attrib) & CONTAINS_DATA);x++,buf_ptr++)
        {
                printf ("%s \t", text_direc[ (attrib & OUTPUT) >> 4 ]);
                printf ("%s \t", text_size[ (attrib & (AWORD | ABYTE)) -1 ]);
                printf ("%4x \t %4x \r\n", buf_ptr->io_port, buf_ptr->io_data);
        }
}






