Written by Bill Hall, Olivetti ATC.

#define INCL_PM
#include <os2.h>
#include <stddef.h>
#include "spmtpl.h"

BOOL FAR InitProgram(int argc, char *argv[])
{

    char szTitle[50];

  /* get anchor block handle and message queue handles */
    if ((hAB = WinInitialize(NULL)) == NULL)
	return FALSE;

    if ((hmqMsgQ = WinCreateMsgQueue(hAB,0)) == NULL)
        return FALSE;

  /* This string is needed to register the Window */
    WinLoadString(hAB,NULL, IDS_APPNAME, sizeof(szAppName), (PSZ)szAppName);

    if (!WinRegisterClass(hAB, 			/* anchor block handle */
			  (PCH)szAppName, 	/* class name */
			  (PFNWP)MainWndProc,	/* window procedure for class */
			  CS_SIZEREDRAW,   	/* class styles */
			  0))			/* no extra data needed */
	return FALSE;

  /* This string is needed to create the frame window */
    WinLoadString(hAB, NULL, IDS_TITLE, sizeof(szTitle), (PSZ)szTitle);

    hwndFrame = WinCreateStdWindow(HWND_DESKTOP,	/* parent */
                                   WS_VISIBLE | FS_TITLEBAR   | /*frame style*/
                                   FS_SYSMENU | FS_SIZEBORDER |
                                   FS_MINMAX,
                                   (PCH)szAppName,	/* class */
                                   (PCH)szTitle,	/* window title */
                                   0L,			/*default client style*/
                                   (HMODULE)NULL,	/* resources in .EXE */
                                   NULL,		/* frame id */
                                   (HWND FAR *)&hwndMain);
							/* handle to client */

    if (hwndFrame) {
        WinShowWindow(hwndFrame, TRUE);
	return TRUE;
    }
    return FALSE;
}

/* called when client is created */
void FAR WndCreate(HWND hWnd)
{

    FONTMETRICS FM;
    HPS hPS;

  /* get the size of an icon */
    xIconsize = WinQuerySysValue(HWND_DESKTOP, SV_CXICON);
    yIconsize = WinQuerySysValue(HWND_DESKTOP, SV_CYICON);

  /* load the icon string */
    WinLoadString(hAB, NULL, IDS_ICON, (USHORT)sizeof(szIcon), (PSZ)szIcon);

  /* get the system font character metrics */
    hPS = WinGetPS(hWnd);
    GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &FM);
    CharHeight = FM.lMaxBaselineExt + FM.lExternalLeading;
    CharWidth = FM.lAveCharWidth;
    WinReleasePS (hPS);
}
