/* 
 * FPLOT - fpout.c
 *
 * Copyright (C) 1997 - 2000  Michael C. Ring
 *
 * Permission to use, copy, and distribute this software and its
 * documentation for any purpose with or without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and 
 * that both that copyright notice and this permission notice appear 
 * in supporting documentation.
 *
 * Permission to modify the software is granted, but not the right to
 * distribute the modified code.  Modifications are to be distributed 
 * as patches to released version.
 *  
 * This software is provided "as is" without express or implied warranty.
 */

/*
 *      fpout.c
 *
 *      $Log: fpout.c,v $
 *      Revision 1.22  2000/01/17 21:23:53  mike
 *      fix dumb typo
 *
 *      Revision 1.21  2000/01/17 21:05:31  mike
 *      added set coordinates command
 *
 *      Revision 1.20  2000/01/13 04:22:07  mike
 *      add new grid line option
 *
 *      Revision 1.19  2000/01/10 04:25:26  mike
 *      add code for variable graph borders
 *
 *      Revision 1.18  2000/01/10 02:21:27  mike
 *      tweak logic for plotting lines
 *
 *      Revision 1.17  2000/01/10 00:10:50  mike
 *      allow blank lines in the data file
 *
 *      Revision 1.16  2000/01/09 04:55:22  mike
 *      cast fread to int to eliminate DOS warning
 *
 *      Revision 1.15  2000/01/08 06:20:08  mike
 *      added proto.h and full prototypes
 *
 *      Revision 1.14  1999/09/25 22:09:37  mring
 *      added new set pointsizescale command
 *
 *      Revision 1.13  1999/09/25 21:39:25  mring
 *      change special flag values for center and rightjustify
 *      add FplotPageSize to postscript header
 *
 *      Revision 1.12  1999/01/13 02:04:17  mring
 *      tweak g_graph_x_m?? on log plot
 *
 *      Revision 1.11  1998/10/16 22:40:37  mring
 *      added rotation angles to label output
 *
 *      Revision 1.10  1998/10/16 22:27:03  mring
 *      added MAX_LABELS
 *
 *      Revision 1.9  1998/04/03 20:07:29  mring
 *      minor tweaks
 *
 *      Revision 1.8  1998/03/15 23:42:51  mring
 *      move outside box to end of plotting routine
 *      plot data lines from max Y range down to 1
 *      changed calls to fread
 *
 *      Revision 1.7  1998/03/08 20:01:56  mring
 *      added code to support 'center' and 'rightjustify' on labels 1-8
 *
 *      Revision 1.6  1998/03/06 00:33:26  mring
 *      added some comments
 *
 *      Revision 1.5  1998/03/05 03:43:20  mring
 *      update for 0.5a
 *
 *      Revision 1.4  1997/12/05 02:20:31  mring
 *      updated for version 0.4a
 *
 *      Revision 1.3  1997/11/26 23:21:14  mring
 *      added MAX_LINE_LENGTH
 *
 *      Revision 1.2  1997/11/24 01:34:19  mring
 *      added copyright notice
 *
 *      Revision 1.1  1997/11/23 23:08:25  mring
 *      Initial revision
 */

#include "fplot.h"
#include "proto.h"
#include "glob.h"

/* RCS TRACER */
/*
 * $Id: fpout.c,v 1.22 2000/01/17 21:23:53 mike Exp $
 */

static  FILE    *ptr_out;
static  int	log_flag;
static  double  y1slope, y1int, y2slope, y2int, xslope, xint;

/***********************************************************************/
void	output_epson_lq_plot()
{
if (g_output_file[0] == '\0')
   ptr_out = stdout;
else
  {
   if ((ptr_out = fopen(g_output_file, "wb")) == NULL)
     {
      fprintf(stderr,"Could not open plot file \'%s\'\n",g_output_file);
      exit_program(27);
     }
  }

/* add code here for Epson LQ ... */

if (g_output_file[0] != '\0')
  fclose(ptr_out);
}
/***********************************************************************/
void	output_epson_fx_plot()
{
if (g_output_file[0] == '\0')
   ptr_out = stdout;
else
  {
   if ((ptr_out = fopen(g_output_file, "wb")) == NULL)
     {
      fprintf(stderr,"Could not open plot file \'%s\'\n",g_output_file);
      exit_program(27);
     }
  }

/* add code here for Epson FX ... */

if (g_output_file[0] != '\0')
  fclose(ptr_out);
}
/***********************************************************************/
void	output_hpgl2_plot()
{
if (g_output_file[0] == '\0')
   ptr_out = stdout;
else
  {
   if ((ptr_out = fopen(g_output_file, "wb")) == NULL)
     {
      fprintf(stderr,"Could not open plot file \'%s\'\n",g_output_file);
      exit_program(27);
     }
  }

/* add code here for HPGL2 ... */

if (g_output_file[0] != '\0')
  fclose(ptr_out);
}
/***********************************************************************/
void	output_postscript_plot()
{
if (g_output_file[0] == '\0')
   ptr_out = stdout;
else
  {
   if ((ptr_out = fopen(g_output_file, "w")) == NULL)
     {
      fprintf(stderr,"Could not open plot file \'%s\'\n",g_output_file);
      exit_program(27);
     }
  }

ps_print_header();

ps_print_dict();            /* output the dictionary  */

ps_print_plot();            /* output the actual plot */

ps_print_trailer();

if (g_output_file[0] != '\0')
  fclose(ptr_out);
}
/***********************************************************************/
void	ps_print_header()
{
long	length, width;

width  = (long)(g_papersize_width * 72.0 + 0.5);
length = (long)(g_papersize_length * 72.0 + 0.5);

/* page size in points: 8.5 x 11 == 612 x 792 */

fprintf(ptr_out,"%%!PS\n");
fprintf(ptr_out,"%%%%Creator: fplot\n");
fprintf(ptr_out,"%%%%FplotPageSize: %ld %ld\n",width,length);
fprintf(ptr_out,"%%%%Pages: (atend)\n");
fprintf(ptr_out,"%%%%EndComments\n");
}
/***********************************************************************/
void	ps_print_dict()
{
double  at, bt, ct, dt;

at = 320.0 * g_point_size_scale;
bt = 2.0 * at;
ct = 2.65625 * at;
dt = at;

fprintf(ptr_out,"/fplot 20 dict def\n");
fprintf(ptr_out,"fplot begin\n");

fprintf(ptr_out,"/at %.1f def\n",at);
fprintf(ptr_out,"/bt %.1f def\n",bt);
fprintf(ptr_out,"/ct %.1f def\n",ct);
fprintf(ptr_out,"/dt %.1f def\n",dt);

fprintf(ptr_out,"/N {newpath} bind def\n");
fprintf(ptr_out,"/S {stroke} bind def\n");
fprintf(ptr_out,"/M {moveto} bind def\n");
fprintf(ptr_out,"/L {lineto} bind def\n");
fprintf(ptr_out,"/R {rmoveto} bind def\n");
fprintf(ptr_out,"/T {rlineto} bind def\n");
fprintf(ptr_out,"/Z {closepath} bind def\n");

fprintf(ptr_out,
    "/A { N M ct 2 div 0 at sub R 0 ct sub at T ct at T Z S } def\n");

fprintf(ptr_out,"/B { N M bt 2 div bt 2 div R 0 bt sub 0 T\n");
fprintf(ptr_out,"0 0 bt sub T bt 0 T Z S } def\n");

fprintf(ptr_out,
    "/C { N M ct 2 div 0 R 0 ct sub at T 0 0 bt sub T Z S } def\n");

fprintf(ptr_out,"/D { N M at 0 R 0 at sub at T 0 at sub 0 at sub T\n");
fprintf(ptr_out,"at 0 at sub T Z S } def\n");

fprintf(ptr_out,"/P { N M dt 0 R 0 dt dt add sub 0 T dt 0 T\n");
fprintf(ptr_out,"0 0 dt sub T 0 dt dt add T S } def\n");

fprintf(ptr_out,"/X { N M dt dt R 0 dt dt add sub dup T dt dt T\n");
fprintf(ptr_out,"dt 0 dt sub T 0 dt dt add sub dt dt add T S } def\n");

fprintf(ptr_out,"end\n");
fprintf(ptr_out,"%%%%Page: 1 1\n");
fprintf(ptr_out,"%%%%EndProlog\n");
}
/***********************************************************************/
void	ps_print_plot()
{
fprintf(ptr_out,"fplot begin\n");
fprintf(ptr_out,"gsave\n");
fprintf(ptr_out,"0.010 0.010 scale\n");
fprintf(ptr_out,"0 setgray\n");

ps_print_box_labels_data();

fprintf(ptr_out,"grestore\n");
fprintf(ptr_out,"end\n");
}
/***********************************************************************/
void	ps_print_box_labels_data()
{
double  *dp, d1, d2, c1, c2, cstart, delta, xdata, ydata,
	border, rotation;
int     loop, j, nr, jdiv, first, dash_on, dash_off, ct5, ct150,
	reset_flag, loop2;
long    graph_x_low, graph_x_high, graph_y_low, graph_y_high, ltmp, dfont,
        lstr, xcoord, ycoord, mx, my;
char    *cp, *cp2, point_style[16];

/* allocate a string buffer and some doubles for temp use */

dp   = (double *)memory_allocate(16 * sizeof(double));
cp   = (char *)memory_allocate(1500 * sizeof(char));
cp2  = cp;
cp2 += 1000;

/*						      P.S.
       Y-Range         Line-width        Line-color   Dict   Symbol
       -----------------------------------------------------------------
	  1              Medium            Black      /D     Diamond

	  2              Narrow            Black      /B     Box     

	  3              Wide              Black      /A     Triangle Up

	  4              Medium            Gray       /C     Triangle Down

	  5              Narrow            Gray       /P     Plus sign 

	  6              Wide              Gray       /X     Cross sign  

          
	  The pattern is repeated for Y ranges 7-12.
 */

strcpy(point_style,".DBACPXDBACPX.");

border = 7200.0;   /* graph border is 1" scaled 100:1 and 72 points/inch */

/*
 *  calculate graph borders and the X, Y1, & Y2 slopes and y-intercepts
 */

graph_x_low  = (long)(border * g_border_left + 0.5);
graph_x_high = (long)(g_papersize_length * border - 
					   border * g_border_right + 0.5);

graph_y_high = (long)(border * g_border_top + 0.5);
graph_y_low  = (long)(g_papersize_width  * border - 
				           border * g_border_bottom + 0.5);

y1slope = (double)(graph_y_high - graph_y_low) /
                  (g_graph_y1_max - g_graph_y1_min);

y1int   = graph_y_high - y1slope * g_graph_y1_max;

y2slope = (double)(graph_y_high - graph_y_low) /
                  (g_graph_y2_max - g_graph_y2_min);

y2int   = graph_y_high - y2slope * g_graph_y2_max;

xslope  = (double)(graph_x_high - graph_x_low) /
                  (g_graph_x_max - g_graph_x_min);

xint    = graph_x_high - xslope * g_graph_x_max;

/*
 *      display the labels now
 */

fprintf(ptr_out,"/Helvetica findfont 1400 scalefont setfont\n");
dfont = 1400;    /* default font size for 4 major labels (scaled 100:1) */

if (g_xlabel[0] != '\0')        /* X Label */
  {
   lstr = convert_string_to_ps(g_xlabel,cp);
   ltmp = (long)(g_fontsize_xlabel * 100.0 + 0.5);

   mx  = (graph_x_low + graph_x_high) / 2;
   mx -= lstr * ltmp / (2 * 1400);
   my  = graph_y_low + 4600;

   fprintf(ptr_out,"gsave\n");

   if (ltmp != dfont)
     fprintf(ptr_out,"/Helvetica findfont %ld scalefont setfont\n",ltmp);

   fprintf(ptr_out,"%ld %ld M 90 rotate\n",my,mx);
   fprintf(ptr_out,"%s show\n",cp);
   fprintf(ptr_out,"grestore\n");
  }


if (g_y1label[0] != '\0')        /* Y1 Label */
  {
   lstr = convert_string_to_ps(g_y1label,cp);
   ltmp = (long)(g_fontsize_y1label * 100.0 + 0.5);

   mx  = graph_x_low - 4600;
   my  = (graph_y_low + graph_y_high) / 2;
   my += lstr * ltmp / (2 * 1400);

   fprintf(ptr_out,"gsave\n");

   if (ltmp != dfont)
     fprintf(ptr_out,"/Helvetica findfont %ld scalefont setfont\n",ltmp);

   fprintf(ptr_out,"%ld %ld M 180 rotate\n",my,mx);
   fprintf(ptr_out,"%s show\n",cp);
   fprintf(ptr_out,"grestore\n");
  }


if (g_y2label[0] != '\0')        /* Y2 Label */
  {
   lstr = convert_string_to_ps(g_y2label,cp);
   ltmp = (long)(g_fontsize_y2label * 100.0 + 0.5);

   mx  = graph_x_high + 4600;
   my  = (graph_y_low + graph_y_high) / 2;
   my -= lstr * ltmp / (2 * 1400);

   fprintf(ptr_out,"gsave\n");

   if (ltmp != dfont)
     fprintf(ptr_out,"/Helvetica findfont %ld scalefont setfont\n",ltmp);

   fprintf(ptr_out,"%ld %ld M 0 rotate\n",my,mx); 
   fprintf(ptr_out,"%s show\n",cp);
   fprintf(ptr_out,"grestore\n");
  }


if (g_title[0] != '\0')        /* Title */
  {
   lstr = convert_string_to_ps(g_title,cp);
   ltmp = (long)(g_fontsize_title * 100.0 + 0.5);

   mx  = (graph_x_low + graph_x_high) / 2;
   mx -= lstr * ltmp / (2 * 1400);
   my  = graph_y_high - 3200;

   fprintf(ptr_out,"gsave\n");

   if (ltmp != dfont)
     fprintf(ptr_out,"/Helvetica findfont %ld scalefont setfont\n",ltmp);

   fprintf(ptr_out,"%ld %ld M 90 rotate\n",my,mx);
   fprintf(ptr_out,"%s show\n",cp);
   fprintf(ptr_out,"grestore\n");
  }


log_flag = FALSE;
if (g_xaxis_scale == X_AXIS_SCALE_LOG)
  {
   log_flag = TRUE;

   c1 = g_true_x_min + 1.0E-4 * g_true_x_min;
   g_graph_x_min = floor(log10(c1));

   c1 = g_true_x_max - 1.0E-4 * g_true_x_max;
   g_graph_x_max = floor(1.0 + log10(c1));

   /* recompute since we changed the x axis scaling */

   xslope  = (double)(graph_x_high - graph_x_low) /
                     (g_graph_x_max - g_graph_x_min);
      
   xint    = graph_x_high - xslope * g_graph_x_max;
  }    


/*
 *      use smaller font for the labels
 */

fprintf(ptr_out,"/Helvetica findfont 1000 scalefont setfont\n");
dfont = 1000;    /* default font size for MAX_LABELS (scaled 100:1) */

/* search through all labels */

for (j=1; j <= MAX_LABELS; j++)
  {
   if (g_label_array[j] != NULL)
     {
      if (strlen(g_label_array[j]) > 0)
        {
         ltmp = (long)(g_label_fontsize[j] * 100.0 + 0.5);
   
         get_xy_coord_labels(g_label_coord[j], g_label_array[j], g_label_x[j],
	 		     g_label_y[j], g_label_fontsize[j], cp, &mx, &my);
   
         fprintf(ptr_out,"gsave\n");
      
         if (ltmp != dfont)
           fprintf(ptr_out,"/Helvetica findfont %ld scalefont setfont\n",ltmp);
      
         rotation = 90.0 + g_label_rotate[j];
         if (rotation < -180.0)  rotation += 360.0;
         if (rotation >  180.0)  rotation -= 360.0;
         format_double(rotation,cp2);
   
         fprintf(ptr_out,"%ld %ld M %s rotate\n",my,mx,cp2);
         fprintf(ptr_out,"%s show\n",cp);
         fprintf(ptr_out,"grestore\n");
        }
     }
  }


/*
 *      draw the GRID lines, either full grids or just tick marks
 */

if (g_gridlines == GRID_LINES_TICK)
  {
   fprintf(ptr_out,"100 setlinewidth\n");

   dash_on = 600;       /* points the dash is ON  */

   if (g_xaxis_scale == X_AXIS_SCALE_LINEAR)
     {
      jdiv  = g_x_divisions;
      delta = ((double)graph_x_high - graph_x_low) / jdiv;

      for (j=1; j < jdiv; j++)                 /* loop for all divisions */
        {
         xcoord = (long)(delta * j + graph_x_low + 0.5);

         ycoord = graph_y_high;
         fprintf(ptr_out,"N %ld %ld M ",ycoord,xcoord);
         ycoord += dash_on;
         fprintf(ptr_out,"%ld %ld L S\n",ycoord,xcoord);

         ycoord = graph_y_low;
         fprintf(ptr_out,"N %ld %ld M ",ycoord,xcoord);
         ycoord -= dash_on;
         fprintf(ptr_out,"%ld %ld L S\n",ycoord,xcoord);
        }
     }

   if (g_xaxis_scale == X_AXIS_SCALE_LOG)
     {
      if (g_true_x_min <= 0.0 || g_true_x_max <= 0.0)
        {
         fprintf(stderr,
	   "ERROR : There is X axis data less than 0 on a LOG plot\n");
         exit_program(18);
        }

      d2 = g_graph_x_max - 0.01;
      d1 = g_graph_x_min;

      while (1)          /* loop for all decades of the LOG plot */
        {
         if (d1 > d2)  break;

         c1     = pow(10.0,d1);
         cstart = c1;

         for (j=2; j <= 9; j++)  
           {
            c1 += cstart;

            xcoord = (long)(log10(c1) * xslope + xint + 0.5);

            ycoord = graph_y_high;
            fprintf(ptr_out,"N %ld %ld M ",ycoord,xcoord);
            ycoord += dash_on;
            fprintf(ptr_out,"%ld %ld L S\n",ycoord,xcoord);

            ycoord = graph_y_low;
            fprintf(ptr_out,"N %ld %ld M ",ycoord,xcoord);
            ycoord -= dash_on;
            fprintf(ptr_out,"%ld %ld L S\n",ycoord,xcoord);
           }

         c1 = 10.0 * cstart;        /* draw the even decade line solid */

         xcoord = (long)(log10(c1) * xslope + xint + 0.5);
         ycoord = graph_y_high;
         fprintf(ptr_out,"N %ld %ld M ",ycoord,xcoord);

         ycoord = graph_y_low;
         fprintf(ptr_out,"%ld %ld L S\n",ycoord,xcoord);

         d1 += 1.0;
        }
     }

   /* plot Y range grid lines */

   jdiv = g_y1_divisions;
   delta = ((double)graph_y_high - graph_y_low) / jdiv;

   for (j=1; j < jdiv; j++)                 /* loop for all divisions */
     {
      ycoord = (long)(delta * j + graph_y_low + 0.5);

      xcoord = graph_x_low;
      fprintf(ptr_out,"N %ld %ld M ",ycoord,xcoord);
      xcoord += dash_on;
      fprintf(ptr_out,"%ld %ld L S\n",ycoord,xcoord);

      xcoord = graph_x_high;
      fprintf(ptr_out,"N %ld %ld M ",ycoord,xcoord);
      xcoord -= dash_on;
      fprintf(ptr_out,"%ld %ld L S\n",ycoord,xcoord);
     }
  }

if (g_gridlines == GRID_LINES_ON)
  {
   fprintf(ptr_out,"50 setlinewidth\n");

   dash_on  = 900;       /* points the dash is ON  */
   dash_off = 450;       /* points the dash is OFF */

   if (g_xaxis_scale == X_AXIS_SCALE_LINEAR)
     {
      jdiv  = g_x_divisions;
      delta = ((double)graph_x_high - graph_x_low) / jdiv;

      for (j=1; j < jdiv; j++)                 /* loop for all divisions */
        {
         xcoord = (long)(delta * j + graph_x_low + 0.5);
         ycoord = graph_y_high;

         while (1)        /* draw incremental line segments */
           {
            fprintf(ptr_out,"N %ld %ld M ",ycoord,xcoord);

            ycoord += dash_on;
            if (ycoord >= graph_y_low)
               ycoord = graph_y_low;

            fprintf(ptr_out,"%ld %ld L S\n",ycoord,xcoord);

            ycoord += dash_off;

            if (ycoord >= graph_y_low)
              break;
           }
        }
     }

   if (g_xaxis_scale == X_AXIS_SCALE_LOG)
     {
      if (g_true_x_min <= 0.0 || g_true_x_max <= 0.0)
        {
         fprintf(stderr,
	   "ERROR : There is X axis data less than 0 on a LOG plot\n");
         exit_program(18);
        }

      d2 = g_graph_x_max - 0.01;
      d1 = g_graph_x_min;

      while (1)          /* loop for all decades of the LOG plot */
        {
         if (d1 > d2)  break;

         c1     = pow(10.0,d1);
         cstart = c1;

         for (j=2; j <= 9; j++)  
           {
            c1 += cstart;

            xcoord = (long)(log10(c1) * xslope + xint + 0.5);
            ycoord = graph_y_high;

            while (1)        /* draw incremental line segments */
              {
               fprintf(ptr_out,"N %ld %ld M ",ycoord,xcoord);

               ycoord += dash_on;
               if (ycoord >= graph_y_low)
                  ycoord = graph_y_low;

               fprintf(ptr_out,"%ld %ld L S\n",ycoord,xcoord);

               ycoord += dash_off;

               if (ycoord >= graph_y_low)
                 break;
              }
           }

         c1 = 10.0 * cstart;        /* draw the even decade line solid */

         xcoord = (long)(log10(c1) * xslope + xint + 0.5);
         ycoord = graph_y_high;
         fprintf(ptr_out,"N %ld %ld M ",ycoord,xcoord);

         ycoord = graph_y_low;
         fprintf(ptr_out,"%ld %ld L S\n",ycoord,xcoord);

         d1 += 1.0;
        }
     }

   /* plot Y range grid lines */

   jdiv = g_y1_divisions;
   delta = ((double)graph_y_high - graph_y_low) / jdiv;

   for (j=1; j < jdiv; j++)                 /* loop for all divisions */
     {
      xcoord = graph_x_low;
      ycoord = (long)(delta * j + graph_y_low + 0.5);

      while (1)        /* draw incremental line segments */
        {
         fprintf(ptr_out,"N %ld %ld M ",ycoord,xcoord);

         xcoord += dash_on;
         if (xcoord >= graph_x_high)
            xcoord = graph_x_high;

         fprintf(ptr_out,"%ld %ld L S\n",ycoord,xcoord);

         xcoord += dash_off;

         if (xcoord >= graph_x_high)
           break;
        }
     }
  }

nr = g_num_y_ranges + 1;		/* num records */

/*
 *      graph the data now
 */

if ((g_tmp_ptr3 = fopen(g_tmp_file3,"rb")) == NULL)
  {
   fprintf(stderr,"Could not open plot file \'%s\'\n",g_tmp_file3);
   exit_program(60);
  }

setvbuf(g_tmp_ptr3,g_big_buffer,_IOFBF,BIG_BUF_SIZE);

/*
 *  draw the lines
 */

if (g_graph_type == GRAPH_TYPE_LINES ||
    g_graph_type == GRAPH_TYPE_LINES_AND_POINTS)
  {
                                                /* loop for all Y ranges */
   for (loop2=1; loop2 <= g_num_y_ranges; loop2++)
     {
      rewind(g_tmp_ptr3);
      first = TRUE;
      ct5   = 0;
      ct150 = 147;
      loop  = nr - loop2;	      /* plot from max Y range down to 1 */

      if (g_graph_type == GRAPH_TYPE_LINES_AND_POINTS)
        {
         fprintf(ptr_out,"100 setlinewidth\n");
         fprintf(ptr_out,"0 setgray\n");
        }
      else
        {
         if (((loop + 1) % 3) == 0)
            fprintf(ptr_out,"60 setlinewidth\n");
         else
           {
            if ((loop % 3) == 0)
              fprintf(ptr_out,"140 setlinewidth\n");
            else
              fprintf(ptr_out,"100 setlinewidth\n");
           }

         if (((loop + 2) % 6) <= 2)
           fprintf(ptr_out,"0.5 setgray\n");
         else
           fprintf(ptr_out,"0 setgray\n");
        }

      reset_flag = FALSE;

      while (1)
        {
         if ((int)fread((char *)dp,sizeof(double),nr,g_tmp_ptr3) < nr)  break;

         if ((xdata = dp[0]) < SPECIAL_BREAK_FLAG)
	   {
	    reset_flag = TRUE;
            ct150 = 147;
            fprintf(ptr_out,"S ");
	   }
         else
	   {
            if (log_flag)
              xdata = log10(xdata);
   
	    xcoord = (long)(xdata * xslope + xint + 0.5);
   
            if (xcoord < graph_x_low)   xcoord = graph_x_low;
            if (xcoord > graph_x_high)  xcoord = graph_x_high;
   
            ydata = dp[loop];
            if (loop == 2)
              ycoord = (long)(ydata * y2slope + y2int + 0.5);
            else
              ycoord = (long)(ydata * y1slope + y1int + 0.5);
   
            if (ycoord > graph_y_low)    ycoord = graph_y_low;
            if (ycoord < graph_y_high)   ycoord = graph_y_high;
   
            if (first)
              {
               first = FALSE;
               fprintf(ptr_out,"N %ld %ld M ",ycoord,xcoord);
              }
            else
              {
	       if (reset_flag)
                 fprintf(ptr_out,"N %ld %ld M ",ycoord,xcoord);
	       else
                 fprintf(ptr_out,"%ld %ld L ",ycoord,xcoord);
              }
   
	    reset_flag = FALSE;

            if (++ct5 == 5)
              {
               ct5 = 0;
               fprintf(ptr_out,"\n");
              }

            if (--ct150 == 0)
              {
               ct150 = 150;
               fprintf(ptr_out,"S N %ld %ld M ",ycoord,xcoord);

               if (++ct5 == 5)
                 {
                  ct5 = 0;
                  fprintf(ptr_out,"\n");
                 }
              }
           }
        }

      if (reset_flag)
        fprintf(ptr_out,"\n");
      else
        fprintf(ptr_out,"S\n");
     }  /* end for loop=1-g_num_y_ranges */
  } /* end if lines or lines&points */

/*
 *  draw the points
 */

if (g_graph_type == GRAPH_TYPE_POINTS ||
    g_graph_type == GRAPH_TYPE_LINES_AND_POINTS)
  {
                                                /* loop for all Y ranges */
   for (loop=1; loop <= g_num_y_ranges; loop++)
     {
      rewind(g_tmp_ptr3);
      ct5 = 0;

      fprintf(ptr_out,"100 setlinewidth\n");
      fprintf(ptr_out,"0 setgray\n");

      while (1)
        {
         if ((int)fread((char *)dp,sizeof(double),nr,g_tmp_ptr3) < nr)  break;

         if ((xdata = dp[0]) > SPECIAL_BREAK_FLAG)
	   {
            if (log_flag)
              xdata = log10(xdata);
   
	    xcoord = (long)(xdata * xslope + xint + 0.5);
   
            if (xcoord < graph_x_low)   xcoord = graph_x_low;
            if (xcoord > graph_x_high)  xcoord = graph_x_high;
   
            ydata = dp[loop];
            if (loop == 2)
              ycoord = (long)(ydata * y2slope + y2int + 0.5);
            else
              ycoord = (long)(ydata * y1slope + y1int + 0.5);
   
            if (ycoord > graph_y_low)    ycoord = graph_y_low;
            if (ycoord < graph_y_high)   ycoord = graph_y_high;
   
            fprintf(ptr_out,"%ld %ld %c ",ycoord,xcoord,point_style[loop]);
   
            if (++ct5 == 5)
              {
               ct5 = 0;
               fprintf(ptr_out,"\n");
              }
           }
        }

      if (ct5 != 0)
        fprintf(ptr_out,"\n");
     }  /* end for loop=1-g_num_y_ranges */
  } /* end if points or lines&points */

fclose(g_tmp_ptr3);
g_tmp_ptr3 = NULL;

/*
 *      draw the box (that the plot fits inside of)
 */

fprintf(ptr_out,"200 setlinewidth 0 setgray\n");
fprintf(ptr_out,"N %ld %ld M ",graph_y_low,graph_x_low);
fprintf(ptr_out,"%ld %ld L ",graph_y_high,graph_x_low);
fprintf(ptr_out,"%ld %ld L ",graph_y_high,graph_x_high);
fprintf(ptr_out,"%ld %ld L Z S\n",graph_y_low,graph_x_high);

/*
 *      use this font for the axis numbers
 */

fprintf(ptr_out,"100 setlinewidth\n");
fprintf(ptr_out,"/Helvetica findfont 1200 scalefont setfont\n");

/*
 *	Put the numbers on the X axis 
 */

if (g_xaxis_scale == X_AXIS_SCALE_LINEAR)
  {
   jdiv  = g_x_divisions;
   delta = ((double)graph_x_high - graph_x_low) / jdiv;
   c1    = g_graph_x_min;
   c2    = (g_graph_x_max - g_graph_x_min) / jdiv;

   for (j=0; j <= jdiv; j++)   
     {
      mx = (long)(delta * j + graph_x_low + 0.5);
      my = graph_y_low;

      format_double(c1,cp);
      lstr = convert_string_to_ps(cp,cp2);

      mx -= lstr * 12 / 28;       /* lstr / 2 * (12 / 14) */
      my += 1400;
   
      fprintf(ptr_out,"gsave\n");
      fprintf(ptr_out,"%ld %ld M 90 rotate\n",my,mx);
      fprintf(ptr_out,"%s show\n",cp2);
      fprintf(ptr_out,"grestore\n");

      c1 += c2;
     }
  }

if (g_xaxis_scale == X_AXIS_SCALE_LOG)
  {
   d2 = g_graph_x_max + 0.01;
   d1 = g_graph_x_min;

   /*
    *   Only display the even powers of 10 for a LOG plot
    */

   while (1)          /* loop for all decades of the LOG plot */
     {
      if (d1 > d2)  break;

      c1 = pow(10.0,d1);

      mx = (long)(d1 * xslope + xint + 0.5);
      my = graph_y_low;

      format_double(c1,cp);
      lstr = convert_string_to_ps(cp,cp2);

      mx -= lstr * 12 / 28;       /* lstr / 2 * (12 / 14) */
      my += 1400;
   
      fprintf(ptr_out,"gsave\n");
      fprintf(ptr_out,"%ld %ld M 90 rotate\n",my,mx);
      fprintf(ptr_out,"%s show\n",cp2);
      fprintf(ptr_out,"grestore\n");

      d1 += 1.0;
     }
  }

/* put the numbers on the Y1 Axis */

jdiv  = g_y1_divisions;
delta = ((double)graph_y_high - graph_y_low) / jdiv;
c1    = g_graph_y1_min;
c2    = (g_graph_y1_max - g_graph_y1_min) / jdiv;

for (j=0; j <= jdiv; j++)                 /* loop for all divisions */
  {
   mx = graph_x_low;
   my = (long)(delta * j + graph_y_low + 0.5);

   format_double(c1,cp);
   lstr = convert_string_to_ps(cp,cp2);

   mx -= lstr * 12 / 14 + 500;
   my += 375 * 12 / 14;
   
   fprintf(ptr_out,"gsave\n");
   fprintf(ptr_out,"%ld %ld M 90 rotate\n",my,mx);
   fprintf(ptr_out,"%s show\n",cp2);
   fprintf(ptr_out,"grestore\n");

   c1 += c2;
  }

/* put the numbers on the Y2 Axis */

if (g_force_y2_y1 == FALSE && g_num_y_ranges == 2)
  {
   jdiv = 1;
   if (g_y1_divisions == g_y2_divisions) 
     jdiv = g_y2_divisions;

   delta = ((double)graph_y_high - graph_y_low) / jdiv;
   c1    = g_graph_y2_min;
   c2    = (g_graph_y2_max - g_graph_y2_min) / jdiv;

   for (j=0; j <= jdiv; j++)
     {
      mx = graph_x_high;
      my = (long)(delta * j + graph_y_low + 0.5);

      format_double(c1,cp);
      lstr = convert_string_to_ps(cp,cp2);

      mx += 500;
      my += 375 * 12 / 14;
   
      fprintf(ptr_out,"gsave\n");
      fprintf(ptr_out,"%ld %ld M 90 rotate\n",my,mx);
      fprintf(ptr_out,"%s show\n",cp2);
      fprintf(ptr_out,"grestore\n");

      c1 += c2;
     }
  }

memory_free(cp);
memory_free(dp);
}
/***********************************************************************/
void	ps_print_trailer()
{
fprintf(ptr_out,"showpage\n");
fprintf(ptr_out,"%%%%Trailer\n");
fprintf(ptr_out,"%%%%Pages: 1\n");
}
/***********************************************************************/
/*
 *	definition of bit-mapped variable 'g_label_coord[]', passed 
 *      in here as 'lblcoord'.
 *
 *	XXXX   XXXX
 *             0001   use inches for x,y coordinates
 *             0010   use the graph's axis for x,y coordinates
 *
 *      0000   ->     normal 'X' axis positioning
 *      0001   ->     CENTER the 'X' position
 *      0010   ->     RIGHTJUSTIFY the 'X' position
 */
void    get_xy_coord_labels(lblcoord,cplabel,dx,dy,fontsize,cpdest,
			    xcord,ycord)
int	lblcoord;
char    *cplabel, *cpdest;
double  dx, dy, fontsize;
long	*xcord, *ycord;
{
long	lstr, mm;
double  dd;

lstr = convert_string_to_ps(cplabel,cpdest);

/* do Y coord first */

if ((lblcoord & 1) != 0)      /* inches */
  {
   mm = (long)(7200.0 * (g_papersize_width - dy) + 0.5);
  }
else                          /* plot coordinates */
  {
   mm = (long)(dy * y1slope + y1int + 0.5);
  }

*ycord = mm;

/* do X coord next */

if ((lblcoord & 2) != 0)              /* plot coordinates */
  {
   if (log_flag)
     mm = (long)(log10(dx) * xslope + xint + 0.5);
   else
     mm = (long)(dx * xslope + xint + 0.5);
  }
else			              /* inches   */
  {
   dd = (double)lstr * fontsize / (14.0 * 7200.0);

   if ((lblcoord & 0x10) != 0)        /* 'CENTER' */
     {
      dd = (g_papersize_length - dd) / 2.0;
      mm = (long)(dd * 7200.0 + 0.5);
     }
   else
     {
      if ((lblcoord & 0x20) != 0)     /* 'RIGHTJUSTIFY' */
        {
         dd = g_papersize_length - 0.5 - dd;  
         mm = (long)(dd * 7200.0 + 0.5);
	}
      else			      /* normal label positioning */
	{
         mm = (long)(dx * 7200.0 + 0.5);
	}
     }
  }

*xcord = mm;
}
/***********************************************************************/
