//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVSYSTEM.H                           |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     OS interface & utils interface       |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

void __init_system( void );
void __set_startup_video_mode( void );

#ifndef _PVSYSTEM_H
#define _PVSYSTEM_H

typedef void (*Tscreen_mode_proc) ( char mode, char char_size );
struct Tcursor
{
  char beg_line;
  char end_line;
};
typedef char Tpal[0x10];

#endif //_PVSYSTEM.H

//SYSTEM & DOS INTERFACE

void _cli( void );
void _sti( void );
#ifdef __386__
int lock_region ( void *address, unsigned length );
#endif
boolean critical_error( void );
boolean memavail( unsigned long &mem );
char *fexpand( char *filespec );
char *add_ext( char *name, char *ext );
char *min_path( char *filespec );
char *short_path( char *filespec, int n );
boolean get_date_time( char *filespec, uint &date, uint &time );
long file_size( char *filespec );
uint pack_time( char hours, char minutes, char seconds );
uint pack_date( uint year, char month, char day );
void unpack_time( unsigned packed, char &hours, char &minutes, char &seconds );
void unpack_date( unsigned packed, uint &year, char &month, char &day );

//SCREEN

void set_char_size( char size );
void set_video_mode( char mode, char char_size );
void direct_set_video_mode( char mode, char char_size );
void update_screen_information( void );
void set_page( char page_num );
char *save_screen_status( void );
void restore_screen_status( char *p );
void save_dos_screen( void );
void restore_dos_screen( void );
Tscreen_mode_proc hook_mode_proc( Tscreen_mode_proc p );

#ifndef HGR

//EGA/VGA FONTS MANAGEMENT

char seq_read( char reg );
void seq_write( char reg, char val );
char gpx_read( char reg );
void gpx_write( char reg, char val );
void open_font_map( void );
void close_font_map( void );
char *get_char_def( int chr, char *buf );
char *set_char_def( int chr, char *buf );
char *xchg_char_def( int chr, char *buf );
void set_char_width( char width );
void select_fonts( char font1, char font2 );

#endif

//CURSOR MANAGEMENT

void get_cursor( Tcursor &x );
void set_cursor( Tcursor &x );

#ifndef HGR

//EGA/VGA PALETTE MANAGEMENT

void set_blink( boolean blink );
#ifndef NOPAL
void set_palette( char no, char value );
char get_palette( char no );
void set_border( char color );
char get_border( void );
void set_all_palette( Tpal &x );
void get_all_palette( Tpal &x );
#endif

#endif //!HGR

//SOUND

void beep( uint hz, uint ms );
#ifndef NOTIMER
void smart_beep( uint hz, uint ticks );
#endif

#ifdef DECLARE_PVSYSTEM
#ifdef CYR
char *months[12] = {
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  " ",
  "",
  "",
  "",
  ""
};
char *week_days[7] = {
  "",
  "",
  "",
  "",
  "",
  "",
  ""
};
#else
char *months[] = {
  "January",
  "February",
  "March",
  "April",
  "May",
  "June",
  "July",
  "August",
  "September",
  "October",
  "November",
  "December"
};
char *week_days[7] = {
  "Sunday",
  "Monday",
  "Tuesday",
  "Wednesday",
  "Thursday",
  "Friday",
  "Saturday"
};
#endif
Tscreen_mode_proc change_video_mode = direct_set_video_mode;
boolean scr_bw        = 0;             //!=0 if black-and-white mode selected
boolean scr_forced_bw = 0;             //!=0 if black-and-white mode forced
boolean scr_forced_g0 = 0;             //!=0 if soft fonts disabled
#ifdef HGR
Tcursor insert_cursor = {  6, 8 };
Tcursor over_cursor   = {  0, 8 };
Tcursor no_cursor     = {  9, 9 };
Tcursor *current_cursor = &no_cursor;
#else
Tcursor insert_cursor = {  6, 7 };
Tcursor over_cursor   = {  1, 7 };
Tcursor no_cursor     = { 32, 0 };
#endif
Tpal default_pal = { 0, 1, 2, 3, 4, 5, 20 ,7 ,56, 57, 58, 59, 60, 61, 62, 63 };
char frame_standard[10] = { '', '', '', '', ' ', '', '', '', '', 0 };
char frame_cyr[10]      = { '', '', '', '', ' ', '', '', '', '', 0 };
char frame_normal[10]   = { '', '', '', '', ' ', '', '', '', '', 0 };
char text_attr     = 0x07;             //|t
char bold_attr     = 0x0F;             //|b
char selected_attr = 0x70;             //|s
char disabled_attr = 0x08;             //|d
char shortcut_attr = 0x0E;             //|~
char attr[10]      = { 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 };
#ifdef __FLAT__
word *scr_address;                     //active text page address
#else
word far *scr_address;                 //active text page address
#endif
uint scr_length;                       //screen page length in bytes
uint scr_mode;                         //current video mode
uint scr_columns;                      //screen columns
uint scr_rows;                         //screen rows
char scr_page;                         //active text page number
boolean scr_soft_fonts;                //TRUE if characters redefinable
char scr_char_size;                    //EGA/VGA bytes per character
char scr_font_num;                     //active EGA/VGA font number
#else //DECLARE
extern char *months[];
extern char *week_days[];
extern Tscreen_mode_proc change_video_mode;
extern boolean scr_bw;
extern boolean scr_forced_bw;
extern boolean scr_forced_g0;
extern Tcursor insert_cursor;
extern Tcursor over_cursor;
extern Tcursor no_cursor;
#ifdef HGR
extern Tcursor *current_cursor;
#endif
extern Tpal default_pal;
extern char frame_standard[0x10];
extern char frame_cyr[0x10];
extern char frame_normal[0x10];
extern char text_attr;
extern char bold_attr;
extern char selected_attr;
extern char disabled_attr;
extern char shortcut_attr;
extern char attr[10];
#ifdef __FLAT__
extern word *scr_address;
#else
extern word far *scr_address;
#endif
extern uint scr_length;
extern uint scr_mode;
extern uint scr_columns;
extern uint scr_rows;
extern char scr_page;
extern boolean scr_soft_fonts;
extern char scr_char_size;
extern char scr_font_num;
#endif //DECLARE
