//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVINI.H                              |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     INI files processor interface        |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#ifndef _PVINI_H
#define _PVINI_H
#ifdef CYR
#define INIERR_RANGE    " "
#else
#define INIERR_RANGE    "Value out of range"
#endif
#endif

FILE *read_ini( char *filename );
Ttext_editor *open_ini( char *filename );
void close_ini( void );
boolean seek_section( boolean fatal, char *section );
char *seek_var( boolean fatal, char *var );
boolean ini( char *var, boolean &x, boolean _default );
boolean ini( char *var, long &x, long _default );
#ifndef NOFLOAT
boolean ini( char *var, double &x, double _default );
#endif
boolean set_ini( char *var, char *value, ... );
boolean save_ini( void );
void ini_err( boolean flag, char *msg, ... );
void ini_lnerr( boolean flag, char *msg, ... );
void ini_errs( boolean report );
char *ini_section( void );
uint ini_line( void );
