//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVBASICS.H                           |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Basic and common-use stuff interface |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

//SET PROCESSING

#ifndef _PVBASICS_H
#define _PVBASICS_H

#ifdef HDEBUG
  #define NEW(x)        ( assert(_heapchk()==_HEAPOK),(new x)      )
  #define MALLOC(x)     ( assert(_heapchk()==_HEAPOK),malloc(x)    )
  #define REALLOC(x,y)  ( assert(_heapchk()==_HEAPOK),realloc(x,y) )
  #define STRDUP(x)     ( assert(_heapchk()==_HEAPOK),strdup(x)    )
  #define FREE(x)       ( assert(_heapchk()==_HEAPOK),free(x)      )
  #define DELETE(x)     ( assert(_heapchk()==_HEAPOK),(delete x)   )
#else
  #define NEW(x)        (new x)
  #define MALLOC(x)     malloc(x)
  #define REALLOC(x,y)  realloc(x,y)
  #define STRDUP(x)     strdup(x)
  #define FREE(x)       free(x)
  #define DELETE(x)     (delete x)
#endif

#define lo(x) (*((char *)&(x)))    //low char of a word
#define hi(x) (*((char *)&(x)+1))  //hi char of a word
#define INCL(s,m) (s)[(m)>>3] |= (char)(1 << ((m)&7))
#define EXCL(s,m) (s)[(m)>>3] &= (char)(~(1 << ((m)&7)))
#define IN(s,m) (s)[(m)>>3] & ( 1 << ((m)&7))

#ifdef __386__
#ifdef __FLAT__
#define MKFP(segment,offset) (void*)FP_OFF(MK_FP(0,(segment<<4)+offset))
#else
#define MKFP(segment,offset) MK_FP(0,(segment<<4)+offset)
#endif
#else
#define MKFP(segment,offset) MK_FP(segment,offset)
#endif

#ifdef __386__
#define INTR(i,inregs,outregs) int386(i,inregs,outregs)
#define INTRX(i,inregs,outregs,segregs) int386x(i,inregs,outregs,segregs)
#else
#define INTR(i,inregs,outregs) int86(i,inregs,outregs)
#define INTRX(i,inregs,outregs,segregs) int86x(i,inregs,outregs,segregs)
#endif

#define BIOS_DTA(offset) MKFP(0x0040,offset)
#define VGA_CHARS (char *)MKFP(0xA000,0x0000)

class Tset
{
  public:
    char members[32];
    void operator ~ ( void ); //clear the set
    void operator ! ( void ); //[0..255]
    int is_empty( void );
    friend Tset& operator << ( Tset &set, uint member );
    friend Tset& operator >> ( Tset &set, uint member );
    friend Tset& operator << ( Tset &set, Tset &set1 );
    friend Tset& operator >> ( Tset &set, Tset &set1 );
    friend int operator &( Tset &set, uint member ); //return != 0 if member is in set
    friend int operator &( uint member, Tset &set ); //return != 0 if member is in set
    friend int operator == ( Tset &set1, Tset &set2 );
    friend int operator != ( Tset &set1, Tset &set2 );
};

inline int operator & ( Tset &set, uint member )
{
  return IN( set.members, member );
}

inline int operator & ( uint member, Tset &set )
{
  return IN( set.members, member );
}

inline Tset& operator << ( Tset &set, uint member )
{
  INCL( set.members, member );
  return set;
}

inline Tset& operator >> ( Tset &set, uint member )
{
  EXCL( set.members, member );
  return set;
}

inline int operator != ( Tset &set1, Tset &set2 )
{
  return !( set1 == set2 );
}

inline int min( int x, int y ) { return ( (x < y) ? x : y ); }
inline int max( int x, int y ) { return ( (x > y) ? x : y ); }
inline uint minw( uint x, uint y ) { return ( (x < y) ? x : y ); }
inline uint maxw( uint x, uint y ) { return ( (x > y) ? x : y ); }
inline long minl( long x, long y ) { return ( (x < y) ? x : y ); }
inline long maxl( long x, long y ) { return ( (x > y) ? x : y ); }

extern char rolb( char x, char num );
#pragma aux rolb = \
  "rol al,cl"      \
  parm [al] [cl]   \
  value [al]       \
  modify [al];

extern char rorb( char x, char num );
#pragma aux rorb = \
  "ror al,cl"      \
  parm [al] [cl]   \
  value [al]       \
  modify [al];

extern word rolw( word x, char num );
#pragma aux rolw = \
  "rol ax,cl"      \
  parm [ax] [cl]   \
  value [ax]       \
  modify [ax];

extern word rorw( word x, char num );
#pragma aux rorw = \
  "ror ax,cl"      \
  parm [ax] [cl]   \
  value [ax]       \
  modify [ax];

//TEXT PROCESSING

inline char cyr_toupper( char c )
{
  if( c>=0xA0 && c<=0xBF )
    return (char)(c-0x20);
  else
    return c;
}

inline char cyr_tolower( char c )
{
  if( c>=0x80 && c<=0x9F )
    return (char) (c+0x20);
  else
    return c;
}

#endif

void cyr_strupr( char *str );
void cyr_strlwr( char *str );

//ROTATIONS

extern char rolb( char x, char num );
extern char rorb( char x, char num );
extern word rolw( word x, char num );
extern word rorw( word x, char num );
