//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVHGR.CPP                            |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Support for graphics-mode version    |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_basics
#define uses_conio
#define uses_dc
#define uses_hgr
#define uses_string
#define uses_system

#define DECLARE_PVHGR
#include "PVuses.h"
#undef DECLARE_PVHGR

//100702.14@compuserve.com Mr. Rex
//BDavis1968@aol.com       Stefano

/*
Thgr public
*/
  Thgr::Thgr( int _xl, int _yl ):
    Titem( _xl, _yl )
  {
    event_mask |= evMOUSE_HGR_DRAG;
    grow_mode = gmGROW_BOTH;
    color = 15;
    buffer = NULL;
    buf_size = 0;
    id = 0xFF;
    for( int i=0; i<HGR_MAX_BUFFERS; i++ )
      if( hgrs[i]==NULL )
      {
        hgrs[i] = this;
        id = i;
        break;
      }
    set_state( isVALID, id!=0xFF );
  }

  Thgr::~Thgr( void )
  {
    if( buffer!=NULL ) FREE( buffer );
    if( id    !=0xFF ) hgrs[id] = NULL;
  }

  void Thgr::set_color( char _color )
  {
    color = _color;
  }


/*
Thgr protected
*/
  void Thgr::resize( int _xl, int _yl )
  {
    if( set_buf_size( _xl, _yl ) )
    {
      Titem::resize( _xl, _yl );
      refresh();
    }
  }

  void Thgr::set_palette( void )
  {
    text_attr = 0;
  }

  void Thgr::draw( void )
  {
    txtf( "|r%c%c|l%c", (char)xl, id, (char)yl );
  }

  void Thgr::initialize( void )
  {
    resize( xl, yl );
  }


/*
Tplane public
*/
  Tplane::Tplane( int _xl, int _yl ):
    Thgr( _xl, _yl )
  {
    mul_table  = NULL;
    plane0     = NULL;
    plane1     = NULL;
    plane2     = NULL;
    plane3     = NULL;
    plane_size = 0;
  }

  void Tplane::clear( void )
  {
    memset( plane0, 0, plane_size );
    memset( plane1, 0, plane_size );
    memset( plane2, 0, plane_size );
    memset( plane3, 0, plane_size );
    if( color&1 ) memset( plane0, 255, plane_size );
    if( color&2 ) memset( plane1, 255, plane_size );
    if( color&4 ) memset( plane2, 255, plane_size );
    if( color&8 ) memset( plane3, 255, plane_size );
  }

  void Tplane::set_pixel( int _x, int _y )
  {
    if( _x<0 || _x>hgr_max_x || _y<0 || _y>hgr_max_y ) return;
    char b1=0x80>>(_x%8), b0=~b1;
    int offset=_y*xl+_x/8;
    plane0[offset]&=b0; if( color&1 ) plane0[offset]|=b1;
    plane1[offset]&=b0; if( color&2 ) plane1[offset]|=b1;
    plane2[offset]&=b0; if( color&4 ) plane2[offset]|=b1;
    plane3[offset]&=b0; if( color&8 ) plane3[offset]|=b1;
  }

  static  int __xl;
  extern "C" void draw_line_bin( void );
  extern void draw_line( int x1, int y1, int x2, int y2, char *p0, int plstepcolor  );
  #pragma aux draw_line =                       \
  "             push    ebp                     "\
  "             mov     ebp,__xl                "\
  "             call    draw_line_bin           "\
  "             pop     ebp                     "\
  parm [edi] [esi] [ebx] [eax] [edx] [ecx]       \
  modify [eax ebx ecx edx esi edi];

  void Tplane::line( int x1, int y1, int x2, int y2 )
  {
    int q;
    if( x1>x2)
    {
      q=x1; x1=x2; x2=q;
      q=y1; y1=y2; y2=q;
    }
    if( x1<0 )
      if( x2<0 ) return;
      else
      {
        y1 = (x2*y1-x1*y2) / (x2-x1);
        x1 = 0;
      }
    if( x2>hgr_max_x )
      if( x1>hgr_max_x ) return;
      else
      {
        y2 = ( (hgr_max_x-x1)*y2 + (x2-hgr_max_x)*y1 ) / (x2-x1);
        x2 = hgr_max_x;
      }
    if( y1>y2 )
    {
      q=x1; x1=x2; x2=q;
      q=y1; y1=y2; y2=q;
    }
    if( y1<0 )
      if( y2<0 ) return;
      else
      {
        x1 = (x1*y2-x2*y1) / (y2-y1);
        y1 = 0;
      }
    if( y2>hgr_max_y )
      if( y1>hgr_max_y ) return;
      else
      {
        x2 = ( (hgr_max_y-y1)*x2 + (y2-hgr_max_y)*x1 ) / (y2-y1);
        y2 = hgr_max_y;
      }
    __xl=xl;
    draw_line( x1, y1, x2, y2, plane0, ((plane1-plane0)<<4)|(color&0x0F) );
  }

  void Tplane::draw( char *screen, int l )
  {
    int sx, sy;
    int offset=(int)(screen-(char*)scr_address);
    make_local( offset%80, (offset/80)/16, sx, sy );
    int plane_ofs = sy*xl*16+sx, i;
    char *dest, *src;
    _cli();
    outpw( 0x03CE, 0x0001 );
    outpw( 0x03C4, 0x0102 );
    for( i=17,dest=screen,src=plane0+plane_ofs; --i; dest+=80,src+=xl )
      memcpy( dest, src, l );
    outp ( 0x03C5, 0x02 );
    for( i=17,dest=screen,src=plane1+plane_ofs; --i; dest+=80,src+=xl )
      memcpy( dest, src, l );
    outp ( 0x03C5, 0x04 );
    for( i=17,dest=screen,src=plane2+plane_ofs; --i; dest+=80,src+=xl )
      memcpy( dest, src, l );
    outp ( 0x03C5, 0x08 );
    for( i=17,dest=screen,src=plane3+plane_ofs; --i; dest+=80,src+=xl )
      memcpy( dest, src, l );
    _sti();
  }


/*
Tplane protected
*/
  size_t Tplane::get_buf_size( int _xl, int _yl )
  {
    return (_xl*_yl*16)*4 + _yl*16*sizeof(int);
  }

  boolean Tplane::set_buf_size( int _xl, int _yl )
  {
    size_t bs;
    char *new_blk = (char *)REALLOC( buffer, bs=get_buf_size( _xl, _yl ) );
    if( new_blk==NULL ) return 0;
    buffer = new_blk; buf_size = bs;
    hgr_cols=_xl*8; hgr_rows=_yl*16;
    hgr_max_x=hgr_cols-1; hgr_max_y=hgr_rows-1;
    char *b=buffer;
    plane_size=_xl*_yl*16;
    plane0=b, b+=plane_size;
    plane1=b, b+=plane_size;
    plane2=b, b+=plane_size;
    plane3=b, b+=plane_size;
    mul_table = (int*)b;
    for( int i=0,s=0; i<_yl*16; mul_table[i++]=s,s+=_xl );
    return 1;
  }
