//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVDRV.CPP                            |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Drivers implementation               |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_conio
#define uses_ctype
#define uses_string
#define uses_comlin
#define uses_config
#define uses_ini
#define uses_system

#define DECLARE_PVDRV
#include "PVuses.h"
#undef DECLARE_PVDRV

#pragma off( check_stack )


/*
EVENTS DRIVER
*/
  struct Tevents_data
  {
    boolean events_overflow_flag;
    uint event_mask;
    uint events_num;
    unsigned long old_timer;
    Tevent events_queue[MAX_EVENTS];
  };

  static Tevents_data events_data =
  {
  /* EVENTS_OVERFLOW_FLAG */ 0,
  /* EVENT_MASK           */ (uint)-1
  #ifndef NOMOUSE
                                    & ~evMOUSE_MOVE
  #endif
  ,
  /* EVENTS_NUM           */ 0,
  /* OLD_TIMER            */
  /* EVENTS_QUEUE         */
  };

  #define EVENTS_OVERFLOW_FLAG events_data.events_overflow_flag
  #define EVENT_MASK events_data.event_mask
  #define EVENTS_NUM events_data.events_num
  #define OLD_TIMER events_data.old_timer
  #define EVENTS_QUEUE events_data.events_queue

  uint get_system_events_mask( void )
  {
    return EVENT_MASK;
  };

  void set_system_events_mask( uint em )
  {
    EVENT_MASK = em;
  };

  void clear_events( void )
  {
    Tevent ev;
    while( EVENTS_NUM ) get_event( ev );
  };

  boolean event_present( void )
  {
    return ( EVENTS_NUM != 0 );
  }

  #ifdef __386__
  //Dummy function to indicate org of the code to lock
  void events_lock_region_begin( void )
  {
  }
  #endif

  extern char _cld( void );
  #pragma aux _cld = "cld";

  extern char set_es( void );
  #pragma aux set_es = \
    "mov ax,ds"        \
    "mov es,ax"        \
    modify [ax];

  boolean put_event( Tevent &ev )
  {
    set_es();
    if( !( ev.code & EVENT_MASK ) ) return 0;
    if( ( EVENTS_OVERFLOW_FLAG = ( EVENTS_NUM == MAX_EVENTS ) ) != 0 )
    {
      smart_beep( 1000, 1 );
      return 0;
    }
    _cli();
    EVENTS_QUEUE[EVENTS_NUM++] = ev;
    _sti();
    return 1;
  };

  #ifdef __386__
  //Dummy function to indicate end of the code to lock
  void events_lock_region_end( void )
  {
  }
  #endif

  void get_event( Tevent &ev )
  {
    static boolean first_idle = 1;
    unsigned long timer;
  #ifdef __FLAT__
    unsigned long *system_timer = (unsigned long *) BIOS_DTA( 0x6C );
    timer = *system_timer;
  #else
    unsigned long far *system_timer = (unsigned long *) BIOS_DTA( 0x6C );
    do { timer = *system_timer; } while( timer!=*system_timer );
  #endif
    uint i, j, p;

    if( !EVENTS_NUM )
    {
      ev.code = evNOTHING;
      ev.priority = 0;
      ev.destination = NULL;
      if( first_idle ) OLD_TIMER = timer;
      first_idle = 0;
      ev.TIME_PASSED = timer - OLD_TIMER;
      return;
    }
    first_idle = 1;
    _cli();
    for( i = 0, p = (uint)-1; i < EVENTS_NUM; i++ )
      if( EVENTS_QUEUE[i].priority < p )
      {
        p = EVENTS_QUEUE[i].priority;
        j = i;
      }
    memcpy( &ev, &EVENTS_QUEUE[j], sizeof( Tevent ) );
    memmove( &EVENTS_QUEUE[j], &EVENTS_QUEUE[j+1],
             ( --EVENTS_NUM - j ) * sizeof( Tevent ) );
    _sti();
  }

  boolean events_overflow( void )
  {
    return EVENTS_OVERFLOW_FLAG;
  }


/*
TIMER DRIVER
*/
  #define MAX_TIMERS 16
  #define TIMER_INTR  8//0x1C

  struct Ttimer_data
  {
    uint allocs;
    uint counters[MAX_TIMERS];
    Tcallback callbacks[MAX_TIMERS];
    Tevent events[MAX_TIMERS];
    void (interrupt far *old_timer_handler )( void );
  };

  static Ttimer_data timer_data;

  #define ALLOCS timer_data.allocs
  #define COUNTERS timer_data.counters
  #define CALLBACKS timer_data.callbacks
  #define EVENTS timer_data.events
  #define OLD_TIMER_HANDLER timer_data.old_timer_handler

  #ifdef __386__
  //Dummy function to indicate org of the code to lock
  void timer_lock_region_begin( void )
  {
  }
  #endif

  static void _loadds interrupt far timer_handler( void )
  {
    set_es();
    for( int i=0; i<MAX_TIMERS; i++ )
      if( COUNTERS[i]>0 && !--COUNTERS[i] )
        if( CALLBACKS[i] != NULL )
          CALLBACKS[i]();
        else
          put_event( EVENTS[i] );
    OLD_TIMER_HANDLER();
  }

  #ifdef __386__
  //Dummy function to indicate end of the code to lock
  void timer_lock_region_end( void )
  {
  }
  #endif

  int alloc_timer( void )
  {
    int i;
    uint u;
    for( i=0,u=1; i<MAX_TIMERS; i++,u<<=1 )
      if( !(ALLOCS&u) )
      {
        ALLOCS |= u;
        return i;
      }
    return -1;
  }

  void event_request( int handle, Tevent &ev, uint ticks )
  {
    if( handle==-1 ) return;
    CALLBACKS[handle] = NULL;
    memcpy( &EVENTS[handle], &ev, sizeof( Tevent ) );
    COUNTERS[handle] = ticks;
  }

  void call_request( int handle, Tcallback callback, uint ticks )
  {
    if( handle==-1 ) return;
    CALLBACKS[handle] = callback;
    COUNTERS[handle] = ticks;
  }

  void cancel_request( int handle )
  {
    if( handle==-1 ) return;
    COUNTERS[handle] = 0;
  }

  void free_timer( int handle )
  {
    int i;
    uint u;
    if( handle==-1 ) return;
    cancel_request( handle );
    for( i=0,u=1; i<handle; i++,u<<=1 );
    ALLOCS &= ~u;
  }


/*
KEYBOARD DRIVER
*/
  #define KBD_INTR 0x09

  static char convert_table[] = {
    (kALT_A >> 8), (kALT_B >> 8), (kALT_C >> 8), (kALT_D >> 8), (kALT_E >> 8),
    (kALT_F >> 8), (kALT_G >> 8), (kALT_H >> 8), (kALT_I >> 8), (kALT_J >> 8),
    (kALT_K >> 8), (kALT_L >> 8), (kALT_M >> 8), (kALT_N >> 8), (kALT_O >> 8),
    (kALT_P >> 8), (kALT_Q >> 8), (kALT_R >> 8), (kALT_S >> 8), (kALT_T >> 8),
    (kALT_U >> 8), (kALT_V >> 8), (kALT_W >> 8), (kALT_X >> 8), (kALT_Y >> 8),
    (kALT_Z >> 8)
  };
  static char num_convert_table[] = {
    (kALT_0 >> 8), (kALT_1 >> 8), (kALT_2 >> 8), (kALT_3 >> 8), (kALT_4 >> 8),
    (kALT_5 >> 8), (kALT_6 >> 8), (kALT_7 >> 8), (kALT_8 >> 8), (kALT_9 >> 8)
  };
  #ifdef CYR
  static char cyr_convert_table[] = {
    (kALT_A >> 8), (kALT_B >> 8), (kALT_W >> 8), (kALT_G >> 8), (kALT_D >> 8),
    (kALT_E >> 8), (kALT_V >> 8), (kALT_Z >> 8), (kALT_I >> 8), (kALT_J >> 8),
    (kALT_K >> 8), (kALT_L >> 8), (kALT_M >> 8), (kALT_N >> 8), (kALT_O >> 8),
    (kALT_P >> 8), (kALT_R >> 8), (kALT_S >> 8), (kALT_T >> 8), (kALT_U >> 8),
    (kALT_F >> 8), (kALT_H >> 8), (kALT_C >> 8), (kALT_BACKAPOST >> 8), (kALT_LBRACKET >> 8),
    (kALT_RBRACKET >> 8), (kALT_Y >> 8), (kALT_X >> 8), (kALT_BACKSLASH >> 8), (kALT_Q >> 8)
  };
  #endif

  struct Tkbd_data
  {
    boolean extended_key;
    char last_key;
    void (interrupt far *old_keyboard_handler ) ( void );
  };

  #define EXTENDED_KEY kbd_data.extended_key
  #define LAST_KEY kbd_data.last_key
  #define OLD_KEYBOARD_HANDLER kbd_data.old_keyboard_handler

  static Tkbd_data kbd_data = { 0, 0 };

  #ifdef __386__
  //Dummy function to indicate org of the code to lock
  void keyboard_lock_region_begin( void )
  {
  }
  #endif

  static void _loadds interrupt far keyboard_handler( void )
  {
    word *bios_qh = (word *)BIOS_DTA( 0x1C );
    word *bios_qt = (word *)BIOS_DTA( 0x1A );
    word *shifts  = (word *)BIOS_DTA( 0x17 );
    char p, key, sc;
  #ifdef __386__
    static
  #endif
    Tevent ev;
    set_es();
    ev.destination = NULL;
    while( (inp( 0x64 )&0x01)==0 );
    p = (char) inp( 0x60 );
    OLD_KEYBOARD_HANDLER();
    key = (char) ( p & 0x7F );
    ev.SCAN_CODE = key;
    ev.EXT_KEY = EXTENDED_KEY;
    if( ( EXTENDED_KEY = ( p == 0xE0 ) ) != 0 ) return;
    ev.ASCII = 0;
    if( *bios_qh!=*bios_qt )
    {
      ev.ASCII = * ( (word *) BIOS_DTA( *bios_qt ) );
      *bios_qt = *bios_qh;
      switch( lo( ev.ASCII ) )
      {
        case kSPACE:
          if( *shifts & smALT ) ev.ASCII = kALT_SPACE;
          break;
        case kESC:
          if( *shifts & smCTRL ) ev.ASCII = kCTRL_ESC;
          break;
        default:
          sc = hi( ev.ASCII );
          if( ( sc >= 0x47 ) && ( sc <= 0x53 ) &&
              ( sc != 0x4A ) && ( sc != 0x4E ) )
          {
            if( *shifts & smSHIFT )
            {
              lo( ev.ASCII ) = 0;
              ev.ASCII -= 0x4600;
            }
            else
              if( ( *shifts & smNUM ) != smNUM ) lo( ev.ASCII ) = 0;
          }
      }
      if( lo( ev.ASCII ) == 0xE0 )
        lo( ev.ASCII ) = 0;
      else
        if( lo( ev.ASCII ) && ( ev.ASCII!=0x1C0A ) && ( ev.ASCII!=0x0EF0 ) )
          ev.ASCII &= 0x00FF;
    }
    if( p != LAST_KEY )
    {
      LAST_KEY = p;
      ev.code = evKEY_DOWN;
      ev.priority = epKEY_DOWN;
      if( p >= 0x80 )
      {
        ev.code = evKEY_UP;
        ev.priority = epKEY_UP;
      }
      put_event( ev );
    }
    if( ev.ASCII )
    {
      ev.code = evKEY_PRESS;
      ev.priority = epKEY_PRESS;
      put_event( ev );
    }
  }

  #ifdef __386__
  //Dummy function to indicate org of the code to lock
  void keyboard_lock_region_end( void )
  {
  }
  #endif

  uint get_shifts( void )
  {
    word *shifts = (word *) BIOS_DTA( 0x17 );
    return *shifts;
  }

  void put_shifts( uint shift_mask )
  {
    word *shifts = (word *) BIOS_DTA( 0x17 );
    *shifts = (word)shift_mask;
  }

  uint get_key( void )
  {
  #ifdef __386__
    static
  #endif
    Tevent ev;

    do
    {
      get_event( ev );
    }
    while( ev.code != evKEY_PRESS );
    return ev.ASCII;
  }

  boolean pressed( uint key )
  {
  #ifdef __386__
    static
  #endif
    Tevent ev;

    do
    {
      get_event( ev );
      if( ev.code == evNOTHING ) return 0;
    }
    while( ( ev.code != evKEY_PRESS ) || ( ev.ASCII != key ) );
    return 1;
  }

  uint lat2alt( uint ascii )
  {
    ascii = toupper( ascii );
    if( ( ascii >= 'A' ) && ( ascii <= 'Z' ) )
      return (uint) ( convert_table[ascii-'A'] << 8 );
  #ifdef CYR
    ascii = cyr_toupper( ascii );
    if( ( ascii >= '' ) && ( ascii <= '' ) )
      return (uint) ( cyr_convert_table[ascii-''] << 8 );
  #endif
    if( ( ascii >= '0' ) && ( ascii <= '9' ) )
      return (uint) ( num_convert_table[ascii-'0'] << 8 );
    return 0;
  }

  uint alt2lat( uint ascii )
  {
    word a;
    char *i;
    uint n;

    if( !ascii ) return 0;
    if( lo( ascii ) ) return ascii;
    a = (word) ( ascii >> 8 );
    if( ascii == kALT_0 ) return '0';
    if( ( ascii >= kALT_1 ) && ( ascii <= kALT_9 ) ) return (uint) ( a - 0x47 );
    for( i = convert_table, n = 'A'; n <= 'Z' ; n++, i++ )
      if( lo( a ) == *i ) return n;
    return ascii;
  }

  #ifdef CYR
  uint alt2cyr( uint ascii )
  {
    word a;
    char *i;
    uint n;

    if( !ascii ) return 0;
    if( lo( ascii ) ) return ascii;
    a = (word) ( ascii >> 8 );
    if( ascii == kALT_0 ) return '0';
    if( ( ascii >= kALT_1 ) && ( ascii <= kALT_9 ) ) return (uint) ( a - 0x47 );
    for( i = cyr_convert_table, n = ''; n <= '' ; n++, i++ )
      if( lo( a ) == *i ) return n;
    return ascii;
  }
  #endif

  uint upcased( uint ascii )
  {
    if( ( ascii >= 'a' ) && ( ascii <= 'z' ) ) return (uint) ( ascii - 0x20 );
    return ascii;
  }

  uint get_shortcut( char *s )
  {
    do
    {
      if( ( s = strchr( s, '|' ) ) == NULL ) return 0;
    }
    while( *(++s) != '~' );
    return lat2alt( *(++s) );
  }


/*
MOUSE DRIVER
*/
  #ifndef NOMOUSE

  #define OLD_X mouse_data.old_x
  #define OLD_Y mouse_data.old_y
  #define OLD_HGR_X mouse_data.old_hgr_x
  #define OLD_HGR_Y mouse_data.old_hgr_y
  #define OLD_BUTTONS mouse_data.old_buttons
  #define CODES mouse_data.codes
  #define PRIORITIES mouse_data.priorities
  #define REVERSE mouse_data.reverse
  #define MULTI_CLICK_HANDLE mouse_data.multi_click_handle
  #define REPEAT_HANDLE mouse_data.repeat_handle
  #define CLICK_COUNTER mouse_data.click_counter

  #ifndef HGR

  #define GRAPH_CHARS mouse_data.graph_chars
  #define MOUSE_ORG_X mouse_data.mouse_org_x
  #define MOUSE_ORG_Y mouse_data.mouse_org_y
  #define OLD_POS_X mouse_data.old_pos_x
  #define OLD_POS_Y mouse_data.old_pos_y
  #define DELTA_X mouse_data.delta_x
  #define DELTA_Y mouse_data.delta_y
  #define SHAPE mouse_data.shape
  #define MASK mouse_data.mask
  #define CBUF mouse_data.cbuf
  #define DBUF mouse_data.dbuf

  static word standard_shape14[] =
  {
    0xC000,0xE040,0xF060,0xF870,0xFC78,0xFE7C,0xFF7E,
    0xFE7C,0xFC78,0xFE4C,0xDE0C,0x0F06,0x0F06,0x0F00
  };
  static word standard_shape8[] =
  {
    0xFE00,0xFE7C,0xFC78,0xFC78,0xFE4C,0xCF06,0x0700,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
  };

  static char mouse_hides = 0xFF;

  #endif //!HGR

  static Tscreen_mode_proc old_mode_proc;

  #ifdef __386__
  //Dummy function to indicate org of the code to lock
  void mouse_lock_region_begin( void )
  {
  }
  #endif

  #ifndef HGR

  static void show_mouse_cursor( void )
  {
    int xx,yy,i;
    uint ofs0, ofs1;

    _cli();
    OLD_POS_X = MOUSE_X;
    OLD_POS_Y = MOUSE_Y;
    ofs0 = (uint) ( MOUSE_Y*scr_columns + MOUSE_X );
    ofs1 = (uint) ( ofs0 + scr_columns );
    CBUF[0] = lo( scr_address[ofs0] );
    CBUF[1] = lo( scr_address[ofs1] );
    CBUF[2] = lo( scr_address[ofs0+1] );
    CBUF[3] = lo( scr_address[ofs1+1] );
    open_font_map();
    get_char_def( CBUF[1], get_char_def( CBUF[0], &DBUF[ 0] ) );
    get_char_def( CBUF[3], get_char_def( CBUF[2], &DBUF[32] ) );
    for( i = 0; i < 14; i++ )
    {
      word tmp;
      lo( tmp ) = DBUF[DELTA_Y + i];
      hi( tmp ) = DBUF[DELTA_Y + i + 32];
      tmp = ( rolw( tmp, (char)DELTA_X ) );
      lo( tmp ) &= ~MASK[i];
      lo( tmp ) |= SHAPE[i];
      tmp = ( rorw( tmp, (char)DELTA_X ) );
      DBUF[DELTA_Y + i] = lo( tmp );
      DBUF[DELTA_Y + i + 32] = hi( tmp );
    }
    set_char_def( GRAPH_CHARS[1], set_char_def( GRAPH_CHARS[0], &DBUF[ 0] ) );
    set_char_def( GRAPH_CHARS[3], set_char_def( GRAPH_CHARS[2], &DBUF[32] ) );
    close_font_map();
    xx = (int) ( OLD_POS_X - scr_columns );
    yy = (int) ( OLD_POS_Y - scr_rows );
    lo( scr_address[ofs0] )= GRAPH_CHARS[0];
    if( ++yy ) lo( scr_address[ofs1] ) = GRAPH_CHARS[1];
    if( ++xx )
    {
      lo( scr_address[ofs0+1] ) = GRAPH_CHARS[2];
      if( yy ) lo( scr_address[ofs1+1] ) = GRAPH_CHARS[3];
    }
    _sti();
  }

  static void hide_mouse_cursor( void )
  {
    int xx,yy;
    uint ofs0, ofs1;

    _cli();
    ofs0 = (uint) ( OLD_POS_Y*scr_columns + OLD_POS_X );
    ofs1 = (uint) ( ofs0 + scr_columns );
    xx = (int) ( OLD_POS_X - scr_columns );
    yy = (int) ( OLD_POS_Y - scr_rows );
    lo( scr_address[ofs0] ) = CBUF[0];
    if( ++yy ) lo( scr_address[ofs1] ) = CBUF[1];
    if( ++xx )
    {
      lo( scr_address[ofs0+1] ) = CBUF[2];
      if( yy ) lo( scr_address[ofs1+1] ) = CBUF[3];
    }
    _sti();
  }

  static void update_pos( int rel_x, int rel_y )
  {
    uint x_pixels, y_pixels;

    _cli();
    x_pixels = (uint) ( scr_columns*8 - 1 );
    y_pixels = (uint) ( scr_rows*scr_char_size - 1 );
    rel_x += MOUSE_ORG_X;
    rel_y += MOUSE_ORG_Y;
    if( rel_x < 0 )
    {
      MOUSE_ORG_X -= rel_x;
      rel_x = 0;
    }
    else
      if( rel_x > x_pixels )
      {
        MOUSE_ORG_X -= ( rel_x - x_pixels );
        rel_x = x_pixels;
      }
    if( rel_y < 0 )
    {
      MOUSE_ORG_Y -= rel_y;
      rel_y = 0;
    }
    else
      if( rel_y > y_pixels )
      {
        MOUSE_ORG_Y -= ( rel_y - y_pixels );
        rel_y = y_pixels;
      }
    DELTA_X = (int) ( rel_x & 7 );
    DELTA_Y = (int) ( rel_y % scr_char_size );
    MOUSE_X = (int) ( rel_x >> 3 );
    MOUSE_Y = (int) ( rel_y / scr_char_size );
    _sti();
  }

  #endif //!HGR

  static void auto_repeat( void )
  {
  #ifdef __386__
    static
  #endif
    Tevent ev;

    ev.code = evMOUSE_REP;
    ev.priority = epMOUSE_REP;
    ev.destination = NULL;
    ev.GLOBAL_X = MOUSE_X;
    ev.GLOBAL_Y = MOUSE_Y;
  #ifdef HGR
    ev.GLOBAL_HGR_X = MOUSE_HGR_X;
    ev.GLOBAL_HGR_Y = MOUSE_HGR_Y;
  #endif
    ev.BUTTONS = MOUSE_BUTTONS;
    ev.CLICKS = 0;
    put_event( ev );
    call_request( REPEAT_HANDLE, auto_repeat, REPEAT_TIME );
  }

  static void clear_multi_click( void )
  {
    CLICK_COUNTER = 0;
  }

  /*
    On entry:
      AX - event bit MASK
      BX - buttons status: bit 0 - left, bit 1 - right, bit 2 - center
      CX - x (divide by 8 )
      DX - y (divide by 8 )
      SI - x rel distance
      DI - y rel distance
  */
  void _loadds far mouse_handler( int max, int mbx, int mcx, int mdx, int msi, int mdi )
  {
    uint events, buttons;
    int x, y, rel_x, rel_y, i;
  #ifdef __386__
    static
  #endif
    Tevent ev;
    _cld();
    events = (uint)((word)max);
    buttons = (uint)((word)mbx);
    x = (int)((short)mcx);
    y = (int)((short)mdx);
    rel_x = (int)((short)msi);
    rel_y = (int)((short)mdi);
    ev.destination = NULL;
    _cli();
    set_es();
    buttons &= 7;
    if( !MOUSE_ENABLED ) goto _return;
  #ifndef HGR
    if( GRAPH_CURSOR)
    {
      update_pos( rel_x, rel_y );
      if( !mouse_hides )
      {
        hide_mouse_cursor();
        show_mouse_cursor();
      }
    }
    else
  #endif
    {
  #ifdef HGR
      MOUSE_HGR_X = x;
      MOUSE_HGR_Y = y;
      MOUSE_X = (int) ( x >> 3 );
      MOUSE_Y = (int) ( y >> 4 );
  #else
      MOUSE_X = (int) ( x >> 3 );
      MOUSE_Y = (int) ( y >> 3 );
  #endif
    }
    if( events==1 &&
  #ifdef HGR
          OLD_HGR_X==MOUSE_HGR_X && OLD_HGR_Y==MOUSE_HGR_Y ) goto _return;
    ev.GLOBAL_HGR_X = MOUSE_HGR_X;
    ev.GLOBAL_HGR_Y = MOUSE_HGR_Y;
  #else
          OLD_X==MOUSE_X && OLD_Y==MOUSE_Y ) goto _return;
  #endif
    ev.GLOBAL_X = MOUSE_X;
    ev.GLOBAL_Y = MOUSE_Y;
    if( REVERSE_BUTTONS ) buttons = REVERSE[buttons];
    ev.BUTTONS = MOUSE_BUTTONS = (char) buttons;
    if( buttons != OLD_BUTTONS )
    {
      cancel_request( REPEAT_HANDLE );
      ev.BUTTON = ( ( OLD_BUTTONS&1 ) == ( buttons&1 ) );
      OLD_BUTTONS = buttons;
    }
    for( i = 0; i < 7; i++ )
      if( events & (1 << i ) )
      {
        ev.code = CODES[i];
        switch( ev.code )
        {
          case evMOUSE_MOVE:
          {
            CLICK_COUNTER = 0;
  #ifdef HGR
            if( OLD_X==MOUSE_X && OLD_Y==MOUSE_Y )
              if( buttons )
                ev.code=evMOUSE_HGR_DRAG;
              else
                ev.code=evMOUSE_HGR_MOVE;
            else
  #endif
              if( buttons ) ev.code=evMOUSE_DRAG;
            break;
          }
          case evMOUSE_DOWN:
          {
            ev.CLICKS = CLICK_COUNTER++;
            cancel_request( MULTI_CLICK_HANDLE );
            cancel_request( REPEAT_HANDLE );
            call_request( REPEAT_HANDLE, auto_repeat, REPEAT_WAIT_TIME );
            call_request( MULTI_CLICK_HANDLE, clear_multi_click, MULTI_CLICK_TIME );
            break;
          }
        }
        ev.priority = PRIORITIES[i];
        put_event( ev );
      }
    OLD_X = MOUSE_X;
    OLD_Y = MOUSE_Y;
  #ifdef HGR
    OLD_HGR_X = MOUSE_HGR_X;
    OLD_HGR_Y = MOUSE_HGR_Y;
  #endif
    _return: _sti();
  }
  #ifdef __386__
  #pragma aux mouse_handler parm [EAX] [EBX] [ECX] [EDX] [ESI] [EDI]
  #else
  #pragma aux mouse_handler parm  [AX]  [BX]  [CX]  [DX]  [SI]  [DI]
  #endif

  #ifdef __386__
  //Dummy function to indicate end of the code to lock
  void mouse_lock_region_end( void )
  {
  }
  #endif

  #ifndef HGR

  void graph_mouse( boolean enable )
  {
    union REGS r;

    if( !BUTTONS_COUNT || !scr_soft_fonts ) return;
    _cli();
    hide_mouse();
    if( (GRAPH_CURSOR=enable)==0 )
    {
      r.w.cx = (word) ( MOUSE_X << 3 );
      r.w.dx = (word) ( MOUSE_Y << 3 );
      r.w.ax = 4;
      INTR( 0x33, &r, &r );
    }
    show_mouse();
    _sti();
  }

  void set_graph_cursor( word *def )
  {
    uint i;
    char *p;

    if( !BUTTONS_COUNT ) return;
    _cli();
    hide_mouse();
    if( def == NULL )
      if( scr_char_size == 8 )
        def = standard_shape8;
      else
        def = standard_shape14;
    p = (char * ) def;
    for( i=0; i < 14; i++ )
    {
      SHAPE[i] = *(p++ );
      MASK[i] = *(p++ );
    }
    show_mouse();
    _sti();
  }

  #endif //!HGR

  void hide_mouse( void )
  {
    union REGS r;

    if( BUTTONS_COUNT )
  #ifndef HGR
      if( !GRAPH_CURSOR )
  #endif
      {
        r.w.ax = 2;
        INTR( 0x33, &r, &r );
      }
  #ifndef HGR
      else
        if( !mouse_hides-- ) hide_mouse_cursor();
  #endif
  }

  void show_mouse( void )
  {
    union REGS r;

    if( BUTTONS_COUNT )
  #ifndef HGR
      if( !GRAPH_CURSOR )
  #endif
      {
        r.w.ax = 1;
        INTR( 0x33, &r, &r );
      }
  #ifndef HGR
      else
        if( !++mouse_hides ) show_mouse_cursor();
  #endif
  }

  void mouse_goto_xy( int x, int y )
  {
    union REGS r;

    if( BUTTONS_COUNT )
    {
      hide_mouse();
      MOUSE_X = x;
      MOUSE_Y = y;
  #ifdef HGR
      MOUSE_HGR_X = (int) ( x << 3 );
      MOUSE_HGR_Y = (int) ( y << 3 );
  #else
      MOUSE_ORG_X = (int) ( x << 3 );
      MOUSE_ORG_Y = (int) ( y * scr_char_size );
  #endif
      r.w.cx = (word) ( MOUSE_X << 3 );
      r.w.dx = (word) ( MOUSE_Y << 3 );
      r.w.ax = 4;
      INTR( 0x33, &r, &r );
  #ifndef HGR
      if( GRAPH_CURSOR ) update_pos(0, 0 );
  #endif
      show_mouse();
    }
  }

  void get_mouse_speed( uint &sx, uint &sy )
  {
    union REGS r;

    if( BUTTONS_COUNT )
    {
      r.w.bx = 0;
      r.w.cx = 0;
      r.w.ax = 0x1B;
      INTR( 0x33, &r, &r );
      sx = r.w.bx;
      sy = r.w.cx;
    }
  }

  void set_mouse_speed( uint sx, uint sy )
  {
    union REGS r;

    if( BUTTONS_COUNT )
    {
      r.w.ax = 0x1B;
      INTR( 0x33, &r, &r );
      r.w.bx = (word)sx;
      r.w.cx = (word)sy;
      r.w.ax = 0x1A;
      INTR( 0x33, &r, &r );
    }
  }

  #ifndef HGR

  void set_mouse_mask( uint and_mask, uint or_mask )
  {
    union REGS r;

    if( BUTTONS_COUNT )
    {
      r.w.bx = 0;
      r.w.cx = (word)and_mask;
      r.w.dx = (word)or_mask;
      r.w.ax = 0x0A;
      INTR( 0x33, &r, &r );
    }
  }

  void set_mouse_chars( char *gc )
  {
    _cli();
    hide_mouse();
    restore_chars_def();
    memcpy(GRAPH_CHARS,gc,4 );
    save_chars_def();
    show_mouse();
    _sti();
  }

  static char chars_def[4*16];

  void save_chars_def( void )
  {
    char *ptr;
    int i;

    if( BUTTONS_COUNT && GRAPH_CURSOR )
    {
      open_font_map();
      for( ptr = chars_def, i = 0; i < 4; i++ )
        ptr = get_char_def( GRAPH_CHARS[i], ptr );
      close_font_map();
    }
  }

  void restore_chars_def( void )
  {
    char *ptr;
    int i;

    if( BUTTONS_COUNT && GRAPH_CURSOR )
    {
      open_font_map();
      for( ptr = chars_def, i = 0; i < 4; i++ )
        ptr = set_char_def( GRAPH_CHARS[i], ptr );
      close_font_map();
    }
  }

  #endif //!HGR

  static void mode_proc( char mode, char char_size )
  {
    uint old_scr_rows, old_scr_cols;

    old_scr_rows = scr_rows;
    old_scr_cols = scr_columns;
    hide_mouse();
    old_mode_proc( mode, char_size );
    mouse_goto_xy( (int) ( MOUSE_X*scr_columns/old_scr_cols ),
                   (int) ( MOUSE_Y*scr_rows/old_scr_rows    ) );
  #ifndef HGR
    set_graph_cursor( NULL );
  #endif
    show_mouse();
  }


/*
STARTUP & EXIT
*/
  #ifndef NOCONFIG
  static void read_params( void )
  {
    long x;

    seek_section( 0, SECTION_MOUSE );
    ini( VAR_SENSITIVITY, x, 0 ); if( x ) set_mouse_speed( x, x );
    ini( VAR_MULTI_CLICK, MULTI_CLICK_TIME, MULTI_CLICK_TIME );
    ini( VAR_MOUSE_DELAY, REPEAT_WAIT_TIME, REPEAT_WAIT_TIME );
    ini( VAR_MOUSE_SPEED, REPEAT_TIME, REPEAT_TIME );
    ini_lnerr( !MULTI_CLICK_TIME || !REPEAT_WAIT_TIME || !REPEAT_TIME, INIERR_RANGE );
  #ifndef HGR
    ini( VAR_GRAPH, GRAPH_CURSOR, GRAPH_CURSOR );
  #endif
  }
  #endif
  #endif //NOMOUSE

  void hook_drivers( void )
  {
    OLD_TIMER_HANDLER = _dos_getvect( TIMER_INTR );
    _dos_setvect( TIMER_INTR, timer_handler );
    OLD_KEYBOARD_HANDLER = _dos_getvect( KBD_INTR );
    _dos_setvect( KBD_INTR, keyboard_handler );
  #ifndef NOMOUSE
    union REGS r;
    struct SREGS sr;

    BUTTONS_COUNT = 0;
    r.w.ax = 0;
    INTR( 0x33, &r, &r );
    if( r.w.ax )
    {
      BUTTONS_COUNT = (char ) r.w.bx;
      r.w.ax = 4;
      r.w.cx = r.w.dx = 0;
  #ifndef HGR
      MOUSE_ORG_X = MOUSE_ORG_Y = 0;
  #endif
      INTR( 0x33, &r, &r );
  #ifndef HGR
      GRAPH_CURSOR = GRAPH_CURSOR && ( scr_mode != 7 );
      save_chars_def();
  #endif
      r.w.ax = 0x0C;
      r.w.cx = 0x7F;
  #ifdef __386__
      r.x.edx = FP_OFF( mouse_handler );
  #else
      r.w.dx = FP_OFF( mouse_handler );
  #endif
      segread( &sr );
      sr.es = FP_SEG( mouse_handler );
      INTRX( 0x33, &r, &r, &sr );
      r.w.cx = 0;
      r.w.dx = (word) ( (scr_columns - 1 ) << 3 );
      r.w.ax = 7;
      INTR( 0x33, &r, &r );
      r.w.dx = (word) ( (scr_rows - 1 ) << 3 );
      r.w.ax = 8;
      INTR( 0x33, &r, &r );
  #ifndef HGR
      set_graph_cursor( NULL );
  #endif
      r.w.cx = 0xFF;
      r.w.dx = 0xA000;
      r.w.bx = 0;
      r.w.ax = 0x0A;
      INTR( 0x33, &r, &r );
      mouse_goto_xy( 0, 0 );
    }
  #endif //NOMOUSE
  }

  void unhook_drivers( void )
  {
    _dos_setvect( TIMER_INTR, OLD_TIMER_HANDLER );
    _dos_setvect( KBD_INTR, OLD_KEYBOARD_HANDLER );
  #ifndef NOMOUSE
    union REGS r;
    struct SREGS sr;

    if( BUTTONS_COUNT )
    {
      r.w.ax = 0x0C;
      segread( &sr );
      r.w.cx = r.w.dx = sr.es = 0;
      INTRX( 0x33, &r, &r, &sr );
  #ifndef HGR
      restore_chars_def();
  #endif
    }
  #endif
  }

  static void __tini_drivers( void )
  {
  #ifndef NOMOUSE
    hide_mouse();
  #endif
    unhook_drivers();
  }

  void __init_drivers( void )
  {
  #ifdef __FLAT__
    unsigned long *system_timer = (unsigned long *) BIOS_DTA( 0x6C );
  #else
    unsigned long far *system_timer = (unsigned long *) BIOS_DTA( 0x6C );
  #endif

  #ifdef __386__
    lock_region( &events_data, sizeof( events_data ) );
    lock_region( (void near *) events_lock_region_begin,
                   (char *) events_lock_region_end -
                   (char *) events_lock_region_begin );
    lock_region( &timer_data, sizeof( timer_data ) );
    lock_region( (void near *) timer_lock_region_begin,
                   (char *) timer_lock_region_end -
                   (char *) timer_lock_region_begin );
    lock_region( &kbd_data, sizeof( kbd_data ) );
    lock_region( (void near *) keyboard_lock_region_begin,
                   (char *) keyboard_lock_region_end -
                   (char *) keyboard_lock_region_begin );
  #ifndef NOMOUSE
    lock_region( &mouse_data, sizeof( mouse_data ) );
    lock_region( (void near *) mouse_lock_region_begin,
                   (char *) mouse_lock_region_end -
                   (char *) mouse_lock_region_begin );
  #endif
  #endif
  #ifndef NOMOUSE
    REPEAT_HANDLE = alloc_timer();
    MULTI_CLICK_HANDLE = alloc_timer();
  #endif

  //init events
    do
    {
      OLD_TIMER = *system_timer;
    }
    while( OLD_TIMER != *system_timer );

  //init timer
    for( uint i = 0; i < MAX_TIMERS; i++ )
      COUNTERS[i] = 0;

    hook_drivers();

  //init mouse
  #ifndef NOMOUSE
    if( BUTTONS_COUNT )
    {
      old_mode_proc = hook_mode_proc( mode_proc );
  #ifndef NOCONFIG
      read_params();
  #endif
  #if !defined( NOPARAM ) && !defined( HGR )
      if( param_opt( "/M+" ) ) GRAPH_CURSOR = scr_soft_fonts;
      if( param_opt( "/M-" ) ) GRAPH_CURSOR = 0;
  #endif
    }
  #endif //NOMOUSE
    atexit( __tini_drivers );
  }
