//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVCONFIG.CPP                         |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Startup configuration manager        |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_stdio
#define uses_string
#define uses_comlin
#define uses_config
#define uses_ini
#define uses_system

#define _DECLARE_PVCONFIG
#include "PVuses.h"
#undef  _DECLARE_PVCONFIG

#ifndef NOCONFIG

#define EC_BAD_INIFILE 221

void __init_config( void )
{
#ifndef NOPARAM
  if( param_spec( "/INI:", config_filename ) )
  {
    add_ext( config_filename, ".INI" );
    if( read_ini( min_path(fexpand(config_filename)) ) == NULL )
    {
#ifdef CYR
      printf( ":    %s\n", config_filename );
#else
      printf( "Error: Can't read INI file %s\n", config_filename );
#endif
      exit( EC_BAD_INIFILE );
    }
  }
  else
#endif
  {
    char *filename =
  #ifdef INIFILE
      INIFILE;
  #else
      CONFIG_FILENAME;
  #endif
    read_ini( min_path(fexpand(strcpy(config_filename,filename))) );
  }
}

void __tini_config( void )
{
  close_ini();
}

#endif //NOCONFIG
