/*+
    Name:	fselect.c
    Date:	06-Jun-1988
    Author:	Kent J. Quirk
		(c) Copyright 1988 Ziff Communications Co.
    Abstract:	Displays a list of files and allows user to select one
		of them.
    History:	09-Sep-88   kjq     Version 1.00
-*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <graph.h>
#include "winmenu.h"

/**** s t r c m p p ****
    Abstract:	Compares two pointers to string pointers using strcmp.
		Used by qsort.
    Parameters: Pointers to pointers to the two strings to be compared.
    Returns:	Whatever strcmp would for the two strings.
    Comments:	Necessary because qsort sorts an array of pointers, not
		the strings themselves.
****************************/
int strcmpp(sp, tp)
char **sp, **tp;
{
    return(strcmp(*sp, *tp));
}

#define MAXFILES 256
/**** s e l e c t _ 1 _ f i l e ****
    Abstract:	Displays a sorted list of files in a menu and allows user to
		select one. The files displayed meet the specifications
		of the ambiguous file name passed in (such as *.c, etc).  
    Parameters: char *afn - an ambiguous file name supported by DOS
    Returns:	char * -- a pointer to a malloc'd string containing the 
			    filename chosen, or NULL.
    Comments:	Uses the scroll_menu function to display the names.
		Code to trim off the extensions has been commented out.
		The window size and location is hard-coded.
****************************/
char *select_1_file(afn)
char *afn;
{
    char **filelist;
    struct find_t buffer;
    char *choice;

    int i;

    filelist = malloc(MAXFILES * sizeof(char *));
    
    if (_dos_findfirst(afn, _A_NORMAL, &buffer) == 0)
    {
	/*	*strchr(buffer.name, '.') = 0;	     */
	filelist[0] = strdup(buffer.name);	/* read the first filename */
    }

    for (i=1; _dos_findnext(&buffer) == 0; i++)     /* and all the rest */
    {
	if (i > MAXFILES)
	{
	    printf("Sorry, too many files.\n"); 	/* ugly */
	    break;
	}
	else
	{
	    /*	     *strchr(buffer.name, '.') = 0;    */
	    filelist[i] = strdup(buffer.name);
	}
    }

    filelist[i] = NULL; 			/* the end of the list */
    qsort(filelist, i, sizeof(filelist[0]), strcmpp);

    if ((i = scroll_menu(filelist, afn, "", 5, 3, 17, 1)) >= 0)
	choice = strdup(filelist[i]);		/* dup the one chosen */
    else
	choice = NULL;

    for (i=0; filelist[i] != NULL; i++) 	/* free them all */
	free(filelist[i]);
    
    free(filelist);				/* and the list itself */
    return(choice);
}
