/* eltime.c - use BIOS time-of-day interrupt */
#include "stdio.h"
#include "dos.h"

static long stime ;			/* store time-of-day from last call */
#define TOD_INT  0x1A		/* BIOS time-of-day interrupt */

int eltime()			/* count ticks since last call */
 {
    struct XREG sreg , dreg ;
    long etime , delta ;

    sreg.ax = 0 ;		/* get time count */
    int86(TOD_INT,&sreg,&dreg); /* get current  count */
				/* assemble 32-bit time-of-day value */
    etime = ( ((long) dreg.cx) << 16 ) + (unsigned) dreg.dx ;
    delta = etime - stime ;
											/* check for new day since last call */
    if( ((dreg.ax & 0xff) != 0) || (delta < 0) )   
        delta = delta + 0x01800B0L ; /* new day - add 1 day in ticks */
    stime = etime ;		/* save time-of-day for next call */
    return( (int) delta ) ;		/* return as an integer */
 }
