PROGRAM Bigger_Screen;
CONST
  Wide = 150;  { You can ajust the size of the virtual screen       }
  Long = 40;   { by changing these two constants                    }
  Nline = 25;  { change to 24 if your monitor display only 24 lines }

TYPE
  Scr = ARRAY[1..Nline, 1..80, 1..2] OF Char;
  LongString = STRING[255];

VAR
  MonoD : Scr ABSOLUTE $B000 : 0000;
  ColoD : Scr ABSOLUTE $B800 : 0000;
  Mode  : Byte ABSOLUTE $0040 : $0049; { video mode }
  BigScr : ARRAY[1..Long, 1..Wide, 1..2] OF Char;

  PROCEDURE Big_ClrScr;
  VAR I : Integer;
  BEGIN
    FOR I := 1 TO Wide DO
      BEGIN
        BigScr[1, i, 1] := Chr(32);
        BigScr[1, i, 2] := Chr(15);
      END;
    FOR I := 2 TO Long DO Move(BigScr[1, 1, 1], BigScr[i, 1, 1], Wide*2)
  END;

  PROCEDURE Big_Write(Line : LongString; Col, Row : Integer; VidAtt : Byte);
  VAR I : Integer;
  BEGIN
    IF (Row <= Long) THEN
      FOR I := 0 TO Length(Line)-1 DO
        IF (Col+i) <= Wide THEN
          BEGIN
            BigScr[Row, Col+i, 1] := Line[i+1];
            BigScr[Row, Col+i, 2] := Chr(VidAtt);
          END;
  END;

  PROCEDURE Show_BigScr(col, Row : Integer);
  VAR I : Integer;
  BEGIN
    FOR I := 1 TO Nline DO
      CASE Mode OF
        7    : Move(BigScr[i+col-1, row, 1], MonoD[I, 1, 1], 160);
        2, 3 : Move(BigScr[i+col-1, row, 1], ColoD[I, 1, 1], 160);
      END;
  END;

  PROCEDURE GetMove;
  VAR
    Ch1, Ch2 : Char;
    PosX, PosY : Integer;
  BEGIN
    PosX := 1; PosY := 1;
    ClrScr;
    REPEAT
      Show_BigScr(PosX, PosY);
      Read(Kbd, Ch1);
      IF Ch1 = Chr(27) THEN
        BEGIN
          Read(Kbd, Ch2);
          CASE Ord(Ch2) OF
            72 : IF PosX > 1 THEN PosX := Pred(PosX);       {up   }
            77 : IF PosY < Wide-79 THEN PosY := Succ(PosY); {right}
            80 : IF PosX < Long-Pred(Nline) THEN
                   PosX := Succ(PosX);                      {down }
            75 : IF PosY > 1 THEN PosY := Pred(PosY);       {left }
          END;
        END;
    UNTIL Ch1 = Chr(13);
  END;

BEGIN
  Big_ClrScr;
  Big_Write('<- this is the upper left corner of the screen',
    1, 1, White);
  Big_Write('Use arrow keys to move the "viewport"; press <Return> to quit',
    1, 2, White);
  Big_Write('<- this is the middle of the screen',
    Wide DIV 2, Long DIV 2, Red);
  Big_Write('this is the lower right corner of the screen ->',
    Wide-46, Long, 25);
  GetMove;
END.