'----- PIE.BAS by Brian Giedt

DEFINT A-Z

SCREEN 9

N = 6                                   'number of data items (pie slices)
REDIM GraphData!(N), Radians#(N)        '6 pieces in this pie

Angle = 70                              'angle of pie
Angle2# = 0
Piesize = 164                           'radius of circle in pixels
Removed = 188                           'radius of pie piece removed from pie
Cx = 300                                'center for X position
Cy = 180                                'center for Y position
Pi# = 3.1415926#
Turn# = COS(Angle * Pi# / 180)
Height = Piesize \ 5

FOR X = 1 TO N                          'read the pie chart data
    READ GraphData!(X)
NEXT
DATA 92, 78, 45, 30, 19, 11

Sum! = 0
FOR I = 1 TO N                          'proportionalize pie to the
    Sum! = Sum! + GraphData!(I)         '  sum of its parts
NEXT

FOR I = 1 TO N
    Radians#(I) = GraphData!(I) / Sum!
NEXT

'**** MAIN LOOP ****

FOR C = 1 TO N
    Angle1# = Angle2#                           'retain last angle
    Angle2# = Angle2# + Radians#(C) * 2 * Pi#   'calculate radians
    AvgAngle# = (Angle1# + Angle2#) / 2

    IF C = N THEN       'this is the final slice, pull it away from the rest
       OldCx = Cx
       Cx = Cx + COS(AvgAngle#) * (Removed - Piesize)
       OldCy = Cy
       Cy = Cy - SIN(AvgAngle#) * (Removed - Piesize) * Turn#
    END IF

    CIRCLE (Cx, Cy), Piesize, , -Angle1# - .001#, -Angle2#, Turn#
    PAngle1# = Angle1# + .001#
    Pangle2# = Angle2#

    IF PAngle1# < Pi# THEN
       IF Pangle2# > Pi# THEN
          PAngle1# = Pi#
       ELSE
          Pangle2# = -1
       END IF
    END IF

    IF Pangle2# > 0# THEN               'working with the front pie pieces
                                        'first draw the circle
       CIRCLE (Cx, Cy + Height), Piesize, , PAngle1#, Pangle2#, Turn#
       P1C# = COS(ABS(PAngle1#))
       P2C# = COS(ABS(Pangle2#))
       P1S# = SIN(ABS(PAngle1#))
       P2S# = SIN(ABS(Pangle2#))

                                        'now draw the connecting lines
       LINE (Cx + P1C# * Piesize, Cy - P1S# * Piesize * Turn#)- _
            (Cx + P1C# * Piesize, Cy - P1S# * Piesize * Turn# + Height)
       LINE (Cx + P2C# * Piesize, Cy - P2S# * Piesize * Turn#)- _
            (Cx + P2C# * Piesize, Cy - P2S# * Piesize * Turn# + Height)

       IF C = N THEN             'this is the piece to pull away from the pie
          IF PAngle1# > Pi# * 3 / 2 THEN
             CALL DoLine(CDBL(Cx + P1C# * Piesize), _
                  CDBL(Cy - P1S# * Piesize * Turn# + Height), _
                  CDBL(Cx), CDBL(Cy + Height))
             CALL DoLine(CDBL(Cx), CDBL(Cy), CDBL(Cx), CDBL(Cy + Height))

             PAINT (Cx + P1C# * Piesize - 1, _
                    Cy - P1S# * Piesize * Turn# + Height \ 2), C, 15
          END IF
       END IF

       PAvgAngle# = (PAngle1# + Pangle2#) / 2
       PAINT (Cx + COS(PAvgAngle#) * Piesize, _
              Cy - SIN(PAvgAngle#) * Piesize * Turn# + Height \ 2), C, 15

    END IF

    PAINT (Cx + COS(AvgAngle#) * .8 * Piesize, _
           Cy - SIN(AvgAngle#) * .8 * Piesize * Turn#), C, 15

    IF COS(AvgAngle#) > 0 THEN
       Lx = Cx + COS(AvgAngle#) * Piesize + 8
    ELSE
       Lx = Cx + COS(AvgAngle#) * Piesize
    END IF

    Ly = Cy - SIN(AvgAngle#) * (Piesize) * Turn#

    IF AvgAngle# > Pi# THEN
       Ly = Ly + Removed \ 3
    ELSE
       Ly = Ly - Piesize \ 7
    END IF

NEXT
END

'$INCLUDE: 'DoLine.Bas'
