/* MCI REXX Sample #4 */
/* this script shows you how to control the volume of a CD and also   */
/* how to pause and resume playback.                                  */

signal on error /* When commands fail, call "error" routine. */

  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs


rc = RXFUNCADD('mciRxInit','MCIAPI','mciRxInit')
InitRC = mciRxInit()

/* Open the CD */

rc = mciRxSendString("open cdaudio alias supercd wait", 'Retst', '0', '0')
rc = mciRxSendString("status supercd media present wait", 'Retst', '0', '0')
If Retst <> 'TRUE' then
     do
     say 'Must have CD inserted to run this command file'
     say 'Please insert'
     rc = mciRxSendString("status supercd media present wait", 'Retst', '0', '0')

       do while Retst <> 'TRUE'
         rc = mciRxSendString("status supercd media present wait", 'Retst', '0', '0')
       End
     End
rc = mciRxSendString("play supercd", 'Retst', '0', '0')

say 'Press I to increase volume:'
say 'Press D to decrease volume:'
say 'Press P to pause playback'
say 'Press R to resume playback'

say 'Press Q to quit'
volume=100
volumestring = 'set supercd audio volume '

quit = FALSE

do while quit <> 'TRUE'
   keyin = SysGetKey('NOECHO')
   SELECT
      WHEN keyin = 'd' | keyin = 'D'
        THEN
          do
           volume = volume - 1
           IF volume <= 0 THEN
             volume = 0
           volumecommand =  volumestring volume ' wait'
           rc = mciRxSendString(volumecommand, 'Retst', '0', '0')
          END

      WHEN keyin = 'i' | keyin = 'I'
        THEN
          do
           volume = volume + 1
           IF volume > 100 THEN
             volume = 100
           volumecommand =  volumestring volume ' wait'
           rc = mciRxSendString(volumecommand, 'Retst', '0', '0')
          END

      WHEN keyin = 'p' | keyin = 'P'
        THEN
          rc = mciRxSendString("pause supercd wait", 'Retst', '0', '0')


      WHEN keyin = 'r' | keyin = 'R'
        THEN
          rc = mciRxSendString("resume supercd wait", 'Retst', '0', '0')
      WHEN keyin = 'q' | keyin = 'Q'
        THEN
         quit = TRUE
   OTHERWISE
     SAY "Sorry, but " keyin " isn't supported"

   END  /* End select */

End


rc = mciRxSendString("close supercd wait", 'Retst', '0', '0')

say 'Finished SuperCD playback sample'
exit

error:
   say 'Error' ErrRC 'at line' sigl ', sourceline:' sourceline(sigl)
   say 'Terminating'
   mciRxSendString("close supercd wait", 'Retst', '0', '0')
   mciRxExit()               /* Tell the DLL we're going away */
   exit ErrRC                /* exit, tell caller things went poorly */

halt:
/*
 * Close all device alias's, in case we previously killed
 * this batch file in the same process.
 */
   say 'Terminating'
  mciRxSendString("close supercd wait", 'Retst', '0', '0')
exit

 


