@ECHO OFF
ECHO This batch file demonstrates a technique for comparing a parameter
ECHO against a particular string without regard for upper or lower case.
ECHO.
ECHO Pass NO parameters to test your DOS version's FIND command -or-
ECHO Pass a string starting with "/T" or "/t"                   -or-
ECHO Pass the string "/RUN" in any combination of upper/lower case
ECHO.
IF NOT '%1'=='' GOTO GotParam
ECHO Now testing your DOS version's FIND command:
ECHO.
ECHO /T|find /i "/t">NUL
IF ERRORLEVEL 1 GOTO Fail
ECHO /T|find /i "/r">NUL
IF NOT ERRORLEVEL 1 GOTO Fail
ECHO FIND performed correctly.
ECHO.
GOTO End

:GotParam
:: Branch if %1 begins with /T or /t, e.g. /TEST, /test, /testit!, etc.
:: Note the caret added before the %1 and before /t
echo ^%1|find /i "^/t">NUL
IF NOT ERRORLEVEL 1 GOTO test

:: Branch if %1 is /run in any case, e.g. /RUN, /Run, /run, etc.
:: Note the carets surrounding %1 and surrounding /run
echo ^%1^|find /i "^/run^">NUL
IF NOT ERRORLEVEL 1 GOTO run

ECHO Your parameter was not "/run", nor did it begin with "/t" 
GOTO End

:run
ECHO You chose "/run"
GOTO End

:test
ECHO You chose "/t"
GOTO End

:Fail
ECHO FIND did not set the ERRORLEVEL correctly. 
VER
:End


