/* HELPHOOK.C
   By Pete Davis & Jim Mischel
   PC Magazine Vol. 14, No. 14

   This program finds all instances of WinHelp and 
   attaches each one to the helphook DLL.
*/

#include <windows.h>
#include <toolhelp.h>
#include "hhook.h"

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow) {
    static char szAppName [] = "HelpHook" ;
    MSG msg;
    HWND hwnd ;
    WNDCLASS wndclass ;

    if (!hPrevInstance) {
        wndclass.style = CS_HREDRAW | CS_VREDRAW ;
        wndclass.lpfnWndProc = MainWndProc ;
        wndclass.cbClsExtra = 0 ;
        wndclass.cbWndExtra = 0 ;
        wndclass.hInstance = hInstance ;
        wndclass.hIcon = LoadIcon (hInstance, szAppName) ;
        wndclass.hCursor = LoadCursor (NULL, IDC_ARROW) ;
        wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
        wndclass.lpszMenuName = NULL ;
        wndclass.lpszClassName = szAppName ;

        RegisterClass (&wndclass) ;
    }

    hwnd = CreateWindow (szAppName, "HelpHooker",
    WS_OVERLAPPEDWINDOW,
    CW_USEDEFAULT, CW_USEDEFAULT,
    CW_USEDEFAULT, CW_USEDEFAULT,
    NULL, NULL, hInstance, NULL) ;

    ShowWindow (hwnd, SW_HIDE) ;
    UpdateWindow (hwnd); 

    while (GetMessage (&msg, NULL, 0, 0)) {
        TranslateMessage (&msg) ;
        DispatchMessage (&msg) ;
    }
    return msg.wParam ;
}


void HookDLL(HMODULE hModule, HINSTANCE hInst) {

LPBYTE		lpModule;
long 		(FAR PASCAL *lpfn_FAPI) (LPSTR, WORD, DWORD);
char		Command[256];

	/* Convert WinHelp to a DLL */
	lpModule = GlobalLock(hModule);
	lpModule += 0x0D;
	*lpModule = *lpModule | 0x80;
	
	
	/* Get Address of exported FApi() function */
	(FARPROC) lpfn_FAPI = GetProcAddress(hInst, "EXPFAPI");
	
	/* Convert WinHelp back to an EXE */
	*lpModule = *lpModule & 0x7F;
	GlobalUnlock(hModule);
	
	lstrcpy(Command, "RR(`helphook.dll', `LOADHOOKDLL', `S')");
	lstrcat(Command, ";LoadHookDLL(qchPath)");
	/* Call FApi() */
	_asm { 
		mov		ax, 0;
		push	ax
		push	ax
		mov		ax, 102h
		push	ax
		lea		ax, Command
		push	ds
		push	ax
		mov		ax, hInst
		call 	lpfn_FAPI
	}
}


void HookAll() {

TASKENTRY	TE;

	TE.dwSize = sizeof(TASKENTRY);
	TaskFirst(&TE);
	
	if (!TE.hModule) {
		MessageBox(NULL, "TaskFirst function call failed", 
					"Error", MB_OK);
		return;
	}
	
	while (TE.hNext) {
		if (!lstrcmp(TE.szModule, "WINHELP")) 
			HookDLL(TE.hModule, TE.hInst);
		TaskNext(&TE);
	}
}


long _far _pascal _export MainWndProc (	HWND hwnd, 
										UINT message, 
										UINT wParam, 
										LONG lParam) {

HINSTANCE 	hInstDLL;
int			i;

    switch (message) {

	    case WM_CREATE:
	
			hInstDLL = LoadLibrary("HELPHOOK.DLL");
			HookAll();
			for (i=1; i<=20; i++)
				Yield();
			FreeLibrary(hInstDLL);
			PostMessage(hwnd, WM_DESTROY, 0, 0L);
			Yield();
			break;
		
	    case WM_DESTROY :
    	    PostQuitMessage (0) ;
        	return 0 ;
    }

    return DefWindowProc (hwnd, message, wParam, lParam) ;
}

