/*----------------------------------------
   PATHOPS.C -- Path Operations
                (c) Charles Petzold, 1994
  ----------------------------------------*/

#include <windows.h>
#include <math.h>

#define TWOPI (2 * 3.14159)

char szClass [] = "PathOps" ;
char szTitle [] = "PathOps: Path Operations" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     INT      i, iAngle ;
     LOGBRUSH lb ;
     POINT    pt [37] ;

               // Set up an isotropic display area

     SetMapMode (hdc, MM_ISOTROPIC) ;
     SetWindowExtEx   (hdc, 2000, 2000, NULL) ;
     SetViewportExtEx (hdc, cxArea / 2, -cyArea / 2, NULL) ;

               // Define points on two hexagons used for the Bezier splines

     for (i = 0 ; i < 37 ; i++)
          {
          if (((i + 1) / 3) & 1)             // outer hexagon
               {
               iAngle = 60 * (i / 6) + 30 * ((i + 1) % 3) ;

               pt[i].x = (INT) (900 * cos (TWOPI * iAngle / 360)) ;
               pt[i].y = (INT) (900 * sin (TWOPI * iAngle / 360)) ;
               }
          else
               {
               iAngle = 60 * ((i + 1) / 6) + 30 * ((i + 1) % 3) - 30 ;

               pt[i].x = (INT) (300 * cos (TWOPI * iAngle / 360)) ;
               pt[i].y = (INT) (300 * sin (TWOPI * iAngle / 360)) ;
               }
          }

               // Set the background color to blue

     SetBkColor (hdc, RGB (0, 0, 255)) ;

               // Loop through the four figures

     for (i = 0 ; i < 4 ; i++)
          {
          SetViewportOrgEx (hdc, (2 * (i % 2) + 1) * cxArea / 4,
                                 (2 * (i / 2) + 1) * cyArea / 4, NULL) ;

                    // Begin a path (but not for the first figure!)

          if (i != 0)
               BeginPath (hdc) ;

                    // Draw the Beziers

          MoveToEx (hdc, pt[0].x, pt[0].y, NULL) ;
          PolyBezierTo (hdc, pt + 1, 36) ;

                    // Close the figure and end the path

          if (i != 0)
               {
               CloseFigure (hdc) ;
               EndPath (hdc) ;
               }

                    // Select a hatched red pen into the device context

          lb.lbStyle = BS_HATCHED ;
          lb.lbColor = RGB (255, 0, 0) ;
          lb.lbHatch = HS_DIAGCROSS ;

          SelectObject (hdc, ExtCreatePen (PS_GEOMETRIC | PS_SOLID,
                                           200, &lb, 0, NULL)) ;

                    // Select a solid green brush into the device context

          lb.lbStyle = BS_SOLID ;
          lb.lbColor = RGB (0, 255, 0) ;
          lb.lbHatch = 0 ;

          SelectObject (hdc, CreateBrushIndirect (&lb)) ;

                    // Perform the path operations

          switch (i)
               {
               case 1:  StrokePath (hdc) ;         break ;

               case 2:  FillPath (hdc) ;           break ;

               case 3:  StrokeAndFillPath (hdc) ;  break ;
               }

                    // Clean up

          DeleteObject (SelectObject (hdc, GetStockObject (BLACK_PEN))) ;
          DeleteObject (SelectObject (hdc, GetStockObject (WHITE_BRUSH))) ;
          }
     }
