/*
 * VIDTEST uses Windows' BitBlt and LineTo functions to gauge the speed
 * with which bit block transfers and line draws are performed.
 */

#include <windows.h>
#include "vidtest.h"

long FAR PASCAL WndProc (HWND, WORD, WORD, LONG);

/*
 *  Function WinMain.
 */

int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{
    static char szAppName[] = "VidTest";
    WNDCLASS wndclass;
    HWND hwnd;
    MSG msg;

    if (!hPrevInstance) {
        wndclass.style = 0;
        wndclass.lpfnWndProc = (WNDPROC) WndProc;
        wndclass.cbClsExtra = 0;
        wndclass.cbWndExtra = 0;
        wndclass.hInstance = hInstance;
        wndclass.hIcon = LoadIcon (NULL, IDI_APPLICATION);
        wndclass.hCursor = LoadCursor (NULL, IDC_ARROW);
        wndclass.hbrBackground = NULL;
        wndclass.lpszMenuName = szAppName;
        wndclass.lpszClassName = szAppName;

        RegisterClass (&wndclass);
    }

    hwnd = CreateWindow (szAppName, szAppName, WS_OVERLAPPEDWINDOW,
        16, 16, GetSystemMetrics (SM_CXSCREEN) - 32,
        GetSystemMetrics (SM_CYSCREEN) >> 2, HWND_DESKTOP,
        NULL, hInstance, NULL);

    ShowWindow (hwnd, nCmdShow);
    UpdateWindow (hwnd);

    while (GetMessage (&msg, NULL, 0, 0)) {
        TranslateMessage (&msg);
        DispatchMessage (&msg);
    }

    return msg.wParam;
}

/*
 * WndProc processes messages to the main window.
 */

long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
    HDC hdc;
    RECT rect;
    int nWidth, nCount, i;

    switch (message) {

    case WM_COMMAND:

        switch (wParam) {

        case IDM_START:
            EnableMenuItem (GetMenu (hwnd), IDM_START, MF_GRAYED);
            hdc = GetDC (hwnd);
            SelectObject (hdc, GetStockObject (BLACK_PEN));

            GetClientRect (hwnd, &rect);
            rect.left = rect.right >> 1;
            FillRect (hdc, &rect, GetStockObject (BLACK_BRUSH));

            GetClientRect (hwnd, &rect);
            nWidth = rect.right >> 1;
            nCount = rect.right - nWidth;

            for (i=0; i<nCount; i++) {
                BitBlt (hdc, i + 1, 0, nWidth, rect.bottom, hdc, i, 0,
                    SRCCOPY);
                MoveTo (hdc, i, 0);
                LineTo (hdc, i, rect.bottom);
            }

            ReleaseDC (hwnd, hdc);
            return 0;

        case IDM_EXIT:
            SendMessage (hwnd, WM_CLOSE, 0, 0L);
            return 0;
        }
        break;
    }
    return DefWindowProc (hwnd, message, wParam, lParam);
}
