'MEMCLEAR.BAS - shows how to initialize variables to any value
'Copyright (c) 1992 Ethan Winer

DEFINT A-Z
DECLARE SUB MemClear (Segment, Address, Size, Value)

TYPE Test
  I AS INTEGER
  L AS LONG
  S AS SINGLE
  D AS DOUBLE
END TYPE

DIM TestType AS Test            'create a test TYPE variable
TestType.I = 123                'and assign some values
TestType.L = -123456
TestType.S = 123.456
TestType.D = -123.456

REDIM A&(1 TO 150)              'create a test array
FOR X = 1 TO 150                'and assign some values
  A&(X) = X
NEXT

S$ = SPACE$(200)                'create a test string
FOR X = 1 TO 200                'and assign some values
  MID$(S$, X, 1) = CHR$(X + 35)
NEXT

GOSUB Display                   'show the current contents
PRINT
PRINT "Press a key to clear the variables"
WHILE INKEY$ = "": WEND

'set the TYPE and array elements to all zeros, and the string to "A"'s
CALL MemClear(VARSEG(TestType), VARPTR(TestType), LEN(TestType), 0)
CALL MemClear(VARSEG(A&(1)), VARPTR(A&(1)), 200 * LEN(A&(1)), 0)
CALL MemClear(SSEG(S$), SADD(S$), LEN(S$), 65)
'             ^^^^
'               |------------ use VARSEG here instead of SSEG with QuickBASIC

GOSUB Display
END

Display:
  CLS
  PRINT "TestType elements:"
  PRINT "TestType.I :"; TestType.I
  PRINT "TestType.L :"; TestType.L
  PRINT "TestType.S :"; TestType.S
  PRINT "TestType.D :"; TestType.D
  PRINT

  PRINT "A&() elements:"
  FOR X = 1 TO 150
    PRINT A&(X);
  NEXT

  LOCATE 18, 1
  PRINT "S$ contents:"; S$
RETURN

ClearCode:
  DATA &H55, &H8B, &HEC, 6, &HC4, &H7E, &HA, &H8B, &H4E, 8
  DATA &H8B, &H46, 6, &HF3, &HAA, 7, &H5D, &HCA, 8, 0

SUB MemClear (Segment, Address, Size, Value) STATIC

  IF NOT BeenHere THEN          'do this only once
    DIM Code AS STRING * 20
    RESTORE ClearCode
    FOR X = 1 TO 20
      READ Byte
      MID$(Code$, X, 1) = CHR$(Byte)
    NEXT
    Proc = VARPTR(Code$)
    BeenHere = -1
  END IF

  DEF SEG
  CALL Absolute(BYVAL Segment, BYVAL Address, BYVAL Size, BYVAL Value, Proc)

END SUB

