/* 
CLIPSERV.C -- final version of clipboard server

Copyright (c) 1992 Ziff Davis Communications
PC Magazine * Andrew Schulman (June 1992)
*/

#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include "windows.h"
#include "objwnd.h"
#include "clipserv.h"

#define WM_CLIPCMD      (WM_USER+1)

extern BOOL FAR PASCAL IsWinOldApTask(HANDLE);  /* undocumented */

static HWND this_hwnd, hwndNextViewer;

WORD put_clip_str(char far *s)
{
    WORD ret;
    HANDLE h;
    if (! (h = GlobalAlloc(GMEM_MOVEABLE, _fstrlen(s)+1)))
        return 0;  /* insufficient memory */
    while (! OpenClipboard(this_hwnd))
        yield();   /* see OBJWND.C */
    EmptyClipboard();
    _fstrcpy(GlobalLock(h), s);
    GlobalUnlock(h);
    if (! (ret = SetClipboardData(CF_TEXT, h)))
        GlobalFree(h);
    CloseClipboard();
    return ret;
}

void do_run(HWND hwnd, char *cmd)
{
    char buf[128];
    wsprintf(buf, "CLIPREPLY RUN %04X", WinExec(cmd, SW_NORMAL));
    put_clip_str(buf);
}

void do_dynlink(HWND hwnd, char *cmd)
{
    char *argv[ARG_MAX];
    int argc;
    argc = split(cmd, argv, ARG_MAX, " \t");
    dynlink(hwnd, argc, argv);
}

void do_settitle(HWND hwnd, char *cmd)
{
    SendMessage(hwnd, WM_SETTEXT, 0, (char far *) cmd);
}

#define MATCH(s1, s2)   (strcmp((s1), (s2)) == 0)
#define ISCMD(s1)       (MATCH(strupr(cmd), (s1)))

#pragma argsused
long clipcmd(HWND hwnd, unsigned msg, WORD wparam, LONG lparam)
{
    static char buf[1024], *s=buf;
    HWND owner = wparam;    // HWND of clipboard owner
    char *cmd, *param;
    _fstrncpy(buf, (char far *) lparam, 1024);
    _ffree((char far *) lparam);
    cmd = strtok(s, " \t");
    param = s + strlen(cmd) + 1;
    if (dynlink_error() == 0)
    {
        if (ISCMD("RUN"))            do_run(owner, param);
        else if (ISCMD("DYNLINK"))   do_dynlink(owner, param);
        else if (ISCMD("SETTITLE"))  do_settitle(owner, param);
        else if (ISCMD("EXIT"))      SendMessage(hwnd, WM_DESTROY, 0, 0L);
        else if (ISCMD("INSTCHECK")) put_clip_str("CLIPREPLY INSTOK");
        else                         put_clip_str("CLIPREPLY CMD INVALID");
    }
    return 0;
}

long check_clipboard(HWND hwnd, unsigned msg, WORD wparam, LONG lparam)
{
    char far *fp = 0;
    HWND owner;
    
    if (hwndNextViewer)
        SendMessage(hwndNextViewer, msg, wparam, lparam);
    
    /* only process CMDCLIP requests from OLDAPs */
    owner = GetClipboardOwner();
    if (IsWinOldApTask(GetWindowTask(owner)))
    {
        HANDLE hGMem;
        if (! OpenClipboard(hwnd))
            return 0;
        if (hGMem = GetClipboardData(CF_TEXT))
        {
            LPSTR lp = GlobalLock(hGMem);
            if (_fstrncmp(lp, "CMDCLIP ", 8) == 0)
            {
                int len = _fstrlen(lp);
                if ((lp[len-1] == '\n') || (lp[len-1] == '\r'))
                    lp[len-1] = '\0';   // remove CRLF
                if ((fp = _fmalloc(len+1)) != 0)
                {
                    char far *fp1 = fp;
                    char far *fp2 = &lp[8];     // remove "CMDCLIP "
                    while (*fp1++ = *fp2++)
                        ;
                }
                else
                    ;   /* insufficient memory */
            }
            GlobalUnlock(hGMem);
        }
        CloseClipboard();
    }
    // don't send message until clipboard closed
    if (fp)
        SendMessage(hwnd, WM_CLIPCMD, owner, fp);
    return 0;
}

long changecbchain(HWND hwnd, unsigned msg, WORD wparam, LONG lparam)
{
    /* maintain linked list of clipboard viewers */
    if (wparam == hwndNextViewer)
        hwndNextViewer = LOWORD(lparam);
    else if (hwndNextViewer)
        SendMessage(hwndNextViewer, msg, wparam, lparam);
    return 0;
}

#pragma argsused
long destroy(HWND hwnd, unsigned msg, WORD wparam, LONG lparam)
{
    ChangeClipboardChain(this_hwnd, hwndNextViewer);
    fini_dynlink();
    PostQuitMessage(0);
    return 0;
}

void fail(char *s)
{
    MessageBox(NULL, s, "CLIPSERV", MB_OK);
    exit(1);
}

#pragma argsused
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, 
    LPSTR lpCmdLine, int nCmdShow)
{
    if (hPrevInstance)
        fail("CLIPSERV already installed"); // only one instance
            
    init_dynlink(hInstance);
    
    this_hwnd = objwnd(hPrevInstance, hInstance, "clipserv");
    hwndNextViewer = SetClipboardViewer(this_hwnd);
    
    on(WM_CHANGECBCHAIN, changecbchain);
    on(WM_DRAWCLIPBOARD, check_clipboard);
    on(WM_DESTROY, destroy);
    on(WM_CLIPCMD, clipcmd);     /* user-defined message */
    
    return mainloop();  /* go resident */
}

