MDNM; SERTYPE - A routine to determine the type of UART used in a serialMDBO MDNM;           port.
;
; Douglas Boling, Jan 1992
;
;
; Entry:  DX - Starting I/O address of the serial port
;
; Exit:  AL - Type of serial port
;
;         0 - 8250
;         1 - 16450, 16550, or 8250A
;         2 - 16550A with FIFO queues
;         3 - IBM Type 3 serial port with DMA
;
;=======================================================================

sertype		proc	near
		push	bx
		push	cx
		mov	bx,dx			;Save starting I/O addr
;
;First, disable any serial interrupts 
;
		add	dx,4			;Point to modem ctl reg
		in	al,dx
		push	ax
		and	al,11111011b		;Disable serial interrupt by
		out	dx,al			;  clearing Out 2 bit.
;
;Check for 8250 by checking for a scratch register at starting I/O + 7
;
		mov	ch,0			;Assume type 0
		mov	dx,bx
		add	dx,7			;See if scratch reg exists
		mov	al,55h
		cli
		out	dx,al
		jmp	$+2
		in	al,dx
		cmp	al,55h
		jne	sertype_1
		mov	al,0aah
		out	dx,al
		jmp	$+2
		in	al,dx
		sti
		cmp	al,0aah
		jne	sertype_1
;
;Now check for FIFO mode to determine if 16550A
;
		inc	ch			;Assume type 1
		mov	dx,bx
		add	dx,2 			;Point to FIFO ctl reg
		mov	al,7			;Attempt to enable FIFOs
		cli
		out	dx,al
		jmp	$+2
		in	al,dx			;Read interrupt ID reg
		sti
		and	al,0c0h			;Strip all but FIFO bits
		jz	sertype_1		;If bits 0, 16450 or 16550
;
;Check for Type 3 DMA port by enabling DMA mode 
;
		inc	ch			;Assume type 2
		mov	dx,bx
		add	dx,8003h		;Point to enhanced reg 1
		cli
		in	al,dx
		push	ax
		or	al,01000000b		;Enable DMA transmit mode
		out	dx,al
		push	dx
		mov	dx,bx
		add	dx,2
		in	al,dx
		mov	cl,al
		pop	dx			;Restore Enhanced reg 1
		pop	ax
		out	dx,al
		sti
		and	cl,0c0h			;Again mask all but FIFO ID
		cmp	cl,40h
		jne	sertype_1
		inc	ch			;Must be type 3 
sertype_1:
		pop	ax
		mov	dx,bx
		add	dx,4			;Point to modem ctl reg
		out 	dx,al			;Restore initial condition
		mov	al,ch
		mov	dx,bx
		pop	cx
		pop	bx
		ret
sertype		endp
