@echo off

echo . Compiling BackDown and its protocols

if .%1 == .M  goto masm
if .%1 == .m  goto masm
if .%1 == .T  goto tasm
if .%1 == .t  goto tasm

echo .
echo .      To compile BackDown -- use one of the following commands:
echo .
echo .               For Assembler         Use this command
echo .           ----------------------    ----------------
echo .           Microsoft MASM 5.1/6.0    COMPILE M
echo .           Borland TASM              COMPILE T
echo .
goto end

:masm
  set assembler=MASM
  set linker=link
  goto work

:tasm
  set assembler=tasm -W2 -w-aln
  set linker=tlink
  goto work

:work
  echo . Clean-up old executables
    if exist bd.com del bd.com
    if exist *.bdp  del *.bdp

  echo . Compiling BackDown
    %assembler% bd;                 >log
    if errorlevel 1 goto errors
    %linker% bd;                   >>log
    if errorlevel 1 goto errors
    exe2bin bd.exe bd.com
    del bd.exe

  echo . B+ protocol
    %assembler% bbplus;            >>log
    if errorlevel 1 goto errors
    %linker% bbplus;               >>log
    if errorlevel 1 goto errors
    exe2bin bbplus.exe bbplus.com
    ren bbplus.com bbplus.bdp
    del bbplus.exe

  echo . XMODEM protocol
    %assembler% bxmodm;            >>log
    if errorlevel 1 goto errors
    %linker% bxmodm;               >>log
    if errorlevel 1 goto errors
    exe2bin bxmodm.exe bxmodm.com
    ren bxmodm.com bxmodm.bdp
    del bxmodm.exe

  echo . ASCII protocol
    %assembler% bascii;            >>log
    if errorlevel 1 goto errors
    %linker% bascii;               >>log
    if errorlevel 1 goto errors
    exe2bin bascii.exe bascii.com
    ren bascii.com bascii.bdp
    del bascii.exe

  echo . All Done
    if exist *.obj del *.obj
    if exist *.map del *.map
    set assembler=
    set linker=
    goto end

:errors
  echo . Problems compiling ..
  echo . ..look in LOG file

:end
