/*
	dqueue.h

	Data queue primitives.

	Andrew C. Payne
	12/03/89
*/

struct dqentry {		/* data queue entry */
	struct dqentry	*next;  /* next entry */
	int	len;		/* length of this entry */
	byte	data[1];	/* data field */
};

typedef struct dqentry DQUEUE;	/* a data queue */

/* ----- Function Prototypes ----- */
extern void DQInit(DQUEUE *dq);
extern int DQAdd(DQUEUE *dq, byte *data, int len);
extern int DQEmpty(DQUEUE *dq);
extern struct dqentry *DQFirst(DQUEUE *dq);
extern void DQRemoveFirst(DQUEUE *dq);
extern void DQExtract(DQUEUE *dq, byte *dest, int len);
