
/****************************************************************************
*   Function:    unsigned long sockt(char *host)                            *
*   Operation:   to find time value for host specified in ptr               *
*   Returns:     time value, or -1 for error                                *
*   Parameters:  host, pointer to host for time                             *
*   Calls:       socko()                                                    *
****************************************************************************/

/****************************************************************************
*   Function:    char *sockd(char *host)                                    *
*   Operation:   to find date value for host specified in ptr               *
*   Returns:     date value, or NULL for error                              *
*   Parameters:  host, pointer to host for date                             *
*   Calls:       socko()                                                    *
****************************************************************************/

#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>

extern int errno;

#define MAXLINE 512
#define TVAL_SIZE 4

unsigned long sockt(host)
  char *host;
{
  int fd, i;
  unsigned long temptime;

  if ((fd = socko(host, "time", 0)) < 0) {
    socke("socko(): error in sockt()");
    return 0L;
  }
  i = sockrn(fd, (char *) &temptime, TVAL_SIZE);
  sockc(fd);
  if (i != TVAL_SIZE) {
    socke("sockrn(): short error in sockt()");
    return 0L;
  } else {
    return (ntohl(temptime));
  }
}

char *sockd(host)
  char *host;
{
  int fd;
  char *ptr;
  static char buff[MAXLINE];

  if ((fd = socko(host, "daytime", 0)) < 0) {
    socke("socko(): error in sockd()");
    return NULL;
  }
  if (sockr(fd, buff, MAXLINE) < 0) {
    socke("sockr(): error in sockd()");
    return NULL;
  }
  for (fd = strlen(buff); fd >= 0; fd--)
    if (buff[fd] == '\n')
      buff[fd] = 0;
  return (buff);
}
