/*-----------------------------------------------------------------------*
 * Greg Stevens                                                  6/24/93 *
 *                               nninputs.c                              *
 *                                             [file 2 in a series of 6] *
 *                                                                       *
 *  This file contains parameters for the input patterns to be used by a *
 * neural net.  This file specifies a type PATTERNtype which is a struct *
 * which contains an array of number of patterns by number of elements   *
 * per pattern.  The number of elements per pattern is equal to          *
 * INPUT_LAYER_SIZE, and the number of input patterns is specified as a  *
 * constant at the beginning of this file and can be modified by the user*
 * as long as the data file nninputs.dat contains that number of input   *
 * blocks.  This file also specifies the function InitPatterns for       *
 * getting the patterns from the file and putting them into a variable of*
 * type PATTERNtype.                                                     *
 *                                                                       *
 *-----------------------------------------------------------------------*/
#include "stdio.h"
#include "nnparams.c"                                /* for net constants*/

#define NUM_PATTERNS 10                              /*number input pat's*/

typedef struct
          {
             float p[ NUM_PATTERNS ][ MAXNODES ];
          } PATTERNtype;

/* Function Prototype */
PATTERNtype InitInPatterns( int t );

/* Function Definition */
PATTERNtype InitInPatterns( int t )
{
   FILE *InFile;                                        /*file w/ pattern*/
														/*data           */
   PATTERNtype patns;                                   /*stores patterns*/
   float val;                                           /*pattern value  */
   int P,U;                                             /*loop variables */

   if (t==0)
     InFile = fopen( "nninputs.dat", "rt" );            /*open: read text*/
   else if (t==1)
     InFile = fopen( "nnintest.dat", "rt" );

   if ( InFile==NULL )                                  /* if no file... */
     {
       printf( "File nninputs.dat does not exist!\n" ); /*error message  */
       return( patns );                                 /*leaves function*/
     }

   for (P=0; (P<NUM_PATTERNS); ++P)              /* for each pattern.... */
      for (U=0; (U<INPUT_LAYER_SIZE); ++U)       /*  for each unit in it:*/
        {
          fscanf( InFile, "%f", &val );
          patns.p[P][U] = val;
        }
   fclose( InFile );

   return( patns );
}
